/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.micaxs.smokeleaf.datagen.ModAdvancementProvider;
import net.micaxs.smokeleaf.datagen.ModBlockLootTableProvider;
import net.micaxs.smokeleaf.datagen.ModBlockStateProvider;
import net.micaxs.smokeleaf.datagen.ModBlockTagProvider;
import net.micaxs.smokeleaf.datagen.ModDataMapProvder;
import net.micaxs.smokeleaf.datagen.ModFluidTagsProvider;
import net.micaxs.smokeleaf.datagen.ModGlobalLootModifierProvider;
import net.micaxs.smokeleaf.datagen.ModItemModelProvider;
import net.micaxs.smokeleaf.datagen.ModItemTagProvider;
import net.micaxs.smokeleaf.datagen.ModRecipeProvider;
import net.micaxs.smokeleaf.datagen.ModWorldgenProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="smokeleafindustries")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ModBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput, lookupProvider));
        ModBlockTagProvider blockTagsProvider = new ModBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModFluidTagsProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModDataMapProvder(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModGlobalLootModifierProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new ModAdvancementProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModWorldgenProvider(packOutput, lookupProvider));
    }
}

