/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.effect.harmful;

import java.util.List;
import net.micaxs.smokeleaf.network.ParanoiaHallucinationPayload;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class ParanoiaEffect
extends MobEffect {
    private static final RandomSource RNG = RandomSource.createThreadSafe();
    private static final List<EntityType<?>> SPOOKS = List.of(EntityType.CREEPER, EntityType.ZOMBIE, EntityType.BLAZE, EntityType.CAT, EntityType.SKELETON, EntityType.SPIDER, EntityType.ENDERMAN);
    private static final List<ResourceLocation> SOUNDS = List.of(ResourceLocation.withDefaultNamespace((String)"entity.creeper.primed"), ResourceLocation.withDefaultNamespace((String)"entity.phantom.ambient"), ResourceLocation.withDefaultNamespace((String)"entity.spider.ambient"), ResourceLocation.withDefaultNamespace((String)"entity.enderman.stare"), ResourceLocation.withDefaultNamespace((String)"entity.cat.ambient"), ResourceLocation.withDefaultNamespace((String)"entity.blaze.ambient"), ResourceLocation.withDefaultNamespace((String)"entity.cow.ambient"));

    public ParanoiaEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity living, int amplifier) {
        if (!living.level().isClientSide() && living instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)living;
            int base = Math.max(40, 100 - amplifier * 20);
            if (RNG.nextInt(base) == 0) {
                EntityType<?> type = SPOOKS.get(RNG.nextInt(SPOOKS.size()));
                double radius = 3.0 + RNG.nextDouble() * 6.0;
                double angle = RNG.nextDouble() * Math.PI * 2.0;
                Vec3 eye = sp.getEyePosition();
                double x = sp.getX() + Math.cos(angle) * radius;
                double z = sp.getZ() + Math.sin(angle) * radius;
                double y = eye.y - 1.0 + RNG.nextDouble() * 2.5;
                float yawToPlayer = (float)(Math.toDegrees(Math.atan2(sp.getZ() - z, sp.getX() - x)) - 90.0);
                int life = 40 + RNG.nextInt(60);
                ResourceLocation sound = RNG.nextInt(3) != 0 ? SOUNDS.get(RNG.nextInt(SOUNDS.size())) : null;
                ParanoiaHallucinationPayload payload = new ParanoiaHallucinationPayload(BuiltInRegistries.ENTITY_TYPE.getKey(type), x, y, z, yawToPlayer, life, sound);
                PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        return super.applyEffectTick(living, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

