/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.effect.neutral;

import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class StickyFingersEffect
extends MobEffect {
    private static final double PICKUP_RADIUS = 16.0;

    public StickyFingersEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (!entity.level().isClientSide() && entity instanceof Player) {
            Player player = (Player)entity;
            Level level = entity.level();
            List items = level.getEntitiesOfClass(ItemEntity.class, player.getBoundingBox().inflate(16.0), item -> !item.isRemoved() && item.isAlive());
            for (ItemEntity item2 : items) {
                ItemStack stack = item2.getItem();
                boolean added = player.getInventory().add(stack);
                if (!added) continue;
                item2.discard();
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

