/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.item.custom;

import net.micaxs.smokeleaf.component.ModDataComponentTypes;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BaseBudItem
extends Item {
    public int dry;
    public int dryingTime;

    public BaseBudItem(Item.Properties properties, int iDry, int iDryingTime) {
        super(properties);
        this.dry = iDry;
        this.dryingTime = iDryingTime;
    }

    public BaseBudItem(Item.Properties properties, int iDry, int iDryingTime, int defaultThc, int defaultCbd) {
        super(BaseBudItem.withDefaults(properties, defaultThc, defaultCbd));
        this.dry = iDry;
        this.dryingTime = iDryingTime;
    }

    private static Item.Properties withDefaults(Item.Properties properties, int defaultThc, int defaultCbd) {
        return properties.component((DataComponentType)ModDataComponentTypes.THC.get(), (Object)defaultThc).component((DataComponentType)ModDataComponentTypes.CBD.get(), (Object)defaultCbd);
    }

    public boolean isDry() {
        return this.dry != 0;
    }

    public Component getName(ItemStack stack) {
        Component baseName = super.getName(stack);
        if (stack.get(ModDataComponentTypes.DRY) != null) {
            if (Boolean.TRUE.equals(stack.get(ModDataComponentTypes.DRY))) {
                return Component.translatable((String)"tooltip.smokeleafindustries.dried").append(" ").append(baseName);
            }
            return Component.translatable((String)"tooltip.smokeleafindustries.fresh").append(" ").append(baseName);
        }
        return Component.translatable((String)"tooltip.smokeleafindustries.fresh").append(" ").append(baseName);
    }

    public static void changeDryStatus(ItemStack stack, boolean value) {
        stack.set(ModDataComponentTypes.DRY, (Object)value);
    }

    public static int getThc(ItemStack stack) {
        Integer v = (Integer)stack.get(ModDataComponentTypes.THC);
        return v != null ? v : 0;
    }

    public static int getCbd(ItemStack stack) {
        Integer v = (Integer)stack.get(ModDataComponentTypes.CBD);
        return v != null ? v : 0;
    }

    public static void setThc(ItemStack stack, int value) {
        stack.set(ModDataComponentTypes.THC, (Object)value);
    }

    public static void setCbd(ItemStack stack, int value) {
        stack.set(ModDataComponentTypes.CBD, (Object)value);
    }

    public static void addThc(ItemStack stack, int delta) {
        BaseBudItem.setThc(stack, BaseBudItem.getThc(stack) + delta);
    }

    public static void addCbd(ItemStack stack, int delta) {
        BaseBudItem.setCbd(stack, BaseBudItem.getCbd(stack) + delta);
    }
}

