/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.item.custom;

import java.util.ArrayList;
import java.util.List;
import net.micaxs.smokeleaf.item.ModItems;
import net.micaxs.smokeleaf.item.custom.BaseWeedItem;
import net.micaxs.smokeleaf.sound.ModSounds;
import net.micaxs.smokeleaf.utils.ModTags;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class DabRigItem
extends Item {
    public DabRigItem(Item.Properties properties) {
        super(properties);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 24;
    }

    private List<MobEffectInstance> getOffhandEffects(ItemStack offhandItem, LivingEntity livingEntity) {
        MobEffectInstance current;
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        Item item = offhandItem.getItem();
        if (!(item instanceof BaseWeedItem)) {
            return effects;
        }
        BaseWeedItem weedItem = (BaseWeedItem)item;
        Holder<MobEffect> effectHolder = this.toHolder(weedItem.getEffect(), livingEntity);
        int baseDuration = weedItem.getDuration();
        int amplifier = weedItem.getEffectAmplifier();
        int totalDuration = baseDuration;
        if (livingEntity.hasEffect(effectHolder) && (current = livingEntity.getEffect(effectHolder)) != null) {
            totalDuration = current.getDuration() + baseDuration;
        }
        effects.add(new MobEffectInstance(effectHolder, totalDuration, amplifier));
        return effects;
    }

    private Holder<MobEffect> toHolder(MobEffect effect, LivingEntity entity) {
        return (Holder)BuiltInRegistries.MOB_EFFECT.getResourceKey((Object)effect).flatMap(key -> entity.level().registryAccess().registryOrThrow(Registries.MOB_EFFECT).getHolder(key)).orElseThrow(() -> new IllegalStateException("Unregistered MobEffect: " + String.valueOf(effect)));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack rigStack = player.getItemInHand(hand);
        ItemStack offhandExtract = this.getOffhandExtract(player);
        if (offhandExtract.isEmpty()) {
            return InteractionResultHolder.fail((Object)rigStack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)rigStack);
    }

    private ItemStack findExtract(Player player) {
        ItemStack off = player.getOffhandItem();
        if (this.isExtract(off)) {
            return off;
        }
        ItemStack main = player.getMainHandItem();
        if (this.isExtract(main)) {
            return main;
        }
        Inventory inv = player.getInventory();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack s = inv.getItem(i);
            if (!this.isExtract(s)) continue;
            return s;
        }
        return ItemStack.EMPTY;
    }

    private ItemStack getOffhandExtract(Player player) {
        ItemStack off = player.getOffhandItem();
        return this.isExtract(off) ? off : ItemStack.EMPTY;
    }

    private boolean isExtract(ItemStack stack) {
        if (stack.isEmpty() || !(stack.getItem() instanceof BaseWeedItem)) {
            return false;
        }
        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        return key != null && key.getPath().endsWith("_extract");
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        Object object;
        Player player;
        ItemStack offhandExtract;
        if (!level.isClientSide && entity instanceof Player && !(offhandExtract = this.getOffhandExtract(player = (Player)entity)).isEmpty() && (object = offhandExtract.getItem()) instanceof BaseWeedItem) {
            BaseWeedItem weedItem = (BaseWeedItem)((Object)object);
            for (MobEffectInstance inst : weedItem.buildEffectInstances(offhandExtract)) {
                if (inst == null || inst.getEffect() == null) continue;
                entity.addEffect(inst);
            }
            if (!player.getAbilities().instabuild) {
                offhandExtract.shrink(1);
            }
        }
        return super.finishUsingItem(stack, level, entity);
    }

    private void spawnSmokeParticles(Level level, LivingEntity entity) {
        for (int i = 0; i < 10; ++i) {
            double xOffset = level.random.nextGaussian() * 0.02;
            double yOffset = level.random.nextGaussian() * 0.02;
            double zOffset = level.random.nextGaussian() * 0.02;
            level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, entity.getX() + (double)entity.getBbWidth() * (level.random.nextDouble() - 0.5), entity.getEyeY(), entity.getZ() + (double)entity.getBbWidth() * (level.random.nextDouble() - 0.5), xOffset, yOffset, zOffset);
        }
    }

    private boolean isValidOffhandItem(ItemStack offhand) {
        if (!offhand.isEmpty()) {
            return offhand.is(ModTags.WEED_EXTRACTS) || offhand.is((Item)ModItems.HASH_OIL_TINCTURE.get());
        }
        return false;
    }

    public SoundEvent getDrinkingSound() {
        return ModSounds.BONG_HIT.get();
    }
}

