/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class HempHammer
extends Item {
    public HempHammer(Item.Properties properties) {
        super(properties);
    }

    public boolean hasCraftingRemainingItem() {
        return true;
    }

    @NotNull
    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        ItemStack copy = itemStack.copy();
        copy.setDamageValue(copy.getDamageValue() + 1);
        if (copy.getDamageValue() >= copy.getMaxDamage()) {
            return ItemStack.EMPTY;
        }
        return copy;
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        if (!level.isClientSide && state.getDestroySpeed((BlockGetter)level, pos) > 0.0f) {
            stack.hurtAndBreak(1, miningEntity, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        double ratio;
        int max = stack.getMaxDamage();
        int used = stack.getDamageValue();
        int remaining = max - used;
        double d = ratio = max > 0 ? (double)remaining / (double)max : 0.0;
        ChatFormatting color = ratio > 0.5 ? ChatFormatting.GREEN : (ratio > 0.25 ? ChatFormatting.GOLD : ChatFormatting.RED);
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.smokeleafindustries.hemp_hammer.uses", (Object[])new Object[]{remaining, max}).withStyle(color));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

