/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.item.custom;

import java.util.List;
import net.micaxs.smokeleaf.block.custom.BaseWeedCropBlock;
import net.micaxs.smokeleaf.block.custom.GrowPotBlock;
import net.micaxs.smokeleaf.screen.custom.MagnifyingGlassScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PlantAnalyzerItem
extends Item {
    public PlantAnalyzerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockState state = level.getBlockState(pos);
        if (!(state.getBlock() instanceof BaseWeedCropBlock) && !(state.getBlock() instanceof GrowPotBlock)) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide) {
            PlantAnalyzerItem.openAnalyzerScreen(pos);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openAnalyzerScreen(BlockPos pos) {
        Minecraft.getInstance().setScreen((Screen)new MagnifyingGlassScreen(pos));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.smokeleafindustries.plant_analyzer").withStyle(ChatFormatting.GRAY));
    }
}

