/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.network;

import java.util.Optional;
import net.micaxs.smokeleaf.client.paranoia.HallucinationManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ParanoiaHallucinationPayload(ResourceLocation entityTypeId, double x, double y, double z, float yaw, int lifeTicks, ResourceLocation soundIdOrNull) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ParanoiaHallucinationPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"smokeleafindustries", (String)"paranoia_hallucination"));
    public static final StreamCodec<FriendlyByteBuf, ParanoiaHallucinationPayload> STREAM_CODEC = StreamCodec.of((buf, msg) -> {
        ResourceLocation.STREAM_CODEC.encode(buf, (Object)msg.entityTypeId());
        buf.writeDouble(msg.x());
        buf.writeDouble(msg.y());
        buf.writeDouble(msg.z());
        buf.writeFloat(msg.yaw());
        buf.writeVarInt(msg.lifeTicks());
        ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC).encode(buf, Optional.ofNullable(msg.soundIdOrNull()));
    }, buf -> {
        ResourceLocation typeId = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode(buf);
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        float yaw = buf.readFloat();
        int life = buf.readVarInt();
        ResourceLocation sound = ((Optional)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC).decode(buf)).orElse(null);
        return new ParanoiaHallucinationPayload(typeId, x, y, z, yaw, life, sound);
    });

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleClient(ParanoiaHallucinationPayload msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ClientLevel level = Minecraft.getInstance().level;
            if (level == null) {
                return;
            }
            EntityType type = BuiltInRegistries.ENTITY_TYPE.getOptional(msg.entityTypeId()).orElse(null);
            if (type == null) {
                return;
            }
            SoundEvent sound = msg.soundIdOrNull() == null ? null : (SoundEvent)BuiltInRegistries.SOUND_EVENT.getOptional(msg.soundIdOrNull()).orElse(null);
            HallucinationManager.spawn(type, msg.x(), msg.y(), msg.z(), msg.yaw(), msg.lifeTicks(), sound);
        });
    }
}

