/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.micaxs.smokeleaf.recipe.DryingRecipeInput;
import net.micaxs.smokeleaf.recipe.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record DryingRecipe(Ingredient ingredient, ItemStack result, int time, boolean dryBud) implements Recipe<DryingRecipeInput>
{
    public boolean matches(DryingRecipeInput input, Level level) {
        return this.ingredient.test(input.getItem(0));
    }

    public ItemStack assemble(DryingRecipeInput input, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int w, int h) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.ingredient);
        return list;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.DRYING_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.DRYING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<DryingRecipe> {
        public static final MapCodec<DryingRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(DryingRecipe::ingredient), (App)ItemStack.CODEC.optionalFieldOf("result", (Object)ItemStack.EMPTY).forGetter(r -> r.result().isEmpty() ? ItemStack.EMPTY : r.result()), (App)Codec.INT.optionalFieldOf("time", (Object)200).forGetter(DryingRecipe::time), (App)Codec.BOOL.optionalFieldOf("dry_bud", (Object)false).forGetter(DryingRecipe::dryBud)).apply((Applicative)inst, (ing, stack, time, dryBud) -> new DryingRecipe((Ingredient)ing, (ItemStack)stack, (int)time, (boolean)dryBud)));
        public static final StreamCodec<RegistryFriendlyByteBuf, DryingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, DryingRecipe::ingredient, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ItemStack.STREAM_CODEC), r -> r.result().isEmpty() ? Optional.empty() : Optional.of(r.result()), (StreamCodec)ByteBufCodecs.VAR_INT, DryingRecipe::time, (StreamCodec)ByteBufCodecs.BOOL, DryingRecipe::dryBud, (ing, optResult, time, dryBud) -> new DryingRecipe((Ingredient)ing, optResult.orElse(ItemStack.EMPTY), (int)time, (boolean)dryBud));

        public MapCodec<DryingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DryingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

