/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.recipe;

import com.mojang.serialization.MapCodec;
import net.micaxs.smokeleaf.component.ManualGrinderContents;
import net.micaxs.smokeleaf.component.ModDataComponentTypes;
import net.micaxs.smokeleaf.item.custom.ManualGrinderItem;
import net.micaxs.smokeleaf.recipe.ManualGrinderInput;
import net.micaxs.smokeleaf.recipe.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class LoadManualGrinderRecipe
extends CustomRecipe {
    public LoadManualGrinderRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        ItemStack grinder = ItemStack.EMPTY;
        ItemStack ingredient = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof ManualGrinderItem) {
                if (!grinder.isEmpty()) {
                    return false;
                }
                if (stack.has((DataComponentType)ModDataComponentTypes.MANUAL_GRINDER_CONTENTS.get())) {
                    return false;
                }
                grinder = stack;
                continue;
            }
            if (!ingredient.isEmpty()) {
                return false;
            }
            if (!this.hasManualGrinderRecipe(level, stack)) {
                return false;
            }
            ingredient = stack;
        }
        return !grinder.isEmpty() && !ingredient.isEmpty();
    }

    private boolean hasManualGrinderRecipe(Level level, ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        ManualGrinderInput in = new ManualGrinderInput(stack.copyWithCount(1));
        return level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.MANUAL_GRINDER_TYPE.get(), (RecipeInput)in, level).isPresent();
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
        ItemStack grinder = ItemStack.EMPTY;
        ItemStack ingredient = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof ManualGrinderItem) {
                grinder = stack;
                continue;
            }
            if (!ingredient.isEmpty()) continue;
            ingredient = stack;
        }
        if (grinder.isEmpty() || ingredient.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack result = grinder.copy();
        result.setCount(1);
        ItemStack stored = ingredient.copyWithCount(1);
        result.set((DataComponentType)ModDataComponentTypes.MANUAL_GRINDER_CONTENTS.get(), (Object)ManualGrinderContents.fromStack(stored));
        return result;
    }

    public boolean canCraftInDimensions(int w, int h) {
        return w * h >= 2;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<LoadManualGrinderRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final LoadManualGrinderRecipe TEMPLATE = new LoadManualGrinderRecipe(CraftingBookCategory.MISC);
        private static final MapCodec<LoadManualGrinderRecipe> CODEC = MapCodec.unit((Object)((Object)TEMPLATE));
        private static final StreamCodec<RegistryFriendlyByteBuf, LoadManualGrinderRecipe> STREAM_CODEC = StreamCodec.unit((Object)((Object)TEMPLATE));

        public MapCodec<LoadManualGrinderRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, LoadManualGrinderRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

