/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.micaxs.smokeleaf.component.DNAContents;
import net.micaxs.smokeleaf.item.custom.DNAStrandItem;
import net.micaxs.smokeleaf.recipe.ModRecipes;
import net.micaxs.smokeleaf.recipe.SynthesizerRecipeInput;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record SynthesizerRecipe(Ingredient dnaIngredient, ItemStack result) implements Recipe<SynthesizerRecipeInput>
{
    public boolean matches(SynthesizerRecipeInput input, Level level) {
        if (level.isClientSide()) {
            return false;
        }
        if (!this.dnaIngredient.test(input.dna())) {
            return false;
        }
        return !input.reagent1().isEmpty() && !input.reagent2().isEmpty() && !input.reagent3().isEmpty();
    }

    public ItemStack assemble(SynthesizerRecipeInput input, HolderLookup.Provider provider) {
        ItemStack dna = input.dna();
        if (!(dna.getItem() instanceof DNAStrandItem)) {
            return this.result.copy();
        }
        ItemStack filled = dna.copyWithCount(1);
        DNAContents contents = DNAContents.EMPTY;
        ItemStack[] reagents = new ItemStack[]{input.reagent1(), input.reagent2(), input.reagent3()};
        for (int i = 0; i < 3; ++i) {
            if (reagents[i].isEmpty()) continue;
            contents = contents.with(i, reagents[i].copyWithCount(1));
        }
        DNAStrandItem.setContents(filled, contents);
        return filled;
    }

    public boolean canCraftInDimensions(int w, int h) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.SYNTHESIZER_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.SYNTHESIZER_TYPE.get();
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.dnaIngredient);
        return list;
    }

    public static class Serializer
    implements RecipeSerializer<SynthesizerRecipe> {
        private static final MapCodec<SynthesizerRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(SynthesizerRecipe::dnaIngredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(SynthesizerRecipe::result)).apply((Applicative)instance, SynthesizerRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, SynthesizerRecipe> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, SynthesizerRecipe>(){

            public SynthesizerRecipe decode(RegistryFriendlyByteBuf buf) {
                Ingredient dna = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
                ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
                return new SynthesizerRecipe(dna, result);
            }

            public void encode(RegistryFriendlyByteBuf buf, SynthesizerRecipe value) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)value.dnaIngredient);
                ItemStack.STREAM_CODEC.encode((Object)buf, (Object)value.result);
            }
        };

        public MapCodec<SynthesizerRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SynthesizerRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

