/*
 * Decompiled with CFR 0.152.
 */
package net.micaxs.smokeleaf.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;

public class UvImageButton
extends AbstractButton {
    private final ResourceLocation texture;
    private final int texW;
    private final int texH;
    private final int u;
    private final int v;
    private final int w;
    private final int h;
    private final Integer hoverU;
    private final Integer hoverV;
    private final int hoverVOffset;
    private final Consumer<UvImageButton> onPressCb;

    public UvImageButton(int x, int y, int width, int height, int u, int v, int hoverU, int hoverV, ResourceLocation texture, int texW, int texH, Consumer<UvImageButton> onPress) {
        super(x, y, width, height, CommonComponents.EMPTY);
        this.u = u;
        this.v = v;
        this.w = width;
        this.h = height;
        this.hoverU = hoverU;
        this.hoverV = hoverV;
        this.hoverVOffset = 0;
        this.texture = texture;
        this.texW = texW;
        this.texH = texH;
        this.onPressCb = onPress;
    }

    public UvImageButton(int x, int y, int width, int height, int u, int v, int hoverVOffset, ResourceLocation texture, int texW, int texH, Consumer<UvImageButton> onPress) {
        super(x, y, width, height, CommonComponents.EMPTY);
        this.u = u;
        this.v = v;
        this.w = width;
        this.h = height;
        this.hoverU = null;
        this.hoverV = null;
        this.hoverVOffset = hoverVOffset;
        this.texture = texture;
        this.texW = texW;
        this.texH = texH;
        this.onPressCb = onPress;
    }

    public void onPress() {
        if (this.onPressCb != null) {
            this.onPressCb.accept(this);
        }
    }

    protected void renderWidget(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        int du = this.u;
        int dv = this.v;
        if (this.isHoveredOrFocused()) {
            if (this.hoverU != null && this.hoverV != null) {
                du = this.hoverU;
                dv = this.hoverV;
            } else {
                dv = this.v + this.hoverVOffset;
            }
        }
        RenderSystem.enableBlend();
        g.blit(this.texture, this.getX(), this.getY(), (float)du, (float)dv, this.w, this.h, this.texW, this.texH);
        RenderSystem.disableBlend();
    }

    protected void updateWidgetNarration(NarrationElementOutput narration) {
        this.defaultButtonNarrationText(narration);
    }
}

