/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.block.entity;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import noobanidus.mods.lootr.common.api.ILootrBlockEntityConverter;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.advancement.IContainerTrigger;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import noobanidus.mods.lootr.common.api.data.LootrBlockType;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;
import noobanidus.mods.lootr.common.data.LootrInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LootrChestBlockEntity
extends ChestBlockEntity
implements ILootrBlockEntity {
    private final ChestLidController chestLidController = new ChestLidController();
    protected UUID infoId;
    protected boolean hasBeenOpened = false;
    private String cachedId;
    private final Set<UUID> clientOpeners = new ObjectLinkedOpenHashSet();
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            if (!LootrChestBlockEntity.this.hasBeenOpened) {
                LootrChestBlockEntity.this.hasBeenOpened = true;
                LootrChestBlockEntity.this.markChanged();
            }
            LootrChestBlockEntity.playSound(level, pos, state, SoundEvents.CHEST_OPEN);
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            LootrChestBlockEntity.playSound(level, pos, state, SoundEvents.CHEST_CLOSE);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int p_155364_, int p_155365_) {
            LootrChestBlockEntity.this.signalOpenCount(level, pos, state, p_155364_, p_155365_);
        }

        protected boolean isOwnContainer(Player player) {
            ChestMenu menu;
            Container container;
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof ChestMenu && (container = (menu = (ChestMenu)abstractContainerMenu).getContainer()) instanceof LootrInventory) {
                LootrInventory data = (LootrInventory)container;
                return LootrChestBlockEntity.this.getInfoUUID().equals(data.getInfo().getInfoUUID());
            }
            return false;
        }
    };
    protected boolean clientOpened;
    private boolean savingToItem = false;

    protected LootrChestBlockEntity(BlockEntityType<?> p_155327_, BlockPos p_155328_, BlockState p_155329_) {
        super(p_155327_, p_155328_, p_155329_);
    }

    public LootrChestBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        this(LootrRegistry.getChestBlockEntity(), pWorldPosition, pBlockState);
    }

    @Override
    public void defaultTick(Level level, BlockPos pos, BlockState state) {
        ILootrBlockEntity.super.defaultTick(level, pos, state);
        this.chestLidController.tickLid();
    }

    protected static void playSound(Level pLevel, BlockPos pPos, BlockState pState, SoundEvent pSound) {
        ChestType chesttype = (ChestType)pState.getValue((Property)ChestBlock.TYPE);
        if (chesttype != ChestType.LEFT) {
            double d0 = (double)pPos.getX() + 0.5;
            double d1 = (double)pPos.getY() + 0.5;
            double d2 = (double)pPos.getZ() + 0.5;
            if (chesttype == ChestType.RIGHT) {
                Direction direction = ChestBlock.getConnectedDirection((BlockState)pState);
                d0 += (double)direction.getStepX() * 0.5;
                d2 += (double)direction.getStepZ() * 0.5;
            }
            pLevel.playSound(null, d0, d1, d2, pSound, SoundSource.BLOCKS, 0.5f, pLevel.random.nextFloat() * 0.1f + 0.9f);
        }
    }

    public static int getOpenCount(BlockGetter pLevel, BlockPos pPos) {
        BlockEntity blockentity;
        BlockState blockstate = pLevel.getBlockState(pPos);
        if (blockstate.hasBlockEntity() && (blockentity = pLevel.getBlockEntity(pPos)) instanceof LootrChestBlockEntity) {
            LootrChestBlockEntity chest = (LootrChestBlockEntity)blockentity;
            return chest.openersCounter.getOpenerCount();
        }
        return 0;
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.tryLoadLootTable(compound);
        if (compound.hasUUID("LootrId")) {
            this.infoId = compound.getUUID("LootrId");
        }
        if (compound.contains("LootrHasBeenOpened", 1)) {
            this.hasBeenOpened = compound.getBoolean("LootrHasBeenOpened");
        }
        if (this.infoId == null) {
            this.getInfoUUID();
        }
        this.clientOpeners.clear();
        if (compound.contains("LootrOpeners")) {
            ListTag list = compound.getList("LootrOpeners", 11);
            for (Tag thisTag : list) {
                this.clientOpeners.add(NbtUtils.loadUUID((Tag)thisTag));
            }
        }
    }

    public void saveToItem(ItemStack itemstack, HolderLookup.Provider provider) {
        this.savingToItem = true;
        super.saveToItem(itemstack, provider);
        this.savingToItem = false;
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        this.trySaveLootTable(compound);
        if (!LootrAPI.shouldDiscard() && !this.savingToItem) {
            compound.putUUID("LootrId", this.getInfoUUID());
        }
        compound.putBoolean("LootrHasBeenOpened", this.hasBeenOpened);
        if (this.level != null && this.level.isClientSide() && this.clientOpeners != null && !this.clientOpeners.isEmpty()) {
            ListTag list = new ListTag();
            for (UUID opener : this.clientOpeners) {
                list.add((Object)NbtUtils.createUUID((UUID)opener));
            }
            compound.put("LootrOpeners", (Tag)list);
        }
    }

    public boolean triggerEvent(int pId, int pType) {
        if (pId == 1) {
            this.chestLidController.shouldBeOpen(pType > 0);
            return true;
        }
        return super.triggerEvent(pId, pType);
    }

    public void startOpen(Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            this.openersCounter.incrementOpeners(pPlayer, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            this.openersCounter.decrementOpeners(pPlayer, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public float getOpenNess(float pPartialTicks) {
        return this.chestLidController.getOpenness(pPartialTicks);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag result = super.getUpdateTag(provider);
        this.saveAdditional(result, provider);
        Set currentOpeners = this.getVisualOpeners();
        if (currentOpeners != null) {
            ListTag list = new ListTag();
            for (UUID opener : Sets.intersection((Set)currentOpeners, LootrAPI.getPlayerIds())) {
                list.add((Object)NbtUtils.createUUID((UUID)opener));
            }
            if (!list.isEmpty()) {
                result.put("LootrOpeners", (Tag)list);
            }
        }
        return result;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, BlockEntity::getUpdateTag);
    }

    public void unpackLootTable(@Nullable Player player) {
    }

    @Override
    @Nullable
    public Set<UUID> getClientOpeners() {
        return this.clientOpeners;
    }

    @Override
    public LootrBlockType getInfoBlockType() {
        return LootrBlockType.CHEST;
    }

    @Override
    public ILootrInfo.LootrInfoType getInfoType() {
        return ILootrInfo.LootrInfoType.CONTAINER_BLOCK_ENTITY;
    }

    @Override
    public void markChanged() {
        this.setChanged();
        this.markDataChanged();
    }

    @Override
    @NotNull
    public UUID getInfoUUID() {
        if (this.infoId == null) {
            this.infoId = UUID.randomUUID();
        }
        return this.infoId;
    }

    @Override
    public String getInfoKey() {
        if (this.cachedId == null) {
            this.cachedId = ILootrInfo.generateInfoKey(this.getInfoUUID());
        }
        return this.cachedId;
    }

    @Override
    public boolean hasBeenOpened() {
        return this.hasBeenOpened;
    }

    @Override
    public boolean isPhysicallyOpen() {
        return this.getOpenNess(1.0f) > 0.0f;
    }

    @Override
    public boolean isClientOpened() {
        return this.clientOpened;
    }

    @Override
    public void setClientOpened(boolean opened) {
        this.clientOpened = opened;
    }

    @Override
    @NotNull
    public BlockPos getInfoPos() {
        return this.getBlockPos();
    }

    @Override
    public ResourceKey<LootTable> getInfoLootTable() {
        return this.getLootTable();
    }

    @Override
    @Nullable
    public Component getInfoDisplayName() {
        return this.getDisplayName();
    }

    @Override
    @NotNull
    public ResourceKey<Level> getInfoDimension() {
        return this.getLevel().dimension();
    }

    @Override
    public int getInfoContainerSize() {
        return this.getContainerSize();
    }

    @Override
    public long getInfoLootSeed() {
        return this.getLootTableSeed();
    }

    @Override
    @Nullable
    public NonNullList<ItemStack> getInfoReferenceInventory() {
        return null;
    }

    @Override
    public boolean isInfoReferenceInventory() {
        return false;
    }

    @Override
    public Level getInfoLevel() {
        return this.getLevel();
    }

    @Override
    public int getPhysicalOpenerCount() {
        return this.openersCounter.getOpenerCount();
    }

    @Override
    @Nullable
    public IContainerTrigger getTrigger() {
        return LootrRegistry.getChestTrigger();
    }

    public static class DefaultBlockEntityConverter
    implements ILootrBlockEntityConverter<LootrChestBlockEntity> {
        @Override
        public ILootrBlockEntity apply(LootrChestBlockEntity blockEntity) {
            return blockEntity;
        }

        @Override
        public BlockEntityType<?> getBlockEntityType() {
            return LootrRegistry.getChestBlockEntity();
        }
    }
}

