/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.client;

import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.platform.events.ClientTickEvent;
import com.cobblemon.mod.common.platform.events.PlatformEvents;
import fr.harmex.cobbledollars.common.CobbleDollars;
import fr.harmex.cobbledollars.common.client.CobbleDollarsClientImplementation;
import fr.harmex.cobbledollars.common.client.config.ClientConfig;
import fr.harmex.cobbledollars.common.client.gui.CobbleDollarsOverlay;
import fr.harmex.cobbledollars.common.client.renderer.entity.CobbleMerchantRenderer;
import fr.harmex.cobbledollars.common.client.utils.GuiUtilsKt;
import fr.harmex.cobbledollars.common.world.entity.CobbleDollarsEntities;
import fr.harmex.cobbledollars.common.world.entity.CobbleMerchant;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u0003J\u001d\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0010\u0010\u0003J\r\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0011\u0010\u0003R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\bR\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\"\u0010\u001a\u001a\u00020\u00198\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001b\u0010%\u001a\u00020 8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\u00a8\u0006&"}, d2={"Lfr/harmex/cobbledollars/common/client/CobbleDollarsClient;", "", "<init>", "()V", "Lfr/harmex/cobbledollars/common/client/CobbleDollarsClientImplementation;", "implementation", "", "init", "(Lfr/harmex/cobbledollars/common/client/CobbleDollarsClientImplementation;)V", "registerEntityRenderers", "Lnet/minecraft/client/gui/GuiGraphics;", "guiGraphics", "Lnet/minecraft/client/DeltaTracker;", "deltaTracker", "beforeChatRender", "(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V", "loadConfig", "saveConfig", "Lfr/harmex/cobbledollars/common/client/CobbleDollarsClientImplementation;", "getImplementation", "()Lfr/harmex/cobbledollars/common/client/CobbleDollarsClientImplementation;", "setImplementation", "", "CONFIG_PATH", "Ljava/lang/String;", "Lfr/harmex/cobbledollars/common/client/config/ClientConfig;", "config", "Lfr/harmex/cobbledollars/common/client/config/ClientConfig;", "getConfig", "()Lfr/harmex/cobbledollars/common/client/config/ClientConfig;", "setConfig", "(Lfr/harmex/cobbledollars/common/client/config/ClientConfig;)V", "Lfr/harmex/cobbledollars/common/client/gui/CobbleDollarsOverlay;", "overlay$delegate", "Lkotlin/Lazy;", "getOverlay", "()Lfr/harmex/cobbledollars/common/client/gui/CobbleDollarsOverlay;", "overlay", "common"})
public final class CobbleDollarsClient {
    @NotNull
    public static final CobbleDollarsClient INSTANCE = new CobbleDollarsClient();
    public static CobbleDollarsClientImplementation implementation;
    @NotNull
    private static final String CONFIG_PATH = "config/cobbledollars/client.json";
    public static ClientConfig config;
    @NotNull
    private static final Lazy overlay$delegate;

    private CobbleDollarsClient() {
    }

    @NotNull
    public final CobbleDollarsClientImplementation getImplementation() {
        CobbleDollarsClientImplementation cobbleDollarsClientImplementation = implementation;
        if (cobbleDollarsClientImplementation != null) {
            return cobbleDollarsClientImplementation;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"implementation");
        return null;
    }

    public final void setImplementation(@NotNull CobbleDollarsClientImplementation cobbleDollarsClientImplementation) {
        Intrinsics.checkNotNullParameter((Object)cobbleDollarsClientImplementation, (String)"<set-?>");
        implementation = cobbleDollarsClientImplementation;
    }

    @NotNull
    public final ClientConfig getConfig() {
        ClientConfig clientConfig = config;
        if (clientConfig != null) {
            return clientConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        return null;
    }

    public final void setConfig(@NotNull ClientConfig clientConfig) {
        Intrinsics.checkNotNullParameter((Object)clientConfig, (String)"<set-?>");
        config = clientConfig;
    }

    @NotNull
    public final CobbleDollarsOverlay getOverlay() {
        Lazy lazy = overlay$delegate;
        return (CobbleDollarsOverlay)((Object)lazy.getValue());
    }

    public final void init(@NotNull CobbleDollarsClientImplementation implementation) {
        Intrinsics.checkNotNullParameter((Object)implementation, (String)"implementation");
        this.setImplementation(implementation);
        this.registerEntityRenderers();
        this.loadConfig();
        Observable.DefaultImpls.subscribe$default((Observable)((Observable)PlatformEvents.CLIENT_TICK_PRE), null, CobbleDollarsClient::init$lambda$1, (int)1, null);
    }

    public final void registerEntityRenderers() {
        CobbleDollarsClientImplementation cobbleDollarsClientImplementation = this.getImplementation();
        EntityType<CobbleMerchant> entityType = CobbleDollarsEntities.COBBLE_MERCHANT;
        Intrinsics.checkNotNullExpressionValue(entityType, (String)"COBBLE_MERCHANT");
        cobbleDollarsClientImplementation.registerEntityRenderer(entityType, CobbleMerchantRenderer::new);
    }

    public final void beforeChatRender(@NotNull GuiGraphics guiGraphics, @NotNull DeltaTracker deltaTracker) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter((Object)deltaTracker, (String)"deltaTracker");
        this.getOverlay().render(guiGraphics, deltaTracker);
    }

    public final void loadConfig() {
        File configFile = new File(CONFIG_PATH);
        configFile.getParentFile().mkdirs();
        if (configFile.exists()) {
            try {
                FileReader reader = new FileReader(configFile);
                this.setConfig((ClientConfig)ClientConfig.Companion.getGSON().fromJson((Reader)reader, ClientConfig.class));
                reader.close();
            }
            catch (Exception exception) {
                this.setConfig(new ClientConfig());
                CobbleDollars.INSTANCE.getLOGGER().error("Failed to load the config! Using default config until the following has been addressed:");
                exception.printStackTrace();
            }
        } else {
            this.setConfig(new ClientConfig());
        }
        this.saveConfig();
    }

    public final void saveConfig() {
        try {
            File configFile = new File(CONFIG_PATH);
            FileWriter writer = new FileWriter(configFile);
            ClientConfig.Companion.getGSON().toJson((Object)this.getConfig(), (Appendable)writer);
            writer.close();
        }
        catch (Exception exception) {
            CobbleDollars.INSTANCE.getLOGGER().error("Failed to save the config! Please consult the following stack trace:");
            exception.printStackTrace();
        }
    }

    private static final CobbleDollarsOverlay overlay_delegate$lambda$0() {
        return new CobbleDollarsOverlay();
    }

    private static final Unit init$lambda$1(ClientTickEvent.Pre it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        GuiUtilsKt.tick();
        return Unit.INSTANCE;
    }

    static {
        overlay$delegate = LazyKt.lazy(CobbleDollarsClient::overlay_delegate$lambda$0);
    }
}

