/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import fr.harmex.cobbledollars.common.client.CobbleDollarsClient;
import fr.harmex.cobbledollars.common.client.utils.OverlayPosition;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ/\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0007J\u000f\u0010\u001a\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0002\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010\u001cR\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0016\u0010#\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010\"\u00a8\u0006$"}, d2={"Lfr/harmex/cobbledollars/common/client/gui/screen/ClientConfigScreen;", "Lnet/minecraft/client/gui/screens/Screen;", "parent", "<init>", "(Lnet/minecraft/client/gui/screens/Screen;)V", "", "init", "()V", "", "mouseX", "mouseY", "", "button", "", "mouseClicked", "(DDI)Z", "Lnet/minecraft/client/gui/GuiGraphics;", "guiGraphics", "", "partialTick", "render", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "renderListBackground", "(Lnet/minecraft/client/gui/GuiGraphics;)V", "renderListSeparators", "onClose", "isPauseScreen", "()Z", "Lnet/minecraft/client/gui/screens/Screen;", "Lnet/minecraft/client/gui/components/CycleButton;", "Lfr/harmex/cobbledollars/common/client/utils/OverlayPosition;", "overlayPositionButton", "Lnet/minecraft/client/gui/components/CycleButton;", "centerX", "I", "centerY", "common"})
public final class ClientConfigScreen
extends Screen {
    @NotNull
    private final Screen parent;
    private CycleButton<OverlayPosition> overlayPositionButton;
    private int centerX;
    private int centerY;

    public ClientConfigScreen(@NotNull Screen parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super((Component)Component.literal((String)"CobbleDollars Client Config"));
        this.parent = parent;
    }

    protected void init() {
        this.centerX = this.width / 2;
        this.centerY = this.height / 2;
        this.overlayPositionButton = CycleButton.builder(OverlayPosition::getDisplayName).withValues((Collection)OverlayPosition.getEntries()).withInitialValue((Object)CobbleDollarsClient.INSTANCE.getConfig().getOverlayPosition()).create(this.centerX - 100, this.centerY - 10, 200, 20, (Component)Component.literal((String)"Overlay Position"), ClientConfigScreen::init$lambda$0);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        CycleButton<OverlayPosition> cycleButton = this.overlayPositionButton;
        if (cycleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overlayPositionButton");
            cycleButton = null;
        }
        if (!cycleButton.mouseClicked(mouseX, mouseY, button)) {
            CycleButton<OverlayPosition> cycleButton2 = this.overlayPositionButton;
            if (cycleButton2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"overlayPositionButton");
                cycleButton2 = null;
            }
            cycleButton2.setFocused(false);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderListBackground(guiGraphics);
        this.renderListSeparators(guiGraphics);
        CycleButton<OverlayPosition> cycleButton = this.overlayPositionButton;
        if (cycleButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overlayPositionButton");
            cycleButton = null;
        }
        cycleButton.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 15, 0xFFFFFF);
    }

    private final void renderListBackground(GuiGraphics guiGraphics) {
        RenderSystem.enableBlend();
        guiGraphics.fill(RenderType.gui(), 0, 39, this.width, this.height - 38, 0x70000000);
        RenderSystem.disableBlend();
    }

    private final void renderListSeparators(GuiGraphics guiGraphics) {
        RenderSystem.enableBlend();
        guiGraphics.hLine(0, this.width, 37, 0x33FFFFFF);
        guiGraphics.hLine(0, this.width, 38, -1090519040);
        guiGraphics.hLine(0, this.width, this.height - 38, -1090519040);
        guiGraphics.hLine(0, this.width, this.height - 37, 0x33FFFFFF);
        RenderSystem.disableBlend();
    }

    public void onClose() {
        CobbleDollarsClient.INSTANCE.saveConfig();
        Minecraft minecraft = this.minecraft;
        Intrinsics.checkNotNull((Object)minecraft);
        minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return true;
    }

    private static final void init$lambda$0(CycleButton button, OverlayPosition overlayPosition) {
        CobbleDollarsClient.INSTANCE.getConfig().setOverlayPosition(overlayPosition);
    }
}

