/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.command;

import com.cobblemon.mod.common.api.permission.Permission;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import fr.harmex.cobbledollars.common.CobbleDollars;
import fr.harmex.cobbledollars.common.command.arguments.BigIntegerArgumentType;
import fr.harmex.cobbledollars.common.command.permission.CobbleDollarsPermissions;
import fr.harmex.cobbledollars.common.config.BankConfig;
import fr.harmex.cobbledollars.common.config.CommonConfig;
import fr.harmex.cobbledollars.common.config.ShopConfig;
import fr.harmex.cobbledollars.common.network.CobbleDollarsNetwork;
import fr.harmex.cobbledollars.common.network.packets.s2c.SyncShopConfigPacket;
import fr.harmex.cobbledollars.common.utils.MiscUtilsKt;
import fr.harmex.cobbledollars.common.utils.extensions.BigIntegerExtensionsKt;
import fr.harmex.cobbledollars.common.utils.extensions.PlayerExtensionKt;
import fr.harmex.cobbledollars.common.world.cobbledollars.CobbleDollarsAccount;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J-\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J-\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0018J-\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ!\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u001d\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b \u0010\u001c\u00a8\u0006!"}, d2={"Lfr/harmex/cobbledollars/common/command/CobbleDollarsCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "sourceStack", "Lnet/minecraft/server/level/ServerPlayer;", "target", "Ljava/math/BigInteger;", "amount", "", "pay", "(Lnet/minecraft/commands/CommandSourceStack;Lnet/minecraft/server/level/ServerPlayer;Ljava/math/BigInteger;)I", "Lnet/minecraft/world/entity/player/Player;", "query", "(Lnet/minecraft/commands/CommandSourceStack;Lnet/minecraft/world/entity/player/Player;)I", "", "targets", "give", "(Lnet/minecraft/commands/CommandSourceStack;Ljava/util/Collection;Ljava/math/BigInteger;)I", "remove", "set", "reload", "(Lnet/minecraft/commands/CommandSourceStack;)I", "page", "displayLeaderboard", "(Lnet/minecraft/commands/CommandSourceStack;I)I", "updateLeaderboard", "common"})
@SourceDebugExtension(value={"SMAP\nCobbleDollarsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CobbleDollarsCommand.kt\nfr/harmex/cobbledollars/common/command/CobbleDollarsCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n1557#2:285\n1628#2,3:286\n1062#2:289\n1872#2,3:290\n*S KotlinDebug\n*F\n+ 1 CobbleDollarsCommand.kt\nfr/harmex/cobbledollars/common/command/CobbleDollarsCommand\n*L\n188#1:285\n188#1:286,3\n189#1:289\n216#1:290,3\n*E\n"})
public final class CobbleDollarsCommand {
    @NotNull
    public static final CobbleDollarsCommand INSTANCE = new CobbleDollarsCommand();

    private CobbleDollarsCommand() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)"cobbledollars");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        LiteralArgumentBuilder literalArgumentBuilder2 = (LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)((ArgumentBuilder)literalArgumentBuilder), (Permission)CobbleDollarsPermissions.INSTANCE.getCOBBLE_DOLLARS(), (boolean)false, (int)2, null);
        LiteralArgumentBuilder literalArgumentBuilder3 = Commands.literal((String)"pay");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder3, (String)"literal(...)");
        LiteralArgumentBuilder literalArgumentBuilder4 = (LiteralArgumentBuilder)literalArgumentBuilder2.then(((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)((ArgumentBuilder)literalArgumentBuilder3), (Permission)CobbleDollarsPermissions.INSTANCE.getCOBBLE_DOLLARS_PAY(), (boolean)false, (int)2, null)).then(Commands.argument((String)"target", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"amount", (ArgumentType)BigIntegerArgumentType.Companion.bigInt(1)).executes(CobbleDollarsCommand::register$lambda$0))));
        LiteralArgumentBuilder literalArgumentBuilder5 = Commands.literal((String)"query");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder5, (String)"literal(...)");
        LiteralArgumentBuilder literalArgumentBuilder6 = (LiteralArgumentBuilder)literalArgumentBuilder4.then(((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)((ArgumentBuilder)literalArgumentBuilder5), (Permission)CobbleDollarsPermissions.INSTANCE.getCOBBLE_DOLLARS_QUERY(), (boolean)false, (int)2, null)).then(Commands.argument((String)"target", (ArgumentType)((ArgumentType)EntityArgument.player())).executes(CobbleDollarsCommand::register$lambda$1)));
        LiteralArgumentBuilder literalArgumentBuilder7 = Commands.literal((String)"give");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder7, (String)"literal(...)");
        LiteralArgumentBuilder literalArgumentBuilder8 = (LiteralArgumentBuilder)literalArgumentBuilder6.then(((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)((ArgumentBuilder)literalArgumentBuilder7), (Permission)CobbleDollarsPermissions.INSTANCE.getCOBBLE_DOLLARS_GIVE(), (boolean)false, (int)2, null)).then(Commands.argument((String)"targets", (ArgumentType)((ArgumentType)EntityArgument.players())).then(Commands.argument((String)"amount", (ArgumentType)BigIntegerArgumentType.Companion.bigInt(1)).executes(CobbleDollarsCommand::register$lambda$2))));
        LiteralArgumentBuilder literalArgumentBuilder9 = Commands.literal((String)"remove");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder9, (String)"literal(...)");
        LiteralArgumentBuilder literalArgumentBuilder10 = (LiteralArgumentBuilder)literalArgumentBuilder8.then(((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)((ArgumentBuilder)literalArgumentBuilder9), (Permission)CobbleDollarsPermissions.INSTANCE.getCOBBLE_DOLLARS_REMOVE(), (boolean)false, (int)2, null)).then(Commands.argument((String)"targets", (ArgumentType)((ArgumentType)EntityArgument.players())).then(Commands.argument((String)"amount", (ArgumentType)BigIntegerArgumentType.Companion.bigInt(1)).executes(CobbleDollarsCommand::register$lambda$3))));
        LiteralArgumentBuilder literalArgumentBuilder11 = Commands.literal((String)"set");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder11, (String)"literal(...)");
        LiteralArgumentBuilder literalArgumentBuilder12 = (LiteralArgumentBuilder)literalArgumentBuilder10.then(((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)((ArgumentBuilder)literalArgumentBuilder11), (Permission)CobbleDollarsPermissions.INSTANCE.getCOBBLE_DOLLARS_SET(), (boolean)false, (int)2, null)).then(Commands.argument((String)"targets", (ArgumentType)((ArgumentType)EntityArgument.players())).then(Commands.argument((String)"amount", (ArgumentType)BigIntegerArgumentType.Companion.bigInt(0)).executes(CobbleDollarsCommand::register$lambda$4))));
        LiteralArgumentBuilder literalArgumentBuilder13 = Commands.literal((String)"reload");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder13, (String)"literal(...)");
        LiteralArgumentBuilder literalArgumentBuilder14 = (LiteralArgumentBuilder)literalArgumentBuilder12.then(((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)((ArgumentBuilder)literalArgumentBuilder13), (Permission)CobbleDollarsPermissions.INSTANCE.getCOBBLE_DOLLARS_RELOAD(), (boolean)false, (int)2, null)).executes(CobbleDollarsCommand::register$lambda$5));
        LiteralArgumentBuilder literalArgumentBuilder15 = Commands.literal((String)"leaderboard");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder15, (String)"literal(...)");
        LiteralArgumentBuilder literalArgumentBuilder16 = (LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)((ArgumentBuilder)literalArgumentBuilder15), (Permission)CobbleDollarsPermissions.INSTANCE.getCOBBLE_DOLLARS_LEADERBOARD(), (boolean)false, (int)2, null)).executes(CobbleDollarsCommand::register$lambda$6);
        LiteralArgumentBuilder literalArgumentBuilder17 = Commands.literal((String)"update");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder17, (String)"literal(...)");
        LiteralCommandNode mainNode = dispatcher.register((LiteralArgumentBuilder)literalArgumentBuilder14.then(literalArgumentBuilder16.then(((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)((ArgumentBuilder)literalArgumentBuilder17), (Permission)CobbleDollarsPermissions.INSTANCE.getCOBBLE_DOLLARS_LEADERBOARD_UPDATE(), (boolean)false, (int)2, null)).executes(CobbleDollarsCommand::register$lambda$7))));
        LiteralArgumentBuilder literalArgumentBuilder18 = Commands.literal((String)"cd");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder18, (String)"literal(...)");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)((ArgumentBuilder)literalArgumentBuilder18), (Permission)CobbleDollarsPermissions.INSTANCE.getCOBBLE_DOLLARS(), (boolean)false, (int)2, null)).redirect((CommandNode)mainNode));
    }

    private final int pay(CommandSourceStack sourceStack, ServerPlayer target, BigInteger amount) {
        ServerPlayer serverPlayer = sourceStack.getPlayerOrException();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayerOrException(...)");
        if (amount.compareTo(PlayerExtensionKt.getCobbleDollars((Player)serverPlayer)) > 0) {
            sourceStack.sendFailure((Component)MiscUtilsKt.cobbleDollarsCommand("pay.fail", new Object[0]));
            return 0;
        }
        Object[] objectArray = sourceStack.getPlayerOrException();
        Intrinsics.checkNotNull((Object)objectArray);
        Player player = (Player)objectArray;
        BigInteger bigInteger = PlayerExtensionKt.getCobbleDollars((Player)objectArray).subtract(amount);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"subtract(...)");
        PlayerExtensionKt.setCobbleDollars(player, bigInteger);
        Player player2 = (Player)target;
        BigInteger bigInteger2 = PlayerExtensionKt.getCobbleDollars((Player)target).add(amount);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"add(...)");
        PlayerExtensionKt.setCobbleDollars(player2, bigInteger2);
        objectArray = new Object[2];
        ServerPlayer serverPlayer2 = sourceStack.getPlayer();
        Intrinsics.checkNotNull((Object)serverPlayer2);
        Intrinsics.checkNotNull((Object)serverPlayer2.getDisplayName());
        objectArray[1] = TextKt.green((MutableComponent)BigIntegerExtensionsKt.format$default(amount, false, 1, null));
        target.sendSystemMessage((Component)MiscUtilsKt.cobbleDollarsCommand("pay.receive", objectArray));
        sourceStack.sendSuccess(() -> CobbleDollarsCommand.pay$lambda$8(amount, target), true);
        return amount.intValue();
    }

    private final int query(CommandSourceStack sourceStack, Player target) {
        BigInteger cobbleDollars = PlayerExtensionKt.getCobbleDollars(target);
        sourceStack.sendSuccess(() -> CobbleDollarsCommand.query$lambda$9(target, cobbleDollars), false);
        return cobbleDollars.intValue();
    }

    private final int give(CommandSourceStack sourceStack, Collection<? extends ServerPlayer> targets, BigInteger amount) {
        for (ServerPlayer serverPlayer : targets) {
            Player player = (Player)serverPlayer;
            BigInteger bigInteger = PlayerExtensionKt.getCobbleDollars((Player)serverPlayer).add(amount);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"add(...)");
            PlayerExtensionKt.setCobbleDollars(player, bigInteger);
        }
        if (targets.size() == 1) {
            sourceStack.sendSuccess(() -> CobbleDollarsCommand.give$lambda$10(amount, targets), true);
        } else {
            sourceStack.sendSuccess(() -> CobbleDollarsCommand.give$lambda$11(amount, targets), true);
        }
        return targets.size();
    }

    private final int remove(CommandSourceStack sourceStack, Collection<? extends ServerPlayer> targets, BigInteger amount) {
        for (ServerPlayer serverPlayer : targets) {
            Player player = (Player)serverPlayer;
            BigInteger bigInteger = PlayerExtensionKt.getCobbleDollars((Player)serverPlayer).subtract((BigInteger)RangesKt.coerceAtMost((Comparable)amount, (Comparable)PlayerExtensionKt.getCobbleDollars((Player)serverPlayer)));
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"subtract(...)");
            PlayerExtensionKt.setCobbleDollars(player, bigInteger);
        }
        if (targets.size() == 1) {
            sourceStack.sendSuccess(() -> CobbleDollarsCommand.remove$lambda$12(amount, targets), true);
        } else {
            sourceStack.sendSuccess(() -> CobbleDollarsCommand.remove$lambda$13(amount, targets), true);
        }
        return targets.size();
    }

    private final int set(CommandSourceStack sourceStack, Collection<? extends ServerPlayer> targets, BigInteger amount) {
        for (ServerPlayer serverPlayer : targets) {
            PlayerExtensionKt.setCobbleDollars((Player)serverPlayer, amount);
        }
        if (targets.size() == 1) {
            sourceStack.sendSuccess(() -> CobbleDollarsCommand.set$lambda$14(amount, targets), true);
        } else {
            sourceStack.sendSuccess(() -> CobbleDollarsCommand.set$lambda$15(amount, targets), true);
        }
        return targets.size();
    }

    private final int reload(CommandSourceStack sourceStack) {
        CommonConfig.Companion.load();
        ShopConfig.Companion.load();
        BankConfig.Companion.load();
        CobbleDollars.INSTANCE.getSaveExecutor().close();
        MinecraftServer minecraftServer = sourceStack.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        CobbleDollars.INSTANCE.saveSchedule(minecraftServer);
        CobbleDollarsNetwork.INSTANCE.sendToAllPlayers(new SyncShopConfigPacket(CobbleDollars.INSTANCE.getShopConfig().getDefaultShop(), CobbleDollars.INSTANCE.getBankConfig().getBank()));
        sourceStack.sendSuccess(CobbleDollarsCommand::reload$lambda$16, true);
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private final int displayLeaderboard(CommandSourceStack sourceStack, int page) {
        void $this$sortedByDescending$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        sourceStack.sendSystemMessage((Component)Component.empty());
        Iterable iterable = CobbleDollars.INSTANCE.getCobbleDollarsAccounts();
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CobbleDollarsAccount cobbleDollarsAccount = (CobbleDollarsAccount)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String playerName = cobbleDollarsAccount.component1();
            BigInteger balance = cobbleDollarsAccount.component2();
            collection.add(new Pair((Object)playerName, (Object)balance));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        List leaderboard = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair pair = (Pair)b;
                boolean bl = false;
                BigInteger balance = (BigInteger)pair.component2();
                pair = (Pair)a;
                Comparable comparable = balance;
                bl = false;
                balance = (BigInteger)pair.component2();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)balance);
            }
        });
        int pageAmount = leaderboard.size() / 10 + 1;
        Duration nextSaveDuration = Duration.between(LocalDateTime.now(), CobbleDollars.INSTANCE.getNextSaveDateTime());
        MutableComponent mutableComponent = Component.literal((String)"CobbleDollars Leaderboard");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        MutableComponent headerComponent = TextKt.green((MutableComponent)mutableComponent);
        if (pageAmount > 1) {
            headerComponent.append(" ").append((Component)TextKt.green((String)"(")).append((Component)TextKt.darkGreen((String)String.valueOf(page + 1))).append((Component)TextKt.green((String)("/" + pageAmount + ")")));
        }
        if (nextSaveDuration.getSeconds() >= 0L) {
            headerComponent.append(" ").append((Component)TextKt.darkGray((String)("(" + nextSaveDuration.getSeconds() + "s)")));
        }
        headerComponent.append((Component)TextKt.green((String)":"));
        sourceStack.sendSystemMessage((Component)headerComponent);
        int startIndex = page * 10;
        int endIndex = Math.min(startIndex + 10, leaderboard.size());
        Iterable $this$forEachIndexed$iv = leaderboard.subList(startIndex, endIndex);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            MutableComponent mutableComponent2;
            MutableComponent rankComponent;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair = (Pair)item$iv;
            int index = n;
            boolean bl = false;
            String playerName = (String)pair.component1();
            BigInteger balance = (BigInteger)pair.component2();
            int rank = startIndex + index + 1;
            boolean isOdd = rank % 2 == 1;
            ServerPlayer serverPlayer = sourceStack.getPlayer();
            boolean isCurrentPlayer = Intrinsics.areEqual((Object)playerName, serverPlayer != null && (serverPlayer = serverPlayer.getName()) != null ? serverPlayer.getString() : null);
            if (isCurrentPlayer) {
                MutableComponent mutableComponent3 = Component.literal((String)(rank + ". "));
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"literal(...)");
                v3 = TextKt.gold((MutableComponent)mutableComponent3);
            } else if (isOdd) {
                v3 = Component.literal((String)(rank + ". "));
            } else {
                MutableComponent mutableComponent4 = Component.literal((String)(rank + ". "));
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent4, (String)"literal(...)");
                v3 = rankComponent = TextKt.gray((MutableComponent)mutableComponent4);
            }
            if (isCurrentPlayer) {
                MutableComponent mutableComponent5 = Component.literal((String)playerName);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent5, (String)"literal(...)");
                mutableComponent2 = TextKt.gold((MutableComponent)mutableComponent5);
            } else if (isOdd) {
                mutableComponent2 = Component.literal((String)playerName);
            } else {
                MutableComponent mutableComponent6 = Component.literal((String)playerName);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent6, (String)"literal(...)");
                mutableComponent2 = TextKt.gray((MutableComponent)mutableComponent6);
            }
            MutableComponent nameComponent = mutableComponent2;
            MutableComponent balanceComponent = isOdd ? TextKt.green((MutableComponent)BigIntegerExtensionsKt.format$default(balance, false, 1, null)) : TextKt.darkGreen((MutableComponent)BigIntegerExtensionsKt.format$default(balance, false, 1, null));
            MutableComponent message = rankComponent.append((Component)nameComponent).append(" ").append((Component)balanceComponent);
            sourceStack.sendSystemMessage((Component)message);
        }
        boolean hasPreviousPage = page > 0;
        boolean hasNextPage = (page + 1) * 10 < leaderboard.size();
        MutableComponent pageSelector = Component.empty();
        if (hasPreviousPage) {
            MutableComponent mutableComponent7 = Component.literal((String)"<<-");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent7, (String)"literal(...)");
            pageSelector.append((Component)TextKt.onClick$default((MutableComponent)TextKt.onHover((MutableComponent)mutableComponent7, (String)("Page " + page)), (boolean)false, arg_0 -> CobbleDollarsCommand.displayLeaderboard$lambda$20(sourceStack, page, arg_0), (int)1, null));
        }
        if (hasPreviousPage && hasNextPage) {
            pageSelector.append((Component)Component.literal((String)" | "));
        }
        if (hasNextPage) {
            MutableComponent mutableComponent8 = Component.literal((String)"->>");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent8, (String)"literal(...)");
            pageSelector.append((Component)TextKt.onClick$default((MutableComponent)TextKt.onHover((MutableComponent)mutableComponent8, (String)("Page " + (page + 2))), (boolean)false, arg_0 -> CobbleDollarsCommand.displayLeaderboard$lambda$21(sourceStack, page, arg_0), (int)1, null));
        }
        sourceStack.sendSystemMessage((Component)pageSelector);
        return 1;
    }

    static /* synthetic */ int displayLeaderboard$default(CobbleDollarsCommand cobbleDollarsCommand, CommandSourceStack commandSourceStack, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return cobbleDollarsCommand.displayLeaderboard(commandSourceStack, n);
    }

    private final int updateLeaderboard(CommandSourceStack sourceStack) {
        CobbleDollars.INSTANCE.getSaveExecutor().close();
        MinecraftServer minecraftServer = sourceStack.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        CobbleDollars.INSTANCE.saveSchedule(minecraftServer);
        sourceStack.sendSuccess(CobbleDollarsCommand::updateLeaderboard$lambda$22, true);
        return 1;
    }

    private static final int register$lambda$0(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        ServerPlayer serverPlayer = EntityArgument.getPlayer((CommandContext)context, (String)"target");
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayer(...)");
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.pay(commandSourceStack, serverPlayer, BigIntegerArgumentType.Companion.getBigInteger(context, "amount"));
    }

    private static final int register$lambda$1(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        ServerPlayer serverPlayer = EntityArgument.getPlayer((CommandContext)context, (String)"target");
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayer(...)");
        return INSTANCE.query(commandSourceStack, (Player)serverPlayer);
    }

    private static final int register$lambda$2(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        Collection collection = EntityArgument.getPlayers((CommandContext)context, (String)"targets");
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPlayers(...)");
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.give(commandSourceStack, collection, BigIntegerArgumentType.Companion.getBigInteger(context, "amount"));
    }

    private static final int register$lambda$3(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        Collection collection = EntityArgument.getPlayers((CommandContext)context, (String)"targets");
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPlayers(...)");
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.remove(commandSourceStack, collection, BigIntegerArgumentType.Companion.getBigInteger(context, "amount"));
    }

    private static final int register$lambda$4(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        Collection collection = EntityArgument.getPlayers((CommandContext)context, (String)"targets");
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPlayers(...)");
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.set(commandSourceStack, collection, BigIntegerArgumentType.Companion.getBigInteger(context, "amount"));
    }

    private static final int register$lambda$5(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        return INSTANCE.reload((CommandSourceStack)object);
    }

    private static final int register$lambda$6(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        return CobbleDollarsCommand.displayLeaderboard$default(INSTANCE, (CommandSourceStack)object, 0, 2, null);
    }

    private static final int register$lambda$7(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        return INSTANCE.updateLeaderboard((CommandSourceStack)object);
    }

    private static final Component pay$lambda$8(BigInteger $amount, ServerPlayer $target) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        Object[] objectArray = new Object[2];
        objectArray[0] = TextKt.red((MutableComponent)BigIntegerExtensionsKt.format$default($amount, false, 1, null));
        Intrinsics.checkNotNull((Object)$target.getDisplayName());
        return (Component)MiscUtilsKt.cobbleDollarsCommand("pay.success", objectArray);
    }

    private static final Component query$lambda$9(Player $target, BigInteger $cobbleDollars) {
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        Intrinsics.checkNotNullParameter((Object)$cobbleDollars, (String)"$cobbleDollars");
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNull((Object)$target.getDisplayName());
        objectArray[1] = TextKt.green((MutableComponent)BigIntegerExtensionsKt.format$default($cobbleDollars, false, 1, null));
        return (Component)MiscUtilsKt.cobbleDollarsCommand("query.success", objectArray);
    }

    private static final Component give$lambda$10(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[2];
        objectArray[0] = TextKt.green((MutableComponent)BigIntegerExtensionsKt.format$default($amount, false, 1, null));
        Intrinsics.checkNotNull((Object)((ServerPlayer)$targets.iterator().next()).getDisplayName());
        return (Component)MiscUtilsKt.cobbleDollarsCommand("give.success.single", objectArray);
    }

    private static final Component give$lambda$11(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[]{TextKt.green((MutableComponent)BigIntegerExtensionsKt.format$default($amount, false, 1, null)), $targets.size()};
        return (Component)MiscUtilsKt.cobbleDollarsCommand("give.success.multiple", objectArray);
    }

    private static final Component remove$lambda$12(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[2];
        objectArray[0] = TextKt.red((MutableComponent)BigIntegerExtensionsKt.format$default($amount, false, 1, null));
        Intrinsics.checkNotNull((Object)((ServerPlayer)$targets.iterator().next()).getDisplayName());
        return (Component)MiscUtilsKt.cobbleDollarsCommand("remove.success.single", objectArray);
    }

    private static final Component remove$lambda$13(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[]{TextKt.red((MutableComponent)BigIntegerExtensionsKt.format$default($amount, false, 1, null)), $targets.size()};
        return (Component)MiscUtilsKt.cobbleDollarsCommand("remove.success.multiple", objectArray);
    }

    private static final Component set$lambda$14(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[2];
        objectArray[0] = TextKt.green((MutableComponent)BigIntegerExtensionsKt.format$default($amount, false, 1, null));
        Intrinsics.checkNotNull((Object)((ServerPlayer)$targets.iterator().next()).getDisplayName());
        return (Component)MiscUtilsKt.cobbleDollarsCommand("set.success.single", objectArray);
    }

    private static final Component set$lambda$15(BigInteger $amount, Collection $targets) {
        Intrinsics.checkNotNullParameter((Object)$amount, (String)"$amount");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Object[] objectArray = new Object[]{TextKt.green((MutableComponent)BigIntegerExtensionsKt.format$default($amount, false, 1, null)), $targets.size()};
        return (Component)MiscUtilsKt.cobbleDollarsCommand("set.success.multiple", objectArray);
    }

    private static final Component reload$lambda$16() {
        return (Component)MiscUtilsKt.cobbleDollarsCommand("reload", new Object[0]);
    }

    private static final Unit displayLeaderboard$lambda$20(CommandSourceStack $sourceStack, int $page, ServerPlayer it) {
        Intrinsics.checkNotNullParameter((Object)$sourceStack, (String)"$sourceStack");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.displayLeaderboard($sourceStack, $page - 1);
        return Unit.INSTANCE;
    }

    private static final Unit displayLeaderboard$lambda$21(CommandSourceStack $sourceStack, int $page, ServerPlayer it) {
        Intrinsics.checkNotNullParameter((Object)$sourceStack, (String)"$sourceStack");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.displayLeaderboard($sourceStack, $page + 1);
        return Unit.INSTANCE;
    }

    private static final Component updateLeaderboard$lambda$22() {
        return (Component)MiscUtilsKt.cobbleDollarsCommand("leaderboard.update", new Object[0]);
    }
}

