/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.mixin;

import fr.harmex.cobbledollars.common.utils.extensions.CompoundTagExtensionKt;
import fr.harmex.cobbledollars.common.utils.extensions.PlayerExtensionKt;
import fr.harmex.cobbledollars.common.world.entity.villager.CobbleDollarsProfessions;
import fr.harmex.cobbledollars.common.world.item.trading.CobbleDollarsShopHolder;
import fr.harmex.cobbledollars.common.world.item.trading.shop.Shop;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Villager.class})
public class VillagerMixin
implements CobbleDollarsShopHolder {
    @Unique
    private Shop shop = new Shop();
    @Unique
    @NotNull
    private @NotNull Set<@NotNull Player> tradingPlayers = new HashSet<Player>();

    @Inject(method={"mobInteract"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/npc/Villager;level()Lnet/minecraft/world/level/Level;", ordinal=1, shift=At.Shift.AFTER)}, cancellable=true)
    private void cobbleMerchantInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (this.cobbleDollars$isCobbleMerchant() && !player.level().isClientSide) {
            if (player.isShiftKeyDown()) {
                PlayerExtensionKt.openBank(player, this);
            } else {
                PlayerExtensionKt.openShop(player, this);
                this.tradingPlayers.add(player);
            }
            cir.setReturnValue((Object)InteractionResult.CONSUME);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    private void addShopToNbt(CompoundTag compound, CallbackInfo ci) {
        if (this.shop != null) {
            CompoundTagExtensionKt.putShop(compound, this.shop, this.cobbleDollars$self().registryAccess());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    private void readShopFromNbt(CompoundTag compound, CallbackInfo ci) {
        if (compound.contains("CobbleMerchantShop")) {
            this.shop = CompoundTagExtensionKt.getShop(compound, this.cobbleDollars$self().registryAccess());
        }
    }

    @Override
    @Unique
    @Nullable
    public Shop getShop() {
        return this.shop;
    }

    @Override
    @Unique
    public void setShop(@Nullable Shop shop) {
        this.shop = shop;
    }

    @Override
    @Unique
    @NotNull
    public UUID getMerchantUUID() {
        return this.cobbleDollars$self().getUUID();
    }

    @Override
    @Unique
    public void setMerchantUUID(@NotNull UUID uuid) {
    }

    @Unique
    private boolean cobbleDollars$isCobbleMerchant() {
        return this.cobbleDollars$self().getVillagerData().getProfession() == CobbleDollarsProfessions.COBBLE_MERCHANT;
    }

    @Unique
    private Villager cobbleDollars$self() {
        return (Villager)this;
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull Player> getTradingPlayers() {
        return this.tradingPlayers;
    }

    @Override
    public void setTradingPlayers(@NotNull @NotNull Set<@NotNull Player> players) {
        this.tradingPlayers = players;
    }
}

