/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import fr.harmex.cobbledollars.common.utils.extensions.CompoundTagExtensionKt;
import fr.harmex.cobbledollars.common.world.item.trading.CobbleDollarsShopHolder;
import fr.harmex.cobbledollars.common.world.item.trading.shop.Shop;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ZombieVillager.class})
public class ZombieVillagerMixin
implements CobbleDollarsShopHolder {
    @Unique
    private Shop shop = new Shop();
    @Unique
    private Set<Player> tradingPlayers = new HashSet<Player>();

    @Inject(method={"finishConversion"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/npc/Villager;setVillagerData(Lnet/minecraft/world/entity/npc/VillagerData;)V", shift=At.Shift.AFTER)})
    private void transferCobbleMerchantShop(ServerLevel serverLevel, CallbackInfo ci, @Local Villager villager) {
        ((CobbleDollarsShopHolder)villager).setShop(this.shop);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    private void addShopToNbt(CompoundTag compound, CallbackInfo ci) {
        if (this.shop != null) {
            CompoundTagExtensionKt.putShop(compound, this.shop, this.cobbleDollars$self().registryAccess());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    private void readShopFromNbt(CompoundTag compound, CallbackInfo ci) {
        if (compound.contains("CobbleMerchantShop")) {
            this.shop = CompoundTagExtensionKt.getShop(compound, this.cobbleDollars$self().registryAccess());
        }
    }

    @Override
    @Unique
    @Nullable
    public Shop getShop() {
        return this.shop;
    }

    @Override
    @Unique
    public void setShop(@Nullable Shop shop) {
        this.shop = shop;
    }

    @Override
    @Unique
    @NotNull
    public UUID getMerchantUUID() {
        return this.cobbleDollars$self().getUUID();
    }

    @Override
    @Unique
    public void setMerchantUUID(@NotNull UUID uuid) {
    }

    @Unique
    private ZombieVillager cobbleDollars$self() {
        return (ZombieVillager)this;
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull Player> getTradingPlayers() {
        return this.tradingPlayers;
    }

    @Override
    public void setTradingPlayers(@NotNull @NotNull Set<@NotNull Player> players) {
        this.tradingPlayers = players;
    }
}

