/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.network.handlers.server;

import com.cobblemon.mod.common.api.net.ServerNetworkPacketHandler;
import fr.harmex.cobbledollars.common.CobbleDollars;
import fr.harmex.cobbledollars.common.network.CobbleDollarsNetwork;
import fr.harmex.cobbledollars.common.network.packets.c2s.BuyPacket;
import fr.harmex.cobbledollars.common.network.packets.s2c.UpdateStockPacket;
import fr.harmex.cobbledollars.common.utils.extensions.PlayerExtensionKt;
import fr.harmex.cobbledollars.common.world.item.trading.CobbleDollarsShopHolder;
import fr.harmex.cobbledollars.common.world.item.trading.shop.Category;
import fr.harmex.cobbledollars.common.world.item.trading.shop.Offer;
import fr.harmex.cobbledollars.common.world.item.trading.shop.Shop;
import java.math.BigInteger;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0011\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lfr/harmex/cobbledollars/common/network/handlers/server/BuyHandler;", "Lcom/cobblemon/mod/common/api/net/ServerNetworkPacketHandler;", "Lfr/harmex/cobbledollars/common/network/packets/c2s/BuyPacket;", "<init>", "()V", "packet", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "handle", "(Lfr/harmex/cobbledollars/common/network/packets/c2s/BuyPacket;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/server/level/ServerPlayer;)V", "Lnet/minecraft/world/item/ItemStack;", "items", "Ljava/math/BigInteger;", "price", "buy", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Ljava/math/BigInteger;)V", "common"})
@SourceDebugExtension(value={"SMAP\nBuyHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuyHandler.kt\nfr/harmex/cobbledollars/common/network/handlers/server/BuyHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1863#2,2:101\n*S KotlinDebug\n*F\n+ 1 BuyHandler.kt\nfr/harmex/cobbledollars/common/network/handlers/server/BuyHandler\n*L\n58#1:101,2\n*E\n"})
public final class BuyHandler
implements ServerNetworkPacketHandler<BuyPacket> {
    @NotNull
    public static final BuyHandler INSTANCE = new BuyHandler();

    private BuyHandler() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handle(@NotNull BuyPacket packet, @NotNull MinecraftServer server, @NotNull ServerPlayer player) {
        ServerLevel level;
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ResourceKey dimension = player.level().dimension();
        ServerLevel serverLevel = level = server.getLevel(dimension);
        Entity entity = serverLevel != null ? serverLevel.getEntity(packet.getMerchantUUID()) : null;
        CobbleDollarsShopHolder cobbleMerchant = entity instanceof CobbleDollarsShopHolder ? (CobbleDollarsShopHolder)entity : null;
        int realAmount = packet.getAmount();
        int obtainableLimit = PlayerExtensionKt.getMaxAmountObtainable((Player)player, packet.getOffer().getItem());
        realAmount = RangesKt.coerceAtMost((int)realAmount, (int)obtainableLimit);
        if (packet.getHasMerchant()) {
            Offer offer;
            Object object;
            if (cobbleMerchant == null) return;
            Shop shop = cobbleMerchant.getShop();
            if (shop == null) return;
            if (shop.isEmpty()) {
                shop = CobbleDollars.INSTANCE.getShopConfig().getDefaultShop();
            }
            Offer offer2 = (object = (Category)CollectionsKt.getOrNull((List)shop, (int)packet.getCategoryIndex())) != null && (object = ((Category)object).getOffers()) != null ? (Offer)CollectionsKt.getOrNull((List)((List)object), (int)packet.getOfferIndex()) : (offer = null);
            if (!Intrinsics.areEqual(offer, (Object)packet.getOffer())) return;
            if (offer.getStock() == 0) {
                return;
            }
            if (offer.getStock() > 0) {
                realAmount = RangesKt.coerceAtMost((int)realAmount, (int)offer.getStock());
                offer.setStock(offer.getStock() - realAmount);
                Iterable $this$forEach$iv = cobbleMerchant.getTradingPlayers();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Player player2 = (Player)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)player2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
                    CobbleDollarsNetwork.INSTANCE.sendPacketToPlayer((ServerPlayer)player2, new UpdateStockPacket(packet.getCategoryIndex(), packet.getOfferIndex(), offer.getStock(), packet.getMerchantUUID()));
                }
            }
        }
        ItemStack boughtStack = packet.getOffer().getItem().copyWithCount(realAmount);
        BigInteger bigInteger = packet.getOffer().getPrice();
        BigInteger bigInteger2 = BigInteger.valueOf(realAmount);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger2);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"multiply(...)");
        BigInteger totalPrice = bigInteger3;
        if (realAmount <= 0) return;
        Intrinsics.checkNotNull((Object)boughtStack);
        this.buy(player, boughtStack, totalPrice);
    }

    private final void buy(ServerPlayer player, ItemStack items, BigInteger price) {
        if (PlayerExtensionKt.getCobbleDollars((Player)player).compareTo(price) >= 0) {
            Player player2 = (Player)player;
            BigInteger bigInteger = PlayerExtensionKt.getCobbleDollars((Player)player).subtract(price);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"subtract(...)");
            PlayerExtensionKt.setCobbleDollars(player2, bigInteger);
            player.addItem(items);
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            player.containerMenu.broadcastChanges();
        }
    }
}

