/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.utils.extensions;

import com.cobblemon.mod.common.api.text.TextKt;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.harmex.cobbledollars.common.CobbleDollars;
import fr.harmex.cobbledollars.common.network.CobbleDollarsNetwork;
import fr.harmex.cobbledollars.common.network.packets.s2c.SyncBankPacket;
import fr.harmex.cobbledollars.common.network.packets.s2c.SyncShopPacket;
import fr.harmex.cobbledollars.common.utils.CobbleDollarsPlayer;
import fr.harmex.cobbledollars.common.utils.MiscUtilsKt;
import fr.harmex.cobbledollars.common.utils.extensions.BigIntegerExtensionsKt;
import fr.harmex.cobbledollars.common.world.entity.ClientSideCobbleDollarsShopHolder;
import fr.harmex.cobbledollars.common.world.inventory.BankMenu;
import fr.harmex.cobbledollars.common.world.inventory.ShopMenu;
import fr.harmex.cobbledollars.common.world.item.trading.CobbleDollarsShopHolder;
import fr.harmex.cobbledollars.common.world.item.trading.shop.Shop;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0019\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u001b\u0010\b\u001a\u00020\u0007*\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\b\u0010\t\u001a\u0019\u0010\f\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\r\u001a)\u0010\u0012\u001a\u00020\u0011*\u00020\u00002\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u001d\u0010\u0014\u001a\u00020\u0011*\u00020\u00002\b\b\u0002\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a\u0019\u0010\u001a\u001a\u00020\u0019*\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a\u0011\u0010\u001d\u001a\u00020\u001c*\u00020\u0019\u00a2\u0006\u0004\b\u001d\u0010\u001e\u001a\u0011\u0010 \u001a\u00020\u0011*\u00020\u001f\u00a2\u0006\u0004\b \u0010!\u001a\u0011\u0010\"\u001a\u00020\u0011*\u00020\u001f\u00a2\u0006\u0004\b\"\u0010!\u001a\u0011\u0010#\u001a\u00020\u0011*\u00020\u001f\u00a2\u0006\u0004\b#\u0010!\u001a\u001d\u0010&\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00010$*\u00020\u0017\u00a2\u0006\u0004\b&\u0010'\u001a!\u0010)\u001a\u00020\u0007*\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0001\u00a2\u0006\u0004\b)\u0010*\u001a\u001b\u0010+\u001a\u0004\u0018\u00010\u0001*\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b+\u0010,\u001a!\u0010-\u001a\u00020\u0007*\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0001\u00a2\u0006\u0004\b-\u0010*\u001a\u001b\u0010.\u001a\u0004\u0018\u00010\u0001*\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b.\u0010,\u001a\u0011\u0010/\u001a\u00020\u0011*\u00020\u001f\u00a2\u0006\u0004\b/\u0010!\"(\u00105\u001a\u00020\u0001*\u00020\u00002\u0006\u00100\u001a\u00020\u00018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b1\u00102\"\u0004\b3\u00104\"\u001c\u00108\u001a\n 7*\u0004\u0018\u000106068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109\"\u0014\u0010:\u001a\u00020%8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b:\u0010;\u00a8\u0006<"}, d2={"Lnet/minecraft/world/entity/player/Player;", "Ljava/math/BigInteger;", "unitPrice", "", "getMaxAmountPurchasable", "(Lnet/minecraft/world/entity/player/Player;Ljava/math/BigInteger;)I", "price", "", "canBuy", "(Lnet/minecraft/world/entity/player/Player;Ljava/math/BigInteger;)Z", "Lnet/minecraft/world/item/ItemStack;", "itemStack", "getMaxAmountObtainable", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/ItemStack;)I", "Lfr/harmex/cobbledollars/common/world/item/trading/CobbleDollarsShopHolder;", "cobbleMerchant", "isEditMode", "", "openShop", "(Lnet/minecraft/world/entity/player/Player;Lfr/harmex/cobbledollars/common/world/item/trading/CobbleDollarsShopHolder;Z)V", "openBank", "(Lnet/minecraft/world/entity/player/Player;Lfr/harmex/cobbledollars/common/world/item/trading/CobbleDollarsShopHolder;)V", "Ljava/util/UUID;", "Lnet/minecraft/server/MinecraftServer;", "server", "Ljava/io/File;", "getAccountFile", "(Ljava/util/UUID;Lnet/minecraft/server/MinecraftServer;)Ljava/io/File;", "Lcom/google/gson/JsonObject;", "loadJson", "(Ljava/io/File;)Lcom/google/gson/JsonObject;", "Lnet/minecraft/server/level/ServerPlayer;", "updateCobbleDollarsAccount", "(Lnet/minecraft/server/level/ServerPlayer;)V", "loginCobbleDollarsAccount", "logoutCobbleDollarsAccount", "", "", "getAllPlayerCobbleDollars", "(Lnet/minecraft/server/MinecraftServer;)Ljava/util/Map;", "amount", "addOfflineCobbleDollars", "(Ljava/util/UUID;Lnet/minecraft/server/MinecraftServer;Ljava/math/BigInteger;)Z", "getOfflineCobbleDollars", "(Ljava/util/UUID;Lnet/minecraft/server/MinecraftServer;)Ljava/math/BigInteger;", "addOfflineCobbleDollarsLegacy", "getOfflineCobbleDollarsLegacy", "earnOfflineCobbleDollars", "value", "getCobbleDollars", "(Lnet/minecraft/world/entity/player/Player;)Ljava/math/BigInteger;", "setCobbleDollars", "(Lnet/minecraft/world/entity/player/Player;Ljava/math/BigInteger;)V", "cobbleDollars", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "GSON", "Lcom/google/gson/Gson;", "ACCOUNT_PATH", "Ljava/lang/String;", "common"})
@SourceDebugExtension(value={"SMAP\nPlayerExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerExtension.kt\nfr/harmex/cobbledollars/common/utils/extensions/PlayerExtensionKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,265:1\n13346#2,2:266\n*S KotlinDebug\n*F\n+ 1 PlayerExtension.kt\nfr/harmex/cobbledollars/common/utils/extensions/PlayerExtensionKt\n*L\n152#1:266,2\n*E\n"})
public final class PlayerExtensionKt {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    @NotNull
    private static final String ACCOUNT_PATH = "cobbledollarsplayerdata";

    @NotNull
    public static final BigInteger getCobbleDollars(@NotNull Player $this$cobbleDollars) {
        Intrinsics.checkNotNullParameter((Object)$this$cobbleDollars, (String)"<this>");
        return ((CobbleDollarsPlayer)$this$cobbleDollars).cobbleDollars$getCobbleDollars();
    }

    public static final void setCobbleDollars(@NotNull Player $this$cobbleDollars, @NotNull BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)$this$cobbleDollars, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ((CobbleDollarsPlayer)$this$cobbleDollars).cobbleDollars$setCobbleDollars(value);
    }

    public static final int getMaxAmountPurchasable(@NotNull Player $this$getMaxAmountPurchasable, @NotNull BigInteger unitPrice) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$getMaxAmountPurchasable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unitPrice, (String)"unitPrice");
        if (Intrinsics.areEqual((Object)unitPrice, (Object)BigInteger.ZERO)) {
            n = 9999;
        } else {
            BigInteger bigInteger = PlayerExtensionKt.getCobbleDollars($this$getMaxAmountPurchasable).divide(unitPrice);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"divide(...)");
            Comparable comparable = bigInteger;
            BigInteger bigInteger2 = BigInteger.valueOf(9999);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
            n = ((BigInteger)RangesKt.coerceAtMost((Comparable)comparable, (Comparable)bigInteger2)).intValue();
        }
        return n;
    }

    public static final boolean canBuy(@NotNull Player $this$canBuy, @Nullable BigInteger price) {
        Intrinsics.checkNotNullParameter((Object)$this$canBuy, (String)"<this>");
        return price != null && PlayerExtensionKt.getCobbleDollars($this$canBuy).compareTo(price) >= 0;
    }

    public static final int getMaxAmountObtainable(@NotNull Player $this$getMaxAmountObtainable, @NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)$this$getMaxAmountObtainable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        int spaceAvailable = 0;
        Iterator iterator = $this$getMaxAmountObtainable.getInventory().items.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ItemStack slotStack = (ItemStack)iterator2.next();
            if (Intrinsics.areEqual((Object)slotStack, (Object)ItemStack.EMPTY)) {
                spaceAvailable += itemStack.getMaxStackSize();
            }
            if (!Intrinsics.areEqual((Object)slotStack.getItem(), (Object)itemStack.getItem()) || !Intrinsics.areEqual((Object)slotStack.getComponents(), (Object)itemStack.getComponents())) continue;
            spaceAvailable += itemStack.getMaxStackSize() - slotStack.getCount();
        }
        return spaceAvailable;
    }

    @JvmOverloads
    public static final void openShop(@NotNull Player $this$openShop, @Nullable CobbleDollarsShopHolder cobbleMerchant, boolean isEditMode) {
        Intrinsics.checkNotNullParameter((Object)$this$openShop, (String)"<this>");
        $this$openShop.openMenu((MenuProvider)new SimpleMenuProvider((arg_0, arg_1, arg_2) -> PlayerExtensionKt.openShop$lambda$0(cobbleMerchant, arg_0, arg_1, arg_2), (Component)MiscUtilsKt.cobbleDollarsScreen("shop"))).ifPresent(arg_0 -> PlayerExtensionKt.openShop$lambda$1($this$openShop, cobbleMerchant, isEditMode, arg_0));
    }

    public static /* synthetic */ void openShop$default(Player player, CobbleDollarsShopHolder cobbleDollarsShopHolder, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            cobbleDollarsShopHolder = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        PlayerExtensionKt.openShop(player, cobbleDollarsShopHolder, bl);
    }

    @JvmOverloads
    public static final void openBank(@NotNull Player $this$openBank, @NotNull CobbleDollarsShopHolder cobbleMerchant) {
        Intrinsics.checkNotNullParameter((Object)$this$openBank, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cobbleMerchant, (String)"cobbleMerchant");
        $this$openBank.openMenu((MenuProvider)new SimpleMenuProvider((arg_0, arg_1, arg_2) -> PlayerExtensionKt.openBank$lambda$2(cobbleMerchant, arg_0, arg_1, arg_2), (Component)MiscUtilsKt.cobbleDollarsScreen("bank"))).ifPresent(arg_0 -> PlayerExtensionKt.openBank$lambda$3($this$openBank, cobbleMerchant, arg_0));
    }

    public static /* synthetic */ void openBank$default(Player player, CobbleDollarsShopHolder cobbleDollarsShopHolder, int n, Object object) {
        if ((n & 1) != 0) {
            cobbleDollarsShopHolder = new ClientSideCobbleDollarsShopHolder(null, null, null, 7, null);
        }
        PlayerExtensionKt.openBank(player, cobbleDollarsShopHolder);
    }

    @NotNull
    public static final File getAccountFile(@NotNull UUID $this$getAccountFile, @NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)$this$getAccountFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        File file = server.getWorldPath(LevelResource.ROOT).resolve("cobbledollarsplayerdata/" + $this$getAccountFile + ".json").toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final JsonObject loadJson(@NotNull File $this$loadJson) {
        JsonObject jsonObject;
        Intrinsics.checkNotNullParameter((Object)$this$loadJson, (String)"<this>");
        if ($this$loadJson.exists() && $this$loadJson.length() > 0L) {
            JsonObject jsonObject2;
            Closeable closeable = new FileReader($this$loadJson);
            Throwable throwable = null;
            try {
                FileReader reader = (FileReader)closeable;
                boolean bl = false;
                jsonObject2 = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            JsonObject jsonObject3 = jsonObject2;
            Intrinsics.checkNotNull((Object)jsonObject3);
            jsonObject = jsonObject3;
        } else {
            jsonObject = new JsonObject();
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void updateCobbleDollarsAccount(@NotNull ServerPlayer $this$updateCobbleDollarsAccount) {
        Intrinsics.checkNotNullParameter((Object)$this$updateCobbleDollarsAccount, (String)"<this>");
        try {
            Object object;
            UUID uUID = $this$updateCobbleDollarsAccount.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            MinecraftServer minecraftServer = $this$updateCobbleDollarsAccount.server;
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"server");
            File accountFile = PlayerExtensionKt.getAccountFile(uUID, minecraftServer);
            accountFile.getParentFile().mkdirs();
            JsonObject $this$updateCobbleDollarsAccount_u24lambda_u245 = object = PlayerExtensionKt.loadJson(accountFile);
            boolean bl = false;
            $this$updateCobbleDollarsAccount_u24lambda_u245.addProperty("name", $this$updateCobbleDollarsAccount.getName().getString());
            $this$updateCobbleDollarsAccount_u24lambda_u245.addProperty("cobbledollars", (Number)PlayerExtensionKt.getCobbleDollars((Player)$this$updateCobbleDollarsAccount));
            JsonObject jsonObject = object;
            object = new FileWriter(accountFile);
            Throwable throwable = null;
            try {
                FileWriter writer = (FileWriter)object;
                boolean bl2 = false;
                GSON.toJson((JsonElement)jsonObject, (Appendable)writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            CobbleDollars.INSTANCE.getLOGGER().error("Unable to update CobbleDollars account for " + $this$updateCobbleDollarsAccount);
            e.printStackTrace();
        }
    }

    public static final void loginCobbleDollarsAccount(@NotNull ServerPlayer $this$loginCobbleDollarsAccount) {
        Intrinsics.checkNotNullParameter((Object)$this$loginCobbleDollarsAccount, (String)"<this>");
        try {
            UUID uUID = $this$loginCobbleDollarsAccount.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            MinecraftServer minecraftServer = $this$loginCobbleDollarsAccount.server;
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"server");
            File accountFile = PlayerExtensionKt.getAccountFile(uUID, minecraftServer);
            accountFile.getParentFile().mkdirs();
            PlayerExtensionKt.earnOfflineCobbleDollars($this$loginCobbleDollarsAccount);
            PlayerExtensionKt.updateCobbleDollarsAccount($this$loginCobbleDollarsAccount);
        }
        catch (Exception e) {
            CobbleDollars.INSTANCE.getLOGGER().error("Unable to log in CobbleDollars account for " + $this$loginCobbleDollarsAccount);
            e.printStackTrace();
        }
    }

    public static final void logoutCobbleDollarsAccount(@NotNull ServerPlayer $this$logoutCobbleDollarsAccount) {
        Intrinsics.checkNotNullParameter((Object)$this$logoutCobbleDollarsAccount, (String)"<this>");
        try {
            UUID uUID = $this$logoutCobbleDollarsAccount.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            MinecraftServer minecraftServer = $this$logoutCobbleDollarsAccount.server;
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"server");
            File accountFile = PlayerExtensionKt.getAccountFile(uUID, minecraftServer);
            accountFile.getParentFile().mkdirs();
            PlayerExtensionKt.updateCobbleDollarsAccount($this$logoutCobbleDollarsAccount);
        }
        catch (Exception e) {
            CobbleDollars.INSTANCE.getLOGGER().error("Unable to log out CobbleDollars account for " + $this$logoutCobbleDollarsAccount);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Map<String, BigInteger> getAllPlayerCobbleDollars(@NotNull MinecraftServer $this$getAllPlayerCobbleDollars) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllPlayerCobbleDollars, (String)"<this>");
        HashMap map = new HashMap();
        File accountsFolder = $this$getAllPlayerCobbleDollars.getWorldPath(LevelResource.ROOT).resolve(ACCOUNT_PATH).toFile();
        accountsFolder.mkdirs();
        File[] fileArray = accountsFolder.listFiles(PlayerExtensionKt::getAllPlayerCobbleDollars$lambda$7);
        Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles(...)");
        Object[] $this$forEach$iv = fileArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            try {
                Closeable closeable = new FileReader(file);
                Throwable throwable = null;
                try {
                    FileReader reader = (FileReader)closeable;
                    boolean bl2 = false;
                    JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                    ((Map)map).put(jsonObject.get("name").getAsString(), jsonObject.get("cobbledollars").getAsBigInteger());
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                CobbleDollars.INSTANCE.getLOGGER().error("Error while trying to read '" + file.getPath() + "'");
                e.printStackTrace();
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean addOfflineCobbleDollars(@NotNull UUID $this$addOfflineCobbleDollars, @NotNull MinecraftServer server, @NotNull BigInteger amount) {
        Intrinsics.checkNotNullParameter((Object)$this$addOfflineCobbleDollars, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        try {
            Object object;
            BigInteger bigInteger;
            File accountFile;
            block10: {
                block9: {
                    accountFile = PlayerExtensionKt.getAccountFile($this$addOfflineCobbleDollars, server);
                    accountFile.getParentFile().mkdirs();
                    bigInteger = PlayerExtensionKt.getOfflineCobbleDollars($this$addOfflineCobbleDollars, server);
                    if (bigInteger == null) break block9;
                    BigInteger bigInteger2 = bigInteger.add(amount);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"add(...)");
                    bigInteger = bigInteger2;
                    if (bigInteger2 != null) break block10;
                }
                bigInteger = amount;
            }
            BigInteger totalOfflineEarnings = bigInteger;
            JsonObject $this$addOfflineCobbleDollars_u24lambda_u2410 = object = PlayerExtensionKt.loadJson(accountFile);
            boolean bl = false;
            $this$addOfflineCobbleDollars_u24lambda_u2410.addProperty("offline_earnings", (Number)totalOfflineEarnings);
            JsonObject jsonObject = object;
            object = new FileWriter(accountFile);
            Throwable throwable = null;
            try {
                FileWriter writer = (FileWriter)object;
                boolean bl2 = false;
                GSON.toJson((JsonElement)jsonObject, (Appendable)writer);
                boolean bl3 = true;
                return bl3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            CobbleDollars.INSTANCE.getLOGGER().error("Unable to add offline CobbleDollars for " + $this$addOfflineCobbleDollars);
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final BigInteger getOfflineCobbleDollars(@NotNull UUID $this$getOfflineCobbleDollars, @NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)$this$getOfflineCobbleDollars, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        try {
            File accountFile = PlayerExtensionKt.getAccountFile($this$getOfflineCobbleDollars, server);
            if (!accountFile.exists()) {
                return null;
            }
            Closeable closeable = new FileReader(accountFile);
            Throwable throwable = null;
            try {
                FileReader reader = (FileReader)closeable;
                boolean bl = false;
                JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                JsonElement jsonElement = jsonObject.get("offline_earnings");
                BigInteger bigInteger = jsonElement != null ? jsonElement.getAsBigInteger() : null;
                return bigInteger;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            CobbleDollars.INSTANCE.getLOGGER().error("Unable to get offline CobbleDollars for " + $this$getOfflineCobbleDollars);
            e.printStackTrace();
            return null;
        }
    }

    public static final boolean addOfflineCobbleDollarsLegacy(@NotNull UUID $this$addOfflineCobbleDollarsLegacy, @NotNull MinecraftServer server, @NotNull BigInteger amount) {
        Intrinsics.checkNotNullParameter((Object)$this$addOfflineCobbleDollarsLegacy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        try {
            BigInteger bigInteger;
            File cobbleDollarsStoreRoot;
            block5: {
                block4: {
                    cobbleDollarsStoreRoot = server.getWorldPath(LevelResource.ROOT).resolve("cobbledollars/" + $this$addOfflineCobbleDollarsLegacy + ".json").toFile();
                    cobbleDollarsStoreRoot.getParentFile().mkdirs();
                    bigInteger = PlayerExtensionKt.getOfflineCobbleDollarsLegacy($this$addOfflineCobbleDollarsLegacy, server);
                    if (bigInteger == null) break block4;
                    BigInteger bigInteger2 = bigInteger.add(amount);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"add(...)");
                    bigInteger = bigInteger2;
                    if (bigInteger2 != null) break block5;
                }
                bigInteger = amount;
            }
            BigInteger totalAmount = bigInteger;
            FileWriter writer = new FileWriter(cobbleDollarsStoreRoot);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("offlineEarnings", (Number)totalAmount);
            GSON.toJson((JsonElement)jsonObject, (Appendable)writer);
            writer.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Nullable
    public static final BigInteger getOfflineCobbleDollarsLegacy(@NotNull UUID $this$getOfflineCobbleDollarsLegacy, @NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)$this$getOfflineCobbleDollarsLegacy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        try {
            File cobbleDollarsStoreRoot = server.getWorldPath(LevelResource.ROOT).resolve("cobbledollars/" + $this$getOfflineCobbleDollarsLegacy + ".json").toFile();
            if (cobbleDollarsStoreRoot.exists()) {
                FileReader reader = new FileReader(cobbleDollarsStoreRoot);
                JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                reader.close();
                return jsonObject.get("offlineEarnings").getAsBigInteger();
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static final void earnOfflineCobbleDollars(@NotNull ServerPlayer $this$earnOfflineCobbleDollars) {
        block3: {
            BigInteger offlineEarnings;
            Intrinsics.checkNotNullParameter((Object)$this$earnOfflineCobbleDollars, (String)"<this>");
            File cobbleDollarsStoreRoot = $this$earnOfflineCobbleDollars.server.getWorldPath(LevelResource.ROOT).resolve("cobbledollars/" + $this$earnOfflineCobbleDollars.getUUID() + ".json").toFile();
            if (cobbleDollarsStoreRoot.exists()) {
                BigInteger offlineEarnings2;
                UUID uUID = $this$earnOfflineCobbleDollars.getUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                MinecraftServer minecraftServer = $this$earnOfflineCobbleDollars.server;
                Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"server");
                BigInteger bigInteger = offlineEarnings2 = PlayerExtensionKt.getOfflineCobbleDollarsLegacy(uUID, minecraftServer);
                if (bigInteger != null) {
                    BigInteger offlineEarnings3 = bigInteger;
                    boolean bl = false;
                    Player player = (Player)$this$earnOfflineCobbleDollars;
                    BigInteger bigInteger2 = PlayerExtensionKt.getCobbleDollars((Player)$this$earnOfflineCobbleDollars).add(offlineEarnings3);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"add(...)");
                    PlayerExtensionKt.setCobbleDollars(player, bigInteger2);
                    Object[] objectArray = new Object[]{TextKt.green((MutableComponent)BigIntegerExtensionsKt.format$default(offlineEarnings3, false, 1, null))};
                    $this$earnOfflineCobbleDollars.sendSystemMessage((Component)MiscUtilsKt.cobbleDollarsLang("chat", "offline_earnings", objectArray));
                    cobbleDollarsStoreRoot.delete();
                }
            }
            UUID uUID = $this$earnOfflineCobbleDollars.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            MinecraftServer minecraftServer = $this$earnOfflineCobbleDollars.server;
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"server");
            File accountFile = PlayerExtensionKt.getAccountFile(uUID, minecraftServer);
            if (!accountFile.exists()) break block3;
            UUID uUID2 = $this$earnOfflineCobbleDollars.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
            MinecraftServer minecraftServer2 = $this$earnOfflineCobbleDollars.server;
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer2, (String)"server");
            BigInteger bigInteger = offlineEarnings = PlayerExtensionKt.getOfflineCobbleDollars(uUID2, minecraftServer2);
            if (bigInteger != null) {
                BigInteger offlineEarnings4 = bigInteger;
                boolean bl = false;
                Player player = (Player)$this$earnOfflineCobbleDollars;
                BigInteger bigInteger3 = PlayerExtensionKt.getCobbleDollars((Player)$this$earnOfflineCobbleDollars).add(offlineEarnings4);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"add(...)");
                PlayerExtensionKt.setCobbleDollars(player, bigInteger3);
                UUID uUID3 = $this$earnOfflineCobbleDollars.getUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"getUUID(...)");
                MinecraftServer minecraftServer3 = $this$earnOfflineCobbleDollars.server;
                Intrinsics.checkNotNullExpressionValue((Object)minecraftServer3, (String)"server");
                BigInteger bigInteger4 = offlineEarnings4.negate();
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"negate(...)");
                PlayerExtensionKt.addOfflineCobbleDollars(uUID3, minecraftServer3, bigInteger4);
                Object[] objectArray = new Object[]{TextKt.green((MutableComponent)BigIntegerExtensionsKt.format$default(offlineEarnings4, false, 1, null))};
                $this$earnOfflineCobbleDollars.sendSystemMessage((Component)MiscUtilsKt.cobbleDollarsLang("chat", "offline_earnings", objectArray));
            }
        }
    }

    @JvmOverloads
    public static final void openShop(@NotNull Player $this$openShop, @Nullable CobbleDollarsShopHolder cobbleMerchant) {
        Intrinsics.checkNotNullParameter((Object)$this$openShop, (String)"<this>");
        PlayerExtensionKt.openShop$default($this$openShop, cobbleMerchant, false, 2, null);
    }

    @JvmOverloads
    public static final void openShop(@NotNull Player $this$openShop) {
        Intrinsics.checkNotNullParameter((Object)$this$openShop, (String)"<this>");
        PlayerExtensionKt.openShop$default($this$openShop, null, false, 3, null);
    }

    @JvmOverloads
    public static final void openBank(@NotNull Player $this$openBank) {
        Intrinsics.checkNotNullParameter((Object)$this$openBank, (String)"<this>");
        PlayerExtensionKt.openBank$default($this$openBank, null, 1, null);
    }

    private static final AbstractContainerMenu openShop$lambda$0(CobbleDollarsShopHolder $cobbleMerchant, int containerId, Inventory playerInventory, Player player) {
        Intrinsics.checkNotNull((Object)playerInventory);
        CobbleDollarsShopHolder cobbleDollarsShopHolder = $cobbleMerchant;
        if (cobbleDollarsShopHolder == null) {
            cobbleDollarsShopHolder = new ClientSideCobbleDollarsShopHolder(null, null, null, 7, null);
        }
        return new ShopMenu(containerId, playerInventory, null, cobbleDollarsShopHolder, 4, null);
    }

    private static final void openShop$lambda$1(Player $this_openShop, CobbleDollarsShopHolder $cobbleMerchant, boolean $isEditMode, int it) {
        Intrinsics.checkNotNullParameter((Object)$this_openShop, (String)"$this_openShop");
        ClientSideCobbleDollarsShopHolder defaultMerchant = new ClientSideCobbleDollarsShopHolder(null, null, null, 7, null);
        ServerPlayer serverPlayer = (ServerPlayer)$this_openShop;
        Object object = $cobbleMerchant;
        if (object == null || (object = object.getShop()) == null) {
            Shop shop = defaultMerchant.getShop();
            object = shop;
            Intrinsics.checkNotNull((Object)shop);
        }
        boolean bl = $cobbleMerchant != null;
        Object object2 = $cobbleMerchant;
        if (object2 == null || (object2 = object2.getMerchantUUID()) == null) {
            object2 = defaultMerchant.getMerchantUUID();
        }
        CobbleDollarsNetwork.INSTANCE.sendPacket(serverPlayer, new SyncShopPacket(it, (Shop)object, bl, (UUID)object2, $isEditMode));
    }

    private static final AbstractContainerMenu openBank$lambda$2(CobbleDollarsShopHolder $cobbleMerchant, int containerId, Inventory playerInventory, Player player) {
        Intrinsics.checkNotNullParameter((Object)$cobbleMerchant, (String)"$cobbleMerchant");
        Intrinsics.checkNotNull((Object)playerInventory);
        return new BankMenu(containerId, playerInventory, null, $cobbleMerchant, 4, null);
    }

    private static final void openBank$lambda$3(Player $this_openBank, CobbleDollarsShopHolder $cobbleMerchant, int it) {
        Intrinsics.checkNotNullParameter((Object)$this_openBank, (String)"$this_openBank");
        Intrinsics.checkNotNullParameter((Object)$cobbleMerchant, (String)"$cobbleMerchant");
        CobbleDollarsNetwork.INSTANCE.sendPacket((ServerPlayer)$this_openBank, new SyncBankPacket(it, $cobbleMerchant.getMerchantUUID()));
    }

    private static final boolean getAllPlayerCobbleDollars$lambda$7(File file) {
        Intrinsics.checkNotNull((Object)file);
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"json");
    }
}

