/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.world.item.trading.shop;

import fr.harmex.cobbledollars.common.utils.extensions.CompoundTagExtensionKt;
import fr.harmex.cobbledollars.common.world.item.trading.shop.Category;
import fr.harmex.cobbledollars.common.world.item.trading.shop.Offer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 %2\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003:\u0001%B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005B!\b\u0016\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0007B\u001d\b\u0016\u0012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\b\"\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\nJ\r\u0010\u000b\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ!\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00022\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J%\u0010\u0012\u001a\u00020\u000f2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u0015\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u001b\u0010\u0019J\u0015\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020\u00172\b\u0010!\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010$\u001a\u00020\u00172\b\u0010!\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b$\u0010#\u00a8\u0006&"}, d2={"Lfr/harmex/cobbledollars/common/world/item/trading/shop/Shop;", "Ljava/util/ArrayList;", "Lfr/harmex/cobbledollars/common/world/item/trading/shop/Category;", "Lkotlin/collections/ArrayList;", "<init>", "()V", "shopList", "(Ljava/util/ArrayList;)V", "", "category", "([Lfr/harmex/cobbledollars/common/world/item/trading/shop/Category;)V", "copy", "()Lfr/harmex/cobbledollars/common/world/item/trading/shop/Shop;", "", "index", "", "addCategory", "(Lfr/harmex/cobbledollars/common/world/item/trading/shop/Category;Ljava/lang/Integer;)V", "delCategory", "", "name", "get", "(Ljava/lang/String;)Lfr/harmex/cobbledollars/common/world/item/trading/shop/Category;", "", "has", "(Ljava/lang/String;)Z", "add", "del", "Lnet/minecraft/core/RegistryAccess;", "registryAccess", "Lnet/minecraft/nbt/ListTag;", "save", "(Lnet/minecraft/core/RegistryAccess;)Lnet/minecraft/nbt/ListTag;", "other", "equalsWithoutStock", "(Lfr/harmex/cobbledollars/common/world/item/trading/shop/Shop;)Z", "equals", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nShop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Shop.kt\nfr/harmex/cobbledollars/common/world/item/trading/shop/Shop\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1863#2,2:130\n295#2,2:132\n1863#2,2:134\n1872#2,2:136\n1872#2,3:138\n1874#2:141\n1872#2,2:142\n1872#2,3:144\n1874#2:147\n*S KotlinDebug\n*F\n+ 1 Shop.kt\nfr/harmex/cobbledollars/common/world/item/trading/shop/Shop\n*L\n46#1:130,2\n68#1:132,2\n78#1:134,2\n102#1:136,2\n105#1:138,3\n102#1:141\n119#1:142,2\n122#1:144,3\n119#1:147\n*E\n"})
public final class Shop
extends ArrayList<Category> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public Shop() {
    }

    public Shop(@NotNull ArrayList<Category> shopList) {
        Intrinsics.checkNotNullParameter(shopList, (String)"shopList");
        this();
        this.addAll((Collection)shopList);
    }

    public Shop(Category ... category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        this();
        CollectionsKt.addAll((Collection)this, (Object[])category);
    }

    @NotNull
    public final Shop copy() {
        Shop shop = new Shop();
        Iterable $this$forEach$iv = this;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Category it = (Category)element$iv;
            boolean bl = false;
            shop.add(it.copy());
        }
        return shop;
    }

    public final void addCategory(@NotNull Category category, @Nullable Integer index) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        if (index == null) {
            this.add(category);
        } else {
            this.add(index, category);
        }
    }

    public static /* synthetic */ void addCategory$default(Shop shop, Category category, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        shop.addCategory(category, n);
    }

    public final void delCategory(@Nullable Category category, @Nullable Integer index) {
        if (category != null && index != null && Intrinsics.areEqual(this.get(index), (Object)category)) {
            this.remove(index);
        } else {
            Category category2 = category;
            if (category2 != null) {
                this.remove((Object)category2);
            } else if (index != null) {
                this.remove(index);
            }
        }
    }

    public static /* synthetic */ void delCategory$default(Shop shop, Category category, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            category = null;
        }
        if ((n2 & 2) != 0) {
            n = null;
        }
        shop.delCategory(category, n);
    }

    @Nullable
    public final Category get(@NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable $this$firstOrNull$iv = this;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Category it = (Category)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final boolean has(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.get(name) != null;
    }

    @Override
    public final boolean add(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.add(new Category(name, new ArrayList<Offer>()));
    }

    public final boolean del(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.removeIf(arg_0 -> Shop.del$lambda$3(arg_0 -> Shop.del$lambda$2(name, arg_0), arg_0));
    }

    @NotNull
    public final ListTag save(@NotNull RegistryAccess registryAccess) {
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        ListTag categoryList = new ListTag();
        Iterator iterator = this.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Category category = (Category)e;
            CompoundTag categoryCompound = new CompoundTag();
            ListTag offerList = new ListTag();
            Iterable $this$forEach$iv = category.getOffers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Offer it = (Offer)element$iv;
                boolean bl = false;
                if (it.getItem().isEmpty()) continue;
                CompoundTag offerCompound = new CompoundTag();
                offerCompound.put("Item", it.getItem().save((HolderLookup.Provider)registryAccess, (Tag)new CompoundTag()));
                CompoundTagExtensionKt.putBigInt(offerCompound, "Price", it.getPrice());
                if (it.getStock() >= 0) {
                    offerCompound.putInt("Stock", it.getStock());
                }
                offerList.add((Object)offerCompound);
            }
            categoryCompound.putString("Category", category.getName());
            categoryCompound.put("Offers", (Tag)offerList);
            categoryList.add((Object)categoryCompound);
        }
        return categoryList;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equalsWithoutStock(@Nullable Shop other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.size() != other.size()) {
            return false;
        }
        Iterable $this$forEachIndexed$iv = this;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void category;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Category category2 = (Category)item$iv;
            int categoryIndex = n;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)category.getName(), (Object)((Category)other.get(categoryIndex)).getName())) {
                return false;
            }
            Iterable $this$forEachIndexed$iv2 = category.getOffers();
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                void offer;
                int n2;
                if ((n2 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Offer offer2 = (Offer)item$iv2;
                int offerIndex = n2;
                boolean bl2 = false;
                if (offer.equalsWithoutStock(((Category)other.get(categoryIndex)).getOffers().get(offerIndex))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(@Nullable Shop other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.size() != other.size()) {
            return false;
        }
        Iterable $this$forEachIndexed$iv = this;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void category;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Category category2 = (Category)item$iv;
            int categoryIndex = n;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)category.getName(), (Object)((Category)other.get(categoryIndex)).getName())) {
                return false;
            }
            Iterable $this$forEachIndexed$iv2 = category.getOffers();
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                void offer;
                int n2;
                if ((n2 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Offer offer2 = (Offer)item$iv2;
                int offerIndex = n2;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)offer, (Object)((Category)other.get(categoryIndex)).getOffers().get(offerIndex))) continue;
                return false;
            }
        }
        return true;
    }

    private static final boolean del$lambda$2(String $name, Category it) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getName(), (Object)$name);
    }

    private static final boolean del$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lfr/harmex/cobbledollars/common/world/item/trading/shop/Shop$Companion;", "", "<init>", "()V", "Lnet/minecraft/core/RegistryAccess;", "registryAccess", "Lnet/minecraft/nbt/ListTag;", "listTag", "Lfr/harmex/cobbledollars/common/world/item/trading/shop/Shop;", "read", "(Lnet/minecraft/core/RegistryAccess;Lnet/minecraft/nbt/ListTag;)Lfr/harmex/cobbledollars/common/world/item/trading/shop/Shop;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Shop read(@NotNull RegistryAccess registryAccess, @NotNull ListTag listTag) {
            Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
            Intrinsics.checkNotNullParameter((Object)listTag, (String)"listTag");
            Shop shop = new Shop();
            Iterator iterator = listTag.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Iterator iterator3;
                Tag categoryCompound = (Tag)iterator2.next();
                ArrayList<Offer> offerList = new ArrayList<Offer>();
                Intrinsics.checkNotNull((Object)categoryCompound, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
                Intrinsics.checkNotNullExpressionValue((Object)((CompoundTag)categoryCompound).getList("Offers", 10).iterator(), (String)"iterator(...)");
                while (iterator3.hasNext()) {
                    Tag offerTag = (Tag)iterator3.next();
                    Intrinsics.checkNotNull((Object)offerTag, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
                    CompoundTag offerCompound = (CompoundTag)offerTag;
                    Optional optional = ItemStack.parse((HolderLookup.Provider)((HolderLookup.Provider)registryAccess), (Tag)((Tag)offerCompound.getCompound("Item")));
                    Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"parse(...)");
                    ItemStack offerItem = (ItemStack)OptionalsKt.getOrDefault((Optional)optional, (Object)ItemStack.EMPTY);
                    if (offerItem.isEmpty()) continue;
                    BigInteger offerPrice = CompoundTagExtensionKt.getBigInt(offerCompound, "Price");
                    int offerStock = offerCompound.contains("Stock") ? offerCompound.getInt("Stock") : -1;
                    Intrinsics.checkNotNull((Object)offerItem);
                    offerList.add(new Offer(offerItem, offerPrice, offerStock));
                }
                String string = ((CompoundTag)categoryCompound).getString("Category");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                Category category = new Category(string, offerList);
                shop.add(category);
            }
            return shop;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

