/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import net.satisfy.camping.Camping;
import net.satisfy.camping.client.model.BackpackModel;

public class EnderbagModel<T extends Entity>
extends EntityModel<T>
implements BackpackModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Camping.identifier("enderbag"), "main");
    private final ModelPart enderbag;

    public EnderbagModel(ModelPart root) {
        this.enderbag = root.getChild("enderbag");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition enderbag = partdefinition.addOrReplaceChild("enderbag", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 10.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(1, 16).addBox(4.0f, 2.0f, 4.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int i2) {
        poseStack.pushPose();
        this.enderbag.render(poseStack, buffer, packedLight, packedOverlay);
        poseStack.popPose();
    }

    public void setupAnim(T entity, float f, float g, float h, float i, float j) {
        this.enderbag.xRot = entity.isCrouching() ? 0.5235988f : 0.0f;
    }

    @Override
    public void copyBody(ModelPart model) {
        this.enderbag.copyFrom(model);
    }
}

