/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import net.satisfy.camping.Camping;
import net.satisfy.camping.client.model.BackpackModel;

public class GoodybagModel<T extends Entity>
extends EntityModel<T>
implements BackpackModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Camping.identifier("goodybag"), "main");
    private final ModelPart goodybag;

    public GoodybagModel(ModelPart root) {
        this.goodybag = root.getChild("goodybag");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition goodybag = partdefinition.addOrReplaceChild("goodybag", CubeListBuilder.create().texOffs(0, 26).addBox(2.0f, -5.0f, 4.0f, 8.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(0.0f, 0.0f, -2.0f, 12.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(29, 2).addBox(5.0f, -8.0f, 4.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 10).addBox(1.0f, -10.0f, -2.0f, 10.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(32, 10).addBox(1.0f, -10.0f, -2.0f, 10.0f, 3.0f, 6.0f, new CubeDeformation(0.2f)).texOffs(16, 27).addBox(-2.0f, -5.0f, -2.0f, 3.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(34, 27).addBox(11.0f, -5.0f, -2.0f, 2.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition goods = goodybag.addOrReplaceChild("goods", CubeListBuilder.create().texOffs(8, 33).addBox(11.0f, -12.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition small_map_r1 = goods.addOrReplaceChild("small_map_r1", CubeListBuilder.create().texOffs(8, 33).addBox(-0.2f, -6.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)11.0f, (float)-2.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition spyglass_r1 = goods.addOrReplaceChild("spyglass_r1", CubeListBuilder.create().texOffs(0, 33).addBox(-1.0f, -6.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-8.0f, (float)1.0f, (float)0.0f, (float)-0.1309f, (float)-0.6545f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int i2) {
        poseStack.pushPose();
        this.goodybag.render(poseStack, buffer, packedLight, packedOverlay);
        poseStack.popPose();
    }

    public void setupAnim(T entity, float f, float g, float h, float i, float j) {
        this.goodybag.xRot = entity.isCrouching() ? 0.5235988f : 0.0f;
    }

    @Override
    public void copyBody(ModelPart model) {
        this.goodybag.copyFrom(model);
    }
}

