/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.satisfy.camping.core.util.BackpackRegistry;
import net.satisfy.camping.core.util.BackpackVariant;
import net.satisfy.camping.core.world.item.BackpackBlockItem;

public class BackpackRenderLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public BackpackRenderLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> $$0) {
        super($$0);
    }

    public static void performTranslations(PoseStack poseStack, BackpackVariant type, boolean isCrouching) {
        float PIXEL = 0.0625f;
        switch (type) {
            case SMALL_BACKPACK: {
                poseStack.translate(0.1875f, 0.625f, 0.1875f);
                break;
            }
            case LARGE_BACKPACK: {
                poseStack.translate(0.0f, 0.75f, 0.625f);
                break;
            }
            case WANDERER_BACKPACK: {
                poseStack.translate(0.0f, 0.5f, 0.65625f);
                break;
            }
            case WANDERER_BAG: {
                poseStack.translate(-0.3125f, 0.625f, 0.25f);
                break;
            }
            case SHEEPBAG: {
                poseStack.translate(-0.1875f, 0.75f, 0.1875f);
                break;
            }
            case GOODYBAG: {
                poseStack.translate(-0.375f, 0.625f, 0.25f);
            }
        }
        if (isCrouching) {
            switch (type) {
                case SMALL_BACKPACK: {
                    poseStack.translate(0.0f, -0.15625f, 0.3125f);
                    break;
                }
                case LARGE_BACKPACK: {
                    poseStack.translate(0.0f, -0.40625f, 0.34375f);
                    break;
                }
                case WANDERER_BACKPACK: {
                    poseStack.translate(0.0f, -0.34375f, 0.09375f);
                    break;
                }
                case WANDERER_BAG: {
                    poseStack.translate(0.0f, -0.1875f, 0.28125f);
                    break;
                }
                case SHEEPBAG: 
                case GOODYBAG: {
                    poseStack.translate(0.0f, -0.1875f, 0.3125f);
                }
            }
        }
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, AbstractClientPlayer abstractClientPlayer, float v, float v1, float v2, float v3, float v4, float v5) {
        ItemStack stack = abstractClientPlayer.getItemBySlot(EquipmentSlot.CHEST);
        Item item = stack.getItem();
        if (!(item instanceof BackpackBlockItem)) {
            return;
        }
        BackpackBlockItem backpack = (BackpackBlockItem)item;
        Model model = BackpackRegistry.getBodyModel((Item)backpack, ((PlayerModel)this.getParentModel()).body);
        poseStack.pushPose();
        BackpackRenderLayer.performTranslations(poseStack, backpack.variant, abstractClientPlayer.isCrouching());
        model.renderToBuffer(poseStack, multiBufferSource.getBuffer(model.renderType(backpack.getTexture())), i, OverlayTexture.NO_OVERLAY, -1);
        poseStack.popPose();
    }
}

