/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.satisfy.camping.core.registry.CampingItems;
import net.satisfy.camping.core.util.BackpackRegistry;
import net.satisfy.camping.core.world.item.EnderpackBlockItem;

public class EnderpackRenderLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public EnderpackRenderLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> $$0) {
        super($$0);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, AbstractClientPlayer abstractClientPlayer, float v, float v1, float v2, float v3, float v4, float v5) {
        ItemStack stack = abstractClientPlayer.getItemBySlot(EquipmentSlot.CHEST);
        Item item = stack.getItem();
        if (!(item instanceof EnderpackBlockItem)) {
            return;
        }
        EnderpackBlockItem enderpack = (EnderpackBlockItem)item;
        Model model = BackpackRegistry.getBodyModel((Item)enderpack, ((PlayerModel)this.getParentModel()).body);
        boolean isEnderBag = enderpack == CampingItems.ENDERBAG;
        boolean isEnderPack = enderpack == CampingItems.ENDERPACK;
        poseStack.pushPose();
        if (isEnderBag) {
            poseStack.translate(-0.3125f, 0.0f, 0.125f);
        }
        if (isEnderPack) {
            poseStack.translate(-0.3125f, 0.0f, 0.125f);
        }
        if (abstractClientPlayer.isCrouching()) {
            poseStack.translate(0.0f, -0.0703125f, 0.00625f);
        }
        model.renderToBuffer(poseStack, multiBufferSource.getBuffer(model.renderType(enderpack.getTexture())), i, OverlayTexture.NO_OVERLAY, -1);
        poseStack.popPose();
    }
}

