/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.core.network.packet;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemContainerContents;
import net.satisfy.camping.core.registry.CampingItems;
import net.satisfy.camping.core.world.BackpackContainer;
import net.satisfy.camping.core.world.inventory.NeoForgeBackpackScreenHandler;
import net.satisfy.camping.platform.Services;

public final class NeoForgeBackpackMenuOpener {
    public static void open(ServerPlayer player) {
        ItemStack equipped = Services.PLATFORM.getEquippedBackpack((Player)player);
        if (equipped == null || equipped.isEmpty()) {
            return;
        }
        if (equipped.is(CampingItems.ENDERPACK) || equipped.is(CampingItems.ENDERBAG)) {
            player.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, p) -> ChestMenu.threeRows((int)id, (Inventory)inv, (Container)player.getEnderChestInventory()), (Component)Component.translatable((String)"container.camping.enderpack")));
            return;
        }
        boolean isBackpack = false;
        for (Item backpack : CampingItems.BACKPACKS.get()) {
            if (!equipped.is(backpack)) continue;
            isBackpack = true;
            break;
        }
        if (!isBackpack) {
            return;
        }
        NonNullList items = NonNullList.withSize((int)24, (Object)ItemStack.EMPTY);
        CustomData beData = (CustomData)equipped.get(DataComponents.BLOCK_ENTITY_DATA);
        if (beData != null) {
            CompoundTag tag = beData.copyTag();
            if (tag.contains("Items", 9)) {
                ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)items, (HolderLookup.Provider)player.registryAccess());
                equipped.remove(DataComponents.BLOCK_ENTITY_DATA);
                if (NeoForgeBackpackMenuOpener.isAllEmpty((NonNullList<ItemStack>)items)) {
                    equipped.remove(DataComponents.CONTAINER);
                } else {
                    equipped.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)items));
                }
            } else {
                equipped.remove(DataComponents.BLOCK_ENTITY_DATA);
            }
        }
        NonNullList tmp = NonNullList.withSize((int)24, (Object)ItemStack.EMPTY);
        ((ItemContainerContents)equipped.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(tmp);
        NonNullList itemsFinal = tmp;
        BlockPos pos = player.blockPosition();
        player.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, p) -> new NeoForgeBackpackScreenHandler(id, inv, new BackpackContainer((NonNullList<ItemStack>)itemsFinal, p, EquipmentSlot.CHEST), pos), (Component)Component.translatable((String)"container.camping.backpack")));
    }

    private static boolean isAllEmpty(NonNullList<ItemStack> list) {
        for (ItemStack s : list) {
            if (s.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private NeoForgeBackpackMenuOpener() {
    }
}

