/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.core.util;

import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class GrillingUtil {
    private static final String GRILLED_KEY = "Grilled";
    private static final String NUTRITION_KEY = "GrilledNutrition";
    private static final String SATURATION_KEY = "GrilledSaturation";

    public static boolean isGrilled(ItemStack itemStack) {
        CustomData data = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
        return data != null && data.contains(GRILLED_KEY);
    }

    public static void setGrilled(ItemStack itemStack) {
        CompoundTag tag = GrillingUtil.getOrCreateData(itemStack);
        tag.putBoolean(GRILLED_KEY, true);
        GrillingUtil.increaseFoodValue(itemStack);
        itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    public static void increaseFoodValue(ItemStack itemStack) {
        FoodProperties food = (FoodProperties)itemStack.get(DataComponents.FOOD);
        if (food != null) {
            int newNutrition = (int)((double)food.nutrition() * 1.25);
            float newSaturation = food.saturation() * 1.25f;
            CompoundTag tag = GrillingUtil.getOrCreateData(itemStack);
            tag.putInt(NUTRITION_KEY, newNutrition);
            tag.putFloat(SATURATION_KEY, newSaturation);
            itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
    }

    public static FoodValue getAdditionalFoodValue(ItemStack itemStack) {
        CompoundTag tag;
        CustomData data = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
        if (data != null && (tag = data.copyTag()).contains(NUTRITION_KEY) && tag.contains(SATURATION_KEY)) {
            int nutrition = tag.getInt(NUTRITION_KEY);
            float saturation = tag.getFloat(SATURATION_KEY);
            return new FoodValue(nutrition, saturation);
        }
        return new FoodValue(0, 0.0f);
    }

    public static void addGrilledTooltip(ItemStack itemStack, List<Component> tooltip) {
        if (GrillingUtil.isGrilled(itemStack)) {
            tooltip.add((Component)Component.translatable((String)"tooltip.camping.grilled").setStyle(Style.EMPTY.withColor(5597999)));
            FoodValue value = GrillingUtil.getAdditionalFoodValue(itemStack);
            tooltip.add((Component)Component.translatable((String)"tooltip.camping.grilled.nutrition", (Object[])new Object[]{value.nutrition()}).setStyle(Style.EMPTY.withColor(14329120)));
            tooltip.add((Component)Component.translatable((String)"tooltip.camping.grilled.saturationModifier", (Object[])new Object[]{Float.valueOf(value.saturationModifier())}).setStyle(Style.EMPTY.withColor(14329120)));
        }
    }

    private static CompoundTag getOrCreateData(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        return data == null ? new CompoundTag() : data.copyTag();
    }

    public record FoodValue(int nutrition, float saturationModifier) {
        @Override
        public String toString() {
            return "{Nutrition:" + this.nutrition + ",Saturation:" + this.saturationModifier + "}";
        }
    }
}

