/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.core.world.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.camping.core.registry.CampingBlockEntities;
import net.satisfy.camping.core.world.BackpackContainer;
import net.satisfy.camping.core.world.inventory.BackpackScreenHandler;
import org.jetbrains.annotations.NotNull;

public class BackpackBlockEntity
extends BaseContainerBlockEntity {
    public static final int CONTAINER_SIZE = 24;
    public static final String ITEMS_TAG = "Items";
    private NonNullList<ItemStack> itemStacks = NonNullList.withSize((int)24, (Object)ItemStack.EMPTY);

    public BackpackBlockEntity(BlockPos pos, BlockState state) {
        super(CampingBlockEntities.BACKPACK, pos, state);
    }

    public int getContainerSize() {
        return this.itemStacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack s : this.itemStacks) {
            if (s.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack getItem(int index) {
        return (ItemStack)this.itemStacks.get(index);
    }

    @NotNull
    public ItemStack removeItem(int index, int count) {
        ItemStack out = ContainerHelper.removeItem(this.itemStacks, (int)index, (int)count);
        if (!out.isEmpty()) {
            this.setChanged();
        }
        return out;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.itemStacks, (int)index);
    }

    public void setItem(int index, @NotNull ItemStack stack) {
        this.itemStacks.set(index, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public boolean stillValid(@NotNull Player player) {
        double dz;
        double dy;
        if (this.level == null || this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        double dx = (double)this.worldPosition.getX() + 0.5;
        return player.distanceToSqr(dx, dy = (double)this.worldPosition.getY() + 0.5, dz = (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"container.camping.backpack");
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.itemStacks = NonNullList.withSize((int)24, (Object)ItemStack.EMPTY);
        if (tag.contains(ITEMS_TAG, 9)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, this.itemStacks, (HolderLookup.Provider)provider);
        }
    }

    protected void saveAdditional(CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        ContainerHelper.saveAllItems((CompoundTag)tag, this.itemStacks, (HolderLookup.Provider)provider);
        super.saveAdditional(tag, provider);
    }

    @NotNull
    public NonNullList<ItemStack> getItems() {
        return this.itemStacks;
    }

    protected void setItems(@NotNull NonNullList<ItemStack> nonNullList) {
        this.itemStacks = nonNullList;
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int id, @NotNull Inventory inv) {
        return new BackpackScreenHandler(id, inv, new BackpackContainer(this.itemStacks), this.worldPosition);
    }

    public void clearContent() {
        this.itemStacks.clear();
    }
}

