/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.core.world.block.entity;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.satisfy.camping.core.registry.CampingBlockEntities;
import net.satisfy.camping.core.util.GrillingUtil;
import net.satisfy.camping.core.world.block.GrillBlock;

public class GrillBlockEntity
extends BlockEntity
implements Clearable {
    private static final int INVENTORY_SIZE = 4;
    private final int[] cookingTime = new int[4];
    private final int[] cookingProgress = new int[4];
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private final RecipeManager.CachedCheck<SingleRecipeInput, CampfireCookingRecipe> quickCheck = RecipeManager.createCheck((RecipeType)RecipeType.CAMPFIRE_COOKING);

    public GrillBlockEntity(BlockPos pos, BlockState state) {
        super(CampingBlockEntities.GRILL, pos, state);
    }

    private static void makeParticles(Level level, BlockPos pos) {
        RandomSource r = level.random;
        level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.SMOKE, true, (double)pos.getX() + 0.5 + r.nextDouble() / 3.0 * (double)(r.nextBoolean() ? 1 : -1), (double)pos.getY() + 1.3 + r.nextDouble() + r.nextDouble(), (double)pos.getZ() + 0.5 + r.nextDouble() / 3.0 * (double)(r.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
    }

    public static void particleTick(Level level, BlockPos pos, BlockState state, GrillBlockEntity grill) {
        RandomSource r = level.random;
        if (r.nextFloat() < 0.11f) {
            for (int i = 0; i < r.nextInt(2) + 2; ++i) {
                GrillBlockEntity.makeParticles(level, pos);
            }
        }
        int base = ((Direction)state.getValue((Property)GrillBlock.FACING)).get2DDataValue();
        for (int j = 0; j < grill.items.size(); ++j) {
            if (((ItemStack)grill.items.get(j)).isEmpty() || !(r.nextFloat() < 0.2f)) continue;
            Direction dir = Direction.from2DDataValue((int)Math.floorMod(j + base, 4));
            float off = 0.15625f;
            double x = (double)pos.getX() + 0.5 - (double)((float)dir.getStepX() * off) + (double)((float)dir.getClockWise().getStepX() * off);
            double y = (double)pos.getY() + 1.2;
            double z = (double)pos.getZ() + 0.5 - (double)((float)dir.getStepZ() * off) + (double)((float)dir.getClockWise().getStepZ() * off);
            for (int k = 0; k < 4; ++k) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public static void cookTick(Level level, BlockPos pos, BlockState state, GrillBlockEntity grill) {
        boolean hasItems = false;
        for (int i = 0; i < grill.items.size(); ++i) {
            SingleRecipeInput input;
            ItemStack result;
            ItemStack stack = (ItemStack)grill.items.get(i);
            if (stack.isEmpty()) continue;
            hasItems = true;
            int n = i;
            grill.cookingProgress[n] = grill.cookingProgress[n] + 1;
            if (grill.cookingProgress[i] < grill.cookingTime[i] || !(result = grill.quickCheck.getRecipeFor((RecipeInput)(input = new SingleRecipeInput(stack)), level).map(RecipeHolder::value).map(r -> r.assemble(input, (HolderLookup.Provider)level.registryAccess())).orElse(stack)).isItemEnabled(level.enabledFeatures())) continue;
            GrillingUtil.setGrilled(result);
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)result);
            grill.items.set(i, (Object)ItemStack.EMPTY);
            level.sendBlockUpdated(pos, state, state, 3);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
        }
        if (hasItems) {
            GrillBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            level.playSound(null, pos, SoundEvents.SMOKER_SMOKE, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.items.clear();
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
        if (tag.contains("CookingTimes", 11)) {
            int[] times = tag.getIntArray("CookingTimes");
            System.arraycopy(times, 0, this.cookingProgress, 0, Math.min(this.cookingTime.length, times.length));
        }
        if (tag.contains("CookingTotalTimes", 11)) {
            int[] totals = tag.getIntArray("CookingTotalTimes");
            System.arraycopy(totals, 0, this.cookingTime, 0, Math.min(this.cookingTime.length, totals.length));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
        tag.putIntArray("CookingTimes", this.cookingProgress);
        tag.putIntArray("CookingTotalTimes", this.cookingTime);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
        tag.putIntArray("CookingTimes", this.cookingProgress);
        tag.putIntArray("CookingTotalTimes", this.cookingTime);
        return tag;
    }

    private void markUpdated() {
        this.setChanged();
        Objects.requireNonNull(this.getLevel()).sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public Optional<CampfireCookingRecipe> getCookableRecipe(ItemStack stack) {
        if (this.items.stream().anyMatch(s -> s.isEmpty())) {
            return this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), this.level).map(RecipeHolder::value);
        }
        return Optional.empty();
    }

    public boolean placeFood(Entity entity, ItemStack stack, int cookTime) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack s = (ItemStack)this.items.get(i);
            if (!s.isEmpty()) continue;
            this.cookingTime[i] = cookTime;
            this.cookingProgress[i] = 0;
            this.items.set(i, (Object)stack.split(1));
            if (this.level != null) {
                this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.Context.of((Entity)entity, (BlockState)this.getBlockState()));
            }
            this.markUpdated();
            return true;
        }
        return false;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void clearContent() {
        this.items.clear();
    }
}

