/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.core.world.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.camping.core.util.MultitoolUtil;
import org.jetbrains.annotations.NotNull;

public class MultitoolItem
extends Item {
    public MultitoolItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (state.hasProperty((Property)BlockStateProperties.FACING) || state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            MultitoolUtil.rotateBlock(level, pos, state, player.isShiftKeyDown());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @NotNull Item.TooltipContext tooltipContext, List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.camping.multitool").setStyle(Style.EMPTY.withColor(5597999)));
    }
}

