/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.camping.platform;

import java.util.function.BiFunction;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.satisfy.camping.core.world.item.BackpackBlockItem;
import net.satisfy.camping.core.world.item.EnderpackBlockItem;
import net.satisfy.camping.optional.NeoForgeCuriosHelper;
import net.satisfy.camping.platform.Services;
import net.satisfy.camping.platform.services.IPlatformHelper;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "NeoForge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public String getGameDirectory() {
        return FMLPaths.GAMEDIR.get().toString();
    }

    @Override
    public boolean isClientSide() {
        return FMLLoader.getDist().isClient();
    }

    @Override
    public <T extends AbstractContainerMenu> MenuType<T> createMenuType(BiFunction<Integer, Inventory, T> o, FeatureFlagSet vanillaSet) {
        return new MenuType(o::apply, vanillaSet);
    }

    @Override
    public ItemStack getEquippedBackpack(Player player) {
        ItemStack chestSlotItem = player.getItemBySlot(EquipmentSlot.CHEST);
        if (chestSlotItem.getItem() instanceof BackpackBlockItem || chestSlotItem.getItem() instanceof EnderpackBlockItem) {
            return chestSlotItem;
        }
        if (Services.PLATFORM.isModLoaded("curios")) {
            return NeoForgeCuriosHelper.getBackpackFromCurios(player);
        }
        return ItemStack.EMPTY;
    }
}

