/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight;

import com.lance5057.extradelight.ExtraDelightComponents;
import com.lance5057.extradelight.ExtraDelightMobEffects;
import com.lance5057.extradelight.ExtraDelightWorldGen;
import com.mojang.blaze3d.shaders.FogShape;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.registries.DeferredItem;

@EventBusSubscriber(modid="extradelight", value={Dist.CLIENT})
public class ExtraDelightNeoForgeClientEvents {
    public static Set<DeferredItem<Item>> feasts = new HashSet<DeferredItem<Item>>();
    public static Set<DeferredItem<Item>> servings = new HashSet<DeferredItem<Item>>();
    public static Set<DeferredItem<Item>> butchercraft = new HashSet<DeferredItem<Item>>();

    @SubscribeEvent
    public static void onFogDensityEvent(ViewportEvent.RenderFog event) {
        if (Minecraft.getInstance().player.level().dimension() == ExtraDelightWorldGen.CORNFIELD) {
            event.setNearPlaneDistance(-8.0f);
            event.scaleFarPlaneDistance(0.25f);
            event.setFogShape(FogShape.CYLINDER);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFogColorEvent(ViewportEvent.ComputeFogColor event) {
        if (Minecraft.getInstance().player.level().dimension() == ExtraDelightWorldGen.CORNFIELD) {
            float f = 0.5f;
            event.setRed(f);
            event.setBlue(f);
            event.setGreen(f);
        }
    }

    @SubscribeEvent
    public static void registerComponentToolTips(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Item.TooltipContext ctx = event.getContext();
        List tooltip = event.getToolTip();
        TooltipFlag flag = event.getFlags();
        TooltipProvider tooltipProvider = (TooltipProvider)stack.get((DataComponentType)ExtraDelightComponents.CHILL.get());
        if (tooltipProvider != null) {
            tooltipProvider.addToTooltip(ctx, i -> tooltip.add(i), flag);
        }
    }

    @SubscribeEvent
    public static void addToolTip(ItemTooltipEvent event) {
        if (feasts.stream().anyMatch(s -> event.getItemStack().is((Holder)s))) {
            event.getToolTip().add(Component.translatable((String)"extradelight.tooltip.feast").withStyle(ChatFormatting.BLUE));
        }
        if (servings.stream().anyMatch(s -> event.getItemStack().is((Holder)s))) {
            event.getToolTip().add(Component.translatable((String)"extradelight.tooltip.serving").withStyle(ChatFormatting.BLUE));
        }
        if (!ModList.get().isLoaded("butchercraft") && butchercraft.stream().anyMatch(s -> event.getItemStack().is((Holder)s))) {
            event.getToolTip().add(Component.translatable((String)"extradelight.tooltip.butchercraft").withStyle(ChatFormatting.RED));
        }
    }

    @SubscribeEvent
    public static void puckerEffect(ComputeFovModifierEvent event) {
        if (event.getPlayer().hasEffect(ExtraDelightMobEffects.SOUR_PUCKER)) {
            int i = event.getPlayer().getEffect(ExtraDelightMobEffects.SOUR_PUCKER).getAmplifier() + 1;
            float s = (float)i * 0.25f;
            event.setNewFovModifier(event.getFovModifier() - s);
        }
    }
}

