/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.aesthetics;

import com.lance5057.extradelight.ExtraDelightItems;
import com.lance5057.extradelight.aesthetics.HelmetBlockItem;
import com.lance5057.extradelight.aesthetics.block.MoldingBlock;
import com.lance5057.extradelight.aesthetics.block.RibbonBlock;
import com.lance5057.extradelight.aesthetics.block.cornhuskdoll.CornHuskDollBlock;
import com.lance5057.extradelight.blocks.StepStoolBlock;
import com.lance5057.extradelight.blocks.countercabinet.CounterCabinetBlock;
import com.lance5057.extradelight.blocks.sink.SinkCabinetBlock;
import com.lance5057.extradelight.data.Recipes;
import com.lance5057.extradelight.displays.cabinet.HalfCabinetBlock;
import com.lance5057.extradelight.displays.food.FoodDisplayBlock;
import com.lance5057.extradelight.displays.knife.KnifeBlock;
import com.lance5057.extradelight.displays.spice.SpiceRackBlock;
import com.lance5057.extradelight.displays.wreath.WreathBlock;
import com.lance5057.extradelight.modules.SummerCitrus;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.commons.lang3.text.WordUtils;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.CommonTags;

public class AestheticBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"extradelight");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"extradelight");
    public static final List<DeferredBlock<Block>> STEP_STOOLS = new ArrayList<DeferredBlock<Block>>();
    public static final List<DeferredBlock<Block>> SPICE_RACKS = new ArrayList<DeferredBlock<Block>>();
    public static final List<DeferredBlock<Block>> SPICE_RACKS_FULL = new ArrayList<DeferredBlock<Block>>();
    public static final List<DeferredBlock<Block>> KNIFE_BLOCKS = new ArrayList<DeferredBlock<Block>>();
    public static final List<DeferredBlock<Block>> CABINETS = new ArrayList<DeferredBlock<Block>>();
    public static final List<DeferredBlock<Block>> COUNTER_CABINETS = new ArrayList<DeferredBlock<Block>>();
    public static final List<DeferredBlock<Block>> FOOD_DISPLAY = new ArrayList<DeferredBlock<Block>>();
    public static final List<DeferredBlock<Block>> WALLPAPER_BLOCKS = new ArrayList<DeferredBlock<Block>>();
    public static final List<DeferredBlock<Block>> MOLDED_WALLPAPER_BLOCKS = new ArrayList<DeferredBlock<Block>>();
    public static final List<DeferredBlock<Block>> GINGHAM_BLOCKS = new ArrayList<DeferredBlock<Block>>();
    public static final List<DeferredBlock<Block>> GINGHAM_CARPET_BLOCKS = new ArrayList<DeferredBlock<Block>>();
    public static final List<DeferredItem<Item>> STEP_STOOL_ITEMS = new ArrayList<DeferredItem<Item>>();
    public static final List<DeferredItem<Item>> SPICE_RACKS_ITEMS = new ArrayList<DeferredItem<Item>>();
    public static final List<DeferredItem<Item>> SPICE_RACKS_FULL_ITEMS = new ArrayList<DeferredItem<Item>>();
    public static final List<DeferredItem<Item>> KNIFE_BLOCK_ITEMS = new ArrayList<DeferredItem<Item>>();
    public static final List<DeferredItem<Item>> CABINET_ITEMS = new ArrayList<DeferredItem<Item>>();
    public static final List<DeferredItem<Item>> COUNTER_CABINET_ITEMS = new ArrayList<DeferredItem<Item>>();
    public static final List<DeferredItem<Item>> FOOD_DISPLAY_ITEMS = new ArrayList<DeferredItem<Item>>();
    public static final List<DeferredItem<Item>> WALLPAPER_ITEMS = new ArrayList<DeferredItem<Item>>();
    public static final List<DeferredItem<Item>> MOLDED_WALLPAPER_ITEMS = new ArrayList<DeferredItem<Item>>();
    public static final List<DeferredItem<Item>> GINGHAM_ITEMS = new ArrayList<DeferredItem<Item>>();
    public static final List<DeferredItem<Item>> GINGHAM_CARPET_ITEMS = new ArrayList<DeferredItem<Item>>();
    public static final DeferredHolder<Block, CornHuskDollBlock> CORN_HUSK_DOLL = BLOCKS.register("corn_husk_doll", () -> new CornHuskDollBlock());
    public static final DeferredHolder<Item, BlockItem> CORN_HUSK_DOLL_ITEM = ITEMS.register("corn_husk_doll", () -> new BlockItem((Block)CORN_HUSK_DOLL.get(), new Item.Properties()));
    public static final List<DeferredBlock<Block>> DRIED_CORN_FENCE = new ArrayList<DeferredBlock<Block>>();
    public static final List<DeferredItem<Item>> DRIED_CORN_FENCE_ITEMS = new ArrayList<DeferredItem<Item>>();
    public static final List<DeferredBlock<Block>> WREATHS = new ArrayList<DeferredBlock<Block>>();
    public static final List<DeferredItem<Item>> WREATH_ITEMS = new ArrayList<DeferredItem<Item>>();
    public static final List<DeferredBlock<Block>> BOWS = new ArrayList<DeferredBlock<Block>>();
    public static final List<DeferredItem<Item>> BOW_ITEMS = new ArrayList<DeferredItem<Item>>();
    public static final List<DeferredBlock<Block>> SINKS = new ArrayList<DeferredBlock<Block>>();
    public static final List<DeferredItem<Item>> SINK_ITEMS = new ArrayList<DeferredItem<Item>>();

    public static Block[] getRegistryListAsBlocks(List<DeferredBlock<Block>> blocks) {
        ArrayList<Block> l = new ArrayList<Block>();
        for (DeferredBlock<Block> b : blocks) {
            l.add((Block)b.get());
        }
        Block[] a = (Block[])l.toArray(Block[]::new);
        return a;
    }

    public static Item[] getRegistryListAsItems(List<DeferredItem<Item>> items) {
        ArrayList<Item> l = new ArrayList<Item>();
        for (DeferredItem<Item> b : items) {
            l.add((Item)b.get());
        }
        Item[] a = (Item[])l.toArray(Item[]::new);
        return a;
    }

    public static void registerMoldedWallpaper(String name, Supplier<? extends Block> block, List<DeferredBlock<Block>> blocks, List<DeferredItem<Item>> items) {
        for (WOOD w : WOOD.values()) {
            for (DyeColor d : DyeColor.values()) {
                DeferredBlock b = BLOCKS.register(w.toString() + "_molded_" + d.getName() + "_" + name, block);
                DeferredItem t = ITEMS.register(w.toString() + "_molded_" + d.getName() + "_" + name, () -> new BlockItem((Block)b.get(), new Item.Properties()));
                blocks.add((DeferredBlock<Block>)b);
                items.add((DeferredItem<Item>)t);
            }
        }
    }

    public static void registerAllWood(String name, Supplier<? extends Block> block, List<DeferredBlock<Block>> blocks, List<DeferredItem<Item>> items) {
        for (WOOD w : WOOD.values()) {
            DeferredBlock b = BLOCKS.register(w.toString() + "_" + name, block);
            DeferredItem t = ITEMS.register(w.toString() + "_" + name, () -> new BlockItem((Block)b.get(), new Item.Properties()));
            blocks.add((DeferredBlock<Block>)b);
            items.add((DeferredItem<Item>)t);
        }
    }

    public static void registerAllColors(String name, Supplier<? extends Block> block, List<DeferredBlock<Block>> blocks, List<DeferredItem<Item>> items) {
        for (DyeColor w : DyeColor.values()) {
            DeferredBlock b = BLOCKS.register(name + "_" + w.getName(), block);
            DeferredItem t = ITEMS.register(name + "_" + w.toString(), () -> new BlockItem((Block)b.get(), new Item.Properties()));
            blocks.add((DeferredBlock<Block>)b);
            items.add((DeferredItem<Item>)t);
        }
    }

    public static void registerAllWoodHelm(String name, Supplier<? extends Block> block, List<DeferredBlock<Block>> blocks, List<DeferredItem<Item>> items) {
        DeferredItem t;
        DeferredBlock b;
        for (WOOD wOOD : WOOD.values()) {
            if (wOOD.toString() == "fruit" || wOOD.toString() == "bamboo") continue;
            b = BLOCKS.register(wOOD.toString() + "_" + name, block);
            t = ITEMS.register(wOOD.toString() + "_" + name, () -> new HelmetBlockItem((Block)b.get(), new Item.Properties()));
            blocks.add((DeferredBlock<Block>)b);
            items.add((DeferredItem<Item>)t);
        }
        for (Enum enum_ : EXTRA_LEAVES.values()) {
            b = BLOCKS.register(enum_.toString() + "_" + name, block);
            t = ITEMS.register(enum_.toString() + "_" + name, () -> new HelmetBlockItem((Block)b.get(), new Item.Properties()));
            blocks.add((DeferredBlock<Block>)b);
            items.add((DeferredItem<Item>)t);
        }
    }

    public static void registerAllColorsHelm(String name, Supplier<? extends Block> block, List<DeferredBlock<Block>> blocks, List<DeferredItem<Item>> items) {
        for (DyeColor w : DyeColor.values()) {
            DeferredBlock b = BLOCKS.register(name + "_" + w.getName(), block);
            DeferredItem t = ITEMS.register(name + "_" + w.toString(), () -> new HelmetBlockItem((Block)b.get(), new Item.Properties()));
            blocks.add((DeferredBlock<Block>)b);
            items.add((DeferredItem<Item>)t);
        }
    }

    public static void setup() {
        AestheticBlocks.registerAllWood("step_stool", StepStoolBlock::new, STEP_STOOLS, STEP_STOOL_ITEMS);
        AestheticBlocks.registerAllWood("spice_rack", SpiceRackBlock::new, SPICE_RACKS, SPICE_RACKS_ITEMS);
        AestheticBlocks.registerAllWood("spice_rack_full", SpiceRackBlock::new, SPICE_RACKS_FULL, SPICE_RACKS_FULL_ITEMS);
        AestheticBlocks.registerAllWood("knife_block", KnifeBlock::new, KNIFE_BLOCKS, KNIFE_BLOCK_ITEMS);
        AestheticBlocks.registerAllWood("half_cabinet", HalfCabinetBlock::new, CABINETS, CABINET_ITEMS);
        AestheticBlocks.registerAllWood("sink", SinkCabinetBlock::new, SINKS, SINK_ITEMS);
        AestheticBlocks.registerAllWood("counter_cabinet", CounterCabinetBlock::new, COUNTER_CABINETS, COUNTER_CABINET_ITEMS);
        AestheticBlocks.registerAllWood("food_display", FoodDisplayBlock::new, FOOD_DISPLAY, FOOD_DISPLAY_ITEMS);
        AestheticBlocks.registerAllColors("wallpaper", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).strength(2.0f, 3.0f).sound(SoundType.GRASS)), WALLPAPER_BLOCKS, WALLPAPER_ITEMS);
        AestheticBlocks.registerMoldedWallpaper("wallpaper", () -> new MoldingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).strength(2.0f, 3.0f).sound(SoundType.GRASS)), MOLDED_WALLPAPER_BLOCKS, MOLDED_WALLPAPER_ITEMS);
        AestheticBlocks.registerAllWood("dried_corn_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_FENCE)), DRIED_CORN_FENCE, DRIED_CORN_FENCE_ITEMS);
        AestheticBlocks.registerAllWoodHelm("wreath", WreathBlock::new, WREATHS, WREATH_ITEMS);
        AestheticBlocks.registerAllColorsHelm("ribbon_bow", () -> new RibbonBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACK_WOOL).noOcclusion().noCollission()), BOWS, BOW_ITEMS);
        AestheticBlocks.registerAllColors("gingham", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACK_WOOL)), GINGHAM_BLOCKS, GINGHAM_ITEMS);
        AestheticBlocks.registerAllColors("gingham_carpet", () -> new CarpetBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACK_CARPET)), GINGHAM_CARPET_BLOCKS, GINGHAM_CARPET_ITEMS);
    }

    public static void blockModel(BlockStateProvider bsp) {
        int i;
        for (i = 0; i < WOOD.values().length; ++i) {
            bsp.horizontalBlock((Block)STEP_STOOLS.get(i).get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)bsp.models().withExistingParent(WOOD.values()[i].toString() + "_step_stool", bsp.modLoc("block/stepstool"))).texture("0", bsp.mcLoc("block/" + WOOD.values()[i].toString() + "_planks"))).texture("particle", bsp.mcLoc("block/" + WOOD.values()[i].toString() + "_planks"))).renderType("cutout"));
            bsp.horizontalBlock((Block)SPICE_RACKS.get(i).get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)bsp.models().withExistingParent(WOOD.values()[i].toString() + "_spice_rack", bsp.modLoc("block/spicerack"))).texture("0", bsp.mcLoc("block/" + WOOD.values()[i].toString() + "_planks"))).texture("2", bsp.modLoc("block/" + WOOD.values()[i].toString() + "_ornate"))).texture("particle", bsp.mcLoc("block/" + WOOD.values()[i].toString() + "_planks"))).renderType("cutout"));
            bsp.horizontalBlock((Block)SPICE_RACKS_FULL.get(i).get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)bsp.models().withExistingParent(WOOD.values()[i].toString() + "_spice_rack_full", bsp.modLoc("block/spicerack_filled"))).texture("0", bsp.mcLoc("block/" + WOOD.values()[i].toString() + "_planks"))).texture("2", bsp.modLoc("block/" + WOOD.values()[i].toString() + "_ornate"))).texture("particle", bsp.mcLoc("block/" + WOOD.values()[i].toString() + "_planks"))).renderType("cutout"));
            bsp.horizontalBlock((Block)KNIFE_BLOCKS.get(i).get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)bsp.models().withExistingParent(WOOD.values()[i].toString() + "_knife_block", bsp.modLoc("block/knifeblock"))).texture("0", bsp.mcLoc("block/" + WOOD.values()[i].toString() + "_planks"))).texture("particle", bsp.mcLoc("block/" + WOOD.values()[i].toString() + "_planks"))).renderType("cutout"));
            int f = i;
            bsp.getVariantBuilder((Block)FOOD_DISPLAY.get(i).get()).forAllStates(state -> {
                if (((Boolean)state.getValue((Property)FoodDisplayBlock.ENCASED)).booleanValue()) {
                    return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)bsp.models().withExistingParent(WOOD.values()[f].toString() + "_food_display_encased", bsp.modLoc("block/food_display_encased"))).texture("0", bsp.mcLoc("block/" + WOOD.values()[f].toString() + "_planks"))).texture("particle", bsp.mcLoc("block/" + WOOD.values()[f].toString() + "_planks"))).renderType("cutout")).rotationY(((int)((Direction)state.getValue((Property)FoodDisplayBlock.FACING)).toYRot() + 180) % 360).build();
                }
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)bsp.models().withExistingParent(WOOD.values()[f].toString() + "_food_display", bsp.modLoc("block/food_display"))).texture("0", bsp.mcLoc("block/" + WOOD.values()[f].toString() + "_planks"))).texture("particle", bsp.mcLoc("block/" + WOOD.values()[f].toString() + "_planks"))).renderType("cutout")).rotationY(((int)((Direction)state.getValue((Property)FoodDisplayBlock.FACING)).toYRot() + 180) % 360).build();
            });
            System.out.println(WREATHS);
            if (WOOD.values()[i].toString() == "crimson") {
                bsp.horizontalBlock((Block)WREATHS.get(i).get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)bsp.models().withExistingParent(WOOD.values()[i].toString() + "_wreath_block", bsp.modLoc("block/wreath"))).texture("all", bsp.mcLoc("block/nether_wart_block"))).texture("particle", bsp.mcLoc("block/nether_wart_block"))).renderType("cutout"));
            } else if (WOOD.values()[i].toString() == "warped") {
                bsp.horizontalBlock((Block)WREATHS.get(i).get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)bsp.models().withExistingParent(WOOD.values()[i].toString() + "_wreath_block", bsp.modLoc("block/wreath"))).texture("all", bsp.mcLoc("block/warped_wart_block"))).texture("particle", bsp.mcLoc("block/warped_wart_block"))).renderType("cutout"));
            } else if (WOOD.values()[i].toString() != "fruit" && WOOD.values()[i].toString() != "bamboo") {
                bsp.horizontalBlock((Block)WREATHS.get(i).get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)bsp.models().withExistingParent(WOOD.values()[i].toString() + "_wreath_block", bsp.modLoc("block/wreath"))).texture("all", bsp.mcLoc("block/" + WOOD.values()[i].toString() + "_leaves"))).texture("particle", bsp.mcLoc("block/" + WOOD.values()[i].toString() + "_leaves"))).renderType("cutout"));
            }
            String s = WOOD.values()[i].toString();
            MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)bsp.getMultipartBuilder((Block)DRIED_CORN_FENCE.get(i).get()).part().modelFile((ModelFile)((BlockModelBuilder)bsp.models().withExistingParent(s + "_dried_corn_fence", bsp.modLoc("dried_corn_fence"))).texture("1", bsp.mcLoc("block/" + WOOD.values()[i].toString() + "_planks"))).addModel()).end();
            PipeBlock.PROPERTY_BY_DIRECTION.entrySet().forEach(e -> {
                Direction dir = (Direction)e.getKey();
                if (dir.getAxis().isHorizontal()) {
                    ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)bsp.models().fenceSide(s + "_side", bsp.mcLoc("block/" + s + "_planks"))).rotationY(((int)dir.toYRot() + 180) % 360).uvLock(true).addModel()).condition((Property)e.getValue(), (Comparable[])new Boolean[]{true});
                }
            });
        }
        for (int j = 0; j < EXTRA_LEAVES.values().length; ++j) {
            if (EXTRA_LEAVES.values()[j].toString() == "azalea" || EXTRA_LEAVES.values()[j].toString() == "flowering_azalea") {
                bsp.horizontalBlock((Block)WREATHS.get(WOOD.values().length + j - 2).get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)bsp.models().withExistingParent(EXTRA_LEAVES.values()[j].toString() + "_wreath_block", bsp.modLoc("block/wreath"))).texture("all", bsp.mcLoc("block/" + EXTRA_LEAVES.values()[j].toString() + "_leaves"))).texture("particle", bsp.mcLoc("block/" + EXTRA_LEAVES.values()[j].toString() + "_leaves"))).renderType("cutout"));
                continue;
            }
            bsp.horizontalBlock((Block)WREATHS.get(WOOD.values().length + j - 2).get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)bsp.models().withExistingParent(EXTRA_LEAVES.values()[j].toString() + "_wreath_block", bsp.modLoc("block/wreath"))).texture("all", ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)("block/crops/fruit/" + EXTRA_LEAVES.values()[j].toString() + "/" + EXTRA_LEAVES.values()[j].toString() + "_leaves")))).texture("particle", ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)("block/crops/fruit/" + EXTRA_LEAVES.values()[j].toString() + "/" + EXTRA_LEAVES.values()[j].toString() + "_leaves")))).renderType("cutout"));
        }
        for (i = 0; i < DyeColor.values().length; ++i) {
            bsp.simpleBlock((Block)WALLPAPER_BLOCKS.get(i).get());
            bsp.directionalBlock((Block)BOWS.get(i).get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)bsp.models().withExistingParent(DyeColor.values()[i].toString() + "_bow", bsp.modLoc("block/ribbon_bow"))).texture("0", bsp.modLoc("block/ribbon/" + DyeColor.values()[i].toString().toLowerCase() + "_ribbon"))).texture("particle", bsp.modLoc("block/ribbon/" + DyeColor.values()[i].toString().toLowerCase() + "_ribbon")));
            bsp.simpleBlock((Block)GINGHAM_BLOCKS.get(i).get(), (ModelFile)bsp.models().cubeAll("gingham_" + DyeColor.values()[i].toString(), bsp.modLoc("block/gingham/" + DyeColor.values()[i].toString())));
            bsp.simpleBlock((Block)GINGHAM_CARPET_BLOCKS.get(i).get(), (ModelFile)bsp.models().carpet("gingham_carpet_" + DyeColor.values()[i].toString(), bsp.modLoc("block/gingham/" + DyeColor.values()[i].toString())));
        }
        for (i = 0; i < WOOD.values().length; ++i) {
            for (int c = 0; c < DyeColor.values().length; ++c) {
                int o = i * DyeColor.values().length + c;
                Block b = (Block)MOLDED_WALLPAPER_BLOCKS.get(o).get();
                ((VariantBlockStateBuilder)bsp.getVariantBuilder(b).partialState().with(MoldingBlock.HALF, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)bsp.models().withExistingParent(b.getName().getString() + "_top", bsp.modLoc("block/molding_top"))).texture("0", bsp.modLoc("block/wallpaper_" + String.valueOf(DyeColor.values()[c])))).texture("1", bsp.mcLoc("block/" + String.valueOf((Object)WOOD.values()[i]) + "_planks"))).texture("particle", bsp.modLoc("block/wallpaper_" + String.valueOf(DyeColor.values()[c])))).addModel()).partialState().with(MoldingBlock.HALF, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)bsp.models().withExistingParent(b.getName().getString() + "_bottom", bsp.modLoc("block/molding_bottom"))).texture("0", bsp.modLoc("block/wallpaper_" + String.valueOf(DyeColor.values()[c])))).texture("1", bsp.mcLoc("block/" + String.valueOf((Object)WOOD.values()[i]) + "_planks"))).texture("particle", bsp.modLoc("block/wallpaper_" + String.valueOf(DyeColor.values()[c])))).addModel();
            }
        }
        bsp.simpleBlock((Block)CORN_HUSK_DOLL.get(), (ModelFile)bsp.models().getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/air")));
    }

    public static void itemModel(ItemModelProvider tmp) {
        int i;
        for (i = 0; i < WOOD.values().length; ++i) {
            ((ItemModelBuilder)((ItemModelBuilder)tmp.getBuilder(STEP_STOOLS.get(i).getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(tmp.modLoc("block/stepstool")))).texture("0", tmp.mcLoc("block/" + WOOD.values()[i].toString() + "_planks"));
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)tmp.getBuilder(SPICE_RACKS.get(i).getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(tmp.modLoc("block/spicerack")))).texture("0", tmp.mcLoc("block/" + WOOD.values()[i].toString() + "_planks"))).texture("2", tmp.modLoc("block/" + WOOD.values()[i].toString() + "_ornate"));
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)tmp.getBuilder(SPICE_RACKS_FULL.get(i).getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(tmp.modLoc("block/spicerack_filled")))).texture("0", tmp.mcLoc("block/" + WOOD.values()[i].toString() + "_planks"))).texture("2", tmp.modLoc("block/" + WOOD.values()[i].toString() + "_ornate"));
            ((ItemModelBuilder)((ItemModelBuilder)tmp.getBuilder(KNIFE_BLOCKS.get(i).getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(tmp.modLoc("block/knifeblock")))).texture("0", tmp.mcLoc("block/" + WOOD.values()[i].toString() + "_planks"));
            ((ItemModelBuilder)tmp.getBuilder(CABINETS.get(i).getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(tmp.modLoc("block/" + WOOD.values()[i].toString() + "_half_cabinet")));
            ((ItemModelBuilder)((ItemModelBuilder)tmp.getBuilder(FOOD_DISPLAY.get(i).getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(tmp.modLoc("block/food_display")))).texture("0", tmp.mcLoc("block/" + WOOD.values()[i].toString() + "_planks"));
            if (WOOD.values()[i].toString() == "cinnamon") {
                ((ItemModelBuilder)tmp.getBuilder(COUNTER_CABINET_ITEMS.get(i).getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(tmp.modLoc("block/" + WOOD.values()[i].toString() + "_cabinet")));
            } else if (WOOD.values()[i].toString() == "fruit") {
                ((ItemModelBuilder)tmp.getBuilder(COUNTER_CABINET_ITEMS.get(i).getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(tmp.modLoc("block/" + WOOD.values()[i].toString() + "_cabinet")));
            } else {
                ((ItemModelBuilder)tmp.getBuilder(COUNTER_CABINET_ITEMS.get(i).getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)("block/" + WOOD.values()[i].toString() + "_cabinet"))));
            }
            ((ItemModelBuilder)tmp.getBuilder(SINKS.get(i).getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(tmp.modLoc("block/" + WOOD.values()[i].toString() + "_sink_cabinet")));
            ((ItemModelBuilder)tmp.getBuilder(DRIED_CORN_FENCE.get(i).getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(tmp.modLoc("block/" + WOOD.values()[i].toString() + "_dried_corn_fence")));
            if (WOOD.values()[i].toString() == "crimson") {
                ((ItemModelBuilder)((ItemModelBuilder)tmp.getBuilder(WREATHS.get(i).getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(tmp.modLoc("block/wreath")))).texture("all", tmp.mcLoc("block/nether_wart_block"));
                continue;
            }
            if (WOOD.values()[i].toString() == "warped") {
                ((ItemModelBuilder)((ItemModelBuilder)tmp.getBuilder(WREATHS.get(i).getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(tmp.modLoc("block/wreath")))).texture("all", tmp.mcLoc("block/warped_wart_block"));
                continue;
            }
            if (WOOD.values()[i].toString() == "fruit" || WOOD.values()[i].toString() == "bamboo") continue;
            ((ItemModelBuilder)((ItemModelBuilder)tmp.getBuilder(WREATHS.get(i).getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(tmp.modLoc("block/wreath")))).texture("all", tmp.mcLoc("block/" + WOOD.values()[i].toString() + "_leaves"));
        }
        for (int j = 0; j < EXTRA_LEAVES.values().length; ++j) {
            if (EXTRA_LEAVES.values()[j].toString() == "azalea" || EXTRA_LEAVES.values()[j].toString() == "flowering_azalea") {
                ((ItemModelBuilder)((ItemModelBuilder)tmp.getBuilder(WREATHS.get(WOOD.values().length + j - 2).getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(tmp.modLoc("block/wreath")))).texture("all", tmp.mcLoc("block/" + EXTRA_LEAVES.values()[j].toString() + "_leaves"));
                continue;
            }
            ((ItemModelBuilder)((ItemModelBuilder)tmp.getBuilder(WREATHS.get(WOOD.values().length + j - 2).getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(tmp.modLoc("block/wreath")))).texture("all", ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)("block/crops/fruit/" + EXTRA_LEAVES.values()[j].toString() + "/" + EXTRA_LEAVES.values()[j].toString() + "_leaves")));
        }
        for (i = 0; i < DyeColor.values().length; ++i) {
            ((ItemModelBuilder)tmp.getBuilder(WALLPAPER_ITEMS.get(i).getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)("block/" + BuiltInRegistries.BLOCK.getKey((Object)((BlockItem)WALLPAPER_ITEMS.get(i).get()).getBlock()).getPath()))));
            ((ItemModelBuilder)((ItemModelBuilder)tmp.getBuilder(BOWS.get(i).getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(tmp.modLoc("block/ribbon_bow")))).texture("0", tmp.modLoc("block/ribbon/" + DyeColor.values()[i].toString() + "_ribbon"));
            ((ItemModelBuilder)tmp.getBuilder(GINGHAM_ITEMS.get(i).getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)("block/" + BuiltInRegistries.BLOCK.getKey((Object)((BlockItem)GINGHAM_ITEMS.get(i).get()).getBlock()).getPath()))));
            ((ItemModelBuilder)tmp.getBuilder(GINGHAM_CARPET_ITEMS.get(i).getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)("block/" + BuiltInRegistries.BLOCK.getKey((Object)((BlockItem)GINGHAM_CARPET_ITEMS.get(i).get()).getBlock()).getPath()))));
        }
        for (i = 0; i < WOOD.values().length; ++i) {
            for (int c = 0; c < DyeColor.values().length; ++c) {
                int o = i * DyeColor.values().length + c;
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)tmp.getBuilder(MOLDED_WALLPAPER_ITEMS.get(o).getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(tmp.modLoc("block/molding_bottom")))).texture("1", tmp.mcLoc("block/" + WOOD.values()[i].toString() + "_planks"))).texture("0", tmp.modLoc("block/wallpaper_" + DyeColor.values()[c].toString()));
            }
        }
        ((ItemModelBuilder)tmp.getBuilder(CORN_HUSK_DOLL.getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(tmp.modLoc("block/corn_husk_doll")));
    }

    public static void EngLoc(LanguageProvider lp) {
        String w;
        int i;
        for (i = 0; i < WOOD.values().length; ++i) {
            w = WOOD.values()[i].toString();
            w = WordUtils.capitalize((String)w.replace('_', ' '));
            lp.add((Block)STEP_STOOLS.get(i).get(), w + " Step Stool");
            lp.add((Block)SPICE_RACKS.get(i).get(), w + " Spice Rack");
            lp.add((Block)SPICE_RACKS_FULL.get(i).get(), w + " Spice Rack");
            lp.add((Block)KNIFE_BLOCKS.get(i).get(), w + " Knife Block");
            lp.add((Block)SINKS.get(i).get(), w + " Sink");
            lp.add((Block)CABINETS.get(i).get(), w + " Half Cabinet");
            lp.add((Block)DRIED_CORN_FENCE.get(i).get(), "Dried Corn " + w + " Fence");
            lp.add((Block)COUNTER_CABINETS.get(i).get(), w + " Cabinet (Countertop)");
            lp.add((Block)FOOD_DISPLAY.get(i).get(), w + " Food Display");
            if (WOOD.values()[i].toString() != "fruit" && WOOD.values()[i].toString() != "bamboo") {
                lp.add((Block)WREATHS.get(i).get(), w + " Wreath");
            }
            for (int j = 0; j < DyeColor.values().length; ++j) {
                int o = i * DyeColor.values().length + j;
                String d = DyeColor.values()[j].toString();
                d = WordUtils.capitalize((String)d.replace('_', ' '));
                lp.add((Item)MOLDED_WALLPAPER_ITEMS.get(o).get(), w + " Molded " + d + " Wallpaper");
            }
        }
        for (int j = 0; j < EXTRA_LEAVES.values().length; ++j) {
            String f = EXTRA_LEAVES.values()[j].toString();
            f = WordUtils.capitalize((String)f.replace('_', ' '));
            lp.add((Block)WREATHS.get(WOOD.values().length + j - 2).get(), f + " Wreath");
        }
        for (i = 0; i < DyeColor.values().length; ++i) {
            w = DyeColor.values()[i].toString();
            w = WordUtils.capitalize((String)w.replace('_', ' '));
            lp.add((Item)WALLPAPER_ITEMS.get(i).get(), w + " Wallpaper");
            lp.add((Block)BOWS.get(i).get(), w + " Bow");
            lp.add((Item)GINGHAM_ITEMS.get(i).get(), w + " Gingham");
            lp.add((Item)GINGHAM_CARPET_ITEMS.get(i).get(), w + " Gingham Carpet");
        }
        lp.add((Block)CORN_HUSK_DOLL.get(), "Corn Husk Doll");
    }

    public static void Recipes(RecipeOutput consumer) {
        AestheticBlocks.woodRecipe(consumer, Items.ACACIA_SLAB, Items.ACACIA_TRAPDOOR, Items.ACACIA_FENCE, Items.ACACIA_LEAVES, WOOD.acacia);
        AestheticBlocks.woodRecipe(consumer, Items.BIRCH_SLAB, Items.BIRCH_TRAPDOOR, Items.BIRCH_FENCE, Items.BIRCH_LEAVES, WOOD.birch);
        AestheticBlocks.woodRecipe(consumer, Items.CRIMSON_SLAB, Items.CRIMSON_TRAPDOOR, Items.CRIMSON_FENCE, Items.NETHER_WART_BLOCK, WOOD.crimson);
        AestheticBlocks.woodRecipe(consumer, Items.DARK_OAK_SLAB, Items.DARK_OAK_TRAPDOOR, Items.DARK_OAK_FENCE, Items.DARK_OAK_LEAVES, WOOD.dark_oak);
        AestheticBlocks.woodRecipe(consumer, Items.JUNGLE_SLAB, Items.JUNGLE_TRAPDOOR, Items.JUNGLE_FENCE, Items.JUNGLE_LEAVES, WOOD.jungle);
        AestheticBlocks.woodRecipe(consumer, Items.MANGROVE_SLAB, Items.MANGROVE_TRAPDOOR, Items.MANGROVE_FENCE, Items.MANGROVE_LEAVES, WOOD.mangrove);
        AestheticBlocks.woodRecipe(consumer, Items.OAK_SLAB, Items.OAK_TRAPDOOR, Items.OAK_FENCE, Items.OAK_LEAVES, WOOD.oak);
        AestheticBlocks.woodRecipe(consumer, Items.SPRUCE_SLAB, Items.SPRUCE_TRAPDOOR, Items.SPRUCE_FENCE, Items.SPRUCE_LEAVES, WOOD.spruce);
        AestheticBlocks.woodRecipe(consumer, Items.WARPED_SLAB, Items.WARPED_TRAPDOOR, Items.WARPED_FENCE, Items.WARPED_WART_BLOCK, WOOD.warped);
        AestheticBlocks.woodRecipe(consumer, (Item)ExtraDelightItems.CINNAMON_SLAB.get(), (Item)ExtraDelightItems.CINNAMON_TRAPDOOR.get(), (Item)ExtraDelightItems.CINNAMON_FENCE.get(), (Item)ExtraDelightItems.CINNAMON_LEAVES.get(), WOOD.cinnamon);
        AestheticBlocks.woodRecipe(consumer, (Item)ExtraDelightItems.FRUIT_SLAB.get(), (Item)ExtraDelightItems.FRUIT_TRAPDOOR.get(), (Item)ExtraDelightItems.FRUIT_FENCE.get(), WOOD.fruit);
        AestheticBlocks.woodRecipe(consumer, Items.CHERRY_SLAB, Items.CHERRY_TRAPDOOR, Items.CHERRY_FENCE, Items.CHERRY_LEAVES, WOOD.cherry);
        AestheticBlocks.woodRecipe(consumer, Items.BAMBOO_SLAB, Items.BAMBOO_TRAPDOOR, Items.BAMBOO_FENCE, WOOD.bamboo);
        AestheticBlocks.leafRecipe(consumer, Items.AZALEA_LEAVES, EXTRA_LEAVES.azalea);
        AestheticBlocks.leafRecipe(consumer, Items.FLOWERING_AZALEA_LEAVES, EXTRA_LEAVES.flowering_azalea);
        AestheticBlocks.leafRecipe(consumer, (Item)ExtraDelightItems.HAZELNUT_LEAVES.get(), EXTRA_LEAVES.hazelnut);
        AestheticBlocks.leafRecipe(consumer, (Item)ExtraDelightItems.APPLE_LEAVES.get(), EXTRA_LEAVES.apple);
        AestheticBlocks.leafRecipe(consumer, (Item)SummerCitrus.LEMON_LEAVES_ITEM.get(), EXTRA_LEAVES.lemon);
        AestheticBlocks.leafRecipe(consumer, (Item)SummerCitrus.LIME_LEAVES_ITEM.get(), EXTRA_LEAVES.lime);
        AestheticBlocks.leafRecipe(consumer, (Item)SummerCitrus.ORANGE_LEAVES_ITEM.get(), EXTRA_LEAVES.orange);
        AestheticBlocks.leafRecipe(consumer, (Item)SummerCitrus.GRAPEFRUIT_LEAVES_ITEM.get(), EXTRA_LEAVES.grapefruit);
        AestheticBlocks.moldRecipe(consumer, Items.OAK_SLAB, WOOD.oak, 0);
        AestheticBlocks.moldRecipe(consumer, Items.DARK_OAK_SLAB, WOOD.dark_oak, 16);
        AestheticBlocks.moldRecipe(consumer, Items.SPRUCE_SLAB, WOOD.spruce, 32);
        AestheticBlocks.moldRecipe(consumer, Items.BIRCH_SLAB, WOOD.birch, 48);
        AestheticBlocks.moldRecipe(consumer, Items.JUNGLE_SLAB, WOOD.jungle, 64);
        AestheticBlocks.moldRecipe(consumer, Items.ACACIA_SLAB, WOOD.acacia, 80);
        AestheticBlocks.moldRecipe(consumer, Items.CRIMSON_SLAB, WOOD.crimson, 96);
        AestheticBlocks.moldRecipe(consumer, Items.WARPED_SLAB, WOOD.warped, 112);
        AestheticBlocks.moldRecipe(consumer, Items.MANGROVE_SLAB, WOOD.mangrove, 128);
        AestheticBlocks.moldRecipe(consumer, (Item)ExtraDelightItems.CINNAMON_SLAB.get(), WOOD.cinnamon, 144);
        AestheticBlocks.moldRecipe(consumer, Items.CHERRY_SLAB, WOOD.cherry, 160);
        AestheticBlocks.moldRecipe(consumer, Items.BAMBOO_SLAB, WOOD.bamboo, 176);
        AestheticBlocks.moldRecipe(consumer, (Item)ExtraDelightItems.FRUIT_SLAB.get(), WOOD.fruit, 192);
        AestheticBlocks.cabinetRecipes(consumer);
        for (int i = 0; i < DyeColor.values().length; ++i) {
            DyeColor dye = DyeColor.values()[i];
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)WALLPAPER_ITEMS.get(dye.ordinal()).get()), (int)4).requires((ItemLike)Items.PAPER, 4).requires(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dyes/" + String.valueOf(dye))))).unlockedBy(String.valueOf(dye) + "_wallpaper", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.PAPER})).save(consumer);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)BOW_ITEMS.get(dye.ordinal()).get()), (int)1).pattern(" w ").pattern(" w ").pattern("w w").define(Character.valueOf('w'), (ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(String.valueOf(dye) + "_wool")))).unlockedBy(String.valueOf(dye) + "_bow", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.WHITE_WOOL})).save(consumer);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)GINGHAM_ITEMS.get(dye.ordinal()).get()), (int)4).pattern("cw").pattern("wc").define(Character.valueOf('c'), (ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(String.valueOf(dye) + "_wool")))).define(Character.valueOf('w'), (ItemLike)Items.WHITE_WOOL).unlockedBy(String.valueOf(dye) + "_gingham", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.WHITE_WOOL})).save(consumer);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)GINGHAM_CARPET_ITEMS.get(dye.ordinal()).get()), (int)4).pattern("cw").pattern("wc").define(Character.valueOf('c'), (ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(String.valueOf(dye) + "_carpet")))).define(Character.valueOf('w'), (ItemLike)Items.WHITE_CARPET).unlockedBy(String.valueOf(dye) + "_gingham_carpet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.WHITE_CARPET})).save(consumer);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)GINGHAM_CARPET_ITEMS.get(dye.ordinal()).get()), (int)3).pattern("cc").define(Character.valueOf('c'), (ItemLike)GINGHAM_ITEMS.get(i)).unlockedBy(String.valueOf(dye) + "_gingham_carpet_from_block", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.WHITE_WOOL})).save(consumer, String.valueOf(dye) + "_gingham_carpet_from_block");
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)CORN_HUSK_DOLL.get())).pattern(" c ").pattern(" s ").pattern("ccc").define(Character.valueOf('c'), (ItemLike)ExtraDelightItems.DRIED_CORN_HUSK.get()).define(Character.valueOf('s'), Tags.Items.STRINGS).unlockedBy("corn_husk_doll", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.DRIED_CORN_HUSK.get()})).save(consumer);
    }

    static void moldRecipe(RecipeOutput consumer, Item slab, WOOD name, int add) {
        for (int j = 0; j < 16; ++j) {
            DyeColor d = DyeColor.values()[j];
            String n = String.valueOf(d) + "_" + String.valueOf((Object)name) + "_wallpaper";
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)MOLDED_WALLPAPER_ITEMS.get(j + add).get()), (int)4).requires((ItemLike)Items.PAPER, 4).requires(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dyes/" + String.valueOf(d))))).requires((ItemLike)slab).unlockedBy(n, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.PAPER})).save(consumer);
        }
    }

    static void woodRecipe(RecipeOutput consumer, Item slab, Item trapdoor, Item fence, Item leaves, WOOD name) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)STEP_STOOLS.get(name.ordinal()).get())).pattern(" w ").pattern("s s").pattern("s s").define(Character.valueOf('w'), (ItemLike)slab).define(Character.valueOf('s'), (ItemLike)Items.STICK).unlockedBy(String.valueOf((Object)name) + "_step_stool", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.STICK})).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)SPICE_RACKS.get(name.ordinal()).get())).pattern("wsw").pattern("b b").define(Character.valueOf('w'), (ItemLike)slab).define(Character.valueOf('s'), (ItemLike)Items.STICK).define(Character.valueOf('b'), (ItemLike)Items.IRON_BARS).unlockedBy(String.valueOf((Object)name) + "_spice_rack", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{slab})).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)SPICE_RACKS_FULL.get(name.ordinal()).get())).requires((ItemLike)SPICE_RACKS.get(name.ordinal()).get()).requires((ItemLike)Items.GLASS_BOTTLE, 4).unlockedBy(String.valueOf((Object)name) + "_spice_rack_full", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{slab})).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)KNIFE_BLOCKS.get(name.ordinal()).get())).pattern("wkw").define(Character.valueOf('w'), (ItemLike)slab).define(Character.valueOf('k'), CommonTags.TOOLS_KNIFE).unlockedBy(String.valueOf((Object)name) + "_knife_block", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{slab})).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)DRIED_CORN_FENCE.get(name.ordinal()).get())).requires((ItemLike)fence).requires((ItemLike)ExtraDelightItems.DRIED_CORN_HUSK.get()).unlockedBy(String.valueOf((Object)name) + "_dried_corn_fence", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{fence})).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)fence).requires((ItemLike)DRIED_CORN_FENCE.get(name.ordinal()).get()).unlockedBy(String.valueOf((Object)name) + "_dried_corn_fence_back", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)DRIED_CORN_FENCE.get(name.ordinal()).get()})).save(consumer, Recipes.EDLoc(String.valueOf((Object)name) + "_dried_corn_fence_back"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)WREATHS.get(name.ordinal()).get())).pattern(" l ").pattern("l l").pattern(" l ").define(Character.valueOf('l'), (ItemLike)leaves).unlockedBy(String.valueOf((Object)name) + "_wreath", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{leaves})).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)FOOD_DISPLAY.get(name.ordinal()).get())).pattern(" s ").pattern(" S ").pattern(" s ").define(Character.valueOf('s'), (ItemLike)Items.STICK).define(Character.valueOf('S'), (ItemLike)slab).unlockedBy(String.valueOf((Object)name) + "_food_display", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{slab})).save(consumer);
    }

    static void woodRecipe(RecipeOutput consumer, Item slab, Item trapdoor, Item fence, WOOD name) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)STEP_STOOLS.get(name.ordinal()).get())).pattern(" w ").pattern("s s").pattern("s s").define(Character.valueOf('w'), (ItemLike)slab).define(Character.valueOf('s'), (ItemLike)Items.STICK).unlockedBy(String.valueOf((Object)name) + "_step_stool", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.STICK})).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)SPICE_RACKS.get(name.ordinal()).get())).pattern("wsw").pattern("b b").define(Character.valueOf('w'), (ItemLike)slab).define(Character.valueOf('s'), (ItemLike)Items.STICK).define(Character.valueOf('b'), (ItemLike)Items.IRON_BARS).unlockedBy(String.valueOf((Object)name) + "_spice_rack", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{slab})).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)SPICE_RACKS_FULL.get(name.ordinal()).get())).requires((ItemLike)SPICE_RACKS.get(name.ordinal()).get()).requires((ItemLike)Items.GLASS_BOTTLE, 4).unlockedBy(String.valueOf((Object)name) + "_spice_rack_full", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{slab})).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)KNIFE_BLOCKS.get(name.ordinal()).get())).pattern("wkw").define(Character.valueOf('w'), (ItemLike)slab).define(Character.valueOf('k'), CommonTags.TOOLS_KNIFE).unlockedBy(String.valueOf((Object)name) + "_knife_block", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{slab})).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)DRIED_CORN_FENCE.get(name.ordinal()).get())).requires((ItemLike)fence).requires((ItemLike)ExtraDelightItems.DRIED_CORN_HUSK.get()).unlockedBy(String.valueOf((Object)name) + "_dried_corn_fence", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{fence})).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)fence).requires((ItemLike)DRIED_CORN_FENCE.get(name.ordinal()).get()).unlockedBy(String.valueOf((Object)name) + "_dried_corn_fence_back", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)DRIED_CORN_FENCE.get(name.ordinal()).get()})).save(consumer, Recipes.EDLoc(String.valueOf((Object)name) + "_dried_corn_fence_back"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)FOOD_DISPLAY.get(name.ordinal()).get())).pattern(" s ").pattern(" S ").pattern(" s ").define(Character.valueOf('s'), (ItemLike)Items.STICK).define(Character.valueOf('S'), (ItemLike)slab).unlockedBy(String.valueOf((Object)name) + "_food_display", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{slab})).save(consumer);
    }

    static void leafRecipe(RecipeOutput consumer, Item leaves, EXTRA_LEAVES name) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)WREATHS.get(WOOD.values().length + name.ordinal() - 2).get())).pattern(" l ").pattern("l l").pattern(" l ").define(Character.valueOf('l'), (ItemLike)leaves).unlockedBy(String.valueOf((Object)name) + "_wreath", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{leaves})).save(consumer);
    }

    static void cabinetRecipes(RecipeOutput consumer) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)COUNTER_CABINETS.get(WOOD.mangrove.ordinal()).get())).requires((ItemLike)ModItems.MANGROVE_CABINET.get()).unlockedBy("mangrove_half_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.MANGROVE_CABINET.get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.mangrove) + "_cabinet_full_to_counter");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModItems.MANGROVE_CABINET.get())).requires((ItemLike)CABINETS.get(WOOD.mangrove.ordinal()).get()).unlockedBy("mangrove_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.mangrove.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.mangrove) + "_cabinet_half_to_full");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)CABINETS.get(WOOD.mangrove.ordinal()).get())).requires((ItemLike)COUNTER_CABINETS.get(WOOD.mangrove.ordinal()).get()).unlockedBy("mangrove_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.mangrove.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.mangrove) + "_cabinet_counter_to_half");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)SINKS.get(WOOD.mangrove.ordinal()).get())).requires((ItemLike)ModItems.MANGROVE_CABINET.get()).requires((ItemLike)ExtraDelightItems.TAP.get()).unlockedBy("mangrove_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.mangrove.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.mangrove) + "_cabinet_to_sink");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)COUNTER_CABINETS.get(WOOD.crimson.ordinal()).get())).requires((ItemLike)ModItems.CRIMSON_CABINET.get()).unlockedBy("crimson_half_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CRIMSON_CABINET.get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.crimson) + "_cabinet_full_to_counter");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModItems.CRIMSON_CABINET.get())).requires((ItemLike)CABINETS.get(WOOD.crimson.ordinal()).get()).unlockedBy("crimson_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.crimson.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.crimson) + "_cabinet_half_to_full");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)CABINETS.get(WOOD.crimson.ordinal()).get())).requires((ItemLike)COUNTER_CABINETS.get(WOOD.crimson.ordinal()).get()).unlockedBy("crimson_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.crimson.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.crimson) + "_cabinet_counter_to_half");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)SINKS.get(WOOD.crimson.ordinal()).get())).requires((ItemLike)ModItems.CRIMSON_CABINET.get()).requires((ItemLike)ExtraDelightItems.TAP.get()).unlockedBy("crimson_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.crimson.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.crimson) + "_cabinet_to_sink");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)COUNTER_CABINETS.get(WOOD.warped.ordinal()).get())).requires((ItemLike)ModItems.WARPED_CABINET.get()).unlockedBy("warped_half_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WARPED_CABINET.get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.warped) + "_cabinet_full_to_counter");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModItems.WARPED_CABINET.get())).requires((ItemLike)CABINETS.get(WOOD.warped.ordinal()).get()).unlockedBy("warped_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.warped.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.warped) + "_cabinet_half_to_full");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)CABINETS.get(WOOD.warped.ordinal()).get())).requires((ItemLike)COUNTER_CABINETS.get(WOOD.warped.ordinal()).get()).unlockedBy("warped_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.warped.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.warped) + "_cabinet_counter_to_half");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)SINKS.get(WOOD.warped.ordinal()).get())).requires((ItemLike)ModItems.WARPED_CABINET.get()).requires((ItemLike)ExtraDelightItems.TAP.get()).unlockedBy("warped_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.warped.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.warped) + "_cabinet_to_sink");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)COUNTER_CABINETS.get(WOOD.acacia.ordinal()).get())).requires((ItemLike)ModItems.ACACIA_CABINET.get()).unlockedBy("acacia_half_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ACACIA_CABINET.get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.acacia) + "_cabinet_full_to_counter");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModItems.ACACIA_CABINET.get())).requires((ItemLike)CABINETS.get(WOOD.acacia.ordinal()).get()).unlockedBy("acacia_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.acacia.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.acacia) + "_cabinet_half_to_full");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)CABINETS.get(WOOD.acacia.ordinal()).get())).requires((ItemLike)COUNTER_CABINETS.get(WOOD.acacia.ordinal()).get()).unlockedBy("acacia_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.acacia.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.acacia) + "_cabinet_counter_to_half");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)SINKS.get(WOOD.acacia.ordinal()).get())).requires((ItemLike)ModItems.ACACIA_CABINET.get()).requires((ItemLike)ExtraDelightItems.TAP.get()).unlockedBy("acacia_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.acacia.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.acacia) + "_cabinet_to_sink");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)COUNTER_CABINETS.get(WOOD.oak.ordinal()).get())).requires((ItemLike)ModItems.OAK_CABINET.get()).unlockedBy("oak_half_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.OAK_CABINET.get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.oak) + "_cabinet_full_to_counter");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModItems.OAK_CABINET.get())).requires((ItemLike)CABINETS.get(WOOD.oak.ordinal()).get()).unlockedBy("oak_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.oak.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.oak) + "_cabinet_half_to_full");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)CABINETS.get(WOOD.oak.ordinal()).get())).requires((ItemLike)COUNTER_CABINETS.get(WOOD.oak.ordinal()).get()).unlockedBy("oak_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.oak.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.oak) + "_cabinet_counter_to_half");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)SINKS.get(WOOD.oak.ordinal()).get())).requires((ItemLike)ModItems.OAK_CABINET.get()).requires((ItemLike)ExtraDelightItems.TAP.get()).unlockedBy("oak_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.oak.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.oak) + "_cabinet_to_sink");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)COUNTER_CABINETS.get(WOOD.dark_oak.ordinal()).get())).requires((ItemLike)ModItems.DARK_OAK_CABINET.get()).unlockedBy("dark_oak_half_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.DARK_OAK_CABINET.get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.dark_oak) + "_cabinet_full_to_counter");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModItems.DARK_OAK_CABINET.get())).requires((ItemLike)CABINETS.get(WOOD.dark_oak.ordinal()).get()).unlockedBy("dark_oak_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.dark_oak.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.dark_oak) + "_cabinet_half_to_full");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)CABINETS.get(WOOD.dark_oak.ordinal()).get())).requires((ItemLike)COUNTER_CABINETS.get(WOOD.dark_oak.ordinal()).get()).unlockedBy("dark_oak_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.dark_oak.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.dark_oak) + "_cabinet_counter_to_half");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)SINKS.get(WOOD.dark_oak.ordinal()).get())).requires((ItemLike)ModItems.DARK_OAK_CABINET.get()).requires((ItemLike)ExtraDelightItems.TAP.get()).unlockedBy("dark_oak_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.dark_oak.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.dark_oak) + "_cabinet_to_sink");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)COUNTER_CABINETS.get(WOOD.spruce.ordinal()).get())).requires((ItemLike)ModItems.SPRUCE_CABINET.get()).unlockedBy("spruce_half_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SPRUCE_CABINET.get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.spruce) + "_cabinet_full_to_counter");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModItems.SPRUCE_CABINET.get())).requires((ItemLike)CABINETS.get(WOOD.spruce.ordinal()).get()).unlockedBy("spruce_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.spruce.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.spruce) + "_cabinet_half_to_full");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)CABINETS.get(WOOD.spruce.ordinal()).get())).requires((ItemLike)COUNTER_CABINETS.get(WOOD.spruce.ordinal()).get()).unlockedBy("spruce_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.spruce.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.spruce) + "_cabinet_counter_to_half");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)SINKS.get(WOOD.spruce.ordinal()).get())).requires((ItemLike)ModItems.SPRUCE_CABINET.get()).requires((ItemLike)ExtraDelightItems.TAP.get()).unlockedBy("spruce_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.spruce.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.spruce) + "_cabinet_to_sink");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)COUNTER_CABINETS.get(WOOD.birch.ordinal()).get())).requires((ItemLike)ModItems.BIRCH_CABINET.get()).unlockedBy("birch_half_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BIRCH_CABINET.get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.birch) + "_cabinet_full_to_counter");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModItems.BIRCH_CABINET.get())).requires((ItemLike)CABINETS.get(WOOD.birch.ordinal()).get()).unlockedBy("birch_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.birch.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.birch) + "_cabinet_half_to_full");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)CABINETS.get(WOOD.birch.ordinal()).get())).requires((ItemLike)COUNTER_CABINETS.get(WOOD.birch.ordinal()).get()).unlockedBy("birch_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.birch.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.birch) + "_cabinet_counter_to_half");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)SINKS.get(WOOD.birch.ordinal()).get())).requires((ItemLike)ModItems.BIRCH_CABINET.get()).requires((ItemLike)ExtraDelightItems.TAP.get()).unlockedBy("birch_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.birch.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.birch) + "_cabinet_to_sink");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)COUNTER_CABINETS.get(WOOD.jungle.ordinal()).get())).requires((ItemLike)ModItems.JUNGLE_CABINET.get()).unlockedBy("jungle_half_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.JUNGLE_CABINET.get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.jungle) + "_cabinet_full_to_counter");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModItems.JUNGLE_CABINET.get())).requires((ItemLike)CABINETS.get(WOOD.jungle.ordinal()).get()).unlockedBy("jungle_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.jungle.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.jungle) + "_cabinet_half_to_full");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)CABINETS.get(WOOD.jungle.ordinal()).get())).requires((ItemLike)COUNTER_CABINETS.get(WOOD.jungle.ordinal()).get()).unlockedBy("jungle_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.jungle.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.jungle) + "_cabinet_counter_to_half");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)SINKS.get(WOOD.jungle.ordinal()).get())).requires((ItemLike)ModItems.JUNGLE_CABINET.get()).requires((ItemLike)ExtraDelightItems.TAP.get()).unlockedBy("jungle_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.jungle.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.jungle) + "_cabinet_to_sink");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)COUNTER_CABINETS.get(WOOD.cinnamon.ordinal()).get())).requires((ItemLike)ExtraDelightItems.CINNAMON_CABINET.get()).unlockedBy("cinnamon_half_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CINNAMON_CABINET.get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.cinnamon) + "_cabinet_full_to_counter");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ExtraDelightItems.CINNAMON_CABINET.get())).requires((ItemLike)CABINETS.get(WOOD.cinnamon.ordinal()).get()).unlockedBy("cinnamon_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.cinnamon.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.cinnamon) + "_cabinet_half_to_full");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)CABINETS.get(WOOD.cinnamon.ordinal()).get())).requires((ItemLike)COUNTER_CABINETS.get(WOOD.cinnamon.ordinal()).get()).unlockedBy("cinnamon_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.cinnamon.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.cinnamon) + "_cabinet_counter_to_half");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)SINKS.get(WOOD.cinnamon.ordinal()).get())).requires((ItemLike)ExtraDelightItems.CINNAMON_CABINET.get()).requires((ItemLike)ExtraDelightItems.TAP.get()).unlockedBy("cinnamon_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.cinnamon.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.cinnamon) + "_cabinet_to_sink");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)COUNTER_CABINETS.get(WOOD.cherry.ordinal()).get())).requires((ItemLike)ModItems.CHERRY_CABINET.get()).unlockedBy("cherry_half_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CHERRY_CABINET.get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.cherry) + "_cabinet_full_to_counter");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModItems.CHERRY_CABINET.get())).requires((ItemLike)CABINETS.get(WOOD.cherry.ordinal()).get()).unlockedBy("cherry_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.cherry.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.cherry) + "_cabinet_half_to_full");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)CABINETS.get(WOOD.cherry.ordinal()).get())).requires((ItemLike)COUNTER_CABINETS.get(WOOD.cherry.ordinal()).get()).unlockedBy("cherry_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.cherry.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.cherry) + "_cabinet_counter_to_half");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)SINKS.get(WOOD.cherry.ordinal()).get())).requires((ItemLike)ModItems.CHERRY_CABINET.get()).requires((ItemLike)ExtraDelightItems.TAP.get()).unlockedBy("cherry_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.cherry.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.cherry) + "_cabinet_to_sink");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)COUNTER_CABINETS.get(WOOD.bamboo.ordinal()).get())).requires((ItemLike)ModItems.BAMBOO_CABINET.get()).unlockedBy("bamboo_half_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BAMBOO_CABINET.get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.bamboo) + "_cabinet_full_to_counter");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModItems.BAMBOO_CABINET.get())).requires((ItemLike)CABINETS.get(WOOD.bamboo.ordinal()).get()).unlockedBy("bamboo_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.bamboo.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.bamboo) + "_cabinet_half_to_full");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)CABINETS.get(WOOD.bamboo.ordinal()).get())).requires((ItemLike)COUNTER_CABINETS.get(WOOD.bamboo.ordinal()).get()).unlockedBy("bamboo_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.bamboo.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.bamboo) + "_cabinet_counter_to_half");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)SINKS.get(WOOD.bamboo.ordinal()).get())).requires((ItemLike)ModItems.BAMBOO_CABINET.get()).requires((ItemLike)ExtraDelightItems.TAP.get()).unlockedBy("bamboo_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.bamboo.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.bamboo) + "_cabinet_to_sink");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)COUNTER_CABINETS.get(WOOD.fruit.ordinal()).get())).requires((ItemLike)ExtraDelightItems.FRUIT_CABINET.get()).unlockedBy("fruit_half_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.FRUIT_CABINET.get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.fruit) + "_cabinet_full_to_counter");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ExtraDelightItems.FRUIT_CABINET.get())).requires((ItemLike)CABINETS.get(WOOD.fruit.ordinal()).get()).unlockedBy("fruit_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.fruit.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.fruit) + "_cabinet_half_to_full");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)CABINETS.get(WOOD.fruit.ordinal()).get())).requires((ItemLike)COUNTER_CABINETS.get(WOOD.fruit.ordinal()).get()).unlockedBy("fruit_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.fruit.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.fruit) + "_cabinet_counter_to_half");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)SINKS.get(WOOD.fruit.ordinal()).get())).requires((ItemLike)ExtraDelightItems.FRUIT_CABINET.get()).requires((ItemLike)ExtraDelightItems.TAP.get()).unlockedBy("fruit_cabinet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)CABINETS.get(WOOD.fruit.ordinal()).get()})).save(consumer, "extradelight:half_cabinets/" + String.valueOf((Object)WOOD.fruit) + "_cabinet_to_sink");
    }

    public static enum WOOD {
        oak,
        dark_oak,
        spruce,
        birch,
        jungle,
        acacia,
        crimson,
        warped,
        mangrove,
        cinnamon,
        cherry,
        bamboo,
        fruit;

    }

    public static enum EXTRA_LEAVES {
        azalea,
        flowering_azalea,
        hazelnut,
        apple,
        lemon,
        lime,
        orange,
        grapefruit;

    }
}

