/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks;

import com.lance5057.extradelight.ExtraDelightParticles;
import com.lance5057.extradelight.blocks.AbstractFruitLeafBlock;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

public class FruitLeafBlock
extends AbstractFruitLeafBlock {
    private final DeferredItem<Item> fruit;
    private final DeferredBlock<Block> petalLitter;

    public FruitLeafBlock(BlockBehaviour.Properties p_49795_, DeferredItem<Item> fruit) {
        super(p_49795_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(7))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).setValue((Property)STERILE, (Comparable)Boolean.valueOf(false)));
        this.fruit = fruit;
        this.petalLitter = null;
    }

    public FruitLeafBlock(BlockBehaviour.Properties p_49795_, DeferredItem<Item> fruit, DeferredBlock<Block> petalLitter) {
        super(p_49795_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(7))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).setValue((Property)STERILE, (Comparable)Boolean.valueOf(false)));
        this.fruit = fruit;
        this.petalLitter = petalLitter;
    }

    public VoxelShape getBlockSupportShape(BlockState p_54456_, BlockGetter p_54457_, BlockPos p_54458_) {
        return Shapes.empty();
    }

    public boolean isRandomlyTicking(BlockState p_54449_) {
        if (((Boolean)p_54449_.getValue((Property)PERSISTENT)).booleanValue()) {
            return false;
        }
        return (Integer)p_54449_.getValue((Property)DISTANCE) == 7 || (Integer)p_54449_.getValue((Property)AGE) < 3;
    }

    public void randomTick(BlockState p_222563_, ServerLevel p_222564_, BlockPos p_222565_, RandomSource p_222566_) {
        int i;
        if (this.decaying(p_222563_)) {
            FruitLeafBlock.dropResources((BlockState)p_222563_, (Level)p_222564_, (BlockPos)p_222565_);
            p_222564_.removeBlock(p_222565_, false);
        }
        if (!((Boolean)p_222563_.getValue((Property)STERILE)).booleanValue() && p_222566_.nextInt(100) % 1 == 0 && (i = ((Integer)p_222563_.getValue((Property)AGE)).intValue()) < 3 && p_222564_.getRawBrightness(p_222565_.above(), 0) >= 9 && CommonHooks.canCropGrow((Level)p_222564_, (BlockPos)p_222565_, (BlockState)p_222563_, (p_222566_.nextInt(5) == 0 ? 1 : 0) != 0)) {
            BlockPos p;
            if (this.petalLitter != null && (Integer)p_222563_.getValue((Property)AGE) == 2 && (p = this.searchBelow(p_222565_, (Level)p_222564_, 5)) != p_222565_) {
                p_222564_.setBlock(p, ((Block)this.petalLitter.get()).defaultBlockState(), 3);
            }
            BlockState blockstate = (BlockState)p_222563_.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            p_222564_.setBlock(p_222565_, blockstate, 2);
            p_222564_.gameEvent((Holder)GameEvent.BLOCK_CHANGE, p_222565_, GameEvent.Context.of((BlockState)blockstate));
            CommonHooks.fireCropGrowPost((Level)p_222564_, (BlockPos)p_222565_, (BlockState)p_222563_);
        }
    }

    BlockPos searchBelow(BlockPos pos, Level level, int limit) {
        for (int i = 2; i < limit + 2; ++i) {
            BlockPos bp = new BlockPos(pos.getX(), pos.getY() - i, pos.getZ());
            if (!level.getBlockState(bp).isSolid()) continue;
            return bp.above();
        }
        return pos;
    }

    protected boolean decaying(BlockState p_221386_) {
        return (Boolean)p_221386_.getValue((Property)PERSISTENT) == false && (Integer)p_221386_.getValue((Property)DISTANCE) == 7;
    }

    public void tick(BlockState p_221369_, ServerLevel p_221370_, BlockPos p_221371_, RandomSource p_221372_) {
        p_221370_.setBlock(p_221371_, FruitLeafBlock.updateDistance(p_221369_, (LevelAccessor)p_221370_, p_221371_), 3);
    }

    public int getLightBlock(BlockState p_54460_, BlockGetter p_54461_, BlockPos p_54462_) {
        return 1;
    }

    public BlockState updateShape(BlockState p_54440_, Direction p_54441_, BlockState p_54442_, LevelAccessor p_54443_, BlockPos p_54444_, BlockPos p_54445_) {
        int i = FruitLeafBlock.getDistanceAt(p_54442_) + 1;
        if (i != 1 || (Integer)p_54440_.getValue((Property)DISTANCE) != i) {
            p_54443_.scheduleTick(p_54444_, (Block)this, 1);
        }
        return p_54440_;
    }

    private static BlockState updateDistance(BlockState p_54436_, LevelAccessor p_54437_, BlockPos p_54438_) {
        int i = 7;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            blockpos$mutableblockpos.setWithOffset((Vec3i)p_54438_, direction);
            i = Math.min(i, FruitLeafBlock.getDistanceAt(p_54437_.getBlockState((BlockPos)blockpos$mutableblockpos)) + 1);
            if (i == 1) break;
        }
        return (BlockState)p_54436_.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistanceAt(BlockState p_54464_) {
        return FruitLeafBlock.getOptionalDistanceAt(p_54464_).orElse(7);
    }

    public static OptionalInt getOptionalDistanceAt(BlockState p_277868_) {
        if (p_277868_.is(BlockTags.LOGS)) {
            return OptionalInt.of(0);
        }
        return p_277868_.hasProperty((Property)DISTANCE) ? OptionalInt.of((Integer)p_277868_.getValue((Property)DISTANCE)) : OptionalInt.empty();
    }

    public void animateTick(BlockState p_221374_, Level p_221375_, BlockPos p_221376_, RandomSource p_221377_) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!p_221375_.isRainingAt(p_221376_.above()) || p_221377_.nextInt(15) != 1 || (blockstate = p_221375_.getBlockState(blockpos = p_221376_.below())).canOcclude() && blockstate.isFaceSturdy((BlockGetter)p_221375_, blockpos, Direction.UP))) {
            ParticleUtils.spawnParticleBelow((Level)p_221375_, (BlockPos)p_221376_, (RandomSource)p_221377_, (ParticleOptions)ParticleTypes.DRIPPING_WATER);
        }
        if (!(this.petalLitter == null || (Integer)p_221374_.getValue((Property)AGE) != 1 && (Integer)p_221374_.getValue((Property)AGE) != 2 || p_221377_.nextInt(5) != 0 || FruitLeafBlock.isFaceFull((VoxelShape)(blockstate = p_221375_.getBlockState(blockpos = p_221376_.below())).getCollisionShape((BlockGetter)p_221375_, blockpos), (Direction)Direction.UP))) {
            ParticleUtils.spawnParticleBelow((Level)p_221375_, (BlockPos)p_221376_, (RandomSource)p_221377_, (ParticleOptions)((ParticleOptions)ExtraDelightParticles.PETALS.get()));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_54447_) {
        p_54447_.add(new Property[]{DISTANCE, PERSISTENT, AGE, STERILE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_54424_) {
        BlockState blockstate = (BlockState)this.defaultBlockState().setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true));
        return FruitLeafBlock.updateDistance(blockstate, (LevelAccessor)p_54424_.getLevel(), p_54424_.getClickedPos());
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!level.isClientSide && (Integer)state.getValue((Property)AGE) >= 3) {
            ItemStack fruit = new ItemStack((ItemLike)this.fruit.get(), 1);
            player.getInventory().placeItemBackInInventory(fruit);
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 3);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

