/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks;

import com.lance5057.extradelight.blocks.RecipeFeastBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class JellyBlock
extends RecipeFeastBlock {
    protected static final VoxelShape PLATE_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0);
    protected static final VoxelShape PIE_SHAPE = Shapes.joinUnoptimized((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), (BooleanOp)BooleanOp.OR);

    public JellyBlock(BlockBehaviour.Properties properties, Supplier<Item> servingItem, boolean hasLeftovers) {
        super(properties, hasLeftovers, new VoxelShape[0]);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Integer)state.getValue((Property)SERVINGS) == 0 ? PLATE_SHAPE : PIE_SHAPE;
    }

    public void fallOn(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
        if ((Integer)pState.getValue((Property)SERVINGS) != 0) {
            if (pEntity.isSuppressingBounce()) {
                super.fallOn(pLevel, pState, pPos, pEntity, pFallDistance);
                this.bounceUp(pEntity);
                this.squish(pLevel, pPos);
            } else {
                pEntity.causeFallDamage(pFallDistance, 0.0f, pLevel.damageSources().fall());
                this.bounceUp(pEntity);
                this.squish(pLevel, pPos);
            }
        }
    }

    private void squish(Level pLevel, BlockPos pPos) {
        pLevel.playLocalSound((double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ(), SoundEvents.SLIME_BLOCK_FALL, SoundSource.BLOCKS, 1.0f, 0.0f, false);
        pLevel.setBlock(pPos, (BlockState)this.defaultBlockState().setValue((Property)SERVINGS, (Comparable)Integer.valueOf(0)), 1);
    }

    public void updateEntityAfterFallOn(BlockGetter pLevel, Entity pEntity) {
        if (pEntity.isSuppressingBounce()) {
            super.updateEntityAfterFallOn(pLevel, pEntity);
        }
    }

    private void bounceUp(Entity pEntity) {
        Vec3 vec3 = pEntity.getDeltaMovement();
        if (vec3.y < 0.0) {
            double d0 = pEntity instanceof LivingEntity ? 1.0 : 0.8;
            pEntity.setDeltaMovement(vec3.x, -vec3.y * d0, vec3.z);
        }
    }

    public void stepOn(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        double d0;
        if ((Integer)pState.getValue((Property)SERVINGS) == 0 && (d0 = Math.abs(pEntity.getDeltaMovement().y)) < 0.1 && !pEntity.isSteppingCarefully()) {
            double d1 = 0.4 + d0 * 0.2;
            pEntity.setDeltaMovement(pEntity.getDeltaMovement().multiply(d1, 1.0, d1));
        }
        super.stepOn(pLevel, pPos, pState, pEntity);
    }
}

