/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks;

import com.lance5057.extradelight.blocks.entities.TapBlockEntity;
import com.lance5057.extradelight.util.BlockEntityUtils;
import com.lance5057.extradelight.util.BottleFluidRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class TapBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty GROUND = BlockStateProperties.DOWN;
    private static final VoxelShape EAST_DOWN_SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0), (VoxelShape)Block.box((double)4.0, (double)6.0, (double)6.0, (double)8.0, (double)10.0, (double)10.0));
    private static final VoxelShape NORTH_DOWN_SHAPE = Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)12.0, (double)10.0, (double)10.0, (double)16.0), (VoxelShape)Block.box((double)6.0, (double)6.0, (double)8.0, (double)10.0, (double)10.0, (double)12.0));
    private static final VoxelShape SOUTH_DOWN_SHAPE = Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0), (VoxelShape)Block.box((double)6.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0, (double)8.0));
    private static final VoxelShape WEST_DOWN_SHAPE = Shapes.or((VoxelShape)Block.box((double)12.0, (double)0.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0), (VoxelShape)Block.box((double)8.0, (double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0));
    private static final VoxelShape EAST_SHAPE = Block.box((double)0.0, (double)6.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0);
    private static final VoxelShape NORTH_SHAPE = Block.box((double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape SOUTH_SHAPE = Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0);
    private static final VoxelShape WEST_SHAPE = Block.box((double)12.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);

    public TapBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)GROUND, (Comparable)Boolean.valueOf(true)));
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new TapBlockEntity(pPos, pState);
    }

    public VoxelShape getShape(BlockState p_54105_, BlockGetter p_54106_, BlockPos p_54107_, CollisionContext p_54108_) {
        if (((Boolean)p_54105_.getValue((Property)GROUND)).booleanValue()) {
            switch ((Direction)p_54105_.getValue((Property)FACING)) {
                case NORTH: {
                    return NORTH_DOWN_SHAPE;
                }
                case SOUTH: {
                    return SOUTH_DOWN_SHAPE;
                }
                case WEST: {
                    return WEST_DOWN_SHAPE;
                }
            }
            return EAST_DOWN_SHAPE;
        }
        switch ((Direction)p_54105_.getValue((Property)FACING)) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return EAST_SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_54041_) {
        if (p_54041_.getClickedFace().getOpposite() == Direction.DOWN) {
            Direction direction = p_54041_.getHorizontalDirection().getOpposite();
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)GROUND, (Comparable)Boolean.valueOf(true));
        }
        Direction direction = p_54041_.getClickedFace();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)GROUND, (Comparable)Boolean.valueOf(false));
    }

    public RenderShape getRenderShape(BlockState p_54103_) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState p_54094_, Rotation p_54095_) {
        return (BlockState)p_54094_.setValue((Property)FACING, (Comparable)p_54095_.rotate((Direction)p_54094_.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState p_54091_, Mirror p_54092_) {
        return p_54091_.rotate(p_54092_.getRotation((Direction)p_54091_.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_54097_) {
        p_54097_.add(new Property[]{FACING, GROUND});
    }

    public boolean isPathfindable(BlockState p_54057_, PathComputationType p_54060_) {
        return false;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity tileEntity = pLevel.getBlockEntity(pPos);
        if (tileEntity instanceof TapBlockEntity) {
            TapBlockEntity be = (TapBlockEntity)tileEntity;
            if (!pLevel.isClientSide) {
                if (stack.is(Items.GLASS_BOTTLE)) {
                    BlockEntityUtils.Inventory.givePlayerItemStack(BottleFluidRegistry.getBottleFromFluid(new FluidStack(Fluids.WATER.getSource(), 1000)), pPlayer, pLevel, pPos);
                    pPlayer.getItemInHand(pHand).shrink(1);
                } else if (stack.is(Items.POTION)) {
                    BlockEntityUtils.Inventory.givePlayerItemStack(new ItemStack((ItemLike)Items.GLASS_BOTTLE), pPlayer, pLevel, pPos);
                    pPlayer.getItemInHand(pHand).shrink(1);
                } else {
                    IFluidHandlerItem handlerItem = FluidUtil.getFluidHandler((ItemStack)stack).orElse(null);
                    if (handlerItem != null) {
                        FluidStack f = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
                        if (f.isEmpty()) {
                            far = FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)be.getFluidHandler(), (int)Integer.MAX_VALUE, (Player)pPlayer, (boolean)true);
                            if (far.isSuccess()) {
                                stack.shrink(1);
                                pPlayer.setItemInHand(pHand, stack);
                                pPlayer.getInventory().placeItemBackInInventory(far.getResult());
                            }
                        } else {
                            far = FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)be.getFluidHandler(), (int)Integer.MAX_VALUE, (Player)pPlayer, (boolean)true);
                            if (far.isSuccess()) {
                                stack.shrink(1);
                                pPlayer.setItemInHand(pHand, stack);
                                pPlayer.getInventory().placeItemBackInInventory(far.getResult());
                            }
                        }
                    }
                }
                Direction dir = ((Direction)pState.getValue((Property)FACING)).getOpposite();
                float x = (float)pPos.getX() + (0.5f + 0.3f * (float)dir.getNormal().getX());
                float z = (float)pPos.getZ() + (0.5f + 0.3f * (float)dir.getNormal().getZ());
                pLevel.addParticle((ParticleOptions)ParticleTypes.DRIPPING_WATER, (double)x, (double)((float)pPos.getY() + 0.25f), (double)z, 0.0, 0.0, 0.0);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

