/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class YeastPotBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    public static final BooleanProperty YEASTED = BooleanProperty.create((String)"yeasted");
    private final int speed;
    final Supplier<Item> output;

    public YeastPotBlock(Supplier<Item> output, int speed) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(0.5f, 1.0f).sound(SoundType.STONE).randomTicks());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)YEASTED, (Comparable)Boolean.valueOf(false)));
        this.speed = speed;
        this.output = output;
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pRandom.nextInt() % this.speed == 0) {
            pLevel.setBlock(pPos, (BlockState)this.defaultBlockState().setValue((Property)YEASTED, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return true;
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        pLevel.scheduleTick(pCurrentPos, (Block)this, 1);
        return pState;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide) {
            if (((Boolean)state.getValue((Property)YEASTED)).booleanValue()) {
                if (player.getItemInHand(hand).getItem() == Items.GLASS_BOTTLE) {
                    player.addItem(new ItemStack((ItemLike)this.output.get()));
                    ItemStack s = player.getItemInHand(hand);
                    s.setCount(s.getCount() - 1);
                    level.destroyBlock(pos, true);
                    return ItemInteractionResult.SUCCESS;
                }
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.getValue((Property)YEASTED)).booleanValue()) {
            double d0 = (double)pPos.getX() + 0.25 + pRandom.nextDouble() / 2.0;
            double d1 = (double)pPos.getY() + 0.4;
            double d2 = (double)pPos.getZ() + 0.25 + pRandom.nextDouble() / 2.0;
            pLevel.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, d0, d1, d2, 0.0, 0.0, 0.0);
            pLevel.playLocalSound(d0, d1, d2, SoundEvents.BUBBLE_COLUMN_BUBBLE_POP, SoundSource.AMBIENT, 0.1f, 0.0f, false);
        }
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{YEASTED});
    }
}

