/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks.chocolatebox;

import com.lance5057.extradelight.ExtraDelightTags;
import com.lance5057.extradelight.blocks.chocolatebox.ChocolateBoxBlockEntity;
import com.lance5057.extradelight.util.BlockEntityUtils;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChocolateBoxBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final ResourceLocation CONTENTS = ResourceLocation.withDefaultNamespace((String)"contents");
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");
    public static final MapCodec<ChocolateBoxBlock> CODEC = ChocolateBoxBlock.simpleCodec(ChocolateBoxBlock::new);
    protected VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)3.0, (double)14.0);
    protected VoxelShape SHAPE2 = Block.box((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)3.0, (double)12.0);
    @Nullable
    private final DyeColor color;

    public ChocolateBoxBlock(BlockBehaviour.Properties p_54120_) {
        super(p_54120_);
        this.SHAPE = Block.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0);
        this.SHAPE2 = Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)8.0, (double)12.0);
        this.color = DyeColor.BLACK;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends ChocolateBoxBlock> codec() {
        return CODEC;
    }

    public ChocolateBoxBlock(@Nullable DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ChocolateBoxBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, OPEN});
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction d = (Direction)pState.getValue((Property)FACING);
        if (d == Direction.EAST || d == Direction.WEST) {
            return this.SHAPE;
        }
        return this.SHAPE2;
    }

    public boolean useShapeForLightOcclusion(BlockState pState) {
        return true;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!level.isClientSide) {
            BlockEntity tileEntity;
            if (player.isCrouching()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)OPEN) == false)), 2);
                return ItemInteractionResult.SUCCESS;
            }
            if (((Boolean)state.getValue((Property)OPEN)).booleanValue() && (tileEntity = level.getBlockEntity(pos)) instanceof ChocolateBoxBlockEntity) {
                ChocolateBoxBlockEntity ent = (ChocolateBoxBlockEntity)tileEntity;
                if (stack.is(ExtraDelightTags.CHOCOLATE_BOX_VALID)) {
                    BlockEntityUtils.Inventory.insertItem(ent.getItems(), stack, 8);
                    return ItemInteractionResult.SUCCESS;
                }
                int slot = BlockEntityUtils.Inventory.getLastFilledSlot(ent.getItems(), 8);
                if (slot != -1) {
                    BlockEntityUtils.Inventory.givePlayerItemStack(ent.getItems().extractItem(slot, 1, false), player, level, pos);
                }
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity tileEntity;
        if (player.isCrouching()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)OPEN) == false)), 2);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue() && (tileEntity = level.getBlockEntity(pos)) instanceof ChocolateBoxBlockEntity) {
            ChocolateBoxBlockEntity ent = (ChocolateBoxBlockEntity)tileEntity;
            int slot = BlockEntityUtils.Inventory.getLastFilledSlot(ent.getItems(), 8);
            if (slot != -1) {
                BlockEntityUtils.Inventory.givePlayerItemStack(ent.getItems().extractItem(slot, 1, false), player, level, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }
}

