/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks.countercabinet;

import com.lance5057.extradelight.ExtraDelightBlockEntities;
import com.lance5057.extradelight.blocks.countercabinet.CounterCabinetBlock;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import vectorwing.farmersdelight.common.registry.ModSounds;

public class CounterCabinetBlockEntity
extends BlockEntity {
    public static final String TAG = "inv";
    private final ItemStackHandler items = this.createHandler();
    private final Lazy<IItemHandler> itemHandler = Lazy.of(() -> this.items);
    public static final int NUM_SLOTS = 28;
    private ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            CounterCabinetBlockEntity.this.playSound(state, (SoundEvent)ModSounds.BLOCK_CABINET_OPEN.get());
            CounterCabinetBlockEntity.this.updateBlockState(state, true);
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            CounterCabinetBlockEntity.this.playSound(state, (SoundEvent)ModSounds.BLOCK_CABINET_CLOSE.get());
            CounterCabinetBlockEntity.this.updateBlockState(state, false);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState sta, int arg1, int arg2) {
        }

        protected boolean isOwnContainer(Player p_155060_) {
            if (p_155060_.containerMenu instanceof ChestMenu) {
                Container container = ((ChestMenu)p_155060_.containerMenu).getContainer();
                return container == CounterCabinetBlockEntity.this;
            }
            return false;
        }
    };

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(this, 28){

            public boolean isItemValid(int slot, ItemStack stack) {
                if (slot == 27) {
                    return stack.getItem() instanceof BlockItem;
                }
                return true;
            }

            public int getSlotLimit(int slot) {
                if (slot == 27) {
                    return 1;
                }
                return 64;
            }
        };
    }

    public CounterCabinetBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ExtraDelightBlockEntities.COUNTER_CABINET_BLOCK.get(), pos, state);
    }

    public IItemHandler getItemHandler() {
        return (IItemHandler)this.itemHandler.get();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        this.writeNBT(nbt, registries);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.readNBT(tag, registries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        this.readNBT(tag, registries);
    }

    void readNBT(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains(TAG)) {
            this.items.deserializeNBT(registries, nbt.getCompound(TAG));
        }
    }

    CompoundTag writeNBT(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put(TAG, (Tag)this.items.serializeNBT(registries));
        return tag;
    }

    public void loadAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.readNBT(nbt, registries);
    }

    public void saveAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.writeNBT(nbt, registries);
    }

    public void startOpen(Player pPlayer) {
        if (this.level != null && !this.remove && !pPlayer.isSpectator()) {
            this.openersCounter.incrementOpeners(pPlayer, this.level, this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player pPlayer) {
        if (this.level != null && !this.remove && !pPlayer.isSpectator()) {
            this.openersCounter.decrementOpeners(pPlayer, this.level, this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (this.level != null && !this.remove) {
            this.openersCounter.recheckOpeners(this.level, this.getBlockPos(), this.getBlockState());
        }
    }

    void updateBlockState(BlockState state, boolean open) {
        if (this.level != null) {
            this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)CounterCabinetBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    private void playSound(BlockState state, SoundEvent sound) {
        if (this.level == null) {
            return;
        }
        Vec3i cabinetFacingVector = ((Direction)state.getValue((Property)CounterCabinetBlock.FACING)).getNormal();
        double x = (double)this.worldPosition.getX() + 0.5 + (double)cabinetFacingVector.getX() / 2.0;
        double y = (double)this.worldPosition.getY() + 0.5 + (double)cabinetFacingVector.getY() / 2.0;
        double z = (double)this.worldPosition.getZ() + 0.5 + (double)cabinetFacingVector.getZ() / 2.0;
        this.level.playSound(null, x, y, z, sound, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
    }

    public String getDisplayName() {
        return "screen.countercabinet.name";
    }
}

