/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks.crops.corn;

import com.lance5057.extradelight.ExtraDelightBlocks;
import com.lance5057.extradelight.ExtraDelightConfig;
import com.lance5057.extradelight.ExtraDelightItems;
import com.lance5057.extradelight.ExtraDelightWorldGen;
import com.lance5057.extradelight.blocks.crops.corn.CornProperties;
import com.lance5057.extradelight.blocks.crops.corn.CornTop;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class CornBottom
extends CropBlock {
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)};

    public CornBottom(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)CornProperties.DIMENSION, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_AGE[(Integer)pState.getValue((Property)this.getAgeProperty())];
    }

    protected boolean mayPlaceOn(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return pState.is(Blocks.FARMLAND);
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    public int getAge(BlockState pState) {
        return (Integer)pState.getValue((Property)this.getAgeProperty());
    }

    public BlockState getStateForAge(int pAge) {
        return (BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(pAge));
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return true;
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        if (pLevel.getRawBrightness(pPos, 0) >= 9) {
            int i = this.getAge(pState);
            float f = CropBlock.getGrowthSpeed((BlockState)pState, (BlockGetter)pLevel, (BlockPos)pPos);
            if (CommonHooks.canCropGrow((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.nextInt((int)(25.0f / f) + 1) == 0 ? 1 : 0) != 0)) {
                this.growCrops((Level)pLevel, pPos, pState);
                CommonHooks.fireCropGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            }
        }
        if (pLevel.dimension() == ExtraDelightWorldGen.CORNFIELD) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)CornProperties.DIMENSION, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public void growCrops(Level pLevel, BlockPos pPos, BlockState pState) {
        int j;
        int i = this.getAge(pState) + this.getBonemealAgeIncrease(pLevel);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        if (i == this.getMaxAge() && !this.checkAboveCorn((BlockGetter)pLevel, pPos) && this.checkAboveAir((BlockGetter)pLevel, pPos)) {
            pLevel.setBlock(pPos.above(), ((CornTop)((Object)ExtraDelightBlocks.CORN_TOP.get())).getStateForAge(0), 3);
        }
        pLevel.setBlock(pPos, this.getStateForAge(i), 3);
    }

    protected int getBonemealAgeIncrease(Level pLevel) {
        return 1;
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        if (pLevel instanceof WorldGenRegion ? pLevel.getBlockState(pPos.below()).getBlock() == Blocks.GRASS_BLOCK : (Boolean)pState.getValue((Property)CornProperties.DIMENSION) != false) {
            return true;
        }
        return (pLevel.getRawBrightness(pPos, 0) >= 8 || pLevel.canSeeSky(pPos)) && super.canSurvive(pState, pLevel, pPos);
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (((Boolean)pState.getValue((Property)CornProperties.DIMENSION)).booleanValue()) {
            if (pEntity.isSprinting()) {
                pEntity.hurt(pEntity.damageSources().sweetBerryBush(), 1.0f);
            }
            pEntity.makeStuckInBlock(pState, new Vec3((double)0.8f, 0.75, (double)0.4f));
        }
        super.entityInside(pState, pLevel, pPos, pEntity);
    }

    private static boolean isHalloween() {
        if (!ExtraDelightConfig.ALL_YEAR.getAsBoolean()) {
            LocalDate localdate = LocalDate.now();
            int i = localdate.get(ChronoField.DAY_OF_MONTH);
            int j = localdate.get(ChronoField.MONTH_OF_YEAR);
            return j == 10 && i >= 1 || j == 11 && i <= 10;
        }
        return true;
    }

    public boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return true;
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)ExtraDelightItems.CORN_SEEDS.get();
    }

    public ItemStack getCloneItemStack(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack(this.getBaseSeedId());
    }

    public boolean isValidBonemealTarget(LevelReader pLevel, BlockPos pPos, BlockState state) {
        boolean b = this.checkAboveCorn((BlockGetter)pLevel, pPos);
        if (b) {
            boolean r = ((CropBlock)this.getAboveCorn((BlockGetter)pLevel, pPos).getBlock()).isValidBonemealTarget(pLevel, pPos.above(), pLevel.getBlockState(pPos.above()));
            return r;
        }
        return this.checkAboveAir((BlockGetter)pLevel, pPos);
    }

    private BlockState getAboveCorn(BlockGetter pLevel, BlockPos pPos) {
        BlockState b = pLevel.getBlockState(pPos.above());
        Block block = b.getBlock();
        if (block instanceof CornTop) {
            CornTop top = (CornTop)block;
            return b;
        }
        return null;
    }

    private boolean checkAboveCorn(BlockGetter pLevel, BlockPos pPos) {
        return pLevel.getBlockState(pPos.above()).getBlock() instanceof CornTop;
    }

    private boolean checkAboveAir(BlockGetter pLevel, BlockPos pPos) {
        return pLevel.getBlockState(pPos.above()).isAir();
    }

    public boolean isBonemealSuccess(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void performBonemeal(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        Block block = pLevel.getBlockState(pPos.above()).getBlock();
        if (block instanceof CornTop) {
            CornTop top = (CornTop)block;
            top.growCrops((Level)pLevel, pPos.above(), pLevel.getBlockState(pPos.above()));
        } else {
            this.growCrops((Level)pLevel, pPos, pState);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{AGE, CornProperties.DIMENSION});
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (this.checkAboveCorn((BlockGetter)level, pos)) {
            return this.getAboveCorn((BlockGetter)level, pos).useWithoutItem(level, player, hitResult);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public static void placeAt(LevelAccessor pLevel, BlockState pState, BlockPos pPos, int pFlags) {
        pLevel.setBlock(pPos.above(), (BlockState)((BlockState)((CornTop)((Object)ExtraDelightBlocks.CORN_TOP.get())).defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(3))).setValue((Property)CornProperties.DIMENSION, (Comparable)Boolean.valueOf(true)), 3);
        pLevel.setBlock(pPos, (BlockState)((BlockState)((CornBottom)((Object)ExtraDelightBlocks.CORN_BOTTOM.get())).defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(3))).setValue((Property)CornProperties.DIMENSION, (Comparable)Boolean.valueOf(true)), 3);
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        BlockPos blockpos = pPos.above();
    }

    public void destroy(LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
        if (((Boolean)pState.getValue((Property)CornProperties.DIMENSION)).booleanValue()) {
            pLevel.setBlock(pPos, pState, 3);
        }
    }
}

