/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks.funnel;

import com.lance5057.extradelight.ExtraDelightBlockEntities;
import com.lance5057.extradelight.blocks.funnel.FunnelBlockEntity;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FunnelBlock
extends BaseEntityBlock {
    public static final MapCodec<FunnelBlock> CODEC = FunnelBlock.simpleCodec(FunnelBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.FACING_HOPPER;
    public static final BooleanProperty ENABLED = BlockStateProperties.ENABLED;
    private static final VoxelShape TOP = Block.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape FUNNEL = Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    private static final VoxelShape CONVEX_BASE = Shapes.or((VoxelShape)FUNNEL, (VoxelShape)TOP);
    private static final VoxelShape INSIDE = FunnelBlock.box((double)2.0, (double)11.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape BASE = Shapes.join((VoxelShape)CONVEX_BASE, (VoxelShape)INSIDE, (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape DOWN_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0));
    private static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)12.0, (double)4.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0));
    private static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)6.0, (double)4.0, (double)0.0, (double)10.0, (double)8.0, (double)4.0));
    private static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)6.0, (double)4.0, (double)12.0, (double)10.0, (double)8.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)0.0, (double)4.0, (double)6.0, (double)4.0, (double)8.0, (double)10.0));
    private static final VoxelShape DOWN_INTERACTION_SHAPE = INSIDE;
    private static final VoxelShape EAST_INTERACTION_SHAPE = Shapes.or((VoxelShape)INSIDE, (VoxelShape)Block.box((double)12.0, (double)8.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));
    private static final VoxelShape NORTH_INTERACTION_SHAPE = Shapes.or((VoxelShape)INSIDE, (VoxelShape)Block.box((double)6.0, (double)8.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0));
    private static final VoxelShape SOUTH_INTERACTION_SHAPE = Shapes.or((VoxelShape)INSIDE, (VoxelShape)Block.box((double)6.0, (double)8.0, (double)12.0, (double)10.0, (double)10.0, (double)16.0));
    private static final VoxelShape WEST_INTERACTION_SHAPE = Shapes.or((VoxelShape)INSIDE, (VoxelShape)Block.box((double)0.0, (double)8.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0));

    public MapCodec<FunnelBlock> codec() {
        return CODEC;
    }

    public FunnelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.DOWN)).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case DOWN: {
                return DOWN_SHAPE;
            }
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
        }
        return BASE;
    }

    protected VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case DOWN: {
                return DOWN_INTERACTION_SHAPE;
            }
            case NORTH: {
                return NORTH_INTERACTION_SHAPE;
            }
            case SOUTH: {
                return SOUTH_INTERACTION_SHAPE;
            }
            case WEST: {
                return WEST_INTERACTION_SHAPE;
            }
            case EAST: {
                return EAST_INTERACTION_SHAPE;
            }
        }
        return INSIDE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace().getOpposite();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)(direction.getAxis() == Direction.Axis.Y ? Direction.DOWN : direction))).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(true));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FunnelBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (!level.isClientSide()) {
            return blockEntityType == ExtraDelightBlockEntities.FUNNEL.get() ? FunnelBlockEntity::tick : null;
        }
        return null;
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.is(state.getBlock())) {
            this.checkPoweredState(level, pos, state);
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.checkPoweredState(level, pos, state);
    }

    private void checkPoweredState(Level level, BlockPos pos, BlockState state) {
        boolean flag;
        boolean bl = flag = !level.hasNeighborSignal(pos);
        if (flag != (Boolean)state.getValue((Property)ENABLED)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)ENABLED, (Comparable)Boolean.valueOf(flag)), 2);
        }
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ENABLED});
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

