/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks.funnel;

import com.lance5057.extradelight.ExtraDelightBlockEntities;
import com.lance5057.extradelight.blocks.funnel.FunnelBlock;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class FunnelBlockEntity
extends BlockEntity {
    private int cooldownTime = -1;
    private long tickedGameTime;
    private final FluidTank fluid = this.createFluidHandler();

    public FluidTank getFluidTank() {
        return this.fluid;
    }

    private FluidTank createFluidHandler() {
        return new FluidTank(1000){

            protected void onContentsChanged() {
                FunnelBlockEntity.this.requestModelDataUpdate();
                FunnelBlockEntity.this.getLevel().sendBlockUpdated(FunnelBlockEntity.this.getBlockPos(), FunnelBlockEntity.this.getBlockState(), FunnelBlockEntity.this.getBlockState(), 11);
                FunnelBlockEntity.this.setChanged();
            }
        };
    }

    public FunnelBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ExtraDelightBlockEntities.FUNNEL.get(), pos, blockState);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T be) {
        if (be instanceof FunnelBlockEntity) {
            FunnelBlockEntity funnel = (FunnelBlockEntity)be;
            if (((Boolean)state.getValue((Property)FunnelBlock.ENABLED)).booleanValue()) {
                if (!funnel.isOnCooldown()) {
                    funnel.setCooldown(8);
                    Direction dir = (Direction)state.getValue((Property)FunnelBlock.FACING);
                    FunnelBlockEntity.pushFluidOut(level, pos, dir, funnel);
                    FunnelBlockEntity.pullFluidIn(level, pos, funnel);
                } else {
                    --funnel.cooldownTime;
                }
            }
        }
    }

    public void setCooldown(int cooldownTime) {
        this.cooldownTime = cooldownTime;
    }

    private boolean isOnCooldown() {
        return this.cooldownTime > 0;
    }

    private static void pullFluidIn(Level level, BlockPos pos, FunnelBlockEntity funnel) {
        BlockState state = level.getBlockState(pos.above());
        Block block = state.getBlock();
        if (funnel.fluid.isEmpty()) {
            if (block instanceof LiquidBlock) {
                LiquidBlock liquid = (LiquidBlock)block;
                funnel.fluid.fill(new FluidStack((Fluid)liquid.fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
                level.setBlock(pos.above(), Blocks.AIR.defaultBlockState(), 3);
            } else {
                Optional holder = FluidUtil.getFluidHandler((Level)level, (BlockPos)pos.above(), (Direction)Direction.UP);
                if (holder.isPresent()) {
                    IFluidHandler handler = (IFluidHandler)holder.get();
                    FluidStack fluid = handler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                    funnel.fluid.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
    }

    private static void pushFluidOut(Level level, BlockPos pos, Direction dir, FunnelBlockEntity funnel) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (!funnel.fluid.isEmpty()) {
            Optional holder = FluidUtil.getFluidHandler((Level)level, (BlockPos)pos.relative(dir), (Direction)dir);
            if (holder.isPresent()) {
                IFluidHandler handler = (IFluidHandler)holder.get();
                int filled = handler.fill(funnel.fluid.getFluid(), IFluidHandler.FluidAction.EXECUTE);
                funnel.fluid.drain(filled, IFluidHandler.FluidAction.EXECUTE);
            } else if (level.getBlockState(pos.relative(dir)).isEmpty() && funnel.fluid.getFluidAmount() >= 1000) {
                FluidUtil.tryPlaceFluid(null, (Level)level, null, (BlockPos)pos.relative(dir), (IFluidHandler)funnel.fluid, (FluidStack)funnel.fluid.getFluid());
            }
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        this.writeNBT(nbt, registries);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.readNBT(tag, registries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        this.readNBT(tag, registries);
    }

    void readNBT(CompoundTag nbt, HolderLookup.Provider registries) {
        this.fluid.readFromNBT(registries, nbt);
        this.cooldownTime = nbt.getInt("TransferCooldown");
    }

    CompoundTag writeNBT(CompoundTag tag, HolderLookup.Provider registries) {
        this.fluid.writeToNBT(registries, tag);
        tag.putInt("TransferCooldown", this.cooldownTime);
        return tag;
    }

    public void loadAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.readNBT(nbt, registries);
    }

    public void saveAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.writeNBT(nbt, registries);
    }
}

