/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks.jar;

import com.lance5057.extradelight.ExtraDelightBlockEntities;
import com.lance5057.extradelight.ExtraDelightComponents;
import com.lance5057.extradelight.util.BlockEntityUtils;
import com.lance5057.extradelight.util.BottleFluidRegistry;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class JarBlockEntity
extends BlockEntity {
    public static final String FLUID_TAG = "fluid";
    private final FluidTank tank = this.createFluidHandler();

    public FluidTank getTank() {
        return this.tank;
    }

    public JarBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ExtraDelightBlockEntities.JAR.get(), p_155229_, p_155230_);
    }

    private FluidTank createFluidHandler() {
        FluidTank tank = new FluidTank(1000){

            protected void onContentsChanged() {
                JarBlockEntity.this.requestModelDataUpdate();
                JarBlockEntity.this.getLevel().sendBlockUpdated(JarBlockEntity.this.getBlockPos(), JarBlockEntity.this.getBlockState(), JarBlockEntity.this.getBlockState(), 3);
                JarBlockEntity.this.setChanged();
            }
        };
        return tank;
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(ExtraDelightComponents.FLUID.get(), (Object)SimpleFluidContent.copyOf((FluidStack)this.tank.getFluid()));
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.tank.setFluid(((SimpleFluidContent)input.getOrDefault(ExtraDelightComponents.FLUID.get(), (Object)SimpleFluidContent.EMPTY)).copy());
    }

    public float getFullness() {
        return (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
    }

    public boolean use(Player player, InteractionHand hand) {
        ItemStack i2;
        ItemStack i = BottleFluidRegistry.getBottleFromFluid(this.getTank().getFluid()).getCraftingRemainingItem().copy();
        if (this.getTank().getFluid().is((Fluid)Fluids.WATER)) {
            i = Items.GLASS_BOTTLE.getDefaultInstance();
        }
        if (ItemStack.isSameItem((ItemStack)(i2 = player.getItemInHand(hand)), (ItemStack)i)) {
            if (!i.isEmpty() && this.getTank().drain(250, IFluidHandler.FluidAction.SIMULATE).getAmount() == 250) {
                this.getTank().drain(250, IFluidHandler.FluidAction.EXECUTE);
                BlockEntityUtils.Inventory.givePlayerItemStack(BottleFluidRegistry.getBottleFromFluid(this.getTank().getFluid()).copy(), player, this.level, this.worldPosition);
                player.getItemInHand(hand).shrink(1);
                return true;
            }
        } else if (!player.getItemInHand(hand).isEmpty()) {
            FluidStack stack = BottleFluidRegistry.getFluidFromBottle(player.getItemInHand(hand));
            if (!stack.isEmpty()) {
                if (this.getTank().fill(stack, IFluidHandler.FluidAction.SIMULATE) == 250) {
                    this.getTank().fill(stack, IFluidHandler.FluidAction.EXECUTE);
                    BlockEntityUtils.Inventory.givePlayerItemStack(player.getItemInHand(hand).getCraftingRemainingItem().copy(), player, this.level, this.worldPosition);
                    if (player.getItemInHand(hand).is(Items.POTION)) {
                        BlockEntityUtils.Inventory.givePlayerItemStack(Items.GLASS_BOTTLE.getDefaultInstance(), player, this.level, this.worldPosition);
                    }
                    player.getItemInHand(hand).shrink(1);
                    return true;
                }
                return false;
            }
            return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.tank);
        }
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.tank);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        this.writeNBT(nbt, registries);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.readNBT(tag, registries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        this.readNBT(tag, registries);
    }

    void readNBT(CompoundTag nbt, HolderLookup.Provider registries) {
        this.tank.readFromNBT(registries, nbt);
    }

    CompoundTag writeNBT(CompoundTag tag, HolderLookup.Provider registries) {
        this.tank.writeToNBT(registries, tag);
        return tag;
    }

    public void loadAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.readNBT(nbt, registries);
    }

    public void saveAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.writeNBT(nbt, registries);
    }
}

