/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks.jardisplay;

import com.lance5057.extradelight.blocks.jardisplay.JarDisplayBlock;
import com.lance5057.extradelight.blocks.jardisplay.JarDisplayBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import org.joml.Quaternionf;

public class JarDisplayRenderer
implements BlockEntityRenderer<JarDisplayBlockEntity> {
    public JarDisplayRenderer(BlockEntityRendererProvider.Context cxt) {
    }

    public void render(JarDisplayBlockEntity pBlockEntity, float partialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        if (!pBlockEntity.hasLevel()) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        IItemHandler itemInteractionHandler = pBlockEntity.getItems();
        Direction dir = (Direction)pBlockEntity.getBlockState().getValue((Property)JarDisplayBlock.FACING);
        pPoseStack.pushPose();
        float xoff = 0.0f;
        float yoff = 0.0f;
        float zoff = 0.0f;
        for (int i = 0; i < 4; ++i) {
            ItemStack item = itemInteractionHandler.getStackInSlot(i);
            if (item.isEmpty()) continue;
            pPoseStack.pushPose();
            BakedModel bakedmodel = itemRenderer.getModel(item, pBlockEntity.getLevel(), null, 0).applyTransform(ItemDisplayContext.NONE, pPoseStack, false);
            pPoseStack.translate(0.5f, 0.5f, 0.5f);
            pPoseStack.mulPose(new Quaternionf().rotateXYZ(0.0f, (float)Math.toRadians(-dir.toYRot()), 0.0f));
            pPoseStack.translate((double)xoff + 0.25, (double)yoff - 0.25, (double)zoff + 0.25);
            if (i == 3) {
                pPoseStack.translate(-0.5, 0.0, -0.5);
            }
            if (i == 1) {
                pPoseStack.translate(-0.5, 0.0, 0.0);
            }
            if (i == 2) {
                pPoseStack.translate(0.0, 0.0, -0.5);
            }
            float uniscale = 1.0f;
            pPoseStack.scale(uniscale, uniscale, uniscale);
            itemRenderer.render(item, ItemDisplayContext.GROUND, false, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, bakedmodel);
            pPoseStack.popPose();
        }
        pPoseStack.popPose();
    }
}

