/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks.picnicbasket;

import com.lance5057.extradelight.blocks.picnicbasket.PicnicBasketBlockEntity;
import com.lance5057.extradelight.blocks.picnicbasket.PicnicBasketMenu;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PicnicBasketBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final ResourceLocation CONTENTS = ResourceLocation.withDefaultNamespace((String)"contents");
    public static final MapCodec<PicnicBasketBlock> CODEC = PicnicBasketBlock.simpleCodec(PicnicBasketBlock::new);
    protected VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)5.0, (double)13.0);
    protected VoxelShape SHAPE2 = Block.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)5.0, (double)15.0);
    @Nullable
    private final DyeColor color;

    public PicnicBasketBlock(BlockBehaviour.Properties p_54120_) {
        super(p_54120_);
        this.SHAPE = Block.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0);
        this.SHAPE2 = Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)8.0, (double)12.0);
        this.color = DyeColor.BLACK;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends PicnicBasketBlock> codec() {
        return CODEC;
    }

    public PicnicBasketBlock(@Nullable DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PicnicBasketBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction d = (Direction)pState.getValue((Property)FACING);
        if (d == Direction.EAST || d == Direction.WEST) {
            return this.SHAPE;
        }
        return this.SHAPE2;
    }

    public boolean useShapeForLightOcclusion(BlockState pState) {
        return true;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity tileEntity;
        if (!level.isClientSide && (tileEntity = level.getBlockEntity(pos)) instanceof PicnicBasketBlockEntity) {
            final PicnicBasketBlockEntity be = (PicnicBasketBlockEntity)tileEntity;
            MenuProvider containerProvider = new MenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)be.getDisplayName());
                }

                public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                    return new PicnicBasketMenu(windowId, playerInventory, be);
                }
            };
            player.openMenu(containerProvider, buf -> buf.writeBlockPos(pos));
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }
}

