/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.blocks.picnicbasket;

import com.lance5057.extradelight.ExtraDelightBlockEntities;
import com.lance5057.extradelight.blocks.picnicbasket.PicnicBasketItemStackHandler;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;

public class PicnicBasketBlockEntity
extends BlockEntity {
    public static final String TAG = "inv";
    private final PicnicBasketItemStackHandler items = this.createHandler();
    private final Lazy<IItemHandler> itemHandler = Lazy.of(() -> this.items);
    public static final int NUM_SLOTS = 12;

    public PicnicBasketBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ExtraDelightBlockEntities.PICNIC_BASKET.get(), pos, blockState);
    }

    private PicnicBasketItemStackHandler createHandler() {
        return new PicnicBasketItemStackHandler(12);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.items.getStacks()));
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        ((ItemContainerContents)input.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.items.getStacks());
    }

    public IItemHandler getItems() {
        return (IItemHandler)this.itemHandler.get();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        this.writeNBT(nbt, registries);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.readNBT(tag, registries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        if (tag != null) {
            this.readNBT(tag, registries);
        }
    }

    void readNBT(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains(TAG)) {
            this.items.deserializeNBT(registries, nbt.getCompound(TAG));
        }
    }

    CompoundTag writeNBT(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put(TAG, (Tag)this.items.serializeNBT(registries));
        return tag;
    }

    public void loadAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.readNBT(nbt, registries);
    }

    public void saveAdditional(@Nonnull CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.writeNBT(nbt, registries);
    }

    public String getDisplayName() {
        return "screen.picnic_basket.name";
    }
}

