/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.data;

import it.unimi.dsi.fastutil.booleans.Boolean2ObjectFunction;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.StructureModifier;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

public abstract class BaseDatapackRegistryProvider
extends DatapackBuiltinEntriesProvider {
    private final String modid;

    protected BaseDatapackRegistryProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, RegistrySetBuilder registrySetBuilder, String modid) {
        super(output, registries, registrySetBuilder, Set.of(modid));
        this.modid = modid;
    }

    @NotNull
    public String getName() {
        return "Datapack registries: " + this.modid;
    }

    protected static void registerPlacedFeature(BootstrapContext<PlacedFeature> context, ResourceLocation name, Boolean2ObjectFunction<List<PlacementModifier>> placementModifiers) {
        BaseDatapackRegistryProvider.registerPlacedFeature(context, name, name, placementModifiers);
    }

    protected static void registerPlacedFeature(BootstrapContext<PlacedFeature> context, ResourceLocation name, ResourceLocation retrogenName, Boolean2ObjectFunction<List<PlacementModifier>> placementModifiers) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference configuredFeature = configuredFeatures.getOrThrow(BaseDatapackRegistryProvider.configuredFeature(name));
        context.register(BaseDatapackRegistryProvider.placedFeature(name), (Object)new PlacedFeature((Holder)configuredFeature, (List)placementModifiers.get(false)));
        Holder.Reference retrogenConfiguredFeature = configuredFeatures.getOrThrow(BaseDatapackRegistryProvider.configuredFeature(retrogenName));
        context.register(BaseDatapackRegistryProvider.placedFeature(name.withSuffix("_retrogen")), (Object)new PlacedFeature((Holder)retrogenConfiguredFeature, (List)placementModifiers.get(true)));
    }

    protected static ResourceKey<ConfiguredFeature<?, ?>> configuredFeature(ResourceLocation name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)name);
    }

    protected static ResourceKey<PlacedFeature> placedFeature(ResourceLocation name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)name);
    }

    protected static ResourceKey<BiomeModifier> biomeModifier(ResourceLocation name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)name);
    }

    protected static ResourceKey<StructureModifier> structureModifier(ResourceLocation name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.STRUCTURE_MODIFIERS, (ResourceLocation)name);
    }
}

