/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.data;

import com.lance5057.extradelight.ExtraDelightComponents;
import com.lance5057.extradelight.ExtraDelightFluids;
import com.lance5057.extradelight.ExtraDelightItems;
import com.lance5057.extradelight.ExtraDelightTags;
import com.lance5057.extradelight.aesthetics.AestheticBlocks;
import com.lance5057.extradelight.data.recipebuilders.ChillerRecipeBuilder;
import com.lance5057.extradelight.data.recipebuilders.DryingRackRecipeBuilder;
import com.lance5057.extradelight.data.recipebuilders.DynamicJamRecipeBuilder;
import com.lance5057.extradelight.data.recipebuilders.DynamicToastRecipeBuilder;
import com.lance5057.extradelight.data.recipebuilders.FeastRecipeBuilder;
import com.lance5057.extradelight.data.recipebuilders.JuicerRecipeBuilder;
import com.lance5057.extradelight.data.recipebuilders.MeltingPotRecipeBuilder;
import com.lance5057.extradelight.data.recipebuilders.MixingBowlRecipeBuilder;
import com.lance5057.extradelight.data.recipebuilders.MortarRecipeBuilder;
import com.lance5057.extradelight.data.recipebuilders.OvenRecipeBuilder;
import com.lance5057.extradelight.data.recipebuilders.ToolOnBlockBuilder;
import com.lance5057.extradelight.items.dynamicfood.api.DynamicItemComponent;
import com.lance5057.extradelight.modules.Fermentation;
import com.lance5057.extradelight.modules.SummerCitrus;
import com.lance5057.extradelight.recipe.FlourDoughRecipe;
import com.lance5057.extradelight.util.BottleFluidRegistry;
import com.lance5057.extradelight.workstations.doughshaping.recipes.DoughShapingRecipe;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.FalseCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.common.crafting.DifferenceIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.client.recipebook.CookingPotRecipeBookTab;
import vectorwing.farmersdelight.common.crafting.ingredient.ItemAbilityIngredient;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.CommonTags;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.data.builder.CookingPotRecipeBuilder;
import vectorwing.farmersdelight.data.builder.CuttingBoardRecipeBuilder;

public class Recipes
extends RecipeProvider
implements IConditionBuilder {
    public static final Ingredient ALL_JAM_AS_INGREDIENT = CompoundIngredient.of((Ingredient[])new Ingredient[]{DataComponentIngredient.of((boolean)false, ExtraDelightComponents.DYNAMIC_FOOD, (Object)new DynamicItemComponent(List.of("orange")), (ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.DYNAMIC_JAM.get()}), DataComponentIngredient.of((boolean)false, ExtraDelightComponents.DYNAMIC_FOOD, (Object)new DynamicItemComponent(List.of("lime")), (ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.DYNAMIC_JAM.get()}), DataComponentIngredient.of((boolean)false, ExtraDelightComponents.DYNAMIC_FOOD, (Object)new DynamicItemComponent(List.of("lemon")), (ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.DYNAMIC_JAM.get()}), DataComponentIngredient.of((boolean)false, ExtraDelightComponents.DYNAMIC_FOOD, (Object)new DynamicItemComponent(List.of("grapefruit")), (ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.DYNAMIC_JAM.get()}), DataComponentIngredient.of((boolean)false, ExtraDelightComponents.DYNAMIC_FOOD, (Object)new DynamicItemComponent(List.of("sweet_berries")), (ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.DYNAMIC_JAM.get()}), DataComponentIngredient.of((boolean)false, ExtraDelightComponents.DYNAMIC_FOOD, (Object)new DynamicItemComponent(List.of("glow_berries")), (ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.DYNAMIC_JAM.get()}), DataComponentIngredient.of((boolean)false, ExtraDelightComponents.DYNAMIC_FOOD, (Object)new DynamicItemComponent(List.of("apple")), (ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.DYNAMIC_JAM.get()}), DataComponentIngredient.of((boolean)false, ExtraDelightComponents.DYNAMIC_FOOD, (Object)new DynamicItemComponent(List.of("golden_apple")), (ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.DYNAMIC_JAM.get()}), DataComponentIngredient.of((boolean)false, ExtraDelightComponents.DYNAMIC_FOOD, (Object)new DynamicItemComponent(List.of("chorus_fruit")), (ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.DYNAMIC_JAM.get()}), DataComponentIngredient.of((boolean)false, ExtraDelightComponents.DYNAMIC_FOOD, (Object)new DynamicItemComponent(List.of("melon")), (ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.DYNAMIC_JAM.get()}), DataComponentIngredient.of((boolean)false, ExtraDelightComponents.DYNAMIC_FOOD, (Object)new DynamicItemComponent(List.of("carrot")), (ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.DYNAMIC_JAM.get()}), DataComponentIngredient.of((boolean)false, ExtraDelightComponents.DYNAMIC_FOOD, (Object)new DynamicItemComponent(List.of("mint")), (ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.DYNAMIC_JAM.get()})});
    public static final int SMOKER_COOKING = 100;
    public static final int FURNACE_COOKING = 200;
    public static final int FAST_COOKING = 400;
    public static final int CAMPFIRE_COOKING = 600;
    public static final int NORMAL_COOKING = 800;
    public static final int SLOW_COOKING = 1600;
    public static final float SMALL_EXP = 0.35f;
    public static final float MEDIUM_EXP = 1.0f;
    public static final float LARGE_EXP = 2.0f;
    public static final int FAST_GRIND = 2;
    public static final int STANDARD_GRIND = 4;
    public static final int LONG_GRIND = 8;

    public Recipes(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public static ResourceLocation EDLoc(String texture) {
        return ResourceLocation.fromNamespaceAndPath((String)"extradelight", (String)texture);
    }

    public static ResourceLocation CreateLoc(String texture) {
        return ResourceLocation.fromNamespaceAndPath((String)"create", (String)texture);
    }

    public static ResourceLocation FDLoc(String texture) {
        return ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)texture);
    }

    protected void buildRecipes(RecipeOutput consumer) {
        this.mortarRecipes(consumer);
        this.ovenRecipes(consumer);
        this.knifeRecipes(consumer);
        this.potRecipes(consumer);
        this.craftingRecipes(consumer);
        this.mixingbowlRecipes(consumer);
        this.cookingRecipes(consumer);
        this.dryingRackRecipes(consumer);
        this.doughShapeRecipes(consumer);
        this.feastRecipes(consumer);
        this.toolOnBlockRecipes(consumer);
        this.meltingRecipes(consumer);
        this.chillingRecipes(consumer);
        this.vatRecipes(consumer);
        this.evaporatorRecipes(consumer);
        this.juicerRecipes(consumer);
        this.dynamicJamRecipes(consumer);
        this.dynamicToast(consumer);
        SummerCitrus.Recipes(consumer);
        Fermentation.Recipes(consumer);
        AestheticBlocks.Recipes(consumer);
        BottleFluidRegistry.createRecipesForJEI(consumer);
        SpecialRecipeBuilder.special(FlourDoughRecipe::new).save(consumer, "flour_dough");
    }

    private void juicerRecipes(RecipeOutput consumer) {
        JuicerRecipeBuilder.squeeze(Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOW_BERRIES}), new ItemStack((ItemLike)Items.ORANGE_DYE), new FluidStack(ExtraDelightFluids.GLOW_BERRY_JUICE.FLUID, 100), 25).save(consumer, Recipes.EDLoc("glow_berries"));
        JuicerRecipeBuilder.squeeze(Ingredient.of((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES}), new ItemStack((ItemLike)Items.RED_DYE), new FluidStack(ExtraDelightFluids.SWEET_BERRY_JUICE.FLUID, 100), 25).save(consumer, Recipes.EDLoc("sweet_berries"));
        JuicerRecipeBuilder.squeeze(Ingredient.of(ExtraDelightTags.PROCESSED_TOMATO), new ItemStack((ItemLike)Items.RED_DYE), new FluidStack(ExtraDelightFluids.TOMATO_JUICE.FLUID, 250), 25).save(consumer, Recipes.EDLoc("tomato"));
        JuicerRecipeBuilder.squeeze(Ingredient.of(ExtraDelightTags.CACTUS), new ItemStack((ItemLike)Items.GREEN_DYE), new FluidStack(ExtraDelightFluids.CACTUS_JUICE.FLUID, 100), 25).save(consumer, Recipes.EDLoc("cactus"));
        JuicerRecipeBuilder.squeeze(Ingredient.of(ExtraDelightTags.PROCESSED_MELON), new ItemStack((ItemLike)Items.PINK_DYE), new FluidStack(ExtraDelightFluids.MELON_JUICE.FLUID, 100), 25).save(consumer, Recipes.EDLoc("melon"));
        JuicerRecipeBuilder.squeeze(Ingredient.of(ExtraDelightTags.PICKLED), new ItemStack((ItemLike)Items.BONE_MEAL), new FluidStack(ExtraDelightFluids.PICKLE_JUICE.FLUID, 250), 25).save(consumer, Recipes.EDLoc("pickle"));
        JuicerRecipeBuilder.squeeze(Ingredient.of(ExtraDelightTags.PROCESSED_APPLE), new ItemStack((ItemLike)Items.RED_DYE), new FluidStack(ExtraDelightFluids.APPLE_CIDER.FLUID, 250), 25).save(consumer, Recipes.EDLoc("apple"));
    }

    private void evaporatorRecipes(RecipeOutput consumer) {
    }

    private void vatRecipes(RecipeOutput consumer) {
    }

    private void chillingRecipes(RecipeOutput consumer) {
        ChillerRecipeBuilder.chill(ExtraDelightItems.MILK_CHOCOLATE_BAR.toStack(), 400, 0.35f, ExtraDelightItems.BAR_MOLD.toStack(), new FluidStack((Fluid)ExtraDelightFluids.MILK_CHOCOLATE_SYRUP.FLUID.get(), 250)).build(consumer);
        ChillerRecipeBuilder.chill(ExtraDelightItems.DARK_CHOCOLATE_BAR.toStack(), 400, 0.35f, ExtraDelightItems.BAR_MOLD.toStack(), new FluidStack((Fluid)ExtraDelightFluids.DARK_CHOCOLATE_SYRUP.FLUID.get(), 250)).build(consumer);
        ChillerRecipeBuilder.chill(ExtraDelightItems.WHITE_CHOCOLATE_BAR.toStack(), 400, 0.35f, ExtraDelightItems.BAR_MOLD.toStack(), new FluidStack((Fluid)ExtraDelightFluids.WHITE_CHOCOLATE_SYRUP.FLUID.get(), 250)).build(consumer);
        ChillerRecipeBuilder.chill(ExtraDelightItems.BLOOD_CHOCOLATE_BAR.toStack(), 400, 0.35f, ExtraDelightItems.BAR_MOLD.toStack(), new FluidStack((Fluid)ExtraDelightFluids.BLOOD_CHOCOLATE_SYRUP.FLUID.get(), 250)).build(consumer);
        ChillerRecipeBuilder.chill(ExtraDelightItems.BLOOD_CHOCOLATE_FILLED_BAR.toStack(), 400, 0.35f, ExtraDelightItems.BAR_MOLD.toStack(), new FluidStack((Fluid)ExtraDelightFluids.BLOOD_CHOCOLATE_SYRUP.FLUID.get(), 250)).addIngredient(Ingredient.of(ExtraDelightTags.CHOCOLATE_BAR_FILLING)).build(consumer);
        ChillerRecipeBuilder.chill(ExtraDelightItems.DARK_CHOCOLATE_FILLED_BAR.toStack(), 400, 0.35f, ExtraDelightItems.BAR_MOLD.toStack(), new FluidStack((Fluid)ExtraDelightFluids.DARK_CHOCOLATE_SYRUP.FLUID.get(), 250)).addIngredient(Ingredient.of(ExtraDelightTags.CHOCOLATE_BAR_FILLING)).build(consumer);
        ChillerRecipeBuilder.chill(ExtraDelightItems.MILK_CHOCOLATE_FILLED_BAR.toStack(), 400, 0.35f, ExtraDelightItems.BAR_MOLD.toStack(), new FluidStack((Fluid)ExtraDelightFluids.MILK_CHOCOLATE_SYRUP.FLUID.get(), 250)).addIngredient(Ingredient.of(ExtraDelightTags.CHOCOLATE_BAR_FILLING)).build(consumer);
        ChillerRecipeBuilder.chill(ExtraDelightItems.WHITE_CHOCOLATE_FILLED_BAR.toStack(), 400, 0.35f, ExtraDelightItems.BAR_MOLD.toStack(), new FluidStack((Fluid)ExtraDelightFluids.WHITE_CHOCOLATE_SYRUP.FLUID.get(), 250)).addIngredient(Ingredient.of(ExtraDelightTags.CHOCOLATE_BAR_FILLING)).build(consumer);
        ChillerRecipeBuilder.chill(ExtraDelightItems.BLOOD_CHOCOLATE_TRUFFLE.toStack(6), 400, 0.35f, ExtraDelightItems.MUFFIN_TIN.toStack(), new FluidStack((Fluid)ExtraDelightFluids.BLOOD_CHOCOLATE_SYRUP.FLUID.get(), 250)).addIngredient(Ingredient.of(ExtraDelightTags.CHOCOLATE_TRUFFLE_FILLING)).build(consumer);
        ChillerRecipeBuilder.chill(ExtraDelightItems.DARK_CHOCOLATE_TRUFFLE.toStack(6), 400, 0.35f, ExtraDelightItems.MUFFIN_TIN.toStack(), new FluidStack((Fluid)ExtraDelightFluids.DARK_CHOCOLATE_SYRUP.FLUID.get(), 250)).addIngredient(Ingredient.of(ExtraDelightTags.CHOCOLATE_TRUFFLE_FILLING)).build(consumer);
        ChillerRecipeBuilder.chill(ExtraDelightItems.MILK_CHOCOLATE_TRUFFLE.toStack(6), 400, 0.35f, ExtraDelightItems.MUFFIN_TIN.toStack(), new FluidStack((Fluid)ExtraDelightFluids.MILK_CHOCOLATE_SYRUP.FLUID.get(), 250)).addIngredient(Ingredient.of(ExtraDelightTags.CHOCOLATE_TRUFFLE_FILLING)).build(consumer);
        ChillerRecipeBuilder.chill(ExtraDelightItems.WHITE_CHOCOLATE_TRUFFLE.toStack(6), 400, 0.35f, ExtraDelightItems.MUFFIN_TIN.toStack(), new FluidStack((Fluid)ExtraDelightFluids.WHITE_CHOCOLATE_SYRUP.FLUID.get(), 250)).addIngredient(Ingredient.of(ExtraDelightTags.CHOCOLATE_TRUFFLE_FILLING)).build(consumer);
        ChillerRecipeBuilder.chill(ExtraDelightItems.PEANUT_BUTTER_CUP.toStack(6), 400, 0.35f, ExtraDelightItems.MUFFIN_TIN.toStack(), new FluidStack((Fluid)ExtraDelightFluids.MILK_CHOCOLATE_SYRUP.FLUID.get(), 1000)).addIngredient(Ingredient.of(ExtraDelightTags.NUT_BUTTER)).build(consumer, "milk_peanut_butter_cup");
        ChillerRecipeBuilder.chill(ExtraDelightItems.PEANUT_BUTTER_CUP.toStack(6), 400, 0.35f, ExtraDelightItems.MUFFIN_TIN.toStack(), new FluidStack((Fluid)ExtraDelightFluids.DARK_CHOCOLATE_SYRUP.FLUID.get(), 1000)).addIngredient(Ingredient.of(ExtraDelightTags.NUT_BUTTER)).build(consumer, "dark_peanut_butter_cup");
        ChillerRecipeBuilder.chill(ExtraDelightItems.PEANUT_BUTTER_CUP.toStack(6), 400, 0.35f, ExtraDelightItems.MUFFIN_TIN.toStack(), new FluidStack((Fluid)ExtraDelightFluids.WHITE_CHOCOLATE_SYRUP.FLUID.get(), 1000)).addIngredient(Ingredient.of(ExtraDelightTags.NUT_BUTTER)).build(consumer, "white_peanut_butter_cup");
        ChillerRecipeBuilder.chill(ExtraDelightItems.PEANUT_BUTTER_CUP.toStack(6), 400, 0.35f, ExtraDelightItems.MUFFIN_TIN.toStack(), new FluidStack((Fluid)ExtraDelightFluids.BLOOD_CHOCOLATE_SYRUP.FLUID.get(), 1000)).addIngredient(Ingredient.of(ExtraDelightTags.NUT_BUTTER)).build(consumer, "blood_peanut_butter_cup");
        ChillerRecipeBuilder.chill(ExtraDelightItems.MALLOW_CUP.toStack(6), 400, 0.35f, ExtraDelightItems.MUFFIN_TIN.toStack(), new FluidStack((Fluid)ExtraDelightFluids.MILK_CHOCOLATE_SYRUP.FLUID.get(), 1000)).addIngredient(Ingredient.of(ExtraDelightTags.MARSHMALLOW_FLUFF)).build(consumer, "milk_mallow_cup");
        ChillerRecipeBuilder.chill(ExtraDelightItems.MALLOW_CUP.toStack(6), 400, 0.35f, ExtraDelightItems.MUFFIN_TIN.toStack(), new FluidStack((Fluid)ExtraDelightFluids.DARK_CHOCOLATE_SYRUP.FLUID.get(), 1000)).addIngredient(Ingredient.of(ExtraDelightTags.MARSHMALLOW_FLUFF)).build(consumer, "dark_mallow_cup");
        ChillerRecipeBuilder.chill(ExtraDelightItems.MALLOW_CUP.toStack(6), 400, 0.35f, ExtraDelightItems.MUFFIN_TIN.toStack(), new FluidStack((Fluid)ExtraDelightFluids.WHITE_CHOCOLATE_SYRUP.FLUID.get(), 1000)).addIngredient(Ingredient.of(ExtraDelightTags.MARSHMALLOW_FLUFF)).build(consumer, "white_mallow_cup");
        ChillerRecipeBuilder.chill(ExtraDelightItems.MALLOW_CUP.toStack(6), 400, 0.35f, ExtraDelightItems.MUFFIN_TIN.toStack(), new FluidStack((Fluid)ExtraDelightFluids.BLOOD_CHOCOLATE_SYRUP.FLUID.get(), 1000)).addIngredient(Ingredient.of(ExtraDelightTags.MARSHMALLOW_FLUFF)).build(consumer, "blood_mallow_cup");
        ChillerRecipeBuilder.chill(ExtraDelightItems.TOFFEE.toStack(4), 400, 0.35f, ExtraDelightItems.TRAY.toStack(), new FluidStack((Fluid)ExtraDelightFluids.BLOOD_CHOCOLATE_SYRUP.FLUID.get(), 250)).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.SWEETENER).addIngredient(ExtraDelightTags.ROASTED_NUTS).build(consumer, "blood_toffee");
        ChillerRecipeBuilder.chill(ExtraDelightItems.TOFFEE.toStack(4), 400, 0.35f, ExtraDelightItems.TRAY.toStack(), new FluidStack((Fluid)ExtraDelightFluids.MILK_CHOCOLATE_SYRUP.FLUID.get(), 250)).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.SWEETENER).addIngredient(ExtraDelightTags.ROASTED_NUTS).build(consumer, "milk_toffee");
        ChillerRecipeBuilder.chill(ExtraDelightItems.TOFFEE.toStack(4), 400, 0.35f, ExtraDelightItems.TRAY.toStack(), new FluidStack((Fluid)ExtraDelightFluids.DARK_CHOCOLATE_SYRUP.FLUID.get(), 250)).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.SWEETENER).addIngredient(ExtraDelightTags.ROASTED_NUTS).build(consumer, "dark_toffee");
        ChillerRecipeBuilder.chill(ExtraDelightItems.TOFFEE.toStack(4), 400, 0.35f, ExtraDelightItems.TRAY.toStack(), new FluidStack((Fluid)ExtraDelightFluids.WHITE_CHOCOLATE_SYRUP.FLUID.get(), 250)).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.SWEETENER).addIngredient(ExtraDelightTags.ROASTED_NUTS).build(consumer, "white_toffee");
        ChillerRecipeBuilder.chill(ExtraDelightItems.PEPPERMINT_BARK.toStack(4), 400, 0.35f, ExtraDelightItems.TRAY.toStack(), new FluidStack((Fluid)ExtraDelightFluids.WHITE_CHOCOLATE_SYRUP.FLUID.get(), 250)).addIngredient(ExtraDelightTags.COOKING_OIL).addIngredient(ExtraDelightTags.CHOCOLATE_SYRUP).addIngredient(ExtraDelightTags.PEPPERMINT_CANDY).build(consumer, "peppermint_bark");
        ChillerRecipeBuilder.chill(ExtraDelightItems.FUDGE_BLOCK.toStack(1), 400, 0.35f, ExtraDelightItems.TRAY.toStack(), new FluidStack((Fluid)ExtraDelightFluids.WHITE_CHOCOLATE_SYRUP.FLUID.get(), 250), true).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.MARSHMALLOW_FLUFF).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).addIngredient(ExtraDelightTags.SWEETENER).build(consumer, "fudge_white");
        ChillerRecipeBuilder.chill(ExtraDelightItems.FUDGE_BLOCK.toStack(1), 400, 0.35f, ExtraDelightItems.TRAY.toStack(), new FluidStack((Fluid)ExtraDelightFluids.BLOOD_CHOCOLATE_SYRUP.FLUID.get(), 250), true).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.MARSHMALLOW_FLUFF).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).addIngredient(ExtraDelightTags.SWEETENER).build(consumer, "fudge_blood");
        ChillerRecipeBuilder.chill(ExtraDelightItems.FUDGE_BLOCK.toStack(1), 400, 0.35f, ExtraDelightItems.TRAY.toStack(), new FluidStack((Fluid)ExtraDelightFluids.DARK_CHOCOLATE_SYRUP.FLUID.get(), 250), true).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.MARSHMALLOW_FLUFF).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).addIngredient(ExtraDelightTags.SWEETENER).build(consumer, "fudge_dark");
        ChillerRecipeBuilder.chill(ExtraDelightItems.FUDGE_BLOCK.toStack(1), 400, 0.35f, ExtraDelightItems.TRAY.toStack(), new FluidStack((Fluid)ExtraDelightFluids.MILK_CHOCOLATE_SYRUP.FLUID.get(), 250), true).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.MARSHMALLOW_FLUFF).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).addIngredient(ExtraDelightTags.SWEETENER).build(consumer, "fudge_milk");
        ChillerRecipeBuilder.chill(ExtraDelightItems.MARSHMALLOW.toStack(1), 400, 0.35f, ExtraDelightItems.MUFFIN_TIN.toStack(), new FluidStack((Fluid)ExtraDelightFluids.MARSHMALLOW_FLUFF.FLUID.get(), 250)).build(consumer, "fluff_to_marshmallow");
        ChillerRecipeBuilder.chill(ExtraDelightItems.MISSISSIPPI_MUD_PIE.toStack(1), 800, 0.35f, new ItemStack((ItemLike)ModItems.PIE_CRUST.get()), new FluidStack((Fluid)ExtraDelightFluids.WHIPPED_CREAM.FLUID.get(), 250), true).addIngredient((ItemLike)ExtraDelightItems.CHOCOLATE_CUSTARD.get()).addIngredient((ItemLike)ExtraDelightItems.MARSHMALLOW_FLUFF_BOTTLE.get()).addIngredient(ExtraDelightTags.ROASTED_NUTS).addIngredient(ExtraDelightTags.CHOCOLATE_CHIPS).build(consumer, "mississippi_mud_pie");
        ChillerRecipeBuilder.chill(ExtraDelightItems.GRASSHOPPER_PIE.toStack(1), 800, 0.35f, new ItemStack((ItemLike)ModItems.PIE_CRUST.get()), new FluidStack((Fluid)ExtraDelightFluids.WHIPPED_CREAM.FLUID.get(), 250), true).addIngredient((TagKey<Item>)Tags.Items.DYES_LIME).addIngredient(ExtraDelightTags.MINT).addIngredient((ItemLike)ExtraDelightItems.MARSHMALLOW_FLUFF_BOTTLE.get()).addIngredient(ExtraDelightTags.CHOCOLATE_CHIPS).build(consumer, "grasshopper_pie");
        ChillerRecipeBuilder.chill(ExtraDelightItems.MARSHMALLOW_SLICE_FEAST.toStack(1), 800, 0.35f, ExtraDelightItems.SQUARE_PAN.toStack(), new FluidStack((Fluid)ExtraDelightFluids.MARSHMALLOW_FLUFF.FLUID.get(), 250), true).addIngredient(ExtraDelightTags.SUGAR_COOKIE).addIngredient(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of(ExtraDelightTags.JAM), ALL_JAM_AS_INGREDIENT})).addIngredient(ExtraDelightTags.SUGAR_COOKIE).build(consumer, "marshmallow_slice");
        ChillerRecipeBuilder.chill(ExtraDelightItems.ROCKY_ROAD.toStack(4), 800, 0.35f, ExtraDelightItems.TRAY.toStack(), new FluidStack(ExtraDelightFluids.BLOOD_CHOCOLATE_SYRUP.FLUID, 250)).addIngredient(ExtraDelightTags.GUMMIES).addIngredient(ExtraDelightTags.COOKIE).addIngredient(ExtraDelightTags.MARSHMALLOW).addIngredient(ExtraDelightTags.ROASTED_NUTS).build(consumer, "rocky_road_blood");
        ChillerRecipeBuilder.chill(ExtraDelightItems.ROCKY_ROAD.toStack(4), 800, 0.35f, ExtraDelightItems.TRAY.toStack(), new FluidStack(ExtraDelightFluids.DARK_CHOCOLATE_SYRUP.FLUID, 250)).addIngredient(ExtraDelightTags.GUMMIES).addIngredient(ExtraDelightTags.COOKIE).addIngredient(ExtraDelightTags.MARSHMALLOW).addIngredient(ExtraDelightTags.ROASTED_NUTS).build(consumer, "rocky_road_dark");
        ChillerRecipeBuilder.chill(ExtraDelightItems.ROCKY_ROAD.toStack(4), 800, 0.35f, ExtraDelightItems.TRAY.toStack(), new FluidStack(ExtraDelightFluids.MILK_CHOCOLATE_SYRUP.FLUID, 250)).addIngredient(ExtraDelightTags.GUMMIES).addIngredient(ExtraDelightTags.COOKIE).addIngredient(ExtraDelightTags.MARSHMALLOW).addIngredient(ExtraDelightTags.ROASTED_NUTS).build(consumer, "rocky_road_milk");
        ChillerRecipeBuilder.chill(ExtraDelightItems.ROCKY_ROAD.toStack(4), 800, 0.35f, ExtraDelightItems.TRAY.toStack(), new FluidStack(ExtraDelightFluids.WHITE_CHOCOLATE_SYRUP.FLUID, 250)).addIngredient(ExtraDelightTags.GUMMIES).addIngredient(ExtraDelightTags.COOKIE).addIngredient(ExtraDelightTags.MARSHMALLOW).addIngredient(ExtraDelightTags.ROASTED_NUTS).build(consumer, "rocky_road_white");
        ChillerRecipeBuilder.chill(ExtraDelightItems.APPLE_POPSICLE.toStack(4), 800, 0.35f, new ItemStack((ItemLike)Items.STICK, 4), new FluidStack(ExtraDelightFluids.APPLE_CIDER.FLUID, 250), true).build(consumer, "apple_popsicle_chiller");
        ChillerRecipeBuilder.chill(ExtraDelightItems.CARAMEL_POPSICLE.toStack(4), 800, 0.35f, new ItemStack((ItemLike)Items.STICK, 4), new FluidStack(ExtraDelightFluids.CARAMEL_SAUCE.FLUID, 250), true).addIngredient(ExtraDelightTags.ICE_CREAM).build(consumer, "caramel_popsicle_chiller");
        ChillerRecipeBuilder.chill(ExtraDelightItems.CINNAMON_POPSICLE.toStack(4), 800, 0.35f, new ItemStack((ItemLike)Items.STICK, 4), FluidStack.EMPTY, true).addIngredient(ExtraDelightTags.ICE_CREAM).addIngredient(ExtraDelightTags.GROUND_CINNAMON).build(consumer, "cinnamon_popsicle_chiller");
        ChillerRecipeBuilder.chill(ExtraDelightItems.FUDGE_POPSICLE.toStack(4), 800, 0.35f, new ItemStack((ItemLike)Items.STICK, 4), FluidStack.EMPTY, true).addIngredient(ExtraDelightTags.ICE_CREAM).addIngredient(ExtraDelightTags.COCOA_POWDER).build(consumer, "fudge_popsicle_chiller");
        ChillerRecipeBuilder.chill(ExtraDelightItems.GLOW_BERRY_POPSICLE.toStack(4), 800, 0.35f, new ItemStack((ItemLike)Items.STICK, 4), new FluidStack(ExtraDelightFluids.GLOW_BERRY_JUICE.FLUID, 250), true).build(consumer, "glow_berry_popsicle_chiller");
        ChillerRecipeBuilder.chill(ExtraDelightItems.HONEY_POPSICLE.toStack(4), 800, 0.35f, new ItemStack((ItemLike)Items.STICK, 4), FluidStack.EMPTY, true).addIngredient((ItemLike)Items.HONEY_BOTTLE).addIngredient(ExtraDelightTags.ICE_CREAM).build(consumer, "honey_popsicle_chiller");
        ChillerRecipeBuilder.chill(ExtraDelightItems.SWEET_BERRY_POPSICLE.toStack(4), 800, 0.35f, new ItemStack((ItemLike)Items.STICK, 4), new FluidStack(ExtraDelightFluids.SWEET_BERRY_JUICE.FLUID, 250), true).build(consumer, "sweet_berry_popsicle_chiller");
        ChillerRecipeBuilder.chill(new ItemStack((ItemLike)ModItems.MELON_POPSICLE.get(), 4), 800, 0.35f, new ItemStack((ItemLike)Items.STICK, 4), new FluidStack(ExtraDelightFluids.MELON_JUICE.FLUID, 250), true).build(consumer, "melon_popsicle_chiller");
        ChillerRecipeBuilder.chill(ExtraDelightItems.JELLY_BLACK_FEAST_ITEM.toStack(), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250), true).addIngredient((TagKey<Item>)Tags.Items.DYES_BLACK).addIngredient(ExtraDelightTags.GELATIN).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)Items.SWEET_BERRIES).build(consumer, "black_jelly_feast");
        ChillerRecipeBuilder.chill(ExtraDelightItems.JELLY_RED_FEAST_ITEM.toStack(), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250), true).addIngredient((TagKey<Item>)Tags.Items.DYES_RED).addIngredient(ExtraDelightTags.GELATIN).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)Items.SWEET_BERRIES).build(consumer, "red_jelly_feast");
        ChillerRecipeBuilder.chill(ExtraDelightItems.JELLY_GREEN_FEAST_ITEM.toStack(), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250), true).addIngredient((TagKey<Item>)Tags.Items.DYES_GREEN).addIngredient(ExtraDelightTags.GELATIN).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)Items.SWEET_BERRIES).build(consumer, "green_jelly_feast");
        ChillerRecipeBuilder.chill(ExtraDelightItems.JELLY_BROWN_FEAST_ITEM.toStack(), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250), true).addIngredient((TagKey<Item>)Tags.Items.DYES_BROWN).addIngredient(ExtraDelightTags.GELATIN).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)Items.SWEET_BERRIES).build(consumer, "brown_jelly_feast");
        ChillerRecipeBuilder.chill(ExtraDelightItems.JELLY_BLUE_FEAST_ITEM.toStack(), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250), true).addIngredient((TagKey<Item>)Tags.Items.DYES_BLUE).addIngredient(ExtraDelightTags.GELATIN).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)Items.SWEET_BERRIES).build(consumer, "blue_jelly_feast");
        ChillerRecipeBuilder.chill(ExtraDelightItems.JELLY_PURPLE_FEAST_ITEM.toStack(), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250), true).addIngredient((TagKey<Item>)Tags.Items.DYES_PURPLE).addIngredient(ExtraDelightTags.GELATIN).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)Items.SWEET_BERRIES).build(consumer, "purple_jelly_feast");
        ChillerRecipeBuilder.chill(ExtraDelightItems.JELLY_CYAN_FEAST_ITEM.toStack(), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250), true).addIngredient((TagKey<Item>)Tags.Items.DYES_CYAN).addIngredient(ExtraDelightTags.GELATIN).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)Items.SWEET_BERRIES).build(consumer, "cyan_jelly_feast");
        ChillerRecipeBuilder.chill(ExtraDelightItems.JELLY_LIGHT_GREY_FEAST_ITEM.toStack(), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250), true).addIngredient((TagKey<Item>)Tags.Items.DYES_LIGHT_GRAY).addIngredient(ExtraDelightTags.GELATIN).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)Items.SWEET_BERRIES).build(consumer, "light_grey_jelly_feast");
        ChillerRecipeBuilder.chill(ExtraDelightItems.JELLY_GREY_FEAST_ITEM.toStack(), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250), true).addIngredient((TagKey<Item>)Tags.Items.DYES_GRAY).addIngredient(ExtraDelightTags.GELATIN).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)Items.SWEET_BERRIES).build(consumer, "grey_jelly_feast");
        ChillerRecipeBuilder.chill(ExtraDelightItems.JELLY_PINK_FEAST_ITEM.toStack(), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250), true).addIngredient((TagKey<Item>)Tags.Items.DYES_PINK).addIngredient(ExtraDelightTags.GELATIN).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)Items.SWEET_BERRIES).build(consumer, "pink_jelly_feast");
        ChillerRecipeBuilder.chill(ExtraDelightItems.JELLY_LIME_FEAST_ITEM.toStack(), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250), true).addIngredient((TagKey<Item>)Tags.Items.DYES_LIME).addIngredient(ExtraDelightTags.GELATIN).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)Items.SWEET_BERRIES).build(consumer, "lime_jelly_feast");
        ChillerRecipeBuilder.chill(ExtraDelightItems.JELLY_YELLOW_FEAST_ITEM.toStack(), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250), true).addIngredient((TagKey<Item>)Tags.Items.DYES_YELLOW).addIngredient(ExtraDelightTags.GELATIN).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)Items.SWEET_BERRIES).build(consumer, "yellow_jelly_feast");
        ChillerRecipeBuilder.chill(ExtraDelightItems.JELLY_LIGHT_BLUE_FEAST_ITEM.toStack(), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250), true).addIngredient((TagKey<Item>)Tags.Items.DYES_LIGHT_BLUE).addIngredient(ExtraDelightTags.GELATIN).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)Items.SWEET_BERRIES).build(consumer, "light_blue_jelly_feast");
        ChillerRecipeBuilder.chill(ExtraDelightItems.JELLY_MAGENTA_FEAST_ITEM.toStack(), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250), true).addIngredient((TagKey<Item>)Tags.Items.DYES_MAGENTA).addIngredient(ExtraDelightTags.GELATIN).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)Items.SWEET_BERRIES).build(consumer, "magenta_jelly_feast");
        ChillerRecipeBuilder.chill(ExtraDelightItems.JELLY_ORANGE_FEAST_ITEM.toStack(), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250), true).addIngredient((TagKey<Item>)Tags.Items.DYES_ORANGE).addIngredient(ExtraDelightTags.GELATIN).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)Items.SWEET_BERRIES).build(consumer, "orange_jelly_feast");
        ChillerRecipeBuilder.chill(ExtraDelightItems.JELLY_WHITE_FEAST_ITEM.toStack(), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250), true).addIngredient((TagKey<Item>)Tags.Items.DYES_WHITE).addIngredient(ExtraDelightTags.GELATIN).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)Items.SWEET_BERRIES).build(consumer, "white_jelly_feast");
        ChillerRecipeBuilder.chill(new ItemStack((ItemLike)ExtraDelightItems.ICE_CREAM.get(), 1), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack((Holder)NeoForgeMod.MILK, 250), true).addIngredient(ExtraDelightTags.SWEETENER).build(consumer, "ice_cream");
        ChillerRecipeBuilder.chill(new ItemStack((ItemLike)ExtraDelightItems.GLOW_BERRY_ICE_CREAM.get(), 1), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack((Holder)NeoForgeMod.MILK, 250), true).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)Items.GLOW_BERRIES).addIngredient((ItemLike)Items.GLOW_BERRIES).addIngredient((ItemLike)Items.GLOW_BERRIES).build(consumer, "glow_berry_ice_cream");
        ChillerRecipeBuilder.chill(new ItemStack((ItemLike)ExtraDelightItems.CHOCOLATE_ICE_CREAM.get(), 1), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack((Holder)NeoForgeMod.MILK, 250), true).addIngredient(ExtraDelightTags.SWEETENER).addIngredient(ExtraDelightTags.COCOA_POWDER).build(consumer, "chocolate_ice_cream");
        ChillerRecipeBuilder.chill(new ItemStack((ItemLike)ExtraDelightItems.SWEET_BERRY_ICE_CREAM.get(), 1), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack((Holder)NeoForgeMod.MILK, 250), true).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)Items.SWEET_BERRIES).addIngredient((ItemLike)Items.SWEET_BERRIES).addIngredient((ItemLike)Items.SWEET_BERRIES).build(consumer, "sweet_berry_ice_cream");
        ChillerRecipeBuilder.chill(new ItemStack((ItemLike)ExtraDelightItems.PUMPKIN_ICE_CREAM.get(), 1), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack((Holder)NeoForgeMod.MILK, 250), true).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)ModItems.PUMPKIN_SLICE.get()).addIngredient((ItemLike)ModItems.PUMPKIN_SLICE.get()).addIngredient((ItemLike)ModItems.PUMPKIN_SLICE.get()).build(consumer, "pumpkin_ice_cream");
        ChillerRecipeBuilder.chill(new ItemStack((ItemLike)ExtraDelightItems.HONEY_ICE_CREAM.get(), 1), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack((Holder)NeoForgeMod.MILK, 250), true).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)Items.HONEY_BOTTLE).addIngredient((ItemLike)Items.HONEY_BOTTLE).addIngredient((ItemLike)Items.HONEY_BOTTLE).build(consumer, "honey_ice_cream");
        ChillerRecipeBuilder.chill(new ItemStack((ItemLike)ExtraDelightItems.APPLE_ICE_CREAM.get(), 1), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack((Holder)NeoForgeMod.MILK, 250), true).addIngredient(ExtraDelightTags.SWEETENER).addIngredient(ExtraDelightTags.PROCESSED_APPLE).addIngredient(ExtraDelightTags.PROCESSED_APPLE).addIngredient(ExtraDelightTags.PROCESSED_APPLE).build(consumer, "apple_ice_cream");
        ChillerRecipeBuilder.chill(new ItemStack((ItemLike)ExtraDelightItems.COOKIE_DOUGH_ICE_CREAM.get(), 1), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack((Holder)NeoForgeMod.MILK, 250), true).addIngredient(ExtraDelightTags.SWEETENER).addIngredient(ExtraDelightTags.COOKIE_DOUGH).build(consumer, "cookie_dough_ice_cream");
        ChillerRecipeBuilder.chill(new ItemStack((ItemLike)ExtraDelightItems.MINT_CHIP_ICE_CREAM.get(), 1), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack((Holder)NeoForgeMod.MILK, 250), true).addIngredient(ExtraDelightTags.SWEETENER).addIngredient(ExtraDelightTags.CHOCOLATE_CHIPS).addIngredient(ExtraDelightTags.MINT).build(consumer, "mint_chip_ice_cream");
        ChillerRecipeBuilder.chill(new ItemStack((ItemLike)ExtraDelightItems.NUT_BUTTER_ICE_CREAM.get(), 1), 800, 0.35f, new ItemStack((ItemLike)Items.BOWL), new FluidStack((Holder)NeoForgeMod.MILK, 250), true).addIngredient(ExtraDelightTags.SWEETENER).addIngredient(ExtraDelightTags.NUT_BUTTER).build(consumer, "nut_butter_ice_cream");
    }

    private void meltingRecipes(RecipeOutput consumer) {
        MeltingPotRecipeBuilder.melt(Ingredient.of((ItemLike[])new ItemLike[]{Items.ICE}), 400, new FluidStack((Fluid)Fluids.WATER, 1000)).save(consumer, Recipes.EDLoc("ice_to_water"));
        MeltingPotRecipeBuilder.melt(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.BLOOD_CHOCOLATE_BAR}), 400, new FluidStack(ExtraDelightFluids.BLOOD_CHOCOLATE_SYRUP.FLUID, 250)).save(consumer, Recipes.EDLoc("blood_chocolate_bar"));
        MeltingPotRecipeBuilder.melt(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.MILK_CHOCOLATE_BAR}), 400, new FluidStack(ExtraDelightFluids.MILK_CHOCOLATE_SYRUP.FLUID, 250)).save(consumer, Recipes.EDLoc("milk_chocolate_bar"));
        MeltingPotRecipeBuilder.melt(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.DARK_CHOCOLATE_BAR}), 400, new FluidStack(ExtraDelightFluids.DARK_CHOCOLATE_SYRUP.FLUID, 250)).save(consumer, Recipes.EDLoc("dark_chocolate_bar"));
        MeltingPotRecipeBuilder.melt(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.WHITE_CHOCOLATE_BAR}), 400, new FluidStack(ExtraDelightFluids.WHITE_CHOCOLATE_SYRUP.FLUID, 250)).save(consumer, Recipes.EDLoc("white_chocolate_bar"));
        MeltingPotRecipeBuilder.melt(Ingredient.of(ExtraDelightTags.MARSHMALLOW), 400, new FluidStack(ExtraDelightFluids.MARSHMALLOW_FLUFF.FLUID, 250)).save(consumer, Recipes.EDLoc("marshmallow_fluff"));
        MeltingPotRecipeBuilder.melt(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.MARSHMALLOW_BLOCK}), 400, new FluidStack(ExtraDelightFluids.MARSHMALLOW_FLUFF.FLUID, 1000)).save(consumer, Recipes.EDLoc("marshmallow_fluff_block"));
        MeltingPotRecipeBuilder.melt(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.BLOOD_CHOCOLATE_BLOCK}), 400, new FluidStack(ExtraDelightFluids.BLOOD_CHOCOLATE_SYRUP.FLUID, 1000)).save(consumer, Recipes.EDLoc("blood_chocolate_block"));
        MeltingPotRecipeBuilder.melt(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.MILK_CHOCOLATE_BLOCK}), 400, new FluidStack(ExtraDelightFluids.MILK_CHOCOLATE_SYRUP.FLUID, 1000)).save(consumer, Recipes.EDLoc("milk_chocolate_block"));
        MeltingPotRecipeBuilder.melt(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.DARK_CHOCOLATE_BLOCK}), 400, new FluidStack(ExtraDelightFluids.DARK_CHOCOLATE_SYRUP.FLUID, 1000)).save(consumer, Recipes.EDLoc("dark_chocolate_block"));
        MeltingPotRecipeBuilder.melt(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.WHITE_CHOCOLATE_BLOCK}), 400, new FluidStack(ExtraDelightFluids.WHITE_CHOCOLATE_SYRUP.FLUID, 1000)).save(consumer, Recipes.EDLoc("white_chocolate_block"));
    }

    private void toolOnBlockRecipes(RecipeOutput consumer) {
        ToolOnBlockBuilder.make((Item)ExtraDelightItems.GINGERBREAD_COOKIE_BLOCK.get(), Ingredient.of(ExtraDelightTags.FROSTING_WHITE), (Item)ExtraDelightItems.GINGERBREAD_BLOCK_WHITE.get()).unlockedBy("has_frosting", Recipes.has(ExtraDelightTags.FROSTING_WHITE)).save(consumer, Recipes.EDLoc("frost_gingerbread_white"));
        ToolOnBlockBuilder.make((Item)ExtraDelightItems.GINGERBREAD_COOKIE_BLOCK.get(), Ingredient.of(ExtraDelightTags.FROSTING_LIGHT_GRAY), (Item)ExtraDelightItems.GINGERBREAD_BLOCK_LIGHT_GRAY.get()).unlockedBy("has_frosting", Recipes.has(ExtraDelightTags.FROSTING_LIGHT_GRAY)).save(consumer, Recipes.EDLoc("frost_gingerbread_light_gray"));
        ToolOnBlockBuilder.make((Item)ExtraDelightItems.GINGERBREAD_COOKIE_BLOCK.get(), Ingredient.of(ExtraDelightTags.FROSTING_GRAY), (Item)ExtraDelightItems.GINGERBREAD_BLOCK_GRAY.get()).unlockedBy("has_frosting", Recipes.has(ExtraDelightTags.FROSTING_GRAY)).save(consumer, Recipes.EDLoc("frost_gingerbread_gray"));
        ToolOnBlockBuilder.make((Item)ExtraDelightItems.GINGERBREAD_COOKIE_BLOCK.get(), Ingredient.of(ExtraDelightTags.FROSTING_BROWN), (Item)ExtraDelightItems.GINGERBREAD_BLOCK_BROWN.get()).unlockedBy("has_frosting", Recipes.has(ExtraDelightTags.FROSTING_BROWN)).save(consumer, Recipes.EDLoc("frost_gingerbread_brown"));
        ToolOnBlockBuilder.make((Item)ExtraDelightItems.GINGERBREAD_COOKIE_BLOCK.get(), Ingredient.of(ExtraDelightTags.FROSTING_RED), (Item)ExtraDelightItems.GINGERBREAD_BLOCK_RED.get()).unlockedBy("has_frosting", Recipes.has(ExtraDelightTags.FROSTING_RED)).save(consumer, Recipes.EDLoc("frost_gingerbread_red"));
        ToolOnBlockBuilder.make((Item)ExtraDelightItems.GINGERBREAD_COOKIE_BLOCK.get(), Ingredient.of(ExtraDelightTags.FROSTING_ORANGE), (Item)ExtraDelightItems.GINGERBREAD_BLOCK_ORANGE.get()).unlockedBy("has_frosting", Recipes.has(ExtraDelightTags.FROSTING_ORANGE)).save(consumer, Recipes.EDLoc("frost_gingerbread_orange"));
        ToolOnBlockBuilder.make((Item)ExtraDelightItems.GINGERBREAD_COOKIE_BLOCK.get(), Ingredient.of(ExtraDelightTags.FROSTING_YELLOW), (Item)ExtraDelightItems.GINGERBREAD_BLOCK_YELLOW.get()).unlockedBy("has_frosting", Recipes.has(ExtraDelightTags.FROSTING_YELLOW)).save(consumer, Recipes.EDLoc("frost_gingerbread_yellow"));
        ToolOnBlockBuilder.make((Item)ExtraDelightItems.GINGERBREAD_COOKIE_BLOCK.get(), Ingredient.of(ExtraDelightTags.FROSTING_LIME), (Item)ExtraDelightItems.GINGERBREAD_BLOCK_LIME.get()).unlockedBy("has_frosting", Recipes.has(ExtraDelightTags.FROSTING_LIME)).save(consumer, Recipes.EDLoc("frost_gingerbread_lime"));
        ToolOnBlockBuilder.make((Item)ExtraDelightItems.GINGERBREAD_COOKIE_BLOCK.get(), Ingredient.of(ExtraDelightTags.FROSTING_GREEN), (Item)ExtraDelightItems.GINGERBREAD_BLOCK_GREEN.get()).unlockedBy("has_frosting", Recipes.has(ExtraDelightTags.FROSTING_GREEN)).save(consumer, Recipes.EDLoc("frost_gingerbread_green"));
        ToolOnBlockBuilder.make((Item)ExtraDelightItems.GINGERBREAD_COOKIE_BLOCK.get(), Ingredient.of(ExtraDelightTags.FROSTING_CYAN), (Item)ExtraDelightItems.GINGERBREAD_BLOCK_CYAN.get()).unlockedBy("has_frosting", Recipes.has(ExtraDelightTags.FROSTING_CYAN)).save(consumer, Recipes.EDLoc("frost_gingerbread_cyan"));
        ToolOnBlockBuilder.make((Item)ExtraDelightItems.GINGERBREAD_COOKIE_BLOCK.get(), Ingredient.of(ExtraDelightTags.FROSTING_LIGHT_BLUE), (Item)ExtraDelightItems.GINGERBREAD_BLOCK_LIGHT_BLUE.get()).unlockedBy("has_frosting", Recipes.has(ExtraDelightTags.FROSTING_LIGHT_BLUE)).save(consumer, Recipes.EDLoc("frost_gingerbread_light_blue"));
        ToolOnBlockBuilder.make((Item)ExtraDelightItems.GINGERBREAD_COOKIE_BLOCK.get(), Ingredient.of(ExtraDelightTags.FROSTING_BLUE), (Item)ExtraDelightItems.GINGERBREAD_BLOCK_BLUE.get()).unlockedBy("has_frosting", Recipes.has(ExtraDelightTags.FROSTING_BLUE)).save(consumer, Recipes.EDLoc("frost_gingerbread_blue"));
        ToolOnBlockBuilder.make((Item)ExtraDelightItems.GINGERBREAD_COOKIE_BLOCK.get(), Ingredient.of(ExtraDelightTags.FROSTING_PURPLE), (Item)ExtraDelightItems.GINGERBREAD_BLOCK_PURPLE.get()).unlockedBy("has_frosting", Recipes.has(ExtraDelightTags.FROSTING_PURPLE)).save(consumer, Recipes.EDLoc("frost_gingerbread_purple"));
        ToolOnBlockBuilder.make((Item)ExtraDelightItems.GINGERBREAD_COOKIE_BLOCK.get(), Ingredient.of(ExtraDelightTags.FROSTING_MAGENTA), (Item)ExtraDelightItems.GINGERBREAD_BLOCK_MAGENTA.get()).unlockedBy("has_frosting", Recipes.has(ExtraDelightTags.FROSTING_MAGENTA)).save(consumer, Recipes.EDLoc("frost_gingerbread_magenta"));
        ToolOnBlockBuilder.make((Item)ExtraDelightItems.GINGERBREAD_COOKIE_BLOCK.get(), Ingredient.of(ExtraDelightTags.FROSTING_PINK), (Item)ExtraDelightItems.GINGERBREAD_BLOCK_PINK.get()).unlockedBy("has_frosting", Recipes.has(ExtraDelightTags.FROSTING_PINK)).save(consumer, Recipes.EDLoc("frost_gingerbread_pink"));
    }

    private void feastRecipes(RecipeOutput consumer) {
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.MEAT_LOAF.get()), (Item)ExtraDelightItems.MEAT_LOAF_FEAST.get()).unlockedBy("has_meatloaf", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.MEAT_LOAF_FEAST.get()))).save(consumer, Recipes.EDLoc("meatloaf_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((TagKey)Tags.Items.FOODS_BREAD), new ItemStack((ItemLike)ExtraDelightItems.MEAT_LOAF_SANDWICH.get()), (Item)ExtraDelightItems.MEAT_LOAF_FEAST.get()).unlockedBy("has_meatloaf", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.MEAT_LOAF_FEAST.get()))).save(consumer, Recipes.EDLoc("meatloaf_sandwich_feast"));
        FeastRecipeBuilder.feast(Ingredient.of(ExtraDelightTags.BREAD_SLICE), new ItemStack((ItemLike)ExtraDelightItems.MEAT_LOAF_SANDWICH.get()), (Item)ExtraDelightItems.MEAT_LOAF_FEAST.get()).unlockedBy("has_meatloaf", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.MEAT_LOAF_FEAST.get()))).save(consumer, Recipes.EDLoc("meatloaf_sandwich_slice_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ModItems.BEEF_STEW.get()), (Item)ExtraDelightItems.BEEF_STEW_FEAST.get()).unlockedBy("has_beef_stew", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.BEEF_STEW_FEAST.get()))).save(consumer, Recipes.EDLoc("beef_stew_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COOKED_RICE.get()}), new ItemStack((ItemLike)ExtraDelightItems.BEEF_STEW_RICE.get()), (Item)ExtraDelightItems.BEEF_STEW_FEAST.get()).unlockedBy("has_beef_stew", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.BEEF_STEW_FEAST.get()))).save(consumer, Recipes.EDLoc("beef_stew_rice_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.PORK_STEW.get()), (Item)ExtraDelightItems.PORK_STEW_FEAST.get()).unlockedBy("has_pork_stew", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.PORK_STEW_FEAST.get()))).save(consumer, Recipes.EDLoc("pork_stew_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COOKED_RICE.get()}), new ItemStack((ItemLike)ExtraDelightItems.PORK_STEW_RICE.get()), (Item)ExtraDelightItems.PORK_STEW_FEAST.get()).unlockedBy("has_pork_stew", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.PORK_STEW_FEAST.get()))).save(consumer, Recipes.EDLoc("pork_stew_rice_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.CHICKEN_STEW.get()), (Item)ExtraDelightItems.CHICKEN_STEW_FEAST.get()).unlockedBy("has_chicken_stew", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.CHICKEN_STEW_FEAST.get()))).save(consumer, Recipes.EDLoc("chicken_stew_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COOKED_RICE.get()}), new ItemStack((ItemLike)ExtraDelightItems.CHICKEN_STEW_RICE.get()), (Item)ExtraDelightItems.CHICKEN_STEW_FEAST.get()).unlockedBy("has_chicken_stew", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.CHICKEN_STEW_FEAST.get()))).save(consumer, Recipes.EDLoc("chicken_stew_rice_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)Items.RABBIT_STEW), (Item)ExtraDelightItems.RABBIT_STEW_FEAST.get()).unlockedBy("has_rabbit_stew", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.RABBIT_STEW_FEAST.get()))).save(consumer, Recipes.EDLoc("rabbit_stew_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COOKED_RICE.get()}), new ItemStack((ItemLike)ExtraDelightItems.RABBIT_STEW_RICE.get()), (Item)ExtraDelightItems.RABBIT_STEW_FEAST.get()).unlockedBy("has_rabbit_stew", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.RABBIT_STEW_FEAST.get()))).save(consumer, Recipes.EDLoc("rabbit_stew_rice_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ModItems.FISH_STEW.get()), (Item)ExtraDelightItems.FISH_STEW_FEAST.get()).unlockedBy("has_fish_stew", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.FISH_STEW_FEAST.get()))).save(consumer, Recipes.EDLoc("fish_stew_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COOKED_RICE.get()}), new ItemStack((ItemLike)ExtraDelightItems.FISH_STEW_RICE.get()), (Item)ExtraDelightItems.FISH_STEW_FEAST.get()).unlockedBy("has_fish_stew", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.FISH_STEW_FEAST.get()))).save(consumer, Recipes.EDLoc("fish_stew_rice_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.LAMB_STEW.get()), (Item)ExtraDelightItems.LAMB_STEW_FEAST.get()).unlockedBy("has_lamb_stew", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.LAMB_STEW_FEAST.get()))).save(consumer, Recipes.EDLoc("lamb_stew_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COOKED_RICE.get()}), new ItemStack((ItemLike)ExtraDelightItems.LAMB_STEW_RICE.get()), (Item)ExtraDelightItems.LAMB_STEW_FEAST.get()).unlockedBy("has_lamb_stew", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.LAMB_STEW_FEAST.get()))).save(consumer, Recipes.EDLoc("lamb_stew_rice_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.CURRY.get()), (Item)ExtraDelightItems.CURRY_FEAST.get()).unlockedBy("has_pork_stew", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.CURRY_FEAST.get()))).save(consumer, Recipes.EDLoc("curry_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COOKED_RICE.get()}), new ItemStack((ItemLike)ExtraDelightItems.CURRY_RICE.get()), (Item)ExtraDelightItems.CURRY_FEAST.get()).unlockedBy("has_pork_stew", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.CURRY_FEAST.get()))).save(consumer, Recipes.EDLoc("curry_rice_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.HOTDISH.get()), (Item)ExtraDelightItems.HOTDISH_FEAST.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.HOTDISH_FEAST.get()))).save(consumer, Recipes.EDLoc("hotdish_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.MACARONI_CHEESE.get()), (Item)ExtraDelightItems.MACARONI_CHEESE_FEAST.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.MACARONI_CHEESE_FEAST.get()))).save(consumer, Recipes.EDLoc("mac_cheese_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.LASAGNA.get()), (Item)ExtraDelightItems.LASAGNA_FEAST.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.LASAGNA_FEAST.get()))).save(consumer, Recipes.EDLoc("lasagna_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.HASH.get()), (Item)ExtraDelightItems.HASH_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.HASH_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("hash_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.POT_ROAST.get()), (Item)ExtraDelightItems.POT_ROAST_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.POT_ROAST_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("pot_roast_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.SALISBURY_STEAK.get()), (Item)ExtraDelightItems.SALISBURY_STEAK_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.SALISBURY_STEAK_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("salisbury_steak_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((TagKey)Tags.Items.FOODS_BREAD), new ItemStack((ItemLike)ExtraDelightItems.PULLED_PORK_SANDWICH.get()), (Item)ExtraDelightItems.PULLED_PORK_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.PULLED_PORK_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("pulled_pork_bread_feast"));
        FeastRecipeBuilder.feast(Ingredient.of(ExtraDelightTags.BREAD_SLICE), new ItemStack((ItemLike)ExtraDelightItems.PULLED_PORK_SANDWICH.get()), (Item)ExtraDelightItems.PULLED_PORK_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.PULLED_PORK_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("pulled_pork_bread_slice_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.RACK_LAMB.get()), (Item)ExtraDelightItems.RACK_LAMB_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.RACK_LAMB_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("rack_lamb_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.BEEF_WELLINGTON.get()), (Item)ExtraDelightItems.BEEF_WELLINGTON_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.BEEF_WELLINGTON_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("beef_wellington_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.HAGGIS.get()), (Item)ExtraDelightItems.HAGGIS_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.HAGGIS_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("haggis_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COOKED_RICE.get()}), new ItemStack((ItemLike)ExtraDelightItems.STIRFRY.get()), (Item)ExtraDelightItems.STIRFRY_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.STIRFRY_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("stirfry_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.BBQ_RIBS.get()), (Item)ExtraDelightItems.BBQ_RIBS_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.BBQ_RIBS_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("ribs_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.MASHED_POTATO_GRAVY.get()), (Item)ExtraDelightItems.MASHED_POTATO_GRAVY_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.MASHED_POTATO_GRAVY_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("mashed_potato_gravy_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.SALAD.get()), (Item)ExtraDelightItems.SALAD_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.SALAD_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("salad_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.CORNBREAD.get()), (Item)ExtraDelightItems.CORNBREAD_FEAST.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.CORNBREAD_FEAST.get()))).save(consumer, Recipes.EDLoc("cornbread_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.CORN_PUDDING.get()), (Item)ExtraDelightItems.CORN_PUDDING_FEAST.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.CORN_PUDDING_FEAST.get()))).save(consumer, Recipes.EDLoc("corn_pudding_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.APPLE_CRISP.get()), (Item)ExtraDelightItems.APPLE_CRISP_FEAST.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.APPLE_CRISP_FEAST.get()))).save(consumer, Recipes.EDLoc("apple_crisp_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.STUFFING.get()), (Item)ExtraDelightItems.STUFFING_FEAST.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.STUFFING_FEAST.get()))).save(consumer, Recipes.EDLoc("stuffing_bowl_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.POTATO_AU_GRATIN.get()), (Item)ExtraDelightItems.POTATO_AU_GRATIN_FEAST.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.POTATO_AU_GRATIN_FEAST.get()))).save(consumer, Recipes.EDLoc("potato_au_gratin_bowl"));
        FeastRecipeBuilder.feast(Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), new ItemStack((ItemLike)ExtraDelightItems.PUMPKIN_ROLL.get()), (Item)ExtraDelightItems.PUMPKIN_ROLL_FEAST.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.PUMPKIN_ROLL_FEAST.get()))).save(consumer, Recipes.EDLoc("pumpkin_roll_feast_knife_feast"));
        FeastRecipeBuilder.feast(Ingredient.of(ExtraDelightTags.SPOONS), new ItemStack((ItemLike)ExtraDelightItems.CINNAMON_ROLL.get()), (Item)ExtraDelightItems.CINNAMON_ROLLS_FEAST.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.PUMPKIN_ROLL_FEAST.get()))).save(consumer, Recipes.EDLoc("cinnamon_roll_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.MONKEY_BREAD.get()), (Item)ExtraDelightItems.MONKEY_BREAD_FEAST.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.MONKEY_BREAD_FEAST.get()))).save(consumer, Recipes.EDLoc("monkey_bread_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.MINT_LAMB.get()), (Item)ExtraDelightItems.MINT_LAMB_FEAST.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.MINT_LAMB_FEAST.get()))).save(consumer, Recipes.EDLoc("mint_lamb_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.CHARCUTERIE_BOARD.get()), (Item)ExtraDelightItems.CHARCUTERIE_BOARD_FEAST.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.CHARCUTERIE_BOARD_FEAST.get()))).save(consumer, Recipes.EDLoc("charcuterie_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.CHRISTMAS_PUDDING.get()), (Item)ExtraDelightItems.CHRISTMAS_PUDDING_FEAST.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.CHRISTMAS_PUDDING_FEAST.get()))).save(consumer, Recipes.EDLoc("christmas_pudding_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS_BOTTLE}), new ItemStack((ItemLike)ExtraDelightItems.PUNCH.get()), (Item)ExtraDelightItems.PUNCH_FEAST.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.PUNCH_FEAST.get()))).save(consumer, Recipes.EDLoc("punch_feast"));
        FeastRecipeBuilder.feast(Ingredient.of(), new ItemStack((ItemLike)ExtraDelightItems.BROWNIE.get()), (Item)ExtraDelightItems.BROWNIES_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.BROWNIES_BLOCK.get()))).save(consumer, Recipes.EDLoc("brownies_feast"));
        FeastRecipeBuilder.feast(Ingredient.of(), new ItemStack((ItemLike)ExtraDelightItems.BLONDIE.get()), (Item)ExtraDelightItems.BLONDIES_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.BLONDIES_BLOCK.get()))).save(consumer, Recipes.EDLoc("blondies_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.PAPER}), new ItemStack((ItemLike)ExtraDelightItems.FUDGE_SLICE.get()), (Item)ExtraDelightItems.FUDGE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.FUDGE_BLOCK.get()))).save(consumer, Recipes.EDLoc("fudge_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.STICKY_TOFFEE_PUDDING_SLICE.get()), (Item)ExtraDelightItems.STICKY_TOFFEE_PUDDING_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.STICKY_TOFFEE_PUDDING_BLOCK.get()))).save(consumer, Recipes.EDLoc("sticky_toffee_pudding_feast"));
        FeastRecipeBuilder.feast(Ingredient.of(), new ItemStack((ItemLike)ExtraDelightItems.CRISP_RICE_TREAT.get()), (Item)ExtraDelightItems.CRISP_RICE_TREATS_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.CRISP_RICE_TREATS_BLOCK.get()))).save(consumer, Recipes.EDLoc("crisp_rice_treats_feast"));
        FeastRecipeBuilder.feast(Ingredient.of(), new ItemStack((ItemLike)ExtraDelightItems.SCOTCHAROO.get()), (Item)ExtraDelightItems.SCOTCHAROO_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.SCOTCHAROO_BLOCK.get()))).save(consumer, Recipes.EDLoc("scotcharoo_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.BLACK_FOREST_TRIFLE.get()), (Item)ExtraDelightItems.BLACK_FOREST_TRIFLE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.BLACK_FOREST_TRIFLE_BLOCK.get()))).save(consumer, Recipes.EDLoc("black_forest_trifle_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES}), new ItemStack((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_DIPPED_SWEET_BERRY.get()), (Item)ExtraDelightItems.BLOOD_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("blood_sweet_berry_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOW_BERRIES}), new ItemStack((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_DIPPED_GLOW_BERRY.get()), (Item)ExtraDelightItems.BLOOD_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("blood_glow_berry_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.SLICED_APPLE}), new ItemStack((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_DIPPED_APPLE_SLICE.get()), (Item)ExtraDelightItems.BLOOD_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("blood_apple_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.MARSHMALLOW}), new ItemStack((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_DIPPED_MARSHMALLOW.get()), (Item)ExtraDelightItems.BLOOD_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("blood_marshmallow_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.GRAHAM_CRACKER}), new ItemStack((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_DIPPED_GRAHAM_CRACKER.get()), (Item)ExtraDelightItems.BLOOD_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("blood_graham_cracker_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COOKED_BACON.get()}), new ItemStack((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_DIPPED_BACON.get()), (Item)ExtraDelightItems.BLOOD_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("blood_bacon_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.COFFEE_BEANS}), new ItemStack((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_DIPPED_COFFEE_BEAN.get()), (Item)ExtraDelightItems.BLOOD_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("blood_coffee_bean_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES}), new ItemStack((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_DIPPED_SWEET_BERRY.get()), (Item)ExtraDelightItems.DARK_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("dark_sweet_berry_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOW_BERRIES}), new ItemStack((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_DIPPED_GLOW_BERRY.get()), (Item)ExtraDelightItems.DARK_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("dark_glow_berry_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.SLICED_APPLE}), new ItemStack((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_DIPPED_APPLE_SLICE.get()), (Item)ExtraDelightItems.DARK_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("dark_apple_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.MARSHMALLOW}), new ItemStack((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_DIPPED_MARSHMALLOW.get()), (Item)ExtraDelightItems.DARK_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("dark_marshmallow_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.GRAHAM_CRACKER}), new ItemStack((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_DIPPED_GRAHAM_CRACKER.get()), (Item)ExtraDelightItems.DARK_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("dark_graham_cracker_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COOKED_BACON.get()}), new ItemStack((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_DIPPED_BACON.get()), (Item)ExtraDelightItems.DARK_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("dark_bacon_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.COFFEE_BEANS}), new ItemStack((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_DIPPED_COFFEE_BEAN.get()), (Item)ExtraDelightItems.DARK_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("dark_coffee_bean_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES}), new ItemStack((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_DIPPED_SWEET_BERRY.get()), (Item)ExtraDelightItems.MILK_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("milk_sweet_berry_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOW_BERRIES}), new ItemStack((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_DIPPED_GLOW_BERRY.get()), (Item)ExtraDelightItems.MILK_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("milk_glow_berry_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.SLICED_APPLE}), new ItemStack((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_DIPPED_APPLE_SLICE.get()), (Item)ExtraDelightItems.MILK_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("milk_apple_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.MARSHMALLOW}), new ItemStack((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_DIPPED_MARSHMALLOW.get()), (Item)ExtraDelightItems.MILK_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("milk_marshmallow_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.GRAHAM_CRACKER}), new ItemStack((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_DIPPED_GRAHAM_CRACKER.get()), (Item)ExtraDelightItems.MILK_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("milk_graham_cracker_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COOKED_BACON.get()}), new ItemStack((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_DIPPED_BACON.get()), (Item)ExtraDelightItems.MILK_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("milk_bacon_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.COFFEE_BEANS}), new ItemStack((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_DIPPED_COFFEE_BEAN.get()), (Item)ExtraDelightItems.MILK_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("milk_coffee_bean_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES}), new ItemStack((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_DIPPED_SWEET_BERRY.get()), (Item)ExtraDelightItems.WHITE_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("white_sweet_berry_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOW_BERRIES}), new ItemStack((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_DIPPED_GLOW_BERRY.get()), (Item)ExtraDelightItems.WHITE_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("white_glow_berry_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.SLICED_APPLE}), new ItemStack((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_DIPPED_APPLE_SLICE.get()), (Item)ExtraDelightItems.WHITE_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("white_apple_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.MARSHMALLOW}), new ItemStack((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_DIPPED_MARSHMALLOW.get()), (Item)ExtraDelightItems.WHITE_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("white_marshmallow_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.GRAHAM_CRACKER}), new ItemStack((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_DIPPED_GRAHAM_CRACKER.get()), (Item)ExtraDelightItems.WHITE_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("white_graham_cracker_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COOKED_BACON.get()}), new ItemStack((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_DIPPED_BACON.get()), (Item)ExtraDelightItems.WHITE_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("white_bacon_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.COFFEE_BEANS}), new ItemStack((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_DIPPED_COFFEE_BEAN.get()), (Item)ExtraDelightItems.WHITE_CHOCOLATE_FONDUE_BLOCK.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_FONDUE_BLOCK.get()))).save(consumer, Recipes.EDLoc("white_coffee_bean_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.JELLY_WHITE.get()), (Item)ExtraDelightItems.JELLY_WHITE_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.JELLY_WHITE_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("jelly_white"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.JELLY_ORANGE.get()), (Item)ExtraDelightItems.JELLY_ORANGE_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.JELLY_ORANGE_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("jelly_orange_block"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.JELLY_MAGENTA.get()), (Item)ExtraDelightItems.JELLY_MAGENTA_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.JELLY_MAGENTA_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("jelly_magenta_block"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.JELLY_LIGHT_BLUE.get()), (Item)ExtraDelightItems.JELLY_LIGHT_BLUE_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.JELLY_LIGHT_BLUE_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("jelly_light_blue_block"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.JELLY_YELLOW.get()), (Item)ExtraDelightItems.JELLY_YELLOW_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.JELLY_YELLOW_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("jelly_yellow_block"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.JELLY_LIME.get()), (Item)ExtraDelightItems.JELLY_LIME_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.JELLY_LIME_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("jelly_lime_block"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.JELLY_PINK.get()), (Item)ExtraDelightItems.JELLY_PINK_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.JELLY_PINK_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("jelly_pink_block"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.JELLY_GREY.get()), (Item)ExtraDelightItems.JELLY_GREY_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.JELLY_GREY_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("jelly_grey_block"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.JELLY_LIGHT_GREY.get()), (Item)ExtraDelightItems.JELLY_LIGHT_GREY_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.JELLY_LIGHT_GREY_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("jelly_light_grey_block"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.JELLY_CYAN.get()), (Item)ExtraDelightItems.JELLY_CYAN_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.JELLY_CYAN_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("jelly_cyan_block"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.JELLY_PURPLE.get()), (Item)ExtraDelightItems.JELLY_PURPLE_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.JELLY_PURPLE_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("jelly_purple_block"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.JELLY_BLUE.get()), (Item)ExtraDelightItems.JELLY_BLUE_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.JELLY_BLUE_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("jelly_blue_block"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.JELLY_BROWN.get()), (Item)ExtraDelightItems.JELLY_BROWN_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.JELLY_BROWN_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("jelly_brown_block"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.JELLY_GREEN.get()), (Item)ExtraDelightItems.JELLY_GREEN_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.JELLY_GREEN_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("jelly_green_block"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.JELLY_RED.get()), (Item)ExtraDelightItems.JELLY_RED_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.JELLY_RED_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("jelly_red_block"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.JELLY_BLACK.get()), (Item)ExtraDelightItems.JELLY_BLACK_FEAST_ITEM.get()).unlockedBy("has_hotdish", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.JELLY_BLACK_FEAST_ITEM.get()))).save(consumer, Recipes.EDLoc("jelly_black_block"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.PORK_AND_APPLES.get()), (Item)ExtraDelightItems.PORK_AND_APPLES_FEAST.get()).unlockedBy("has_feast", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.PORK_AND_APPLES_FEAST.get()))).save(consumer, Recipes.EDLoc("pork_apples_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.STUFFED_APPLE.get()), (Item)ExtraDelightItems.STUFFED_APPLES_FEAST.get()).unlockedBy("has_feast", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.STUFFED_APPLES_FEAST.get()))).save(consumer, Recipes.EDLoc("stuffed_apple_feast"));
        FeastRecipeBuilder.feast(Ingredient.of(ExtraDelightTags.ICE_CREAM), new ItemStack((ItemLike)ExtraDelightItems.STUFFED_APPLE_ICE_CREAM.get()), (Item)ExtraDelightItems.STUFFED_APPLES_FEAST.get()).unlockedBy("has_feast", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.STUFFED_APPLES_FEAST.get()))).save(consumer, Recipes.EDLoc("stuffed_apple_ice_cream_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.CHILI_CON_CARNE.get()), (Item)ExtraDelightItems.CHILI_CON_CARNE_FEAST.get()).unlockedBy("has_feast", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.CHILI_CON_CARNE_FEAST.get()))).save(consumer, Recipes.EDLoc("chili_con_carne_feast"));
        FeastRecipeBuilder.feast(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), new ItemStack((ItemLike)ExtraDelightItems.WHITE_CHILI.get()), (Item)ExtraDelightItems.WHITE_CHILI_FEAST.get()).unlockedBy("has_feast", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.WHITE_CHILI_FEAST.get()))).save(consumer, Recipes.EDLoc("white_chili_feast"));
        FeastRecipeBuilder.feast(Ingredient.of(), new ItemStack((ItemLike)ExtraDelightItems.MARSHMALLOW_SLICE.get()), (Item)ExtraDelightItems.MARSHMALLOW_SLICE_FEAST.get()).unlockedBy("has_feast", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.MARSHMALLOW_SLICE_FEAST.get()))).save(consumer, Recipes.EDLoc("marshmallow_slice_feast"));
        FeastRecipeBuilder.feast(Ingredient.of(), new ItemStack((ItemLike)ExtraDelightItems.BRUSCHETTA.get()), (Item)ExtraDelightItems.BRUSCHETTA_FEAST.get()).unlockedBy("has_feast", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.BRUSCHETTA_FEAST.get()))).save(consumer, Recipes.EDLoc("bruschetta_feast"));
    }

    private void doughShapeRecipes(RecipeOutput consumer) {
        Recipes.doughshaping(Ingredient.of(ExtraDelightTags.DOUGH), RecipeCategory.FOOD, (ItemLike)ExtraDelightItems.MACARONI.get(), 1).unlockedBy("has_dough", Recipes.has(ExtraDelightTags.DOUGH)).save(consumer, Recipes.EDLoc("macaroni_pasta"));
        Recipes.doughshaping(Ingredient.of(ExtraDelightTags.DOUGH), RecipeCategory.FOOD, (ItemLike)ExtraDelightItems.LASAGNA_NOODLES.get(), 1).unlockedBy("has_dough", Recipes.has(ExtraDelightTags.DOUGH)).save(consumer, Recipes.EDLoc("lasagna_pasta"));
        Recipes.doughshaping(Ingredient.of(ExtraDelightTags.DOUGH), RecipeCategory.FOOD, (ItemLike)ModItems.RAW_PASTA.get(), 1).unlockedBy("has_dough", Recipes.has(ExtraDelightTags.DOUGH)).save(consumer, Recipes.EDLoc("raw_pasta"));
        Recipes.doughshaping(Ingredient.of(ExtraDelightTags.GINGERBREAD_COOKIE_DOUGH), RecipeCategory.FOOD, (ItemLike)ExtraDelightItems.RAW_GINGERBREAD_ALEX.get(), 8).unlockedBy("has_dough", Recipes.has(ExtraDelightTags.GINGERBREAD_COOKIE_DOUGH)).save(consumer);
        Recipes.doughshaping(Ingredient.of(ExtraDelightTags.GINGERBREAD_COOKIE_DOUGH), RecipeCategory.FOOD, (ItemLike)ExtraDelightItems.RAW_GINGERBREAD_CREEPER.get(), 8).unlockedBy("has_dough", Recipes.has(ExtraDelightTags.GINGERBREAD_COOKIE_DOUGH)).save(consumer);
        Recipes.doughshaping(Ingredient.of(ExtraDelightTags.GINGERBREAD_COOKIE_DOUGH), RecipeCategory.FOOD, (ItemLike)ExtraDelightItems.RAW_GINGERBREAD_PICKAXE.get(), 8).unlockedBy("has_dough", Recipes.has(ExtraDelightTags.GINGERBREAD_COOKIE_DOUGH)).save(consumer);
        Recipes.doughshaping(Ingredient.of(ExtraDelightTags.GINGERBREAD_COOKIE_DOUGH), RecipeCategory.FOOD, (ItemLike)ExtraDelightItems.RAW_GINGERBREAD_STEVE.get(), 8).unlockedBy("has_dough", Recipes.has(ExtraDelightTags.GINGERBREAD_COOKIE_DOUGH)).save(consumer);
        Recipes.doughshaping(Ingredient.of(ExtraDelightTags.GINGERBREAD_COOKIE_DOUGH), RecipeCategory.FOOD, (ItemLike)ExtraDelightItems.RAW_GINGERBREAD_SWORD.get(), 8).unlockedBy("has_dough", Recipes.has(ExtraDelightTags.GINGERBREAD_COOKIE_DOUGH)).save(consumer);
        Recipes.doughshaping(Ingredient.of(ExtraDelightTags.GINGERBREAD_COOKIE_DOUGH), RecipeCategory.FOOD, (ItemLike)ExtraDelightItems.RAW_GINGERBREAD_VILLAGER.get(), 8).unlockedBy("has_dough", Recipes.has(ExtraDelightTags.GINGERBREAD_COOKIE_DOUGH)).save(consumer);
        Recipes.doughshaping(Ingredient.of(ExtraDelightTags.GINGERBREAD_COOKIE_DOUGH), RecipeCategory.FOOD, (ItemLike)ExtraDelightItems.RAW_GINGERBREAD_DIAMOND.get(), 8).unlockedBy("has_dough", Recipes.has(ExtraDelightTags.GINGERBREAD_COOKIE_DOUGH)).save(consumer);
        Recipes.doughshaping(Ingredient.of(ExtraDelightTags.GINGERBREAD_COOKIE_DOUGH), RecipeCategory.FOOD, (ItemLike)ExtraDelightItems.RAW_GINGERBREAD_EMERALD.get(), 8).unlockedBy("has_dough", Recipes.has(ExtraDelightTags.GINGERBREAD_COOKIE_DOUGH)).save(consumer);
        Recipes.doughshaping(Ingredient.of(ExtraDelightTags.SUGAR_COOKIE_DOUGH), RecipeCategory.FOOD, (ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_ALEX.get(), 8).unlockedBy("has_dough", Recipes.has(ExtraDelightTags.SUGAR_COOKIE_DOUGH)).save(consumer);
        Recipes.doughshaping(Ingredient.of(ExtraDelightTags.SUGAR_COOKIE_DOUGH), RecipeCategory.FOOD, (ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_CREEPER.get(), 8).unlockedBy("has_dough", Recipes.has(ExtraDelightTags.SUGAR_COOKIE_DOUGH)).save(consumer);
        Recipes.doughshaping(Ingredient.of(ExtraDelightTags.SUGAR_COOKIE_DOUGH), RecipeCategory.FOOD, (ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_PICKAXE.get(), 8).unlockedBy("has_dough", Recipes.has(ExtraDelightTags.SUGAR_COOKIE_DOUGH)).save(consumer);
        Recipes.doughshaping(Ingredient.of(ExtraDelightTags.SUGAR_COOKIE_DOUGH), RecipeCategory.FOOD, (ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_STEVE.get(), 8).unlockedBy("has_dough", Recipes.has(ExtraDelightTags.SUGAR_COOKIE_DOUGH)).save(consumer);
        Recipes.doughshaping(Ingredient.of(ExtraDelightTags.SUGAR_COOKIE_DOUGH), RecipeCategory.FOOD, (ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_SWORD.get(), 8).unlockedBy("has_dough", Recipes.has(ExtraDelightTags.SUGAR_COOKIE_DOUGH)).save(consumer);
        Recipes.doughshaping(Ingredient.of(ExtraDelightTags.SUGAR_COOKIE_DOUGH), RecipeCategory.FOOD, (ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_VILLAGER.get(), 8).unlockedBy("has_dough", Recipes.has(ExtraDelightTags.SUGAR_COOKIE_DOUGH)).save(consumer);
        Recipes.doughshaping(Ingredient.of(ExtraDelightTags.SUGAR_COOKIE_DOUGH), RecipeCategory.FOOD, (ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_DIAMOND.get(), 8).unlockedBy("has_dough", Recipes.has(ExtraDelightTags.SUGAR_COOKIE_DOUGH)).save(consumer);
        Recipes.doughshaping(Ingredient.of(ExtraDelightTags.SUGAR_COOKIE_DOUGH), RecipeCategory.FOOD, (ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_EMERALD.get(), 8).unlockedBy("has_dough", Recipes.has(ExtraDelightTags.SUGAR_COOKIE_DOUGH)).save(consumer);
        Recipes.doughshaping(Ingredient.of(ExtraDelightTags.CORN_KERNELS), RecipeCategory.FOOD, (ItemLike)ExtraDelightItems.CORN_FLAKES.get(), 1).unlockedBy("has_dough", Recipes.has(ExtraDelightTags.CORN_KERNELS)).save(consumer);
        Recipes.doughshaping(Ingredient.of(ExtraDelightTags.DOUGH), RecipeCategory.FOOD, (ItemLike)ExtraDelightItems.PENNE.get(), 1).unlockedBy("has_dough", Recipes.has(ExtraDelightTags.DOUGH)).save(consumer, Recipes.EDLoc("penne_pasta"));
    }

    public static SingleItemRecipeBuilder doughshaping(Ingredient p_251375_, RecipeCategory p_248984_, ItemLike p_250105_, int p_249506_) {
        return new SingleItemRecipeBuilder(p_248984_, DoughShapingRecipe::new, p_251375_, p_250105_, p_249506_);
    }

    public static SingleItemRecipeBuilder doughshaping(Ingredient p_248596_, RecipeCategory p_250503_, ItemLike p_250269_) {
        return new SingleItemRecipeBuilder(p_250503_, DoughShapingRecipe::new, p_248596_, p_250269_, 1);
    }

    private void dryingRackRecipes(RecipeOutput consumer) {
        DryingRackRecipeBuilder.drying(Ingredient.of((ItemLike[])new ItemLike[]{Items.WET_SPONGE}), new ItemStack((ItemLike)Items.SPONGE), 10.0f, 1000).unlockedBy("has_sponge", Recipes.has((ItemLike)Items.WET_SPONGE)).save(consumer, Recipes.EDLoc("sponge"));
        DryingRackRecipeBuilder.drying(Ingredient.of((ItemLike[])new ItemLike[]{Items.KELP}), new ItemStack((ItemLike)Items.DRIED_KELP), 10.0f, 1000).unlockedBy("has_kelp", Recipes.has((ItemLike)Items.KELP)).save(consumer, Recipes.EDLoc("dried_kelp"));
        DryingRackRecipeBuilder.drying(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.SEAWEED_PASTE.get()}), new ItemStack((ItemLike)ExtraDelightItems.AGAR_SHEETS.get()), 10.0f, 1000).unlockedBy("has_paste", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.SEAWEED_PASTE.get()))).save(consumer, Recipes.EDLoc("agar_sheets"));
        DryingRackRecipeBuilder.drying(Ingredient.of((TagKey)Tags.Items.FOODS_COOKED_FISH), new ItemStack((ItemLike)ExtraDelightItems.FISH_FLAKES.get()), 10.0f, 1000).unlockedBy("has_fish", Recipes.has((TagKey)Tags.Items.FOODS_COOKED_FISH)).save(consumer, Recipes.EDLoc("fish_flakes"));
        DryingRackRecipeBuilder.drying(Ingredient.of(ExtraDelightTags.MEAT), new ItemStack((ItemLike)ExtraDelightItems.JERKY.get()), 10.0f, 1000).unlockedBy("has_meat", Recipes.has(ExtraDelightTags.MEAT)).save(consumer, Recipes.EDLoc("jerky"));
        DryingRackRecipeBuilder.drying(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CORN_HUSK.get()}), new ItemStack((ItemLike)ExtraDelightItems.DRIED_CORN_HUSK.get()), 10.0f, 1000).unlockedBy("has_husk", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.CORN_HUSK.get()))).save(consumer, Recipes.EDLoc("corn_husk"));
        DryingRackRecipeBuilder.drying(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_CINNAMON.get()}), new ItemStack((ItemLike)ExtraDelightItems.CINNAMON_STICK.get()), 10.0f, 1000).unlockedBy("has_husk", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.RAW_CINNAMON.get()))).save(consumer, Recipes.EDLoc("raw_cinnamon"));
        DryingRackRecipeBuilder.drying(Ingredient.of(ExtraDelightTags.PROCESSED_FRUIT), new ItemStack((ItemLike)ExtraDelightItems.DRIED_FRUIT.get()), 10.0f, 1000).unlockedBy("has_husk", Recipes.has(ExtraDelightTags.DRIED_FRUIT)).save(consumer, Recipes.EDLoc("dried_fruit"));
        DryingRackRecipeBuilder.drying(Ingredient.of(ExtraDelightTags.COFFEE_CHERRIES), new ItemStack((ItemLike)ExtraDelightItems.GREEN_COFFEE.get()), 10.0f, 1000).unlockedBy("has_husk", Recipes.has(ExtraDelightTags.DRIED_FRUIT)).save(consumer, Recipes.EDLoc("green_coffee"));
        DryingRackRecipeBuilder.drying(Ingredient.of(ExtraDelightTags.CHILI), new ItemStack((ItemLike)ExtraDelightItems.DRIED_CHILI.get()), 10.0f, 1000).unlockedBy("has_husk", Recipes.has(ExtraDelightTags.DRIED_FRUIT)).save(consumer, Recipes.EDLoc("chili"));
    }

    private void cookingRecipes(RecipeOutput consumer) {
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.OMELETTE_MIX.get()}), (Item)ExtraDelightItems.OMELETTE.get(), consumer, "omelette_mix");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.EGG_MIX.get()}), (Item)ExtraDelightItems.SCRAMBLED_EGGS.get(), consumer, "egg_mix");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GRATED_POTATO.get()}), (Item)ExtraDelightItems.HASHBROWNS.get(), consumer, "hashbrowns");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT}), (Item)ExtraDelightItems.ROASTED_CARROT.get(), consumer, "roasted_carrot");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{Items.APPLE}), (Item)ExtraDelightItems.ROASTED_APPLE.get(), consumer, "roasted_apple");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CHEESE_SANDWICH.get()}), (Item)ExtraDelightItems.GRILLED_CHEESE.get(), consumer, "grilled_cheese");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BREAD_SLICE.get()}), (Item)ExtraDelightItems.TOAST.get(), consumer, "toast");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CACTUS.get()}), (Item)ExtraDelightItems.COOKED_CACTUS.get(), consumer, "cactus");
        Recipes.vanillaCooking(Ingredient.of(ExtraDelightTags.CORN_KERNELS), (Item)ExtraDelightItems.POPCORN.get(), consumer, "popcorn");
        Recipes.vanillaCooking(Ingredient.of(ExtraDelightTags.CORN_ON_COB), (Item)ExtraDelightItems.GRILLED_CORN_ON_COB.get(), consumer, "corn_cob");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{Items.PUMPKIN_SEEDS}), (Item)ExtraDelightItems.ROASTED_PUMPKIN_SEEDS.get(), consumer, "pumpkin_seeds");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_GINGERBREAD_ALEX.get()}), (Item)ExtraDelightItems.GINGERBREAD_ALEX.get(), consumer, "gingerbread_alex");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_GINGERBREAD_CREEPER.get()}), (Item)ExtraDelightItems.GINGERBREAD_CREEPER.get(), consumer, "gingerbread_creeper");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_GINGERBREAD_PICKAXE.get()}), (Item)ExtraDelightItems.GINGERBREAD_PICKAXE.get(), consumer, "gingerbread_pickaxe");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_GINGERBREAD_STEVE.get()}), (Item)ExtraDelightItems.GINGERBREAD_STEVE.get(), consumer, "gingerbread_steve");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_GINGERBREAD_SWORD.get()}), (Item)ExtraDelightItems.GINGERBREAD_SWORD.get(), consumer, "gingerbread_sword");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_GINGERBREAD_VILLAGER.get()}), (Item)ExtraDelightItems.GINGERBREAD_VILLAGER.get(), consumer, "gingerbread_villager");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_GINGERBREAD_DIAMOND.get()}), (Item)ExtraDelightItems.GINGERBREAD_DIAMOND.get(), consumer, "gingerbread_diamond");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_GINGERBREAD_EMERALD.get()}), (Item)ExtraDelightItems.GINGERBREAD_EMERALD.get(), consumer, "gingerbread_emerald");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_ALEX.get()}), (Item)ExtraDelightItems.SUGAR_COOKIE_ALEX.get(), consumer, "sugar_cookie_alex");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_CREEPER.get()}), (Item)ExtraDelightItems.SUGAR_COOKIE_CREEPER.get(), consumer, "sugar_cookie_creeper");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_PICKAXE.get()}), (Item)ExtraDelightItems.SUGAR_COOKIE_PICKAXE.get(), consumer, "sugar_cookie_pickaxe");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_STEVE.get()}), (Item)ExtraDelightItems.SUGAR_COOKIE_STEVE.get(), consumer, "sugar_cookie_steve");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_SWORD.get()}), (Item)ExtraDelightItems.SUGAR_COOKIE_SWORD.get(), consumer, "sugar_cookie_sword");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_VILLAGER.get()}), (Item)ExtraDelightItems.SUGAR_COOKIE_VILLAGER.get(), consumer, "sugar_cookie_villager");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_DIAMOND.get()}), (Item)ExtraDelightItems.SUGAR_COOKIE_DIAMOND.get(), consumer, "sugar_cookie_diamond");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_EMERALD.get()}), (Item)ExtraDelightItems.SUGAR_COOKIE_EMERALD.get(), consumer, "sugar_cookie_emerald");
        Recipes.vanillaCooking(Ingredient.of((ItemLike[])new ItemLike[]{Items.COCOA_BEANS}), (Item)ExtraDelightItems.ROASTED_COCOA_BEANS.get(), consumer, "roasted_cocoa_beans");
        Recipes.vanillaCooking(Ingredient.of(ExtraDelightTags.GREEN_COFFEE), (Item)ExtraDelightItems.COFFEE_BEANS.get(), consumer, "roasted_coffee_beans");
        Recipes.vanillaCooking(Ingredient.of(ExtraDelightTags.PEANUTS), (Item)ExtraDelightItems.ROASTED_PEANUTS.get(), consumer, "roasted_peanuts");
        Recipes.vanillaCooking(Ingredient.of(ExtraDelightTags.HAZELNUTS), (Item)ExtraDelightItems.ROASTED_HAZELNUTS.get(), consumer, "roasted_hazelnuts");
        Recipes.vanillaCooking(Ingredient.of((TagKey)CommonTags.CROPS_RICE), (Item)ExtraDelightItems.CRISP_RICE.get(), consumer, "crisp_rice");
    }

    public static void vanillaCooking(Ingredient of, @NotNull Item item, RecipeOutput consumer, String name) {
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)of, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)item, (float)1.0f, (int)600).unlockedBy(name + "_campfire", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{item})).save(consumer, Recipes.EDLoc("campfire/" + name + "_fire"));
        SimpleCookingRecipeBuilder.smelting((Ingredient)of, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)item, (float)1.0f, (int)200).unlockedBy(name + "_smelting", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{item})).save(consumer, Recipes.EDLoc("smelting/" + name + "_smelt"));
        SimpleCookingRecipeBuilder.smoking((Ingredient)of, (RecipeCategory)RecipeCategory.FOOD, (ItemLike)item, (float)1.0f, (int)100).unlockedBy(name + "_smoking", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{item})).save(consumer, Recipes.EDLoc("smoking/" + name + "_smoke"));
    }

    private void mixingbowlRecipes(RecipeOutput consumer) {
        Recipes.mixing(new ItemStack((ItemLike)ModItems.WHEAT_DOUGH.get(), 3), 8, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.FLOUR), Ingredient.of(ExtraDelightTags.FLOUR), Ingredient.of(ExtraDelightTags.FLOUR), Ingredient.of((TagKey)Tags.Items.EGGS)}, new SizedFluidIngredient[0], consumer, "wheat_dough_egg");
        Recipes.mixing(new ItemStack((ItemLike)ModItems.WHEAT_DOUGH.get(), 3), 8, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.FLOUR), Ingredient.of(ExtraDelightTags.FLOUR), Ingredient.of(ExtraDelightTags.FLOUR)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Fluid)Fluids.WATER, 1000))}, consumer, "wheat_dough");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.EGG_MIX.get(), 1), 8, new ItemStack((ItemLike)Items.BOWL), new Ingredient[]{Ingredient.of((TagKey)Tags.Items.EGGS), Ingredient.of((TagKey)Tags.Items.EGGS)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Holder)NeoForgeMod.MILK, 250))}, consumer, "egg_mix");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.MAYO.get(), 1), 8, new ItemStack((ItemLike)Items.GLASS_BOTTLE), Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.WHISK}), new Ingredient[]{Ingredient.of(ExtraDelightTags.EGG_OR_YOLK), Ingredient.of(ExtraDelightTags.EGG_OR_YOLK)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.OIL.FLUID, 250)), SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.VINEGAR.FLUID, 250))}, consumer, "mayo");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.CARROT_SALAD.get(), 1), 8, new ItemStack((ItemLike)Items.BOWL), new Ingredient[]{Ingredient.of(ExtraDelightTags.GRATED_CARROT), Ingredient.of(ExtraDelightTags.GRATED_CARROT), Ingredient.of(ExtraDelightTags.PROCESSED_APPLE)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.MAYO.FLUID, 250))}, consumer, "carrot_salad");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.EGG_SALAD.get(), 1), 8, new ItemStack((ItemLike)Items.BOWL), new Ingredient[]{Ingredient.of(ExtraDelightTags.BOILED_EGG), Ingredient.of(ExtraDelightTags.BOILED_EGG)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.MAYO.FLUID, 250))}, consumer, "egg_salad");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.FISH_SALAD.get(), 2), 8, new ItemStack((ItemLike)Items.BOWL), new Ingredient[]{Ingredient.of((TagKey)Tags.Items.FOODS_COOKED_FISH), Ingredient.of((TagKey)Tags.Items.FOODS_COOKED_FISH)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.MAYO.FLUID, 250))}, consumer, "fish_salad");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.BUTTER.get(), 1), 8, ItemStack.EMPTY, Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.WHISK}), new Ingredient[0], new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250))}, consumer, "butter");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.WHIPPED_CREAM.get(), 1), 8, new ItemStack((ItemLike)Items.BOWL), Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.WHISK}), new Ingredient[0], new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Holder)NeoForgeMod.MILK, 250))}, consumer, "whipped_cream");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.SEAWEED_SALAD.get(), 2), 4, new ItemStack((ItemLike)Items.BOWL), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.KELP}), Ingredient.of((ItemLike[])new ItemLike[]{Items.KELP}), Ingredient.of(ExtraDelightTags.GRATED_CARROT)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.VINEGAR.FLUID, 250))}, consumer, "seaweed_salad");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.FURIKAKE.get(), 4), 4, new ItemStack((ItemLike)Items.BOWL), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.KELP}), Ingredient.of((ItemLike[])new ItemLike[]{Items.KELP}), Ingredient.of(ExtraDelightTags.FISH_FLAKES), Ingredient.of(ExtraDelightTags.FISH_FLAKES)}, new SizedFluidIngredient[0], consumer, "furikake_rice");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.SALAD_FEAST_ITEM.get(), 1), 4, new ItemStack((ItemLike)Items.BOWL), new Ingredient[]{Ingredient.of(ExtraDelightTags.PROCESSED_CABBAGE), Ingredient.of(ExtraDelightTags.PROCESSED_ONION), Ingredient.of(ExtraDelightTags.PROCESSED_CARROT), Ingredient.of(ExtraDelightTags.CROUTONS), Ingredient.of(ExtraDelightTags.CHEESE), Ingredient.of(ExtraDelightTags.BOILED_EGG), Ingredient.of(ExtraDelightTags.MEAT_COOKED)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.OIL.FLUID, 250)), SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.VINEGAR.FLUID, 250))}, consumer, "salad_meat");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.SALAD_FEAST_ITEM.get(), 1), 4, new ItemStack((ItemLike)Items.BOWL), new Ingredient[]{Ingredient.of(ExtraDelightTags.PROCESSED_CABBAGE), Ingredient.of(ExtraDelightTags.PROCESSED_ONION), Ingredient.of(ExtraDelightTags.PROCESSED_CARROT), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CROUTONS.get()}), Ingredient.of(ExtraDelightTags.CHEESE), Ingredient.of(ExtraDelightTags.BOILED_EGG), Ingredient.of(ExtraDelightTags.PROCESSED_VEG)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.OIL.FLUID, 250)), SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.VINEGAR.FLUID, 250))}, consumer, "salad_veg");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.PASTA_ALFREDO.get(), 1), 2, new ItemStack((ItemLike)Items.BOWL), new Ingredient[]{Ingredient.of(ExtraDelightTags.ALFREDO_SAUCE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.COOKED_PASTA.get()})}, new SizedFluidIngredient[0], consumer, "pasta_alfredo");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.CHICKEN_ALFREDO.get(), 1), 2, new ItemStack((ItemLike)Items.BOWL), new Ingredient[]{Ingredient.of(ExtraDelightTags.ALFREDO_SAUCE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.COOKED_PASTA.get()}), Ingredient.of((TagKey)CommonTags.FOODS_COOKED_CHICKEN)}, new SizedFluidIngredient[0], consumer, "chicken_alfredo");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.PASTA_TOMATO.get(), 1), 2, new ItemStack((ItemLike)Items.BOWL), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TOMATO_SAUCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.COOKED_PASTA.get()})}, new SizedFluidIngredient[0], consumer, "pasta_tomato");
        Recipes.mixing(new ItemStack((ItemLike)ModItems.PASTA_WITH_MEATBALLS.get(), 1), 2, new ItemStack((ItemLike)Items.BOWL), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TOMATO_SAUCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.COOKED_PASTA.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BEEF_PATTY.get()})}, new SizedFluidIngredient[0], consumer, "pasta_meatballs");
        Recipes.mixing(new ItemStack((ItemLike)ModItems.PASTA_WITH_MUTTON_CHOP.get(), 1), 2, new ItemStack((ItemLike)Items.BOWL), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TOMATO_SAUCE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.COOKED_PASTA.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.COOKED_MUTTON})}, new SizedFluidIngredient[0], consumer, "pasta_mutton");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.BUTTERED_PASTA.get(), 1), 2, new ItemStack((ItemLike)Items.BOWL), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.COOKED_PASTA.get()}), Ingredient.of(ExtraDelightTags.BUTTER)}, new SizedFluidIngredient[0], consumer, "buttered_pasta");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.CACTUS_SALAD.get(), 1), 2, new ItemStack((ItemLike)Items.BOWL), new Ingredient[]{Ingredient.of(ExtraDelightTags.COOKED_CACTUS), Ingredient.of(ExtraDelightTags.PROCESSED_TOMATO), Ingredient.of(ExtraDelightTags.PROCESSED_ONION), Ingredient.of(ExtraDelightTags.CHEESE)}, new SizedFluidIngredient[0], consumer, "cactus_salad");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.MILKSHAKE.get(), 1), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.ICE_CREAM.get()})}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Holder)NeoForgeMod.MILK, 250))}, consumer, "milkshake");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.APPLE_MILKSHAKE.get(), 1), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.ICE_CREAM.get()}), Ingredient.of(ExtraDelightTags.PROCESSED_APPLE), Ingredient.of(ExtraDelightTags.PROCESSED_APPLE), Ingredient.of(ExtraDelightTags.PROCESSED_APPLE)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Holder)NeoForgeMod.MILK, 250))}, consumer, "apple_milkshake");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.APPLE_MILKSHAKE.get(), 1), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.APPLE_ICE_CREAM.get()})}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Holder)NeoForgeMod.MILK, 250))}, consumer, "apple_milkshake_ice_cream");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.CHOCOLATE_MILKSHAKE.get(), 1), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.ICE_CREAM.get()}), Ingredient.of(ExtraDelightTags.COCOA_POWDER)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Holder)NeoForgeMod.MILK, 250))}, consumer, "chocolate_milkshake");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.CHOCOLATE_MILKSHAKE.get(), 1), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CHOCOLATE_ICE_CREAM.get()})}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Holder)NeoForgeMod.MILK, 250))}, consumer, "chocolate_milkshake_ice_cream");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.GLOW_BERRY_MILKSHAKE.get(), 1), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.ICE_CREAM.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOW_BERRIES}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOW_BERRIES}), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOW_BERRIES})}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Holder)NeoForgeMod.MILK, 250))}, consumer, "glow_berry_milkshake");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.GLOW_BERRY_MILKSHAKE.get(), 1), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GLOW_BERRY_ICE_CREAM.get()})}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Holder)NeoForgeMod.MILK, 250))}, consumer, "glow_berry_milkshake_ice_cream");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.HONEY_MILKSHAKE.get(), 1), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.ICE_CREAM.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEY_BOTTLE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEY_BOTTLE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEY_BOTTLE})}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Holder)NeoForgeMod.MILK, 250))}, consumer, "honey_milkshake");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.HONEY_MILKSHAKE.get(), 1), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.HONEY_ICE_CREAM.get()})}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Holder)NeoForgeMod.MILK, 250))}, consumer, "honey_milkshake_ice_cream");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.PUMPKIN_MILKSHAKE.get(), 1), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.ICE_CREAM.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PUMPKIN_SLICE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PUMPKIN_SLICE.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PUMPKIN_SLICE.get()})}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Holder)NeoForgeMod.MILK, 250))}, consumer, "pumpkin_milkshake");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.PUMPKIN_MILKSHAKE.get(), 1), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.PUMPKIN_ICE_CREAM.get()})}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Holder)NeoForgeMod.MILK, 250))}, consumer, "pumpkin_milkshake_ice_cream");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.SWEET_BERRY_MILKSHAKE.get(), 1), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.ICE_CREAM.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES})}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Holder)NeoForgeMod.MILK, 250))}, consumer, "sweet_berry_milkshake");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.SWEET_BERRY_MILKSHAKE.get(), 1), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.SWEET_BERRY_ICE_CREAM.get()})}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Holder)NeoForgeMod.MILK, 250))}, consumer, "sweet_berry_milkshake_ice_cream");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.COOKIE_DOUGH_MILKSHAKE.get(), 1), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.ICE_CREAM.get()}), Ingredient.of(ExtraDelightTags.COOKIE_DOUGH)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Holder)NeoForgeMod.MILK, 250))}, consumer, "cookie_dough_milkshake");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.COOKIE_DOUGH_MILKSHAKE.get(), 1), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.COOKIE_DOUGH_ICE_CREAM.get()})}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Holder)NeoForgeMod.MILK, 250))}, consumer, "cookie_dough_milkshake_ice_cream");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.MINT_CHIP_MILKSHAKE.get(), 1), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.ICE_CREAM.get()}), Ingredient.of(ExtraDelightTags.CHOCOLATE_CHIPS), Ingredient.of(ExtraDelightTags.MINT)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Holder)NeoForgeMod.MILK, 250))}, consumer, "mint_chip_milkshake");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.MINT_CHIP_MILKSHAKE.get(), 1), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.MINT_CHIP_ICE_CREAM.get()})}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Holder)NeoForgeMod.MILK, 250))}, consumer, "mint_chip_milkshake_ice_cream");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.SUGAR_COOKIE_DOUGH.get(), 1), 4, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.FLOUR), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.BUTTER), Ingredient.of((TagKey)Tags.Items.EGGS)}, new SizedFluidIngredient[0], consumer, "sugar_cookie_dough");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.APPLE_COOKIE_DOUGH.get(), 1), 4, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.FLOUR), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.BUTTER), Ingredient.of((TagKey)Tags.Items.EGGS), Ingredient.of(ExtraDelightTags.PROCESSED_APPLE), Ingredient.of(ExtraDelightTags.GROUND_CINNAMON)}, new SizedFluidIngredient[0], consumer, "apple_cookie_dough");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.APPLE_COOKIE_DOUGH.get(), 1), 4, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.SUGAR_COOKIE_DOUGH), Ingredient.of(ExtraDelightTags.PROCESSED_APPLE), Ingredient.of(ExtraDelightTags.GROUND_CINNAMON)}, new SizedFluidIngredient[0], consumer, "apple_cookie_dough_sugar");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.CHOCOLATE_CHIP_COOKIE_DOUGH.get(), 1), 4, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.FLOUR), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.BUTTER), Ingredient.of((TagKey)Tags.Items.EGGS), Ingredient.of(ExtraDelightTags.CHOCOLATE_CHIPS)}, new SizedFluidIngredient[0], consumer, "chocolate_chip_cookie_dough");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.CHOCOLATE_CHIP_COOKIE_DOUGH.get(), 1), 4, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.SUGAR_COOKIE_DOUGH), Ingredient.of(ExtraDelightTags.CHOCOLATE_CHIPS)}, new SizedFluidIngredient[0], consumer, "chocolate_chip_cookie_dough_sugar");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.GINGERBREAD_COOKIE_DOUGH.get(), 1), 4, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.FLOUR), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.BUTTER), Ingredient.of((TagKey)Tags.Items.EGGS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GRATED_GINGER.get()}), Ingredient.of(ExtraDelightTags.GROUND_CINNAMON)}, new SizedFluidIngredient[0], consumer, "gingerbread_cookie_dough");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.GINGERBREAD_COOKIE_DOUGH.get(), 1), 4, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.SUGAR_COOKIE_DOUGH), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GRATED_GINGER.get()}), Ingredient.of(ExtraDelightTags.GROUND_CINNAMON)}, new SizedFluidIngredient[0], consumer, "gingerbread_cookie_dough_sugar");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.GLOW_BERRY_COOKIE_DOUGH.get(), 1), 4, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.FLOUR), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.BUTTER), Ingredient.of((TagKey)Tags.Items.EGGS), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOW_BERRIES})}, new SizedFluidIngredient[0], consumer, "glow_berry_cookie_dough");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.GLOW_BERRY_COOKIE_DOUGH.get(), 1), 4, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.SUGAR_COOKIE_DOUGH), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOW_BERRIES})}, new SizedFluidIngredient[0], consumer, "glow_berry_cookie_dough_sugar");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.HONEY_COOKIE_DOUGH.get(), 1), 4, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.FLOUR), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.BUTTER), Ingredient.of((TagKey)Tags.Items.EGGS), Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEY_BOTTLE})}, new SizedFluidIngredient[0], consumer, "honey_cookie_dough");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.HONEY_COOKIE_DOUGH.get(), 1), 4, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.SUGAR_COOKIE_DOUGH), Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEY_BOTTLE})}, new SizedFluidIngredient[0], consumer, "honey_cookie_dough_sugar");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.PUMPKIN_COOKIE_DOUGH.get(), 1), 4, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.FLOUR), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.BUTTER), Ingredient.of((TagKey)Tags.Items.EGGS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PUMPKIN_SLICE.get()})}, new SizedFluidIngredient[0], consumer, "pumpkin_cookie_dough");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.PUMPKIN_COOKIE_DOUGH.get(), 1), 4, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.SUGAR_COOKIE_DOUGH), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PUMPKIN_SLICE.get()})}, new SizedFluidIngredient[0], consumer, "pumpkin_cookie_dough_sugar");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.SWEET_BERRY_COOKIE_DOUGH.get(), 1), 4, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.FLOUR), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.BUTTER), Ingredient.of((TagKey)Tags.Items.EGGS), Ingredient.of((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES})}, new SizedFluidIngredient[0], consumer, "sweet_berry_cookie_dough");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.SWEET_BERRY_COOKIE_DOUGH.get(), 1), 4, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.SUGAR_COOKIE_DOUGH), Ingredient.of((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES})}, new SizedFluidIngredient[0], consumer, "sweet_berry_cookie_dough_sugar");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.FROSTING_BLACK.get(), 4), 2, ItemStack.EMPTY, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BUTTER.get()}), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_BLACK)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250))}, consumer, "frosting_black");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.FROSTING_BLUE.get(), 4), 2, ItemStack.EMPTY, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BUTTER.get()}), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_BLUE)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250))}, consumer, "frosting_blue");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.FROSTING_BROWN.get(), 4), 2, ItemStack.EMPTY, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BUTTER.get()}), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_BROWN)}, new SizedFluidIngredient[0], consumer, "frosting_brown");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.FROSTING_CYAN.get(), 4), 2, ItemStack.EMPTY, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BUTTER.get()}), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_CYAN)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250))}, consumer, "frosting_cyan");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.FROSTING_GRAY.get(), 4), 2, ItemStack.EMPTY, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BUTTER.get()}), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_GRAY)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250))}, consumer, "frosting_gray");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.FROSTING_GREEN.get(), 4), 2, ItemStack.EMPTY, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BUTTER.get()}), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_GREEN)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250))}, consumer, "frosting_green");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.FROSTING_LIGHT_BLUE.get(), 4), 2, ItemStack.EMPTY, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BUTTER.get()}), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_LIGHT_BLUE)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250))}, consumer, "frosting_light_blue");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.FROSTING_LIGHT_GRAY.get(), 4), 2, ItemStack.EMPTY, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BUTTER.get()}), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_LIGHT_GRAY)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250))}, consumer, "frosting_light_gray");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.FROSTING_LIME.get(), 4), 2, ItemStack.EMPTY, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BUTTER.get()}), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_LIME)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250))}, consumer, "frosting_lime");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.FROSTING_MAGENTA.get(), 4), 2, ItemStack.EMPTY, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BUTTER.get()}), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_MAGENTA)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250))}, consumer, "frosting_magenta");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.FROSTING_ORANGE.get(), 4), 2, ItemStack.EMPTY, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BUTTER.get()}), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_ORANGE)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250))}, consumer, "frosting_orange");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.FROSTING_PINK.get(), 4), 2, ItemStack.EMPTY, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BUTTER.get()}), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_PINK)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250))}, consumer, "frosting_pink");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.FROSTING_PURPLE.get(), 4), 2, ItemStack.EMPTY, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BUTTER.get()}), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_PURPLE)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250))}, consumer, "frosting_purple");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.FROSTING_RED.get(), 4), 2, ItemStack.EMPTY, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BUTTER.get()}), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_RED)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250))}, consumer, "frosting_red");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.FROSTING_WHITE.get(), 4), 2, ItemStack.EMPTY, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BUTTER.get()}), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_WHITE)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250))}, consumer, "frosting_white");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.FROSTING_YELLOW.get(), 4), 2, ItemStack.EMPTY, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BUTTER.get()}), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_YELLOW)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250))}, consumer, "frosting_yellow");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.BEET_MINT_SALAD.get(), 2), 4, new ItemStack((ItemLike)Items.BOWL), new Ingredient[]{Ingredient.of(ExtraDelightTags.PROCESSED_BEETROOT), Ingredient.of(ExtraDelightTags.PROCESSED_BEETROOT), Ingredient.of(ExtraDelightTags.MINT), Ingredient.of(ExtraDelightTags.SWEETENER)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.OIL.FLUID, 250)), SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.VINEGAR.FLUID, 250))}, consumer, "beet_mint_salad");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.COFFEE_JELLY.get(), 2), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of(ExtraDelightTags.GELATIN), Ingredient.of(ExtraDelightTags.SWEETENER)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.COFFEE.FLUID, 250)), SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250))}, consumer, "coffee_jelly");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.MARSHMALLOW.get(), 4), 4, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.MALLOWROOT_POWDER), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.EGGS)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Fluid)Fluids.WATER, 250))}, consumer, "marshmallow");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.NOUGAT.get(), 4), 4, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.BUTTER), Ingredient.of((TagKey)Tags.Items.EGGS), Ingredient.of(ExtraDelightTags.ROASTED_NUTS)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Fluid)Fluids.WATER, 250))}, consumer, "nougat");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.GUMMIES.get(), 4), 4, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.GELATIN), Ingredient.of(ExtraDelightTags.GELATIN), Ingredient.of((TagKey)Tags.Items.DYES), Ingredient.of((TagKey)Tags.Items.DYES)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Fluid)Fluids.WATER, 100))}, consumer, "gummies");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_SYRUP_BOTTLE.get(), 1), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.COCOA_BUTTER.FLUID, 100)), SizedFluidIngredient.of((FluidStack)new FluidStack((Holder)NeoForgeMod.MILK, 100))}, consumer, "white_chocolate");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_SYRUP_BOTTLE.get(), 1), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.COCOA_SOLIDS)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.COCOA_BUTTER.FLUID, 100)), SizedFluidIngredient.of((FluidStack)new FluidStack((Holder)NeoForgeMod.MILK, 50))}, consumer, "milk_chocolate");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_SYRUP_BOTTLE.get(), 1), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.COCOA_SOLIDS), Ingredient.of(ExtraDelightTags.COCOA_SOLIDS)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.COCOA_BUTTER.FLUID, 100))}, consumer, "dark_chocolate");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_SYRUP_BOTTLE.get(), 1), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.COCOA_SOLIDS)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.COCOA_BUTTER.FLUID, 100)), SizedFluidIngredient.of(ExtraDelightTags.BLOOD, (int)50)}, consumer, "blood_chocolate");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.PULLED_PORK_FEAST_ITEM.get(), 1), 4, new ItemStack((ItemLike)Items.BOWL), new Ingredient[]{Ingredient.of(ExtraDelightTags.SCRAP_PORK_COOKED), Ingredient.of(ExtraDelightTags.SCRAP_PORK_COOKED), Ingredient.of(ExtraDelightTags.SCRAP_PORK_COOKED), Ingredient.of(ExtraDelightTags.SCRAP_PORK_COOKED)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.BBQ.FLUID, 250))}, consumer, "pulled_pork");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.HAZELNUT_SPREAD_BOTTLE.get(), 2), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER)}, new SizedFluidIngredient[]{SizedFluidIngredient.of(ExtraDelightTags.CHOCOLATE_FLUID, (int)250), SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.NUT_BUTTER.FLUID, 250))}, consumer, "hazelnut_spread");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.APPLE_SLAW.get(), 1), 4, new ItemStack((ItemLike)Items.BOWL), new Ingredient[]{Ingredient.of(ExtraDelightTags.PROCESSED_CABBAGE), Ingredient.of(ExtraDelightTags.SLICED_APPLE)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.MAYO.FLUID, 250)), SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.VINEGAR.FLUID, 250))}, consumer, "apple_slaw");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.CANDY_BAR_SALAD.get(), 1), 4, new ItemStack((ItemLike)Items.BOWL), new Ingredient[]{Ingredient.of(ExtraDelightTags.CHOCOLATE_BAR), Ingredient.of(ExtraDelightTags.SLICED_APPLE), Ingredient.of(ExtraDelightTags.CUSTARD), Ingredient.of(ExtraDelightTags.MARSHMALLOW)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.WHIPPED_CREAM.FLUID, 250)), SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.CARAMEL_SAUCE.FLUID, 250))}, consumer, "candy_bar_salad");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.NUT_BUTTER_COOKIE_DOUGH.get(), 1), 4, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.FLOUR), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.BUTTER), Ingredient.of((TagKey)Tags.Items.EGGS)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.NUT_BUTTER.FLUID, 250))}, consumer, "nut_butter_cookie_dough");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.NUT_BUTTER_COOKIE_DOUGH.get(), 1), 4, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.SUGAR_COOKIE_DOUGH)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.NUT_BUTTER.FLUID, 250))}, consumer, "nut_butter_cookie_dough_sugar");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.NUT_BUTTER_MILKSHAKE.get(), 1), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.ICE_CREAM.get()})}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.NUT_BUTTER.FLUID, 250)), SizedFluidIngredient.of((FluidStack)new FluidStack((Holder)NeoForgeMod.MILK, 250))}, consumer, "nut_butter_milkshake");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.NUT_BUTTER_MILKSHAKE.get(), 1), 4, new ItemStack((ItemLike)Items.GLASS_BOTTLE), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.NUT_BUTTER_ICE_CREAM.get()})}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack((Holder)NeoForgeMod.MILK, 250))}, consumer, "nut_butter_milkshake_ice_cream");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.CHOCOLATE_COOKIE_DOUGH.get(), 1), 4, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.FLOUR), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.BUTTER), Ingredient.of((TagKey)Tags.Items.EGGS), Ingredient.of(ExtraDelightTags.COCOA_POWDER)}, new SizedFluidIngredient[0], consumer, "chocolate_cookie_dough");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.CHOCOLATE_COOKIE_DOUGH.get(), 1), 4, ItemStack.EMPTY, new Ingredient[]{Ingredient.of(ExtraDelightTags.SUGAR_COOKIE_DOUGH), Ingredient.of(ExtraDelightTags.COCOA_POWDER)}, new SizedFluidIngredient[0], consumer, "chocolate_cookie_dough_sugar");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.POTATO_SALAD.get(), 2), 8, new ItemStack((ItemLike)Items.BOWL), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.BAKED_POTATO}), Ingredient.of((ItemLike[])new ItemLike[]{Items.BAKED_POTATO}), Ingredient.of(ExtraDelightTags.PROCESSED_ONION)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.MAYO.FLUID, 250))}, consumer, "potato_salad");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.AIOLI.get(), 1), 8, new ItemStack((ItemLike)Items.GLASS_BOTTLE), Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.WHISK}), new Ingredient[]{Ingredient.of(ExtraDelightTags.EGG_OR_YOLK), Ingredient.of(ExtraDelightTags.EGG_OR_YOLK), Ingredient.of(ExtraDelightTags.PROCESSED_GARLIC)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.VINEGAR.FLUID, 250)), SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.OIL.FLUID, 250))}, consumer, "aioli_from_scratch");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.AIOLI.get(), 1), 8, new ItemStack((ItemLike)Items.GLASS_BOTTLE), Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.WHISK}), new Ingredient[]{Ingredient.of(ExtraDelightTags.PROCESSED_GARLIC)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.MAYO.FLUID, 250))}, consumer, "aioli_cheaty");
        Recipes.mixing(new ItemStack((ItemLike)ExtraDelightItems.AGLIO_E_OLIO.get(), 1), 2, new ItemStack((ItemLike)Items.BOWL), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.COOKED_PASTA}), Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.ROASTED_GARLIC}), Ingredient.of(ExtraDelightTags.PROCESSED_CHILI), Ingredient.of(ExtraDelightTags.CHEESE)}, new SizedFluidIngredient[]{SizedFluidIngredient.of((FluidStack)new FluidStack(ExtraDelightFluids.OIL.FLUID, 250))}, consumer, "aglio_e_olio_mixing");
    }

    public static void mixing(@NotNull ItemStack output, int grind, ItemStack container, Ingredient[] ingredients, SizedFluidIngredient[] sizedFluidIngredients, RecipeOutput consumer, String rc) {
        MixingBowlRecipeBuilder b = MixingBowlRecipeBuilder.stir(output, grind, container);
        for (Ingredient ingredient : ingredients) {
            b.requires(ingredient);
        }
        for (Ingredient ingredient : sizedFluidIngredients) {
            b.requires((SizedFluidIngredient)ingredient);
        }
        b.unlockedBy(rc, Recipes.has((ItemLike)output.getItem()));
        b.save(consumer, Recipes.EDLoc(rc));
    }

    public static void mixing(@NotNull ItemStack output, int grind, ItemStack container, Ingredient utensil, Ingredient[] ingredients, SizedFluidIngredient[] sizedFluidIngredients, RecipeOutput consumer, String rc) {
        MixingBowlRecipeBuilder b = MixingBowlRecipeBuilder.stir(output, grind, container, utensil);
        for (Ingredient ingredient : ingredients) {
            b.requires(ingredient);
        }
        for (Ingredient ingredient : sizedFluidIngredients) {
            b.requires((SizedFluidIngredient)ingredient);
        }
        b.unlockedBy(rc, Recipes.has((ItemLike)output.getItem()));
        b.save(consumer, Recipes.EDLoc(rc));
    }

    private void craftingRecipes(RecipeOutput consumer) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.FRUIT_SALAD.get())).requires(ExtraDelightTags.PROCESSED_APPLE).requires(ExtraDelightTags.PROCESSED_MELON).requires(ExtraDelightTags.PROCESSED_MELON).requires(ExtraDelightTags.PROCESSED_FRUIT).requires(ExtraDelightTags.PROCESSED_FRUIT).requires((ItemLike)ModItems.PUMPKIN_SLICE.get()).requires((ItemLike)Items.GLASS_BOTTLE).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.GLOW_BERRIES})).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.MIXED_SALAD.get())).requires(ExtraDelightTags.PROCESSED_CABBAGE).requires(ExtraDelightTags.PROCESSED_TOMATO).requires(ExtraDelightTags.PROCESSED_BEETROOT).requires((ItemLike)Items.BOWL).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BOWL})).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.WHEAT_DOUGH.get()), (int)3).unlockedBy("has_wheat", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.WHEAT})).save(consumer.withConditions(new ICondition[]{FalseCondition.INSTANCE}));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.PIE_CRUST.get()), (int)1).unlockedBy("has_wheat", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.WHEAT})).save(consumer.withConditions(new ICondition[]{FalseCondition.INSTANCE}));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.APPLE_PIE.get()), (int)1).unlockedBy("has_wheat", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.WHEAT})).save(consumer.withConditions(new ICondition[]{FalseCondition.INSTANCE}));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.SWEET_BERRY_CHEESECAKE.get()), (int)1).unlockedBy("has_wheat", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.WHEAT})).save(consumer.withConditions(new ICondition[]{FalseCondition.INSTANCE}));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.SWEET_BERRY_COOKIE.get()), (int)1).unlockedBy("has_wheat", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.WHEAT})).save(consumer.withConditions(new ICondition[]{FalseCondition.INSTANCE}));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.HONEY_COOKIE.get()), (int)1).unlockedBy("has_wheat", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.WHEAT})).save(consumer.withConditions(new ICondition[]{FalseCondition.INSTANCE}));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.CHOCOLATE_PIE.get()), (int)1).unlockedBy("has_wheat", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.WHEAT})).save(consumer.withConditions(new ICondition[]{FalseCondition.INSTANCE}));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.MELON_POPSICLE.get()), (int)1).unlockedBy("has_wheat", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.WHEAT})).save(consumer.withConditions(new ICondition[]{FalseCondition.INSTANCE}));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.ROAST_CHICKEN_BLOCK.get()), (int)1).unlockedBy("has_wheat", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.WHEAT})).save(consumer.withConditions(new ICondition[]{FalseCondition.INSTANCE}));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.HONEY_GLAZED_HAM_BLOCK.get()), (int)1).unlockedBy("has_wheat", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.WHEAT})).save(consumer.withConditions(new ICondition[]{FalseCondition.INSTANCE}));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.SHEPHERDS_PIE_BLOCK.get()), (int)1).unlockedBy("has_wheat", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.WHEAT})).save(consumer.withConditions(new ICondition[]{FalseCondition.INSTANCE}));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CORN_COB_PIPE.get())).pattern("cs").define(Character.valueOf('c'), (ItemLike)ExtraDelightItems.CORN_COB.get()).define(Character.valueOf('s'), (ItemLike)Items.STICK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CORN_COB.get()})).save(consumer, Recipes.EDLoc("corn_cob_pipe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.OVEN.get())).pattern("bBb").pattern("BfB").pattern("BtB").define(Character.valueOf('b'), (ItemLike)Items.BRICK).define(Character.valueOf('B'), (ItemLike)Items.BRICKS).define(Character.valueOf('f'), (ItemLike)Items.FURNACE).define(Character.valueOf('t'), (ItemLike)Items.TERRACOTTA).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.FURNACE})).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.DOUGH_SHAPING.get())).requires((ItemLike)Items.STICK, 1).requires(ItemTags.PLANKS).requires(Ingredient.of(ExtraDelightTags.FLOUR)).unlockedBy(this.getName(), Recipes.has(ExtraDelightTags.FLOUR)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.DRYING_RACK.get())).pattern("WSW").pattern("SSS").pattern("WSW").define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('S'), Tags.Items.STRINGS).unlockedBy("has_string", Recipes.has((TagKey)Tags.Items.STRINGS)).save(consumer, Recipes.EDLoc("drying_rack"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.SHEET.get())).requires((ItemLike)Items.HEAVY_WEIGHTED_PRESSURE_PLATE, 1).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.HEAVY_WEIGHTED_PRESSURE_PLATE})).save(consumer, Recipes.EDLoc("sheet"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.TRAY.get())).requires((ItemLike)Items.HEAVY_WEIGHTED_PRESSURE_PLATE, 1).requires((ItemLike)Items.IRON_NUGGET).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.HEAVY_WEIGHTED_PRESSURE_PLATE})).save(consumer, Recipes.EDLoc("tray"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.LOAF_PAN.get())).requires((ItemLike)Items.HEAVY_WEIGHTED_PRESSURE_PLATE, 1).requires((ItemLike)Items.IRON_NUGGET, 2).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.HEAVY_WEIGHTED_PRESSURE_PLATE})).save(consumer, Recipes.EDLoc("loaf_pan"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.PIE_DISH.get())).requires((ItemLike)Items.HEAVY_WEIGHTED_PRESSURE_PLATE, 1).requires((ItemLike)Items.IRON_NUGGET, 3).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.HEAVY_WEIGHTED_PRESSURE_PLATE})).save(consumer, Recipes.EDLoc("pie_dish"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.MUFFIN_TIN.get())).requires((ItemLike)Items.HEAVY_WEIGHTED_PRESSURE_PLATE, 1).requires((ItemLike)Items.IRON_NUGGET, 6).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.HEAVY_WEIGHTED_PRESSURE_PLATE})).save(consumer, Recipes.EDLoc("muffin_tin"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BAKING_STONE.get())).requires((ItemLike)Items.STONE_PRESSURE_PLATE, 1).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.STONE_PRESSURE_PLATE})).save(consumer, Recipes.EDLoc("baking_stone"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.YEAST_POT.get())).requires((ItemLike)Items.FLOWER_POT, 1).requires((ItemLike)ModItems.CANVAS.get(), 1).requires(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.POTION}), Ingredient.of((TagKey)Tags.Items.BUCKETS_WATER)})).requires(ExtraDelightTags.SWEETENER).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.FLOWER_POT})).save(consumer, Recipes.EDLoc("yeast_pot"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.VINEGAR_POT.get())).requires((ItemLike)Items.FLOWER_POT, 1).requires((ItemLike)ModItems.CANVAS.get(), 1).requires(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.POTION}), Ingredient.of((TagKey)Tags.Items.BUCKETS_WATER)})).requires(ExtraDelightTags.SWEETENER).requires(Ingredient.of(ExtraDelightTags.FRUIT)).requires(Ingredient.of(ExtraDelightTags.FRUIT)).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.FLOWER_POT})).save(consumer, Recipes.EDLoc("vinegar_pot"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.MORTAR_STONE.get())).pattern("s s").pattern(" s ").define(Character.valueOf('s'), (ItemLike)Items.STONE).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.STONE})).save(consumer, Recipes.EDLoc("mortar_stone"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.PESTLE_ANDESITE.get())).pattern("s  ").pattern(" i ").define(Character.valueOf('s'), (ItemLike)Items.ANDESITE).define(Character.valueOf('i'), (ItemLike)Items.STICK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.ANDESITE})).save(consumer, Recipes.EDLoc("pestle_andesite"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.PESTLE_BASALT.get())).pattern("s  ").pattern(" i ").define(Character.valueOf('s'), (ItemLike)Items.BASALT).define(Character.valueOf('i'), (ItemLike)Items.STICK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BASALT})).save(consumer, Recipes.EDLoc("pestle_basalt"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.PESTLE_BLACKSTONE.get())).pattern("s  ").pattern(" i ").define(Character.valueOf('s'), (ItemLike)Items.BLACKSTONE).define(Character.valueOf('i'), (ItemLike)Items.STICK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BLACKSTONE})).save(consumer, Recipes.EDLoc("pestle_blackstone"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.PESTLE_DEEPSLATE.get())).pattern("s  ").pattern(" i ").define(Character.valueOf('s'), (ItemLike)Items.DEEPSLATE).define(Character.valueOf('i'), (ItemLike)Items.STICK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.DEEPSLATE})).save(consumer, Recipes.EDLoc("pestle_deepslate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.PESTLE_DIORITE.get())).pattern("s  ").pattern(" i ").define(Character.valueOf('s'), (ItemLike)Items.DIORITE).define(Character.valueOf('i'), (ItemLike)Items.STICK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.DIORITE})).save(consumer, Recipes.EDLoc("pestle_diorite"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.PESTLE_ENDSTONE.get())).pattern("s  ").pattern(" i ").define(Character.valueOf('s'), (ItemLike)Items.END_STONE).define(Character.valueOf('i'), (ItemLike)Items.STICK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.END_STONE})).save(consumer, Recipes.EDLoc("pestle_endstone"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.PESTLE_GRANITE.get())).pattern("s  ").pattern(" i ").define(Character.valueOf('s'), (ItemLike)Items.GRANITE).define(Character.valueOf('i'), (ItemLike)Items.STICK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.GRANITE})).save(consumer, Recipes.EDLoc("pestle_granite"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.PESTLE_STONE.get())).pattern("s  ").pattern(" i ").define(Character.valueOf('s'), (ItemLike)Items.STONE).define(Character.valueOf('i'), (ItemLike)Items.STICK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.STONE})).save(consumer, Recipes.EDLoc("pestle_stone"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.MIXING_BOWL.get())).pattern("w w").pattern("w w").pattern(" w ").define(Character.valueOf('w'), Ingredient.of((TagKey)ItemTags.PLANKS)).unlockedBy(this.getName(), Recipes.has((TagKey)ItemTags.PLANKS)).save(consumer, Recipes.EDLoc("mixing_bowl"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.WOODEN_SPOON.get())).pattern("  w").pattern(" s ").pattern("s  ").define(Character.valueOf('w'), Ingredient.of((TagKey)ItemTags.PLANKS)).define(Character.valueOf('s'), Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK})).unlockedBy(this.getName(), Recipes.has((TagKey)ItemTags.PLANKS)).save(consumer, Recipes.EDLoc("wooden_spoon"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.STONE_SPOON.get())).pattern("  w").pattern(" s ").pattern("s  ").define(Character.valueOf('w'), Ingredient.of((TagKey)Tags.Items.STONES)).define(Character.valueOf('s'), Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK})).unlockedBy(this.getName(), Recipes.has((TagKey)Tags.Items.STONES)).save(consumer, Recipes.EDLoc("stone_spoon"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.IRON_SPOON.get())).pattern("  w").pattern(" s ").pattern("s  ").define(Character.valueOf('w'), Ingredient.of((TagKey)Tags.Items.INGOTS_IRON)).define(Character.valueOf('s'), Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK})).unlockedBy(this.getName(), Recipes.has((TagKey)Tags.Items.INGOTS_IRON)).save(consumer, Recipes.EDLoc("iron_spoon"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.GOLD_SPOON.get())).pattern("  w").pattern(" s ").pattern("s  ").define(Character.valueOf('w'), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD)).define(Character.valueOf('s'), Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK})).unlockedBy(this.getName(), Recipes.has((TagKey)Tags.Items.INGOTS_GOLD)).save(consumer, Recipes.EDLoc("gold_spoon"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.DIAMOND_SPOON.get())).pattern("  w").pattern(" s ").pattern("s  ").define(Character.valueOf('w'), Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND)).define(Character.valueOf('s'), Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK})).unlockedBy(this.getName(), Recipes.has((TagKey)Tags.Items.GEMS_DIAMOND)).save(consumer, Recipes.EDLoc("diamond_spoon"));
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.DIAMOND_SPOON.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}), (RecipeCategory)RecipeCategory.FOOD, (Item)((Item)ExtraDelightItems.NETHERITE_SPOON.get())).unlocks("has_netherite_ingot", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT})).save(consumer, "extradelight:netherite_spoon_smithing");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.GRATER.get())).pattern(" p ").pattern("pip").pattern(" p ").define(Character.valueOf('i'), Ingredient.of((TagKey)Tags.Items.INGOTS_IRON)).define(Character.valueOf('p'), Ingredient.of((ItemLike[])new ItemLike[]{Items.HEAVY_WEIGHTED_PRESSURE_PLATE})).unlockedBy(this.getName(), Recipes.has((TagKey)Tags.Items.INGOTS_IRON)).save(consumer, Recipes.EDLoc("grater"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.LID.get())).pattern(" b ").pattern("ccc").define(Character.valueOf('b'), Ingredient.of((TagKey)ItemTags.WOODEN_BUTTONS)).define(Character.valueOf('c'), Ingredient.of((ItemLike[])new ItemLike[]{Items.COPPER_INGOT})).unlockedBy(this.getName(), Recipes.has((TagKey)Tags.Items.INGOTS_COPPER)).save(consumer, Recipes.EDLoc("lid"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.VAT.get())).pattern("c c").pattern("c c").pattern("ccc").define(Character.valueOf('c'), Ingredient.of((TagKey)Tags.Items.INGOTS_COPPER)).unlockedBy(this.getName(), Recipes.has((TagKey)Tags.Items.INGOTS_COPPER)).save(consumer, Recipes.EDLoc("vat"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.EVAPORATOR.get())).pattern("i i").pattern("ppp").define(Character.valueOf('i'), Ingredient.of((TagKey)Tags.Items.NUGGETS_IRON)).define(Character.valueOf('p'), Ingredient.of((ItemLike[])new ItemLike[]{Items.HEAVY_WEIGHTED_PRESSURE_PLATE})).unlockedBy(this.getName(), Recipes.has((TagKey)Tags.Items.NUGGETS_IRON)).save(consumer, Recipes.EDLoc("evaporator"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.JUICER.get())).pattern(" s ").pattern(" b ").pattern("ccc").define(Character.valueOf('s'), Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK})).define(Character.valueOf('b'), Ingredient.of((ItemLike[])new ItemLike[]{Items.BARREL})).define(Character.valueOf('c'), Ingredient.of((TagKey)Tags.Items.INGOTS_COPPER)).unlockedBy(this.getName(), Recipes.has((TagKey)Tags.Items.INGOTS_COPPER)).save(consumer, Recipes.EDLoc("juicer"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.WHISK.get())).pattern(" i ").pattern("iii").pattern(" s ").define(Character.valueOf('i'), Ingredient.of((TagKey)Tags.Items.NUGGETS_IRON)).define(Character.valueOf('s'), Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK})).unlockedBy(this.getName(), Recipes.has((TagKey)Tags.Items.NUGGETS_IRON)).save(consumer, Recipes.EDLoc("whisk"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.GLOW_BERRY_JUICE.get())).requires(Ingredient.of(ExtraDelightTags.FRUIT_GLOW_BERRY), 6).requires(ExtraDelightTags.SWEETENER).requires((ItemLike)Items.GLASS_BOTTLE).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.GLOW_BERRIES})).save(consumer, Recipes.EDLoc("glow_berry_juice"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.SWEET_BERRY_JUICE.get())).requires(Ingredient.of(ExtraDelightTags.FRUIT_SWEET_BERRY), 6).requires(ExtraDelightTags.SWEETENER).requires((ItemLike)Items.GLASS_BOTTLE).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES})).save(consumer, Recipes.EDLoc("sweet_berry_juice"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.TOMATO_JUICE.get())).requires(Ingredient.of((TagKey)CommonTags.CROPS_TOMATO), 2).requires(ExtraDelightTags.SWEETENER).requires((ItemLike)Items.GLASS_BOTTLE).unlockedBy(this.getName(), Recipes.has((TagKey)CommonTags.CROPS_TOMATO)).save(consumer, Recipes.EDLoc("tomato_juice"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CACTUS_JUICE.get())).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CACTUS.get()}), 2).requires(ExtraDelightTags.SWEETENER).requires((ItemLike)Items.GLASS_BOTTLE).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CACTUS.get()})).save(consumer, Recipes.EDLoc("cactus_juice"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.SWEET_BERRY_PIE_ITEM.get())).pattern("ff ").pattern("ff ").define(Character.valueOf('f'), (ItemLike)ExtraDelightItems.SWEET_BERRY_PIE_SLICE.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.SWEET_BERRY_PIE_ITEM.get()})).save(consumer, Recipes.EDLoc("sweet_berry_pie_slice"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.GLOW_BERRY_PIE_ITEM.get())).pattern("ff ").pattern("ff ").define(Character.valueOf('f'), (ItemLike)ExtraDelightItems.GLOW_BERRY_PIE_SLICE.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GLOW_BERRY_PIE_ITEM.get()})).save(consumer, Recipes.EDLoc("glow_berry_pie_slice"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CHEESECAKE_ITEM.get())).pattern("ff ").pattern("ff ").define(Character.valueOf('f'), (ItemLike)ExtraDelightItems.CHEESECAKE_SLICE.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CHEESECAKE_ITEM.get()})).save(consumer, Recipes.EDLoc("cheesecake_slice"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.HONEY_CHEESECAKE_ITEM.get())).pattern("ff ").pattern("ff ").define(Character.valueOf('f'), (ItemLike)ExtraDelightItems.HONEY_CHEESECAKE_SLICE.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.HONEY_CHEESECAKE_ITEM.get()})).save(consumer, Recipes.EDLoc("honey_cheesecake_slice"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CHOCOLATE_CHEESECAKE_ITEM.get())).pattern("ff ").pattern("ff ").define(Character.valueOf('f'), (ItemLike)ExtraDelightItems.CHOCOLATE_CHEESECAKE_SLICE.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CHOCOLATE_CHEESECAKE_ITEM.get()})).save(consumer, Recipes.EDLoc("chocolate_cheesecake_slice"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.PUMPKIN_CHEESECAKE_ITEM.get())).pattern("ff ").pattern("ff ").define(Character.valueOf('f'), (ItemLike)ExtraDelightItems.PUMPKIN_CHEESECAKE_SLICE.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.PUMPKIN_CHEESECAKE_ITEM.get()})).save(consumer, Recipes.EDLoc("pumpkin_cheesecake_slice"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.GLOW_BERRY_CHEESECAKE_ITEM.get())).pattern("ff ").pattern("ff ").define(Character.valueOf('f'), (ItemLike)ExtraDelightItems.GLOW_BERRY_CHEESECAKE_SLICE.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GLOW_BERRY_CHEESECAKE_ITEM.get()})).save(consumer, Recipes.EDLoc("glow_berry_cheesecake_slice"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.APPLE_CHEESECAKE_ITEM.get())).pattern("ff ").pattern("ff ").define(Character.valueOf('f'), (ItemLike)ExtraDelightItems.APPLE_CHEESECAKE_SLICE.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.APPLE_CHEESECAKE_SLICE.get()})).save(consumer, Recipes.EDLoc("apple_cheesecake_slice"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.QUICHE.get())).pattern("ff ").pattern("ff ").define(Character.valueOf('f'), (ItemLike)ExtraDelightItems.QUICHE_SLICE.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.QUICHE.get()})).save(consumer, Recipes.EDLoc("quiche_slice"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.FUDGE_POPSICLE.get())).pattern(" cm").pattern("isc").pattern("Si ").define(Character.valueOf('m'), CommonTags.FOODS_MILK).define(Character.valueOf('c'), ExtraDelightTags.COCOA_POWDER).define(Character.valueOf('s'), ExtraDelightTags.SWEETENER).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('i'), (ItemLike)Items.ICE).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.ICE})).save(consumer, Recipes.EDLoc("fudge_popsicle"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.HONEY_POPSICLE.get())).pattern(" cm").pattern("imc").pattern("Si ").define(Character.valueOf('m'), CommonTags.FOODS_MILK).define(Character.valueOf('c'), (ItemLike)Items.HONEY_BOTTLE).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('i'), (ItemLike)Items.ICE).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.ICE})).save(consumer, Recipes.EDLoc("honey_popsicle"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.GLOW_BERRY_POPSICLE.get())).pattern(" gg").pattern("igg").pattern("Si ").define(Character.valueOf('g'), (ItemLike)Items.GLOW_BERRIES).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('i'), (ItemLike)Items.ICE).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.ICE})).save(consumer, Recipes.EDLoc("glow_berry_popsicle"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.SWEET_BERRY_POPSICLE.get())).pattern(" gg").pattern("igg").pattern("Si ").define(Character.valueOf('g'), (ItemLike)Items.SWEET_BERRIES).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('i'), (ItemLike)Items.ICE).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.ICE})).save(consumer, Recipes.EDLoc("sweet_berry_popsicle"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.APPLE_POPSICLE.get())).pattern(" gg").pattern("igg").pattern("Si ").define(Character.valueOf('g'), ExtraDelightTags.PROCESSED_APPLE).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('i'), (ItemLike)Items.ICE).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.ICE})).save(consumer, Recipes.EDLoc("apple_popsicle"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.OMELETTE_MIX.get())).requires((ItemLike)ExtraDelightItems.EGG_MIX.get(), 1).requires(Ingredient.of(ExtraDelightTags.PROCESSED_VEG), 2).unlockedBy(this.getName(), Recipes.has((TagKey)Tags.Items.FOODS_VEGETABLE)).save(consumer, Recipes.EDLoc("omelette_mix_veg"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.OMELETTE_MIX.get())).requires((ItemLike)ExtraDelightItems.EGG_MIX.get(), 1).requires(Ingredient.of(ExtraDelightTags.PROCESSED_VEG), 1).requires(Ingredient.of(ExtraDelightTags.MEAT), 1).unlockedBy(this.getName(), Recipes.has((TagKey)Tags.Items.FOODS_VEGETABLE)).save(consumer, Recipes.EDLoc("omelette_mix_mix"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.OMELETTE_MIX.get())).requires((ItemLike)ExtraDelightItems.EGG_MIX.get(), 1).requires(Ingredient.of(ExtraDelightTags.MEAT), 2).unlockedBy(this.getName(), Recipes.has(ExtraDelightTags.MEAT)).save(consumer, Recipes.EDLoc("omelette_mix_meat"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.OMELETTE_MIX.get())).requires((ItemLike)ExtraDelightItems.EGG_MIX.get(), 1).requires(Ingredient.of(ExtraDelightTags.CHEESE), 1).unlockedBy(this.getName(), Recipes.has(ExtraDelightTags.CHEESE)).save(consumer, Recipes.EDLoc("omelette_mix_cheese"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.OMELETTE_MIX.get())).requires((ItemLike)ExtraDelightItems.EGG_MIX.get(), 1).requires(Ingredient.of(ExtraDelightTags.PROCESSED_VEG), 2).requires(Ingredient.of(ExtraDelightTags.CHEESE), 1).unlockedBy(this.getName(), Recipes.has((TagKey)Tags.Items.FOODS_VEGETABLE)).save(consumer, Recipes.EDLoc("omelette_mix_veg_cheese"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.OMELETTE_MIX.get())).requires((ItemLike)ExtraDelightItems.EGG_MIX.get(), 1).requires(Ingredient.of((TagKey)Tags.Items.FOODS_VEGETABLE), 1).requires(Ingredient.of(ExtraDelightTags.CHEESE), 1).requires(Ingredient.of(ExtraDelightTags.MEAT), 1).unlockedBy(this.getName(), Recipes.has(ExtraDelightTags.PROCESSED_VEG)).save(consumer, Recipes.EDLoc("omelette_mix_mix_cheese"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.OMELETTE_MIX.get())).requires((ItemLike)ExtraDelightItems.EGG_MIX.get(), 1).requires(Ingredient.of(ExtraDelightTags.MEAT), 2).requires(Ingredient.of(ExtraDelightTags.CHEESE), 1).unlockedBy(this.getName(), Recipes.has(ExtraDelightTags.MEAT)).save(consumer, Recipes.EDLoc("omelette_mix_meat_cheese"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.EGG_SALAD_SANDWICH.get())).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.EGG_SALAD.get()})).requires(Ingredient.of((TagKey)Tags.Items.FOODS_BREAD)).unlockedBy(this.getName(), Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.EGG_SALAD.get()))).save(consumer, Recipes.EDLoc("egg_salad_sandwich"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.EGG_SALAD_SANDWICH.get())).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.EGG_SALAD.get()})).requires(Ingredient.of(ExtraDelightTags.BREAD_SLICE), 2).unlockedBy(this.getName(), Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.EGG_SALAD.get()))).save(consumer, Recipes.EDLoc("egg_salad_sandwich_slice"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CHEESE_BLOCK_ITEM.get())).requires(Ingredient.of(ExtraDelightTags.CHEESE), 9).unlockedBy(this.getName(), Recipes.has(ExtraDelightTags.CHEESE)).save(consumer, Recipes.EDLoc("cheese_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CHEESE_SLAB_BLOCK_ITEM.get()), (int)6).pattern("ppp").define(Character.valueOf('p'), (ItemLike)ExtraDelightItems.CHEESE_BLOCK_ITEM.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CHEESE_BLOCK_ITEM.get()})).save(consumer, Recipes.EDLoc("cheese_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CHEESE_STAIRS_BLOCK_ITEM.get()), (int)4).pattern("p  ").pattern("pp ").pattern("ppp").define(Character.valueOf('p'), (ItemLike)ExtraDelightItems.CHEESE_BLOCK_ITEM.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CHEESE_BLOCK_ITEM.get()})).save(consumer, Recipes.EDLoc("cheese_stairs"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BUTTER_BLOCK_ITEM.get())).requires(Ingredient.of(ExtraDelightTags.BUTTER), 9).unlockedBy(this.getName(), Recipes.has(ExtraDelightTags.BUTTER)).save(consumer, Recipes.EDLoc("butter_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BUTTER_SLAB_BLOCK_ITEM.get()), (int)6).pattern("ppp").define(Character.valueOf('p'), (ItemLike)ExtraDelightItems.BUTTER_BLOCK_ITEM.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BUTTER_BLOCK_ITEM.get()})).save(consumer, Recipes.EDLoc("butters_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BUTTER_STAIRS_BLOCK_ITEM.get()), (int)4).pattern("p  ").pattern("pp ").pattern("ppp").define(Character.valueOf('p'), (ItemLike)ExtraDelightItems.BUTTER_BLOCK_ITEM.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BUTTER_BLOCK_ITEM.get()})).save(consumer, Recipes.EDLoc("butter_stairs"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CHEESE.get()), (int)9).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CHEESE_BLOCK_ITEM.get()})).unlockedBy(this.getName(), Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.CHEESE_BLOCK_ITEM.get()))).save(consumer, Recipes.EDLoc("cheese_block_to_item"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BUTTER.get()), (int)9).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BUTTER_BLOCK_ITEM.get()})).unlockedBy(this.getName(), Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.BUTTER_BLOCK_ITEM.get()))).save(consumer, Recipes.EDLoc("butter_block_to_item"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CHEESE_SANDWICH.get())).pattern(" b ").pattern("mc ").pattern(" b ").define(Character.valueOf('c'), ExtraDelightTags.CHEESE).define(Character.valueOf('m'), CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of(ExtraDelightTags.MAYO), Ingredient.of(ExtraDelightTags.BUTTER), Ingredient.of(ExtraDelightTags.AIOLI)})).define(Character.valueOf('b'), ExtraDelightTags.BREAD_SLICE).unlockedBy(this.getName(), Recipes.has(ExtraDelightTags.CHEESE)).save(consumer, Recipes.EDLoc("cheese_sandwich"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.MEAT_PIE_BLOCK_ITEM.get())).pattern("ss ").pattern("ss ").define(Character.valueOf('s'), (ItemLike)ExtraDelightItems.MEAT_PIE_SLICE.get()).unlockedBy(this.getName(), Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.MEAT_PIE_SLICE.get()))).save(consumer, Recipes.EDLoc("meat_pie_slice"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.PORK_TENDERLOIN_SANDWICH.get())).pattern(" b ").pattern("cm ").pattern(" b ").define(Character.valueOf('c'), CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of(ExtraDelightTags.CONDIMENTS), Ingredient.of(ExtraDelightTags.GRAVY)})).define(Character.valueOf('m'), (ItemLike)ExtraDelightItems.PORK_TENDERLOIN.get()).define(Character.valueOf('b'), ExtraDelightTags.BREAD_SLICE).unlockedBy(this.getName(), Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.PORK_TENDERLOIN.get()))).save(consumer, Recipes.EDLoc("pork_tenderloin_sandwich_bread_slice"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.PORK_TENDERLOIN_SANDWICH.get()), (int)1).requires(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of(ExtraDelightTags.CONDIMENTS), Ingredient.of(ExtraDelightTags.GRAVY)})).requires(Ingredient.of((TagKey)Tags.Items.FOODS_BREAD)).requires((ItemLike)ExtraDelightItems.PORK_TENDERLOIN.get()).unlockedBy(this.getName(), Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.PORK_TENDERLOIN.get()))).save(consumer, Recipes.EDLoc("pork_tenderloin_sandwich"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.FURIKAKE_RICE.get()), (int)1).requires((ItemLike)ExtraDelightItems.FURIKAKE.get()).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COOKED_RICE.get()})).unlockedBy(this.getName(), Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.FURIKAKE.get()))).save(consumer, Recipes.EDLoc("furikake_rice"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.FISH_AND_CHIPS.get()), (int)1).requires((ItemLike)ExtraDelightItems.FRIED_FISH.get()).requires((ItemLike)ExtraDelightItems.FRENCH_FRIES.get()).requires(ExtraDelightTags.VINEGAR).unlockedBy(this.getName(), Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.FRIED_FISH.get()))).save(consumer, Recipes.EDLoc("fish_and_chips"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BREADING_MISANPLAS.get()), (int)1).requires(ExtraDelightTags.FLOUR).requires((ItemLike)ExtraDelightItems.EGG_MIX.get()).requires(ExtraDelightTags.BREAD_CRUMBS).requires(ExtraDelightTags.FRYING_OIL).unlockedBy(this.getName(), Recipes.has(ExtraDelightTags.BREAD_CRUMBS)).save(consumer, Recipes.EDLoc("breading_misanplas"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.MUSHROOM_BURGER.get()), (int)1).requires(Tags.Items.FOODS_BREAD).requires((ItemLike)ModItems.BEEF_PATTY.get()).requires(Tags.Items.MUSHROOMS).requires(Tags.Items.MUSHROOMS).requires(ExtraDelightTags.CHEESE).unlockedBy(this.getName(), Recipes.has((TagKey)Tags.Items.MUSHROOMS)).save(consumer, Recipes.EDLoc("mushroom_burger"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CHEESEBURGER.get()), (int)1).requires(Tags.Items.FOODS_BREAD).requires((ItemLike)ModItems.BEEF_PATTY.get()).requires(CommonTags.CROPS_CABBAGE).requires(ExtraDelightTags.CHEESE).requires(ExtraDelightTags.PROCESSED_TOMATO).requires(ExtraDelightTags.PROCESSED_ONION).requires(ExtraDelightTags.PROCESSED_PICKLED_CUCUMBER).unlockedBy(this.getName(), Recipes.has((ItemLike)((ItemLike)ModItems.BEEF_PATTY.get()))).save(consumer, Recipes.EDLoc("cheeseburger"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CHEESEBURGER.get()), (int)1).requires((ItemLike)ModItems.HAMBURGER.get()).requires(ExtraDelightTags.PROCESSED_PICKLED_CUCUMBER).requires(ExtraDelightTags.CHEESE).unlockedBy(this.getName(), Recipes.has((ItemLike)((ItemLike)ModItems.HAMBURGER.get()))).save(consumer, Recipes.EDLoc("cheeseburger_burger"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BACON_CHEESEBURGER.get()), (int)1).requires(Tags.Items.FOODS_BREAD).requires((ItemLike)ModItems.BEEF_PATTY.get()).requires(CommonTags.CROPS_CABBAGE).requires(ExtraDelightTags.CHEESE).requires(ExtraDelightTags.PROCESSED_TOMATO).requires(ExtraDelightTags.PROCESSED_ONION).requires(CommonTags.FOODS_COOKED_BACON).requires(ExtraDelightTags.PROCESSED_PICKLED_CUCUMBER).unlockedBy(this.getName(), Recipes.has((ItemLike)((ItemLike)ModItems.BEEF_PATTY.get()))).save(consumer, Recipes.EDLoc("bacon_cheeseburger"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BACON_CHEESEBURGER.get()), (int)1).requires((ItemLike)ModItems.HAMBURGER.get()).requires(ExtraDelightTags.CHEESE).requires(CommonTags.FOODS_COOKED_BACON).requires(ExtraDelightTags.PROCESSED_PICKLED_CUCUMBER).unlockedBy(this.getName(), Recipes.has((ItemLike)((ItemLike)ModItems.HAMBURGER.get()))).save(consumer, Recipes.EDLoc("bacon_cheeseburger_burger"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BACON_CHEESEBURGER.get()), (int)1).requires((ItemLike)ExtraDelightItems.CHEESEBURGER.get()).requires(CommonTags.FOODS_COOKED_BACON).unlockedBy(this.getName(), Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.CHEESEBURGER.get()))).save(consumer, Recipes.EDLoc("bacon_cheeseburger_cheeseburger"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BACON_EGG_SANDWICH.get()), (int)1).requires((ItemLike)ModItems.EGG_SANDWICH.get()).requires(CommonTags.FOODS_COOKED_BACON).requires(CommonTags.FOODS_COOKED_BACON).unlockedBy(this.getName(), Recipes.has((TagKey)CommonTags.FOODS_COOKED_BACON)).save(consumer, Recipes.EDLoc("bacon_egg_sandwich"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BACON_EGG_SANDWICH.get()), (int)1).requires(Tags.Items.FOODS_BREAD).requires(CommonTags.FOODS_COOKED_BACON).requires(CommonTags.FOODS_COOKED_BACON).requires(CommonTags.FOODS_COOKED_EGG).requires(CommonTags.FOODS_COOKED_EGG).unlockedBy(this.getName(), Recipes.has((TagKey)CommonTags.FOODS_COOKED_BACON)).save(consumer, Recipes.EDLoc("bacon_egg_sandwich_full"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BACON_EGG_CHEESE_SANDWICH.get()), (int)1).requires((ItemLike)ModItems.EGG_SANDWICH.get()).requires(CommonTags.FOODS_COOKED_BACON).requires(CommonTags.FOODS_COOKED_BACON).requires(ExtraDelightTags.CHEESE).unlockedBy(this.getName(), Recipes.has(ExtraDelightTags.CHEESE)).save(consumer, Recipes.EDLoc("bacon_egg_cheese_sandwich_egg"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BACON_EGG_CHEESE_SANDWICH.get()), (int)1).requires((ItemLike)ExtraDelightItems.BACON_EGG_SANDWICH.get()).requires(ExtraDelightTags.CHEESE).unlockedBy(this.getName(), Recipes.has(ExtraDelightTags.CHEESE)).save(consumer, Recipes.EDLoc("bacon_egg_cheese_sandwich_egg_bacon"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BACON_EGG_CHEESE_SANDWICH.get()), (int)1).requires(Tags.Items.FOODS_BREAD).requires(CommonTags.FOODS_COOKED_BACON).requires(CommonTags.FOODS_COOKED_BACON).requires(CommonTags.FOODS_COOKED_EGG).requires(CommonTags.FOODS_COOKED_EGG).requires(ExtraDelightTags.CHEESE).unlockedBy(this.getName(), Recipes.has(ExtraDelightTags.CHEESE)).save(consumer, Recipes.EDLoc("bacon_egg_cheese_sandwich_full"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.RICEBALL.get()), (int)2).requires((ItemLike)ModItems.COOKED_RICE.get()).requires((ItemLike)Items.DRIED_KELP).requires((ItemLike)ExtraDelightItems.FISH_FLAKES.get()).unlockedBy(this.getName(), Recipes.has((ItemLike)((ItemLike)ModItems.COOKED_RICE.get()))).save(consumer, Recipes.EDLoc("riceball"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.RICEBALL_FILLED.get()), (int)1).requires((ItemLike)ModItems.COOKED_RICE.get()).requires((ItemLike)Items.DRIED_KELP).requires((ItemLike)ExtraDelightItems.FISH_FLAKES.get()).requires(ExtraDelightTags.RICEBALL_FILLING).unlockedBy(this.getName(), Recipes.has((ItemLike)((ItemLike)ModItems.COOKED_RICE.get()))).save(consumer, Recipes.EDLoc("riceball_filled"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.FISH_SALAD_SANDWICH.get()), (int)1).requires((ItemLike)ExtraDelightItems.FISH_SALAD.get()).requires((ItemLike)Items.BREAD).unlockedBy(this.getName(), Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.FISH_SALAD.get()))).save(consumer, Recipes.EDLoc("fish_salad_sandwich"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.FISH_SALAD_SANDWICH.get()), (int)1).requires((ItemLike)ExtraDelightItems.FISH_SALAD.get()).requires(Ingredient.of(ExtraDelightTags.BREAD_SLICE), 2).unlockedBy(this.getName(), Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.FISH_SALAD.get()))).save(consumer, Recipes.EDLoc("fish_salad_sandwich_slice"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CACTUS_EGGS.get()), (int)1).requires(ExtraDelightTags.COOKED_CACTUS).requires((ItemLike)ExtraDelightItems.SCRAMBLED_EGGS.get(), 1).unlockedBy(this.getName(), Recipes.has(ExtraDelightTags.COOKED_CACTUS)).save(consumer, Recipes.EDLoc("cooked_cactus"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CARAMEL_POPCORN.get()), (int)1).requires(ExtraDelightTags.POPCORN).requires((ItemLike)ExtraDelightItems.CARAMEL_SAUCE.get(), 1).requires((ItemLike)Items.BOWL).unlockedBy(this.getName(), Recipes.has(ExtraDelightTags.POPCORN)).save(consumer, Recipes.EDLoc("caramel_popcorn"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CARAMEL_POPSICLE.get())).pattern(" cm").pattern("isc").pattern("Si ").define(Character.valueOf('m'), CommonTags.FOODS_MILK).define(Character.valueOf('c'), (ItemLike)ExtraDelightItems.CARAMEL_SAUCE.get()).define(Character.valueOf('s'), ExtraDelightTags.SWEETENER).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('i'), (ItemLike)Items.ICE).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.ICE})).save(consumer, Recipes.EDLoc("caramel_popsicle"));
        Recipes.bundleItem9(Ingredient.of(ExtraDelightTags.FLOUR), (Item)ExtraDelightItems.FLOUR_SACK.get(), (Item)ExtraDelightItems.FLOUR.get(), consumer, "flour");
        Recipes.bundleItem9(Ingredient.of(ExtraDelightTags.CORN_MEAL), (Item)ExtraDelightItems.CORNMEAL_SACK.get(), (Item)ExtraDelightItems.CORN_MEAL.get(), consumer, "cornmeal");
        Recipes.bundleItem9(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR}), (Item)ExtraDelightItems.SUGAR_SACK.get(), Items.SUGAR, consumer, "sugar");
        Recipes.bundleItem9(Ingredient.of(ExtraDelightTags.CORN_ON_COB), (Item)ExtraDelightItems.CORN_CRATE.get(), (Item)ExtraDelightItems.CORN_ON_COB.get(), consumer, "corn");
        Recipes.bundleItem9(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CORN_HUSK.get()}), (Item)ExtraDelightItems.CORN_HUSK_BUNDLE.get(), (Item)ExtraDelightItems.CORN_HUSK.get(), consumer, "corn_husk");
        Recipes.bundleItem9(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.DRIED_CORN_HUSK.get()}), (Item)ExtraDelightItems.DRIED_CORN_HUSK_BUNDLE.get(), (Item)ExtraDelightItems.DRIED_CORN_HUSK.get(), consumer, "dried_corn_husk");
        Recipes.bundleItem9(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CORN_COB.get()}), (Item)ExtraDelightItems.CORN_COB_BUNDLE.get(), (Item)ExtraDelightItems.CORN_COB.get(), consumer, "corn_cob");
        Recipes.bundleItem9(Ingredient.of(ExtraDelightTags.GINGER), (Item)ExtraDelightItems.GINGER_CRATE.get(), (Item)ExtraDelightItems.GINGER.get(), consumer, "ginger");
        Recipes.bundleItem9(Ingredient.of((TagKey)Tags.Items.EGGS), (Item)ExtraDelightItems.EGG_CRATE.get(), Items.EGG, consumer, "egg");
        Recipes.bundleItem9(Ingredient.of((ItemLike[])new ItemLike[]{Items.APPLE}), (Item)ExtraDelightItems.APPLE_CRATE.get(), Items.APPLE, consumer, "apple");
        Recipes.bundleItem9(Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE}), (Item)ExtraDelightItems.GOLDEN_APPLE_CRATE.get(), Items.GOLDEN_APPLE, consumer, "golden_apple");
        Recipes.bundleItem9(Ingredient.of((ItemLike[])new ItemLike[]{Items.BROWN_MUSHROOM}), (Item)ExtraDelightItems.BROWN_MUSHROOM_CRATE.get(), Items.BROWN_MUSHROOM, consumer, "brown_mushroom");
        Recipes.bundleItem9(Ingredient.of((ItemLike[])new ItemLike[]{Items.RED_MUSHROOM}), (Item)ExtraDelightItems.RED_MUSHROOM_CRATE.get(), Items.RED_MUSHROOM, consumer, "red_mushroom");
        Recipes.bundleItem9(Ingredient.of((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES}), (Item)ExtraDelightItems.SWEET_BERRY_CRATE.get(), Items.SWEET_BERRIES, consumer, "sweet_berries");
        Recipes.bundleItem9(Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOW_BERRIES}), (Item)ExtraDelightItems.GLOW_BERRY_CRATE.get(), Items.GLOW_BERRIES, consumer, "glow_berries");
        Recipes.bundleItem9(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.CORN_SILK}), (Item)ExtraDelightItems.CORN_SILK_SACK.get(), (Item)ExtraDelightItems.CORN_SILK.get(), consumer, "corn_silk");
        Recipes.bundleItem9(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.GROUND_CINNAMON}), (Item)ExtraDelightItems.GROUND_CINNAMON_BLOCK_ITEM.get(), (Item)ExtraDelightItems.GROUND_CINNAMON.get(), consumer, "ground_cinnamon");
        Recipes.bundleItem9(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.RAW_CINNAMON}), (Item)ExtraDelightItems.RAW_CINNAMON_BLOCK.get(), (Item)ExtraDelightItems.RAW_CINNAMON.get(), consumer, "raw_cinnamon");
        Recipes.bundleItem9(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.CINNAMON_STICK}), (Item)ExtraDelightItems.CINNAMON_STICK_BLOCK.get(), (Item)ExtraDelightItems.CINNAMON_STICK.get(), consumer, "cinnamon_stick");
        Recipes.bundleItem9(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.BREAD_CRUMBS}), (Item)ExtraDelightItems.BREADCRUMB_SACK.get(), (Item)ExtraDelightItems.BREAD_CRUMBS.get(), consumer, "breadcrumbs");
        Recipes.bundleItem9(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.MINT}), (Item)ExtraDelightItems.MINT_SACK.get(), (Item)ExtraDelightItems.MINT.get(), consumer, "mint");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CHOCOLATE_MILK.get()), (int)1).requires((ItemLike)ModItems.MILK_BOTTLE.get()).requires(ExtraDelightTags.COCOA_POWDER).unlockedBy(this.getName(), Recipes.has((ItemLike)((ItemLike)ModItems.MILK_BOTTLE.get()))).save(consumer, Recipes.EDLoc("chocolate_milk"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CHOCOLATE_MILK.get()), (int)4).requires((ItemLike)Items.MILK_BUCKET).requires(ExtraDelightTags.COCOA_POWDER).requires(ExtraDelightTags.COCOA_POWDER).requires(ExtraDelightTags.COCOA_POWDER).requires(ExtraDelightTags.COCOA_POWDER).requires((ItemLike)Items.GLASS_BOTTLE, 4).unlockedBy(this.getName(), Recipes.has((ItemLike)Items.MILK_BUCKET)).save(consumer, Recipes.EDLoc("chocolate_milk_bucket"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.OFFSET_SPATULA_DIAMOND.get())).pattern(" is").pattern("i  ").define(Character.valueOf('i'), (ItemLike)Items.DIAMOND).define(Character.valueOf('s'), (ItemLike)Items.STICK).unlockedBy(this.getName(), Recipes.has((ItemLike)Items.DIAMOND)).save(consumer, Recipes.EDLoc("offset_spatula_diamond"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.OFFSET_SPATULA_GOLD.get())).pattern(" is").pattern("i  ").define(Character.valueOf('i'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('s'), (ItemLike)Items.STICK).unlockedBy(this.getName(), Recipes.has((ItemLike)Items.GOLD_INGOT)).save(consumer, Recipes.EDLoc("offset_spatula_gold"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.OFFSET_SPATULA_IRON.get())).pattern(" is").pattern("i  ").define(Character.valueOf('i'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('s'), (ItemLike)Items.STICK).unlockedBy(this.getName(), Recipes.has((ItemLike)Items.IRON_INGOT)).save(consumer, Recipes.EDLoc("offset_spatula_iron"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.OFFSET_SPATULA_WOOD.get())).pattern(" is").pattern("i  ").define(Character.valueOf('i'), ItemTags.PLANKS).define(Character.valueOf('s'), (ItemLike)Items.STICK).unlockedBy(this.getName(), Recipes.has((TagKey)ItemTags.PLANKS)).save(consumer, Recipes.EDLoc("offset_spatula_wood"));
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.OFFSET_SPATULA_DIAMOND.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}), (RecipeCategory)RecipeCategory.FOOD, (Item)((Item)ExtraDelightItems.OFFSET_SPATULA_NETHERITE.get())).unlocks("has_netherite_ingot", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT})).save(consumer, "extradelight:netherite_offset_spatula_smithing");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CANDY_BOWL_ITEM.get())).pattern("gbg").pattern(" g ").define(Character.valueOf('g'), (ItemLike)Items.GLASS).define(Character.valueOf('b'), (ItemLike)Items.BOWL).unlockedBy(this.getName(), Recipes.has((ItemLike)Items.GLASS)).save(consumer, Recipes.EDLoc("candy_bowl"));
        Recipes.bundleItem4(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.MINT_CANDY_BLUE.get()}), (Item)ExtraDelightItems.CANDY_CANE_BLUE.get(), (Item)ExtraDelightItems.MINT_CANDY_BLUE.get(), consumer, "mint_candy_blue");
        Recipes.bundleItem4(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.MINT_CANDY_GREEN.get()}), (Item)ExtraDelightItems.CANDY_CANE_GREEN.get(), (Item)ExtraDelightItems.MINT_CANDY_GREEN.get(), consumer, "mint_candy_green");
        Recipes.bundleItem4(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.MINT_CANDY_RED.get()}), (Item)ExtraDelightItems.CANDY_CANE_RED.get(), (Item)ExtraDelightItems.MINT_CANDY_RED.get(), consumer, "mint_candy_red");
        Recipes.bundleItem4(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CANDY_CANE_BLUE.get()}), (Item)ExtraDelightItems.CANDY_CANE_BLUE_BLOCK.get(), (Item)ExtraDelightItems.CANDY_CANE_BLUE.get(), consumer, "mint_candy_cane_blue");
        Recipes.bundleItem4(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CANDY_CANE_GREEN.get()}), (Item)ExtraDelightItems.CANDY_CANE_GREEN_BLOCK.get(), (Item)ExtraDelightItems.CANDY_CANE_GREEN.get(), consumer, "mint_candy_cane_green");
        Recipes.bundleItem4(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CANDY_CANE_RED.get()}), (Item)ExtraDelightItems.CANDY_CANE_RED_BLOCK.get(), (Item)ExtraDelightItems.CANDY_CANE_RED.get(), consumer, "mint_candy_cane_red");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CINNAMON_POPSICLE.get())).pattern(" cm").pattern("isc").pattern("Si ").define(Character.valueOf('m'), CommonTags.FOODS_MILK).define(Character.valueOf('c'), ExtraDelightTags.GROUND_CINNAMON).define(Character.valueOf('s'), ExtraDelightTags.SWEETENER).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('i'), (ItemLike)Items.ICE).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.ICE})).save(consumer, Recipes.EDLoc("cinnamon_popsicle"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CROQUE_MONSIEUR.get())).pattern("bfm").pattern("tct").pattern(" h ").define(Character.valueOf('m'), CommonTags.FOODS_MILK).define(Character.valueOf('b'), ExtraDelightTags.BUTTER).define(Character.valueOf('f'), ExtraDelightTags.FLOUR).define(Character.valueOf('t'), ExtraDelightTags.TOAST).define(Character.valueOf('c'), ExtraDelightTags.CHEESE).define(Character.valueOf('h'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SMOKED_HAM.get(), Items.COOKED_PORKCHOP})).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.TOAST.get()})).save(consumer, Recipes.EDLoc("croque_monsieur"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CROQUE_MADAME.get())).pattern("bfm").pattern("tet").pattern("c h").define(Character.valueOf('m'), CommonTags.FOODS_MILK).define(Character.valueOf('b'), ExtraDelightTags.BUTTER).define(Character.valueOf('f'), ExtraDelightTags.FLOUR).define(Character.valueOf('t'), ExtraDelightTags.TOAST).define(Character.valueOf('c'), ExtraDelightTags.CHEESE).define(Character.valueOf('h'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SMOKED_HAM.get(), Items.COOKED_PORKCHOP})).define(Character.valueOf('e'), CommonTags.FOODS_COOKED_EGG).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.TOAST.get()})).save(consumer, Recipes.EDLoc("croque_madame"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CROQUE_MADAME.get())).requires((ItemLike)ExtraDelightItems.CROQUE_MONSIEUR.get()).requires(CommonTags.FOODS_COOKED_EGG).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.TOAST.get()})).save(consumer, Recipes.EDLoc("monsieur_to_madam"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.COFFEE_CAKE_FEAST.get())).requires((ItemLike)ExtraDelightItems.COFFEE_CAKE_SLICE.get(), 7).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.COFFEE_CAKE_SLICE.get()})).save(consumer, Recipes.EDLoc("coffee_cake_from_slice"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CHOCOLATE_CAKE_BLOCK.get())).requires((ItemLike)ExtraDelightItems.CHOCOLATE_CAKE.get(), 7).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CHOCOLATE_CAKE.get()})).save(consumer, Recipes.EDLoc("chocolate_cake_from_slice"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CHARCUTERIE_BOARD_FEAST.get())).pattern("cmh").pattern("cmh").pattern("pbp").define(Character.valueOf('m'), CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of(ExtraDelightTags.MEAT_COOKED), Ingredient.of(ExtraDelightTags.SALAMI)})).define(Character.valueOf('c'), (ItemLike)ExtraDelightItems.CRACKERS.get()).define(Character.valueOf('h'), ExtraDelightTags.CHEESE).define(Character.valueOf('b'), (ItemLike)Items.BOWL).define(Character.valueOf('p'), ExtraDelightTags.PICKLED_VEGETABLES).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CHEESE.get()})).save(consumer, Recipes.EDLoc("charcuterie_board"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.PUNCH_FEAST.get())).pattern("fff").pattern("sws").pattern(" b ").define(Character.valueOf('f'), ExtraDelightTags.PROCESSED_FRUIT).define(Character.valueOf('s'), ExtraDelightTags.SWEETENER).define(Character.valueOf('w'), Tags.Items.BUCKETS_WATER).define(Character.valueOf('b'), (ItemLike)Items.BOWL).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.WATER_BUCKET})).save(consumer, Recipes.EDLoc("punch"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.MILK_TART_FEAST.get())).pattern("ss").pattern("ss").define(Character.valueOf('s'), (ItemLike)ExtraDelightItems.MILK_TART_SLICE.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.MILK_TART_SLICE.get()})).save(consumer, Recipes.EDLoc("milk_tart"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CINNAMON_PLANKS.get()), (int)4).requires(ExtraDelightTags.CINNAMON_LOGS).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CINNAMON_LOG.get()})).save(consumer, Recipes.EDLoc("cinnamon_planks"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CINNAMON_WOOD.get()), (int)3).pattern("ff ").pattern("ff ").define(Character.valueOf('f'), (ItemLike)ExtraDelightItems.CINNAMON_LOG.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CINNAMON_LOG.get()})).save(consumer, Recipes.EDLoc("cinnamon_wood"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.STRIPPED_CINNAMON_WOOD.get()), (int)3).pattern("ff ").pattern("ff ").define(Character.valueOf('f'), (ItemLike)ExtraDelightItems.STRIPPED_CINNAMON_LOG.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.STRIPPED_CINNAMON_LOG.get()})).save(consumer, Recipes.EDLoc("stripped_cinnamon_wood"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CINNAMON_CABINET.get())).pattern("sss").pattern("t t").pattern("sss").define(Character.valueOf('s'), (ItemLike)ExtraDelightItems.CINNAMON_SLAB.get()).define(Character.valueOf('t'), (ItemLike)ExtraDelightItems.CINNAMON_TRAPDOOR.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CINNAMON_SLAB.get()})).save(consumer, Recipes.EDLoc("cinnamon_cabinet"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CINNAMON_SLAB.get()), (int)6).pattern("ppp").define(Character.valueOf('p'), (ItemLike)ExtraDelightItems.CINNAMON_PLANKS.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CINNAMON_PLANKS.get()})).save(consumer, Recipes.EDLoc("cinnamon_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CINNAMON_DOOR.get()), (int)3).pattern("pp ").pattern("pp ").pattern("pp ").define(Character.valueOf('p'), (ItemLike)ExtraDelightItems.CINNAMON_PLANKS.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CINNAMON_PLANKS.get()})).save(consumer, Recipes.EDLoc("cinnamon_door"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CINNAMON_TRAPDOOR.get()), (int)2).pattern("ppp").pattern("ppp").define(Character.valueOf('p'), (ItemLike)ExtraDelightItems.CINNAMON_PLANKS.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CINNAMON_PLANKS.get()})).save(consumer, Recipes.EDLoc("cinnamon_trapdoor"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CINNAMON_FENCE.get()), (int)3).pattern("psp").pattern("psp").define(Character.valueOf('p'), (ItemLike)ExtraDelightItems.CINNAMON_PLANKS.get()).define(Character.valueOf('s'), (ItemLike)Items.STICK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CINNAMON_PLANKS.get()})).save(consumer, Recipes.EDLoc("cinnamon_fence"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CINNAMON_FENCE_GATE.get())).pattern("sps").pattern("sps").define(Character.valueOf('p'), (ItemLike)ExtraDelightItems.CINNAMON_PLANKS.get()).define(Character.valueOf('s'), (ItemLike)Items.STICK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CINNAMON_PLANKS.get()})).save(consumer, Recipes.EDLoc("cinnamon_fence_gate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CINNAMON_STAIRS.get()), (int)4).pattern("p  ").pattern("pp ").pattern("ppp").define(Character.valueOf('p'), (ItemLike)ExtraDelightItems.CINNAMON_PLANKS.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CINNAMON_PLANKS.get()})).save(consumer, Recipes.EDLoc("cinnamon_stairs"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CINNAMON_PRESSURE_PLATE.get()), (int)1).pattern("pp").define(Character.valueOf('p'), (ItemLike)ExtraDelightItems.CINNAMON_PLANKS.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CINNAMON_PLANKS.get()})).save(consumer, Recipes.EDLoc("cinnamon_pressure_plate"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CINNAMON_BUTTON.get()), (int)1).requires((ItemLike)ExtraDelightItems.CINNAMON_PLANKS.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CINNAMON_PLANKS.get()})).save(consumer, Recipes.EDLoc("cinnamon_button"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ExtraDelightItems.TAP.get()), (int)1).pattern(" l ").pattern("bcb").define(Character.valueOf('l'), (ItemLike)Items.LEVER).define(Character.valueOf('b'), Tags.Items.BUCKETS_WATER).define(Character.valueOf('c'), (ItemLike)Items.COPPER_INGOT).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.COPPER_INGOT})).save(consumer, Recipes.EDLoc("tap"));
        Recipes.bucket("apple_cider", consumer, (ItemLike)ExtraDelightItems.APPLE_CIDER_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, (ItemLike)ModItems.APPLE_CIDER.get());
        Recipes.bucket("bbq", consumer, (ItemLike)ExtraDelightItems.BBQ_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, (ItemLike)ExtraDelightItems.BBQ_SAUCE.get());
        Recipes.bucket("broth", consumer, (ItemLike)ExtraDelightItems.BROTH_FLUID_BUCKET.get(), (ItemLike)Items.BOWL, (ItemLike)ModItems.BONE_BROTH.get());
        Recipes.bucket("cactus_juice", consumer, (ItemLike)ExtraDelightItems.CACTUS_JUICE_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, (ItemLike)ExtraDelightItems.CACTUS_JUICE.get());
        Recipes.bucket("caramel_sauce", consumer, (ItemLike)ExtraDelightItems.CARAMEL_SAUCE_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, (ItemLike)ExtraDelightItems.CARAMEL_SAUCE.get());
        Recipes.bucket("egg_mix", consumer, (ItemLike)ExtraDelightItems.EGG_MIX_FLUID_BUCKET.get(), (ItemLike)Items.BOWL, (ItemLike)ExtraDelightItems.EGG_MIX.get());
        Recipes.bucket("glow_berry_juice", consumer, (ItemLike)ExtraDelightItems.GLOW_BERRY_JUICE_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, (ItemLike)ExtraDelightItems.GLOW_BERRY_JUICE.get());
        Recipes.bucket("glow_berry_jam", consumer, (ItemLike)ExtraDelightItems.GLOW_JAM_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, (ItemLike)ExtraDelightItems.GLOW_BERRY_JAM.get());
        Recipes.bucket("golden_jam", consumer, (ItemLike)ExtraDelightItems.GOLDEN_JAM_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, (ItemLike)ExtraDelightItems.GOLDEN_APPLE_JAM.get());
        Recipes.bucket("gravy", consumer, (ItemLike)ExtraDelightItems.GRAVY_FLUID_BUCKET.get(), (ItemLike)Items.BOWL, (ItemLike)ExtraDelightItems.GRAVY.get());
        Recipes.bucket("hot_cocoa", consumer, (ItemLike)ExtraDelightItems.HOT_COCOA_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, (ItemLike)ModItems.HOT_COCOA.get());
        Recipes.bucket("ketchup", consumer, (ItemLike)ExtraDelightItems.KETCHUP_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, (ItemLike)ExtraDelightItems.KETCHUP.get());
        Recipes.bucket("mayo", consumer, (ItemLike)ExtraDelightItems.MAYO_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, (ItemLike)ExtraDelightItems.MAYO.get());
        Recipes.bucket("melon_juice", consumer, (ItemLike)ExtraDelightItems.MELON_JUICE_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, (ItemLike)ModItems.MELON_JUICE.get());
        Recipes.bucket("milkshake", consumer, (ItemLike)ExtraDelightItems.MILKSHAKE_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, (ItemLike)ExtraDelightItems.MILKSHAKE.get());
        Recipes.bucket("oil", consumer, (ItemLike)ExtraDelightItems.OIL_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, (ItemLike)ExtraDelightItems.COOKING_OIL.get());
        Recipes.bucket("sweet_berry_juice", consumer, (ItemLike)ExtraDelightItems.SWEET_BERRY_JUICE_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, (ItemLike)ExtraDelightItems.SWEET_BERRY_JUICE.get());
        Recipes.bucket("tea", consumer, (ItemLike)ExtraDelightItems.TEA_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, (ItemLike)ExtraDelightItems.TEA.get());
        Recipes.bucket("tomato_juice", consumer, (ItemLike)ExtraDelightItems.TOMATO_JUICE_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, (ItemLike)ExtraDelightItems.TOMATO_JUICE.get());
        Recipes.bucket("vinegar", consumer, (ItemLike)ExtraDelightItems.VINEGAR_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, (ItemLike)ExtraDelightItems.VINEGAR.get());
        Recipes.bucket("whipped_cream", consumer, (ItemLike)ExtraDelightItems.WHIPPED_CREAM_FLUID_BUCKET.get(), (ItemLike)Items.BOWL, (ItemLike)ExtraDelightItems.WHIPPED_CREAM.get());
        Recipes.jamBucket(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.KEG.get()), (int)1).requires((ItemLike)Items.GLASS, 1).requires((ItemLike)Items.BARREL, 1).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BARREL})).save(consumer, Recipes.EDLoc("keg"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ExtraDelightItems.FUNNEL.get()), (int)1).pattern("c c").pattern("ckc").pattern(" c ").define(Character.valueOf('k'), (ItemLike)ExtraDelightItems.KEG.get()).define(Character.valueOf('c'), (ItemLike)Items.COPPER_INGOT).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.KEG.get()})).save(consumer, Recipes.EDLoc("funnel"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.FRUIT_PLANKS.get()), (int)4).requires(ExtraDelightTags.FRUIT_LOGS).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.FRUIT_LOG.get()})).save(consumer, Recipes.EDLoc("fruit_planks"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.FRUIT_WOOD.get()), (int)3).pattern("ff ").pattern("ff ").define(Character.valueOf('f'), (ItemLike)ExtraDelightItems.FRUIT_LOG.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.FRUIT_LOG.get()})).save(consumer, Recipes.EDLoc("fruit_wood"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.STRIPPED_FRUIT_WOOD.get()), (int)3).pattern("ff ").pattern("ff ").define(Character.valueOf('f'), (ItemLike)ExtraDelightItems.STRIPPED_FRUIT_LOG.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.STRIPPED_FRUIT_LOG.get()})).save(consumer, Recipes.EDLoc("stripped_fruit_wood"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.FRUIT_CABINET.get())).pattern("sss").pattern("t t").pattern("sss").define(Character.valueOf('s'), (ItemLike)ExtraDelightItems.FRUIT_SLAB.get()).define(Character.valueOf('t'), (ItemLike)ExtraDelightItems.FRUIT_TRAPDOOR.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.FRUIT_SLAB.get()})).save(consumer, Recipes.EDLoc("fruit_cabinet"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.FRUIT_SLAB.get()), (int)6).pattern("ppp").define(Character.valueOf('p'), (ItemLike)ExtraDelightItems.FRUIT_PLANKS.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.FRUIT_PLANKS.get()})).save(consumer, Recipes.EDLoc("fruit_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.FRUIT_DOOR.get()), (int)3).pattern("pp ").pattern("pp ").pattern("pp ").define(Character.valueOf('p'), (ItemLike)ExtraDelightItems.FRUIT_PLANKS.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.FRUIT_PLANKS.get()})).save(consumer, Recipes.EDLoc("fruit_door"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.FRUIT_TRAPDOOR.get()), (int)2).pattern("ppp").pattern("ppp").define(Character.valueOf('p'), (ItemLike)ExtraDelightItems.FRUIT_PLANKS.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.FRUIT_PLANKS.get()})).save(consumer, Recipes.EDLoc("fruit_trapdoor"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.FRUIT_FENCE.get()), (int)3).pattern("psp").pattern("psp").define(Character.valueOf('p'), (ItemLike)ExtraDelightItems.FRUIT_PLANKS.get()).define(Character.valueOf('s'), (ItemLike)Items.STICK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.FRUIT_PLANKS.get()})).save(consumer, Recipes.EDLoc("fruit_fence"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.FRUIT_FENCE_GATE.get())).pattern("sps").pattern("sps").define(Character.valueOf('p'), (ItemLike)ExtraDelightItems.FRUIT_PLANKS.get()).define(Character.valueOf('s'), (ItemLike)Items.STICK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.FRUIT_PLANKS.get()})).save(consumer, Recipes.EDLoc("fruit_fence_gate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.FRUIT_STAIRS.get()), (int)4).pattern("p  ").pattern("pp ").pattern("ppp").define(Character.valueOf('p'), (ItemLike)ExtraDelightItems.FRUIT_PLANKS.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.FRUIT_PLANKS.get()})).save(consumer, Recipes.EDLoc("fruit_stairs"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.FRUIT_PRESSURE_PLATE.get()), (int)1).pattern("pp").define(Character.valueOf('p'), (ItemLike)ExtraDelightItems.FRUIT_PLANKS.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.FRUIT_PLANKS.get()})).save(consumer, Recipes.EDLoc("fruit_pressure_plate"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.FRUIT_BUTTON.get()), (int)1).requires((ItemLike)ExtraDelightItems.FRUIT_PLANKS.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.FRUIT_PLANKS.get()})).save(consumer, Recipes.EDLoc("fruit_button"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CHILI_SEEDS.get()), (int)1).requires((ItemLike)ExtraDelightItems.CHILI.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CHILI.get()})).save(consumer, Recipes.EDLoc("chili_seeds"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.MELTING_POT.get()), (int)1).requires((ItemLike)ModItems.COOKING_POT.get(), 2).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CHILI.get()})).save(consumer, Recipes.EDLoc("melting_pot"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CHILLER.get()), (int)1).pattern("i").pattern("c").pattern("k").define(Character.valueOf('c'), ModTags.CABINETS).define(Character.valueOf('i'), (ItemLike)Items.IRON_BLOCK).define(Character.valueOf('k'), ExtraDelightItems.KEG).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.KEG.get()})).save(consumer, Recipes.EDLoc("chiller"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.SQUARE_PAN.get()), (int)1).requires((ItemLike)Items.HEAVY_WEIGHTED_PRESSURE_PLATE).requires((ItemLike)Items.IRON_NUGGET, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.HEAVY_WEIGHTED_PRESSURE_PLATE})).save(consumer, Recipes.EDLoc("square_pan"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.SERVING_POT.get()), (int)1).requires((ItemLike)Items.HEAVY_WEIGHTED_PRESSURE_PLATE).requires((ItemLike)Items.IRON_NUGGET, 5).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.HEAVY_WEIGHTED_PRESSURE_PLATE})).save(consumer, Recipes.EDLoc("serving_pot"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BAR_MOLD.get()), (int)1).requires((ItemLike)Items.HEAVY_WEIGHTED_PRESSURE_PLATE).requires((ItemLike)Items.IRON_NUGGET, 7).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.HEAVY_WEIGHTED_PRESSURE_PLATE})).save(consumer, Recipes.EDLoc("bar_mold"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_BOX.get()), (int)1).requires(ExtraDelightTags.RIBBON).requires((ItemLike)Items.PAPER).requires(Tags.Items.CHESTS).requires(Tags.Items.DYES_WHITE).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AestheticBlocks.BOW_ITEMS.get(DyeColor.WHITE.getId())})).save(consumer, Recipes.EDLoc("white_chocolate_box"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BLACK_CHOCOLATE_BOX.get()), (int)1).requires(ExtraDelightTags.RIBBON).requires((ItemLike)Items.PAPER).requires(Tags.Items.CHESTS).requires(Tags.Items.DYES_BLACK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AestheticBlocks.BOW_ITEMS.get(DyeColor.BLACK.getId())})).save(consumer, Recipes.EDLoc("black_chocolate_box"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BLUE_CHOCOLATE_BOX.get()), (int)1).requires(ExtraDelightTags.RIBBON).requires((ItemLike)Items.PAPER).requires(Tags.Items.CHESTS).requires(Tags.Items.DYES_BLUE).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AestheticBlocks.BOW_ITEMS.get(DyeColor.BLUE.getId())})).save(consumer, Recipes.EDLoc("blue_chocolate_box"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BROWN_CHOCOLATE_BOX.get()), (int)1).requires(ExtraDelightTags.RIBBON).requires((ItemLike)Items.PAPER).requires(Tags.Items.CHESTS).requires(Tags.Items.DYES_BROWN).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AestheticBlocks.BOW_ITEMS.get(DyeColor.BROWN.getId())})).save(consumer, Recipes.EDLoc("brown_chocolate_box"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CYAN_CHOCOLATE_BOX.get()), (int)1).requires(ExtraDelightTags.RIBBON).requires((ItemLike)Items.PAPER).requires(Tags.Items.CHESTS).requires(Tags.Items.DYES_CYAN).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AestheticBlocks.BOW_ITEMS.get(DyeColor.CYAN.getId())})).save(consumer, Recipes.EDLoc("cyan_chocolate_box"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.GRAY_CHOCOLATE_BOX.get()), (int)1).requires(ExtraDelightTags.RIBBON).requires((ItemLike)Items.PAPER).requires(Tags.Items.CHESTS).requires(Tags.Items.DYES_GRAY).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AestheticBlocks.BOW_ITEMS.get(DyeColor.GRAY.getId())})).save(consumer, Recipes.EDLoc("gray_chocolate_box"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.GREEN_CHOCOLATE_BOX.get()), (int)1).requires(ExtraDelightTags.RIBBON).requires((ItemLike)Items.PAPER).requires(Tags.Items.CHESTS).requires(Tags.Items.DYES_GREEN).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AestheticBlocks.BOW_ITEMS.get(DyeColor.GREEN.getId())})).save(consumer, Recipes.EDLoc("green_chocolate_box"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.LIGHT_BLUE_CHOCOLATE_BOX.get()), (int)1).requires(ExtraDelightTags.RIBBON).requires((ItemLike)Items.PAPER).requires(Tags.Items.CHESTS).requires(Tags.Items.DYES_LIGHT_BLUE).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AestheticBlocks.BOW_ITEMS.get(DyeColor.LIGHT_BLUE.getId())})).save(consumer, Recipes.EDLoc("light_blue_chocolate_box"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.LIGHT_GRAY_CHOCOLATE_BOX.get()), (int)1).requires(ExtraDelightTags.RIBBON).requires((ItemLike)Items.PAPER).requires(Tags.Items.CHESTS).requires(Tags.Items.DYES_LIGHT_GRAY).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AestheticBlocks.BOW_ITEMS.get(DyeColor.LIGHT_GRAY.getId())})).save(consumer, Recipes.EDLoc("light_gray_chocolate_box"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.LIME_CHOCOLATE_BOX.get()), (int)1).requires(ExtraDelightTags.RIBBON).requires((ItemLike)Items.PAPER).requires(Tags.Items.CHESTS).requires(Tags.Items.DYES_LIME).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AestheticBlocks.BOW_ITEMS.get(DyeColor.LIME.getId())})).save(consumer, Recipes.EDLoc("lime_chocolate_box"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.MAGENTA_CHOCOLATE_BOX.get()), (int)1).requires(ExtraDelightTags.RIBBON).requires((ItemLike)Items.PAPER).requires(Tags.Items.CHESTS).requires(Tags.Items.DYES_MAGENTA).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AestheticBlocks.BOW_ITEMS.get(DyeColor.MAGENTA.getId())})).save(consumer, Recipes.EDLoc("magenta_chocolate_box"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.ORANGE_CHOCOLATE_BOX.get()), (int)1).requires(ExtraDelightTags.RIBBON).requires((ItemLike)Items.PAPER).requires(Tags.Items.CHESTS).requires(Tags.Items.DYES_ORANGE).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AestheticBlocks.BOW_ITEMS.get(DyeColor.ORANGE.getId())})).save(consumer, Recipes.EDLoc("orange_chocolate_box"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.PINK_CHOCOLATE_BOX.get()), (int)1).requires(ExtraDelightTags.RIBBON).requires((ItemLike)Items.PAPER).requires(Tags.Items.CHESTS).requires(Tags.Items.DYES_PINK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AestheticBlocks.BOW_ITEMS.get(DyeColor.PINK.getId())})).save(consumer, Recipes.EDLoc("pink_chocolate_box"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.PURPLE_CHOCOLATE_BOX.get()), (int)1).requires(ExtraDelightTags.RIBBON).requires((ItemLike)Items.PAPER).requires(Tags.Items.CHESTS).requires(Tags.Items.DYES_PURPLE).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AestheticBlocks.BOW_ITEMS.get(DyeColor.PURPLE.getId())})).save(consumer, Recipes.EDLoc("purple_chocolate_box"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.RED_CHOCOLATE_BOX.get()), (int)1).requires(ExtraDelightTags.RIBBON).requires((ItemLike)Items.PAPER).requires(Tags.Items.CHESTS).requires(Tags.Items.DYES_RED).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AestheticBlocks.BOW_ITEMS.get(DyeColor.RED.getId())})).save(consumer, Recipes.EDLoc("red_chocolate_box"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.YELLOW_CHOCOLATE_BOX.get()), (int)1).requires(ExtraDelightTags.RIBBON).requires((ItemLike)Items.PAPER).requires(Tags.Items.CHESTS).requires(Tags.Items.DYES_YELLOW).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)AestheticBlocks.BOW_ITEMS.get(DyeColor.YELLOW.getId())})).save(consumer, Recipes.EDLoc("yellow_chocolate_box"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_FENCE.get()), (int)3).pattern("bsb").pattern("bsb").define(Character.valueOf('b'), ExtraDelightTags.MILK_CHOCOLATE_BLOCK).define(Character.valueOf('s'), ExtraDelightTags.MILK_CHOCOLATE_BAR).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.MILK_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("milk_chocolate_fence"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_FENCE_GATE.get()), (int)3).pattern("bsb").pattern("bsb").define(Character.valueOf('s'), ExtraDelightTags.MILK_CHOCOLATE_BLOCK).define(Character.valueOf('b'), ExtraDelightTags.MILK_CHOCOLATE_BAR).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.MILK_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("milk_chocolate_fence_gate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_STAIRS.get()), (int)4).pattern("b  ").pattern("bb ").pattern("bbb").define(Character.valueOf('b'), ExtraDelightTags.MILK_CHOCOLATE_BLOCK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.MILK_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("milk_chocolate_stairs"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_DOOR.get()), (int)3).pattern("bb").pattern("bb").pattern("bb").define(Character.valueOf('b'), ExtraDelightTags.MILK_CHOCOLATE_BLOCK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.MILK_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("milk_chocolate_door"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_TRAPDOOR.get()), (int)2).pattern("bbb").pattern("bbb").define(Character.valueOf('b'), ExtraDelightTags.MILK_CHOCOLATE_BLOCK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.MILK_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("milk_chocolate_trapdoor"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_SLAB.get()), (int)6).pattern("bbb").define(Character.valueOf('b'), ExtraDelightTags.MILK_CHOCOLATE_BLOCK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.MILK_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("milk_chocolate_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_PILLAR.get()), (int)3).pattern("b").pattern("b").pattern("b").define(Character.valueOf('b'), ExtraDelightTags.MILK_CHOCOLATE_BLOCK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.MILK_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("milk_chocolate_pillar"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_FENCE.get()), (int)3).pattern("bsb").pattern("bsb").define(Character.valueOf('b'), ExtraDelightTags.BLOOD_CHOCOLATE_BLOCK).define(Character.valueOf('s'), ExtraDelightTags.BLOOD_CHOCOLATE_BAR).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.BLOOD_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("blood_chocolate_fence"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_FENCE_GATE.get()), (int)3).pattern("bsb").pattern("bsb").define(Character.valueOf('s'), ExtraDelightTags.BLOOD_CHOCOLATE_BLOCK).define(Character.valueOf('b'), ExtraDelightTags.BLOOD_CHOCOLATE_BAR).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.BLOOD_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("blood_chocolate_fence_gate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_STAIRS.get()), (int)4).pattern("b  ").pattern("bb ").pattern("bbb").define(Character.valueOf('b'), ExtraDelightTags.BLOOD_CHOCOLATE_BLOCK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.BLOOD_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("blood_chocolate_stairs"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_DOOR.get()), (int)3).pattern("bb").pattern("bb").pattern("bb").define(Character.valueOf('b'), ExtraDelightTags.BLOOD_CHOCOLATE_BLOCK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.BLOOD_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("blood_chocolate_door"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_TRAPDOOR.get()), (int)2).pattern("bbb").pattern("bbb").define(Character.valueOf('b'), ExtraDelightTags.BLOOD_CHOCOLATE_BLOCK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.BLOOD_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("blood_chocolate_trapdoor"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_SLAB.get()), (int)6).pattern("bbb").define(Character.valueOf('b'), ExtraDelightTags.BLOOD_CHOCOLATE_BLOCK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.BLOOD_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("blood_chocolate_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_PILLAR.get()), (int)3).pattern("b").pattern("b").pattern("b").define(Character.valueOf('b'), ExtraDelightTags.BLOOD_CHOCOLATE_BLOCK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.BLOOD_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("blood_chocolate_pillar"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_FENCE.get()), (int)3).pattern("bsb").pattern("bsb").define(Character.valueOf('b'), ExtraDelightTags.WHITE_CHOCOLATE_BLOCK).define(Character.valueOf('s'), ExtraDelightTags.WHITE_CHOCOLATE_BAR).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.WHITE_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("white_chocolate_fence"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_FENCE_GATE.get()), (int)3).pattern("bsb").pattern("bsb").define(Character.valueOf('s'), ExtraDelightTags.WHITE_CHOCOLATE_BLOCK).define(Character.valueOf('b'), ExtraDelightTags.WHITE_CHOCOLATE_BAR).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.WHITE_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("white_chocolate_fence_gate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_STAIRS.get()), (int)4).pattern("b  ").pattern("bb ").pattern("bbb").define(Character.valueOf('b'), ExtraDelightTags.WHITE_CHOCOLATE_BLOCK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.WHITE_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("white_chocolate_stairs"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_DOOR.get()), (int)3).pattern("bb").pattern("bb").pattern("bb").define(Character.valueOf('b'), ExtraDelightTags.WHITE_CHOCOLATE_BLOCK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.WHITE_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("white_chocolate_door"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_TRAPDOOR.get()), (int)2).pattern("bbb").pattern("bbb").define(Character.valueOf('b'), ExtraDelightTags.WHITE_CHOCOLATE_BLOCK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.WHITE_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("white_chocolate_trapdoor"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_SLAB.get()), (int)6).pattern("bbb").define(Character.valueOf('b'), ExtraDelightTags.WHITE_CHOCOLATE_BLOCK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.WHITE_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("white_chocolate_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_PILLAR.get()), (int)3).pattern("b").pattern("b").pattern("b").define(Character.valueOf('b'), ExtraDelightTags.WHITE_CHOCOLATE_BLOCK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.WHITE_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("white_chocolate_pillar"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_FENCE.get()), (int)3).pattern("bsb").pattern("bsb").define(Character.valueOf('b'), ExtraDelightTags.DARK_CHOCOLATE_BLOCK).define(Character.valueOf('s'), ExtraDelightTags.DARK_CHOCOLATE_BAR).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.DARK_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("dark_chocolate_fence"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_FENCE_GATE.get()), (int)3).pattern("bsb").pattern("bsb").define(Character.valueOf('s'), ExtraDelightTags.DARK_CHOCOLATE_BLOCK).define(Character.valueOf('b'), ExtraDelightTags.DARK_CHOCOLATE_BAR).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.DARK_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("dark_chocolate_fence_gate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_STAIRS.get()), (int)4).pattern("b  ").pattern("bb ").pattern("bbb").define(Character.valueOf('b'), ExtraDelightTags.DARK_CHOCOLATE_BLOCK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.DARK_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("dark_chocolate_stairs"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_DOOR.get()), (int)3).pattern("bb").pattern("bb").pattern("bb").define(Character.valueOf('b'), ExtraDelightTags.DARK_CHOCOLATE_BLOCK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.DARK_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("dark_chocolate_door"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_TRAPDOOR.get()), (int)2).pattern("bbb").pattern("bbb").define(Character.valueOf('b'), ExtraDelightTags.DARK_CHOCOLATE_BLOCK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.DARK_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("dark_chocolate_trapdoor"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_SLAB.get()), (int)6).pattern("bbb").define(Character.valueOf('b'), ExtraDelightTags.DARK_CHOCOLATE_BLOCK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.DARK_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("dark_chocolate_slab"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_PILLAR.get()), (int)3).pattern("b").pattern("b").pattern("b").define(Character.valueOf('b'), ExtraDelightTags.DARK_CHOCOLATE_BLOCK).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.DARK_CHOCOLATE_BLOCK})).save(consumer, Recipes.EDLoc("dark_chocolate_pillar"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.XOCOLATL.get()), (int)1).requires((ItemLike)ModItems.HOT_COCOA.get()).requires(ExtraDelightTags.CHILI_POWDER).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.HOT_COCOA.get()})).save(consumer, Recipes.EDLoc("xocolatl_crafted"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.GOURMET_HOT_CHOCOLATE.get()), (int)1).requires((ItemLike)ModItems.HOT_COCOA.get()).requires(ExtraDelightTags.WHIPPED_CREAM).requires(ExtraDelightTags.COOKIE).requires(ExtraDelightTags.GROUND_CINNAMON).requires(ExtraDelightTags.MARSHMALLOW).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.HOT_COCOA.get()})).save(consumer, Recipes.EDLoc("gourmet_hot_chocolate"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.SMORE.get()), (int)1).requires(ExtraDelightTags.GRAHAM_CRACKER).requires(ExtraDelightTags.CHOCOLATE_BAR).requires(ExtraDelightTags.MARSHMALLOW).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.MARSHMALLOW.get()})).save(consumer, Recipes.EDLoc("smore"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.DIRT_CAKE.get()), (int)1).requires(ExtraDelightTags.COOKIE).requires(ExtraDelightItems.CHOCOLATE_CUSTARD).requires(ExtraDelightTags.GUMMIES).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CHOCOLATE_CUSTARD.get()})).save(consumer, Recipes.EDLoc("dirt_cake"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.TRAIL_MIX.get()), (int)3).requires(ExtraDelightTags.CHOCOLATE_CHIPS).requires(ExtraDelightTags.DRIED_FRUIT).requires(ExtraDelightTags.ROASTED_NUTS).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.PEANUTS.get()})).save(consumer, Recipes.EDLoc("trail_mix"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.FLUFFER_NUTTER.get()), (int)1).requires(ExtraDelightTags.BREAD_SLICE).requires(ExtraDelightTags.NUT_BUTTER).requires(ExtraDelightTags.MARSHMALLOW_FLUFF).requires(ExtraDelightTags.BREAD_SLICE).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.MARSHMALLOW_FLUFF_BOTTLE.get()})).save(consumer, Recipes.EDLoc("fluffer_nutter"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CRISP_RICE_CEREAL.get()), (int)1).requires(ExtraDelightTags.PUFFED_RICE).requires(CommonTags.FOODS_MILK).requires((ItemLike)Items.BOWL).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CRISP_RICE.get()})).save(consumer, Recipes.EDLoc("crisp_rice_cereal"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CORN_FLAKES_CEREAL.get()), (int)1).requires(ExtraDelightTags.CORN_FLAKES).requires(CommonTags.FOODS_MILK).requires((ItemLike)Items.BOWL).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CORN_FLAKES.get()})).save(consumer, Recipes.EDLoc("corn_flakes_cereal"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.PEANUT_BUTTER_JELLY.get()), (int)1).requires(ExtraDelightTags.BREAD_SLICE).requires(ExtraDelightTags.NUT_BUTTER).requires(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of(ExtraDelightTags.JAM), ALL_JAM_AS_INGREDIENT})).requires(ExtraDelightTags.BREAD_SLICE).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.JAM.get()})).save(consumer, Recipes.EDLoc("pbj"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BLACK_FOREST_TRIFLE_BLOCK.get()), (int)1).pattern(" w ").pattern("scs").pattern(" b ").define(Character.valueOf('b'), (ItemLike)Items.BOWL).define(Character.valueOf('w'), ExtraDelightTags.WHIPPED_CREAM).define(Character.valueOf('c'), (ItemLike)ExtraDelightItems.CHOCOLATE_CAKE_BLOCK.get()).define(Character.valueOf('s'), (ItemLike)Items.SWEET_BERRIES).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.CHOCOLATE_CAKE})).save(consumer, Recipes.EDLoc("black_forest_trifle"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.ICE_CREAM_SUNDAE.get()), (int)1).requires(ExtraDelightTags.ICE_CREAM).requires(ExtraDelightTags.CHOCOLATE_SYRUP).requires(ExtraDelightTags.ROASTED_NUTS).requires(Tags.Items.FOODS_BERRY).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.JAM.get()})).save(consumer, Recipes.EDLoc("ice_cream_sundae"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_FONDUE_BLOCK.get()), (int)1).pattern("s s").pattern("sbs").pattern(" c ").define(Character.valueOf('b'), ExtraDelightItems.BLOOD_CHOCOLATE_SYRUP_FLUID_BUCKET).define(Character.valueOf('s'), (ItemLike)Items.STICK).define(Character.valueOf('c'), ItemTags.CANDLES).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.BLOOD_CHOCOLATE_SYRUP_FLUID_BUCKET})).save(consumer, Recipes.EDLoc("blood_chocolate_fondue_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_FONDUE_BLOCK.get()), (int)1).pattern("s s").pattern("sbs").pattern(" c ").define(Character.valueOf('b'), ExtraDelightItems.DARK_CHOCOLATE_SYRUP_FLUID_BUCKET).define(Character.valueOf('s'), (ItemLike)Items.STICK).define(Character.valueOf('c'), ItemTags.CANDLES).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.DARK_CHOCOLATE_SYRUP_FLUID_BUCKET})).save(consumer, Recipes.EDLoc("dark_chocolate_fondue_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_FONDUE_BLOCK.get()), (int)1).pattern("s s").pattern("sbs").pattern(" c ").define(Character.valueOf('b'), ExtraDelightItems.MILK_CHOCOLATE_SYRUP_FLUID_BUCKET).define(Character.valueOf('s'), (ItemLike)Items.STICK).define(Character.valueOf('c'), ItemTags.CANDLES).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.MILK_CHOCOLATE_SYRUP_FLUID_BUCKET})).save(consumer, Recipes.EDLoc("milk_chocolate_fondue_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_FONDUE_BLOCK.get()), (int)1).pattern("s s").pattern("sbs").pattern(" c ").define(Character.valueOf('b'), ExtraDelightItems.WHITE_CHOCOLATE_SYRUP_FLUID_BUCKET).define(Character.valueOf('s'), (ItemLike)Items.STICK).define(Character.valueOf('c'), ItemTags.CANDLES).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.WHITE_CHOCOLATE_SYRUP_FLUID_BUCKET})).save(consumer, Recipes.EDLoc("white_chocolate_fondue_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.JAR.get()), (int)1).pattern(" s ").pattern("g g").pattern(" g ").define(Character.valueOf('s'), ItemTags.WOODEN_SLABS).define(Character.valueOf('g'), Tags.Items.GLASS_BLOCKS).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.GLASS})).save(consumer, Recipes.EDLoc("jar"));
        Recipes.bucket("cocoa_butter", consumer, (ItemLike)ExtraDelightItems.COCOA_BUTTER_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, ExtraDelightItems.COCOA_BUTTER_BOTTLE);
        Recipes.bucket("white_chocolate", consumer, (ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_SYRUP_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, ExtraDelightItems.WHITE_CHOCOLATE_SYRUP_BOTTLE);
        Recipes.bucket("blood_chocolate", consumer, (ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_SYRUP_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, ExtraDelightItems.BLOOD_CHOCOLATE_SYRUP_BOTTLE);
        Recipes.bucket("milk_chocolate", consumer, (ItemLike)ExtraDelightItems.MILK_CHOCOLATE_SYRUP_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, ExtraDelightItems.MILK_CHOCOLATE_SYRUP_BOTTLE);
        Recipes.bucket("dark_chocolate", consumer, (ItemLike)ExtraDelightItems.DARK_CHOCOLATE_SYRUP_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, ExtraDelightItems.DARK_CHOCOLATE_SYRUP_BOTTLE);
        Recipes.bucket("coffee", consumer, (ItemLike)ExtraDelightItems.COFFEE_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, ExtraDelightItems.COFFEE);
        Recipes.bucket("nut_butter", consumer, (ItemLike)ExtraDelightItems.NUT_BUTTER_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, ExtraDelightItems.PEANUT_BUTTER_BOTTLE);
        Recipes.bucket("marshmallow_fluff", consumer, (ItemLike)ExtraDelightItems.MARSHMALLOW_FLUFF_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, ExtraDelightItems.MARSHMALLOW_FLUFF_BOTTLE);
        Recipes.bucket("cocoa_nut_butter_spread", consumer, (ItemLike)ExtraDelightItems.COCOA_NUT_BUTTER_SPREAD_FLUID_BUCKET.get(), (ItemLike)Items.GLASS_BOTTLE, ExtraDelightItems.HAZELNUT_SPREAD_BOTTLE);
        Recipes.bundleItem9(Ingredient.of(ExtraDelightTags.MARSHMALLOW), (Item)ExtraDelightItems.MARSHMALLOW_BLOCK.get(), (Item)ExtraDelightItems.MARSHMALLOW.get(), consumer, "marshmallow");
        Recipes.bundleItem9(Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_CARROT}), (Item)ExtraDelightItems.GOLDEN_CARROT_CRATE_BLOCK.get(), Items.GOLDEN_CARROT, consumer, "golden_carrot");
        Recipes.bundleItem9(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_BAR.get()}), (Item)ExtraDelightItems.BLOOD_CHOCOLATE_BLOCK.get(), (Item)ExtraDelightItems.BLOOD_CHOCOLATE_BAR.get(), consumer, "blood_chocolate_block");
        Recipes.bundleItem9(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.DARK_CHOCOLATE_BAR.get()}), (Item)ExtraDelightItems.DARK_CHOCOLATE_BLOCK.get(), (Item)ExtraDelightItems.DARK_CHOCOLATE_BAR.get(), consumer, "dark_chocolate_block");
        Recipes.bundleItem9(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.MILK_CHOCOLATE_BAR.get()}), (Item)ExtraDelightItems.MILK_CHOCOLATE_BLOCK.get(), (Item)ExtraDelightItems.MILK_CHOCOLATE_BAR.get(), consumer, "milk_chocolate_block");
        Recipes.bundleItem9(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_BAR.get()}), (Item)ExtraDelightItems.WHITE_CHOCOLATE_BLOCK.get(), (Item)ExtraDelightItems.WHITE_CHOCOLATE_BAR.get(), consumer, "white_chocolate_block");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CHOCOLATE_CAKE_BLOCK.get()), (int)1).requires(ExtraDelightItems.CHOCOLATE_CAKE, 7).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CORN_FLAKES.get()})).save(consumer, Recipes.EDLoc("chocolate_cake_whole"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.TARTE_TATIN.get())).pattern("ff ").pattern("ff ").define(Character.valueOf('f'), (ItemLike)ExtraDelightItems.TARTE_TATIN_SLICE.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.TARTE_TATIN.get()})).save(consumer, Recipes.EDLoc("tarte_tatin_slice"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ExtraDelightItems.HANGING_CHILI.get())).pattern("ccc").pattern("crc").pattern("ccc").define(Character.valueOf('c'), (ItemLike)ExtraDelightItems.CHILI.get()).define(Character.valueOf('r'), (ItemLike)ModItems.ROPE.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CHILI.get()})).save(consumer, Recipes.EDLoc("hanging_chili"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ExtraDelightItems.HANGING_DRIED_CHILI.get())).pattern("ccc").pattern("crc").pattern("ccc").define(Character.valueOf('c'), (ItemLike)ExtraDelightItems.DRIED_CHILI.get()).define(Character.valueOf('r'), (ItemLike)ModItems.ROPE.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.DRIED_CHILI.get()})).save(consumer, Recipes.EDLoc("hanging_dried_chili"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ExtraDelightItems.HANGING_MINT.get())).pattern("c c").pattern(" r ").pattern("c c").define(Character.valueOf('c'), (ItemLike)ExtraDelightItems.MINT.get()).define(Character.valueOf('r'), (ItemLike)ModItems.ROPE.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.MINT.get()})).save(consumer, Recipes.EDLoc("hanging_mint"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ExtraDelightItems.HANGING_HAM.get())).pattern("r").pattern("c").define(Character.valueOf('c'), (ItemLike)ModItems.HAM.get()).define(Character.valueOf('r'), (ItemLike)ModItems.ROPE.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.HAM.get()})).save(consumer, Recipes.EDLoc("hanging_ham"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ExtraDelightItems.HANGING_CORN.get())).pattern("ccc").pattern("crc").pattern("ccc").define(Character.valueOf('c'), (ItemLike)ExtraDelightItems.CORN_ON_COB.get()).define(Character.valueOf('r'), (ItemLike)ModItems.ROPE.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CORN_ON_COB.get()})).save(consumer, Recipes.EDLoc("hanging_corn"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ExtraDelightItems.HANGING_ONION.get())).pattern("ccc").pattern("crc").pattern("ccc").define(Character.valueOf('c'), (ItemLike)ModItems.ONION.get()).define(Character.valueOf('r'), (ItemLike)ModItems.ROPE.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ONION.get()})).save(consumer, Recipes.EDLoc("hanging_onion"));
        Recipes.bundleItem9(Ingredient.of(ExtraDelightTags.CHILI), (Item)ExtraDelightItems.CHILI_CRATE.get(), (Item)ExtraDelightItems.CHILI.get(), consumer, "chili");
        Recipes.bundleItem9(Ingredient.of(ExtraDelightTags.CHILI_POWDER), (Item)ExtraDelightItems.CHILI_POWDER_SACK.get(), (Item)ExtraDelightItems.CHILI_POWDER.get(), consumer, "chili_powder");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.JALAPENO_STUFFED_POTATO.get()), (int)1).requires((ItemLike)ModItems.STUFFED_POTATO.get()).requires(ExtraDelightTags.PROCESSED_CHILI).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.CHILI})).save(consumer, Recipes.EDLoc("jalapeno_stuffed_potato"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.JALAPENO_STUFFED_POTATO.get()), (int)1).requires((ItemLike)Items.BAKED_POTATO).requires((ItemLike)Items.MILK_BUCKET).requires(CommonTags.FOODS_COOKED_BEEF).requires(ExtraDelightTags.PROCESSED_CHILI).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.CHILI})).save(consumer, Recipes.EDLoc("jalapeno_stuffed_potato_full"));
        Recipes.bundleItem9(Ingredient.of(ExtraDelightTags.PEANUTS_IN_SHELL), (Item)ExtraDelightItems.PEANUT_IN_SHELL_SACK.get(), (Item)ExtraDelightItems.PEANUTS_IN_SHELL.get(), consumer, "peanut_in_shell");
        Recipes.bundleItem9(Ingredient.of(ExtraDelightTags.PEANUTS), (Item)ExtraDelightItems.PEANUT_SACK.get(), (Item)ExtraDelightItems.PEANUTS.get(), consumer, "peanut");
        Recipes.bundleItem9(Ingredient.of(ExtraDelightTags.ROASTED_PEANUTS), (Item)ExtraDelightItems.ROASTED_PEANUT_SACK.get(), (Item)ExtraDelightItems.ROASTED_PEANUTS.get(), consumer, "roasted_peanut");
        Recipes.bundleItem9(Ingredient.of(ExtraDelightTags.HAZELNUTS_IN_SHELL), (Item)ExtraDelightItems.HAZELNUT_IN_SHELL_SACK.get(), (Item)ExtraDelightItems.HAZELNUTS_IN_SHELL.get(), consumer, "hazelnut_in_shell");
        Recipes.bundleItem9(Ingredient.of(ExtraDelightTags.HAZELNUTS), (Item)ExtraDelightItems.HAZELNUT_SACK.get(), (Item)ExtraDelightItems.HAZELNUTS.get(), consumer, "hazelnut");
        Recipes.bundleItem9(Ingredient.of(ExtraDelightTags.ROASTED_HAZELNUTS), (Item)ExtraDelightItems.ROASTED_HAZELNUT_SACK.get(), (Item)ExtraDelightItems.ROASTED_HAZELNUTS.get(), consumer, "roasted_hazelnut");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.MISSISSIPPI_MUD_PIE.get())).pattern("ff ").pattern("ff ").define(Character.valueOf('f'), (ItemLike)ExtraDelightItems.MISSISSIPPI_MUD_PIE_SLICE.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.MISSISSIPPI_MUD_PIE.get()})).save(consumer, Recipes.EDLoc("mississippi_mud_pie_slice"));
        Recipes.bundleItem9(Ingredient.of(ExtraDelightTags.MALLOWROOT), (Item)ExtraDelightItems.MALLOW_ROOT_CRATE.get(), (Item)ExtraDelightItems.MALLOW_ROOT.get(), consumer, "mallow_root");
        Recipes.bundleItem9(Ingredient.of(ExtraDelightTags.MALLOWROOT_POWDER), (Item)ExtraDelightItems.MALLOW_POWDER_SACK.get(), (Item)ExtraDelightItems.MALLOW_POWDER.get(), consumer, "mallow_root_powder");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.GRASSHOPPER_PIE.get())).pattern("ff ").pattern("ff ").define(Character.valueOf('f'), (ItemLike)ExtraDelightItems.GRASSHOPPER_PIE_SLICE.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GRASSHOPPER_PIE.get()})).save(consumer, Recipes.EDLoc("grasshopper_pie_slice"));
        Recipes.bundleItem9(Ingredient.of(ExtraDelightTags.COFFEE_CHERRIES), (Item)ExtraDelightItems.COFFEE_CHERRY_CRATE.get(), (Item)ExtraDelightItems.COFFEE_CHERRIES.get(), consumer, "coffee_cherries");
        Recipes.bundleItem9(Ingredient.of(ExtraDelightTags.GREEN_COFFEE), (Item)ExtraDelightItems.GREEN_COFFEE_BEAN_SACK.get(), (Item)ExtraDelightItems.GREEN_COFFEE.get(), consumer, "green_coffee");
        Recipes.bundleItem9(Ingredient.of(ExtraDelightTags.ROASTED_COFFEE_BEANS), (Item)ExtraDelightItems.COFFEE_BEAN_SACK.get(), (Item)ExtraDelightItems.COFFEE_BEANS.get(), consumer, "coffee_beans");
        Recipes.bundleItem9(Ingredient.of(ExtraDelightTags.GROUND_COFFEE_BEANS), (Item)ExtraDelightItems.GROUND_COFFEE_SACK.get(), (Item)ExtraDelightItems.GROUND_COFFEE.get(), consumer, "ground_coffee");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.AFFOGATO.get()), (int)1).requires(ExtraDelightTags.COFFEE).requires(ExtraDelightTags.ICE_CREAM).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.ICE_CREAM})).save(consumer, Recipes.EDLoc("affogato"));
        Recipes.bundleItem9(Ingredient.of((ItemLike[])new ItemLike[]{Items.COCOA_BEANS}), (Item)ExtraDelightItems.COCOA_BEAN_SACK.get(), Items.COCOA_BEANS, consumer, "cocoa_beans");
        Recipes.bundleItem9(Ingredient.of(ExtraDelightTags.ROASTED_COCOA_BEANS), (Item)ExtraDelightItems.ROASTED_COCOA_BEAN_SACK.get(), (Item)ExtraDelightItems.ROASTED_COCOA_BEANS.get(), consumer, "roasted_cocoa_beans");
        Recipes.bundleItem9(Ingredient.of(ExtraDelightTags.COCOA_SOLIDS), (Item)ExtraDelightItems.COCOA_SOLIDS_SACK.get(), (Item)ExtraDelightItems.COCOA_SOLIDS.get(), consumer, "cocoa_solids");
        Recipes.bundleItem9(Ingredient.of(ExtraDelightTags.COCOA_POWDER), (Item)ExtraDelightItems.COCOA_POWDER_SACK.get(), (Item)ExtraDelightItems.COCOA_POWDER.get(), consumer, "cocoa_powder");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CINNAMON_TOAST.get()), (int)4).requires(ExtraDelightTags.GROUND_CINNAMON).requires(ExtraDelightTags.SWEETENER).requires(ExtraDelightTags.BUTTER).requires(ExtraDelightTags.TOAST).requires(ExtraDelightTags.TOAST).requires(ExtraDelightTags.TOAST).requires(ExtraDelightTags.TOAST).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.GROUND_CINNAMON})).save(consumer, Recipes.EDLoc("cinnamon_toast"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.CURRYWURST.get()), (int)2).requires(ExtraDelightTags.BREAD_SLICE).requires(ExtraDelightTags.BREAD_SLICE).requires(ExtraDelightTags.KETCHUP).requires(ExtraDelightItems.CURRY_POWDER).requires(ExtraDelightTags.SAUSAGE_COOKED).requires(ExtraDelightTags.SAUSAGE_COOKED).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.CURRY_POWDER})).save(consumer, Recipes.EDLoc("currywurst"));
        Recipes.bundleItem9(Ingredient.of(ExtraDelightTags.CORN_KERNELS), (Item)ExtraDelightItems.CORN_SACK.get(), (Item)ExtraDelightItems.CORN_SEEDS.get(), consumer, "corn_kernels");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.PANFORTE.get())).pattern("ff ").pattern("ff ").define(Character.valueOf('f'), (ItemLike)ExtraDelightItems.PANFORTE_SLICE.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.PANFORTE.get()})).save(consumer, Recipes.EDLoc("panforte_slice"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ExtraDelightItems.BACON_EGG_PIE.get())).pattern("ff ").pattern("ff ").define(Character.valueOf('f'), (ItemLike)ExtraDelightItems.BACON_EGG_PIE_SLICE.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BACON_EGG_PIE.get()})).save(consumer, Recipes.EDLoc("bacon_egg_pie_slice"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ExtraDelightItems.HANGING_GARLIC.get())).pattern("ccc").pattern("crc").pattern("ccc").define(Character.valueOf('c'), (ItemLike)ExtraDelightItems.GARLIC.get()).define(Character.valueOf('r'), (ItemLike)ModItems.ROPE.get()).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GARLIC.get()})).save(consumer, Recipes.EDLoc("hanging_garlic"));
        Recipes.bundleItem9(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.GARLIC}), (Item)ExtraDelightItems.GARLIC_CRATE.get(), (Item)ExtraDelightItems.GARLIC.get(), consumer, "garlic");
    }

    public static void jamBucket(RecipeOutput consumer) {
        ItemStack s = new ItemStack((ItemLike)ExtraDelightItems.DYNAMIC_JAM.get(), 4);
        s.set(ExtraDelightComponents.DYNAMIC_FOOD, (Object)new DynamicItemComponent(List.of("sweet_berries")));
        s.set(ExtraDelightComponents.ITEMSTACK_HANDLER, (Object)ItemContainerContents.fromItems(List.of(Items.SWEET_BERRIES.getDefaultInstance(), Items.SWEET_BERRIES.getDefaultInstance(), Items.SWEET_BERRIES.getDefaultInstance(), Items.SUGAR.getDefaultInstance(), Items.SUGAR.getDefaultInstance(), Items.SUGAR.getDefaultInstance())));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, ExtraDelightItems.JAM_FLUID_BUCKET, (int)1).requires(ExtraDelightItems.DYNAMIC_JAM, 4).requires((ItemLike)Items.BUCKET, 1).unlockedBy("jam", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.DYNAMIC_JAM})).save(consumer, Recipes.EDLoc("jam_to_bucket"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemStack)s).requires(ExtraDelightItems.JAM_FLUID_BUCKET, 1).requires((ItemLike)Items.GLASS_BOTTLE, 4).unlockedBy("jam", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ExtraDelightItems.DYNAMIC_JAM})).save(consumer, Recipes.EDLoc("jam_from_bucket"));
    }

    public static void bucket(String name, RecipeOutput consumer, ItemLike fullBucket, ItemLike emptyItem, ItemLike fullItem) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)fullBucket, (int)1).requires(fullItem, 4).requires((ItemLike)Items.BUCKET, 1).unlockedBy(name, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{fullItem})).save(consumer, Recipes.EDLoc(name + "_to_bucket"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)fullItem, (int)4).requires(fullBucket, 1).requires(emptyItem, 4).unlockedBy(name, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{fullItem})).save(consumer, Recipes.EDLoc(name + "_from_bucket"));
    }

    public static void bundleItem9(Ingredient in, Item b, Item out, RecipeOutput consumer, String name) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)b, (int)1).requires(in, 9).unlockedBy(name, Recipes.has((ItemLike)out)).save(consumer, Recipes.EDLoc(name + "_to_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)out, (int)9).requires((ItemLike)b).unlockedBy(name, Recipes.has((ItemLike)b)).save(consumer, Recipes.EDLoc(name + "_from_block"));
    }

    public static void bundleItem4(Ingredient in, Item b, Item out, RecipeOutput consumer, String name) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)b, (int)1).pattern("xx").pattern("xx").define(Character.valueOf('x'), in).unlockedBy(name, Recipes.has((ItemLike)out)).save(consumer, Recipes.EDLoc(name + "_to_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)out, (int)4).requires((ItemLike)b).unlockedBy(name, Recipes.has((ItemLike)b)).save(consumer, Recipes.EDLoc(name + "_from_block"));
    }

    private void potRecipes(RecipeOutput consumer) {
        Recipes.pot((ItemLike)ModItems.BEEF_STEW.get(), 1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.BARRIER})}, consumer.withConditions(new ICondition[]{FalseCondition.INSTANCE}));
        Recipes.pot((ItemLike)ModItems.FISH_STEW.get(), 1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.BARRIER})}, consumer.withConditions(new ICondition[]{FalseCondition.INSTANCE}));
        Recipes.pot((ItemLike)ExtraDelightItems.CHOCOLATE_CUSTARD.get(), 1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, new Ingredient[]{Ingredient.of(ExtraDelightTags.COCOA_POWDER), Ingredient.of((TagKey)CommonTags.FOODS_MILK), Ingredient.of((TagKey)Tags.Items.EGGS), Ingredient.of(ExtraDelightTags.SWEETENER)}, "chocolate_custard", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.PUMPKIN_CUSTARD.get(), 1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PUMPKIN_SLICE.get()}), Ingredient.of((TagKey)CommonTags.FOODS_MILK), Ingredient.of((TagKey)Tags.Items.EGGS), Ingredient.of(ExtraDelightTags.SWEETENER)}, "pumpkin_custard", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.HONEY_CUSTARD.get(), 1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEY_BOTTLE}), Ingredient.of((TagKey)CommonTags.FOODS_MILK), Ingredient.of((TagKey)Tags.Items.EGGS), Ingredient.of(ExtraDelightTags.SWEETENER)}, "honey_custard", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.SWEET_BERRY_CUSTARD.get(), 1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES}), Ingredient.of((TagKey)CommonTags.FOODS_MILK), Ingredient.of((TagKey)Tags.Items.EGGS), Ingredient.of(ExtraDelightTags.SWEETENER)}, "sweet_berry_custard", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.APPLE_CUSTARD.get(), 1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, new Ingredient[]{Ingredient.of(ExtraDelightTags.PROCESSED_APPLE), Ingredient.of((TagKey)CommonTags.FOODS_MILK), Ingredient.of((TagKey)Tags.Items.EGGS), Ingredient.of(ExtraDelightTags.SWEETENER)}, "apple_custard", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.KETCHUP.get(), 1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, new Ingredient[]{Ingredient.of((TagKey)CommonTags.FOODS_TOMATO), Ingredient.of((TagKey)CommonTags.FOODS_TOMATO), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.VINEGAR)}, "ketchup_jar", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.BBQ_SAUCE.get(), 1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, new Ingredient[]{Ingredient.of((TagKey)CommonTags.FOODS_TOMATO), Ingredient.of((TagKey)CommonTags.FOODS_ONION), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.VINEGAR)}, "bbq_sugar", consumer);
        Recipes.pot((ItemLike)ModItems.BONE_BROTH.get(), 1, 200, 1.0f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE}), Ingredient.of(ExtraDelightTags.MAKES_STOCK)}, "stock", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.GRAVY.get(), 1, 200, 1.0f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of(ExtraDelightTags.FLOUR), Ingredient.of(ExtraDelightTags.BROTH)}, "gravy_boat", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.SALISBURY_STEAK_FEAST_ITEM.get(), 1, 400, 0.35f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.MINCED_BEEF.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.MINCED_BEEF.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.MINCED_BEEF.get()}), Ingredient.of((TagKey)CommonTags.FOODS_ONION), Ingredient.of((TagKey)Tags.Items.MUSHROOMS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GRAVY.get()})}, "salisbury_steak_feast", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.MASHED_POTATO_GRAVY_FEAST_ITEM.get(), 1, 400, 0.35f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.POTATO}), Ingredient.of((ItemLike[])new ItemLike[]{Items.POTATO}), Ingredient.of((ItemLike[])new ItemLike[]{Items.POTATO}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GRAVY.get()}), Ingredient.of(ExtraDelightTags.BUTTER), Ingredient.of((TagKey)CommonTags.FOODS_MILK)}, "mashed_potato_gravy_feast", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.FRENCH_FRIES.get(), 1, 200, 0.35f, null, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.POTATO_STICKS.get()}), Ingredient.of(ExtraDelightTags.FRYING_OIL)}, "fries", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.POTATO_CHIPS.get(), 1, 200, 0.35f, null, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.SLICED_POTATO.get()}), Ingredient.of(ExtraDelightTags.FRYING_OIL)}, "chips", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CHEESE.get(), 2, 400, 1.0f, null, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.MILK_BUCKET}), Ingredient.of(ExtraDelightTags.VINEGAR)}, "cheese_vinegar", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.BEEF_STEW_FEAST.get(), 1, 400, 0.35f, ExtraDelightItems.SERVING_POT, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.BEEF}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT}), Ingredient.of((ItemLike[])new ItemLike[]{Items.POTATO}), Ingredient.of((TagKey)CommonTags.CROPS_ONION), Ingredient.of(ExtraDelightTags.BROTH), Ingredient.of(ExtraDelightTags.FLOUR)}, "beef_stew_feast", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.PORK_STEW_FEAST.get(), 1, 400, 0.35f, ExtraDelightItems.SERVING_POT, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.PORKCHOP}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT}), Ingredient.of((ItemLike[])new ItemLike[]{Items.POTATO}), Ingredient.of((TagKey)CommonTags.CROPS_ONION), Ingredient.of(ExtraDelightTags.BROTH), Ingredient.of(ExtraDelightTags.FLOUR)}, "pork_stew", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.LAMB_STEW_FEAST.get(), 1, 400, 0.35f, ExtraDelightItems.SERVING_POT, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.MUTTON}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT}), Ingredient.of((ItemLike[])new ItemLike[]{Items.POTATO}), Ingredient.of((TagKey)CommonTags.CROPS_ONION), Ingredient.of(ExtraDelightTags.BROTH), Ingredient.of(ExtraDelightTags.FLOUR)}, "mutton_stew", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.RABBIT_STEW_FEAST.get(), 1, 400, 0.35f, ExtraDelightItems.SERVING_POT, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.RABBIT}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT}), Ingredient.of((ItemLike[])new ItemLike[]{Items.POTATO}), Ingredient.of((TagKey)CommonTags.CROPS_ONION), Ingredient.of(ExtraDelightTags.BROTH), Ingredient.of(ExtraDelightTags.FLOUR)}, "rabbit_stew", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CHICKEN_STEW_FEAST.get(), 1, 400, 0.35f, ExtraDelightItems.SERVING_POT, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.CHICKEN}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT}), Ingredient.of((ItemLike[])new ItemLike[]{Items.POTATO}), Ingredient.of((TagKey)CommonTags.CROPS_ONION), Ingredient.of(ExtraDelightTags.BROTH), Ingredient.of(ExtraDelightTags.FLOUR)}, "chicken_stew", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.FISH_STEW_FEAST.get(), 1, 400, 0.35f, ExtraDelightItems.SERVING_POT, new Ingredient[]{Ingredient.of((TagKey)CommonTags.FOODS_SAFE_RAW_FISH), Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT}), Ingredient.of((ItemLike[])new ItemLike[]{Items.POTATO}), Ingredient.of((TagKey)CommonTags.CROPS_ONION), Ingredient.of(ExtraDelightTags.BROTH), Ingredient.of(ExtraDelightTags.FLOUR)}, "fish_stew_feast", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.STIRFRY_FEAST_ITEM.get(), 1, 400, 0.35f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of(ExtraDelightTags.MEAT_RAW), Ingredient.of(ExtraDelightTags.MEAT_RAW), Ingredient.of(ExtraDelightTags.PROCESSED_VEG), Ingredient.of(ExtraDelightTags.PROCESSED_VEG), Ingredient.of(ExtraDelightTags.PROCESSED_VEG), Ingredient.of(ExtraDelightTags.PROCESSED_VEG)}, "stirfry_feast", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.FRIED_FISH.get(), 1, 200, 0.35f, null, new Ingredient[]{Ingredient.of((TagKey)ItemTags.FISHES), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BREADING_MISANPLAS.get()})}, "fried_fish", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CHICKEN_FRIED_STEAK.get(), 1, 200, 0.35f, null, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.BEEF}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BREADING_MISANPLAS.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GRAVY.get()})}, "chicken_fried_steak", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.PORK_TENDERLOIN.get(), 1, 200, 0.35f, null, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.PORKCHOP}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BREADING_MISANPLAS.get()})}, "pork_tenderloin", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.FRIED_CHICKEN.get(), 1, 200, 0.35f, null, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CHICKEN_CUTS.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BREADING_MISANPLAS.get()})}, "fried_chicken", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CARROT_SOUP.get(), 2, 200, 0.35f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of((TagKey)Tags.Items.CROPS_CARROT), Ingredient.of((TagKey)Tags.Items.CROPS_CARROT), Ingredient.of((TagKey)CommonTags.CROPS_ONION), Ingredient.of(ExtraDelightTags.BROTH), Ingredient.of((TagKey)CommonTags.FOODS_MILK)}, "carrot_soup", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.FISH_SOUP.get(), 2, 200, 0.35f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of((TagKey)ItemTags.FISHES), Ingredient.of((TagKey)ItemTags.FISHES), Ingredient.of((TagKey)CommonTags.CROPS_ONION), Ingredient.of(ExtraDelightTags.BROTH), Ingredient.of((ItemLike[])new ItemLike[]{Items.DRIED_KELP})}, "fish_soup", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.POTATO_SOUP.get(), 2, 200, 0.35f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of((TagKey)Tags.Items.CROPS_POTATO), Ingredient.of((TagKey)Tags.Items.CROPS_POTATO), Ingredient.of((TagKey)CommonTags.CROPS_ONION), Ingredient.of(ExtraDelightTags.BROTH), Ingredient.of((TagKey)CommonTags.FOODS_MILK)}, "potato_soup", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.TOMATO_SOUP.get(), 2, 200, 0.35f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of((TagKey)CommonTags.CROPS_TOMATO), Ingredient.of((TagKey)CommonTags.CROPS_TOMATO), Ingredient.of((TagKey)CommonTags.CROPS_ONION), Ingredient.of(ExtraDelightTags.BROTH), Ingredient.of((TagKey)CommonTags.FOODS_MILK)}, "tomato_soup", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.BOILED_EGG.get(), 1, 100, 0.35f, null, new Ingredient[]{Ingredient.of((TagKey)Tags.Items.EGGS)}, "boiled_egg", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.SEAWEED_PASTE.get(), 1, 400, 0.35f, null, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.DRIED_KELP}), Ingredient.of((ItemLike[])new ItemLike[]{Items.DRIED_KELP}), Ingredient.of((ItemLike[])new ItemLike[]{Items.DRIED_KELP})}, "seaweed_paste", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.GLAZED_CARROT.get(), 3, 200, 0.35f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT}), Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BUTTER.get()}), Ingredient.of(ExtraDelightTags.SWEETENER)}, "glazed_carrot", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.APPLE_SAUCE.get(), 4, 400, 0.35f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.APPLE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.APPLE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.APPLE}), Ingredient.of(ExtraDelightTags.SWEETENER)}, "apple_sauce", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.HASH_FEAST_ITEM.get(), 1, 400, 0.35f, (ItemLike)ModItems.SKILLET.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GRATED_POTATO.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GRATED_POTATO.get()}), Ingredient.of((TagKey)CommonTags.CROPS_ONION), Ingredient.of(ExtraDelightTags.FRYING_OIL), Ingredient.of(ExtraDelightTags.MEAT)}, "hash", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.SEAWEED_CRISPS.get(), 1, 100, 0.35f, null, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.DRIED_KELP}), Ingredient.of((ItemLike[])new ItemLike[]{Items.DRIED_KELP}), Ingredient.of(ExtraDelightTags.FLOUR), Ingredient.of(ExtraDelightTags.FRYING_OIL)}, "seaweed_crisps", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.MACARONI_CHEESE_FEAST.get(), 1, 200, 0.35f, ExtraDelightItems.SERVING_POT, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.MACARONI.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.MACARONI.get()}), Ingredient.of(ExtraDelightTags.BUTTER), Ingredient.of((TagKey)CommonTags.FOODS_MILK), Ingredient.of(ExtraDelightTags.CHEESE), Ingredient.of(ExtraDelightTags.CHEESE)}, "macaroni_cheese", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.FISH_CAKES.get(), 3, 200, 0.35f, null, new Ingredient[]{Ingredient.of((TagKey)Tags.Items.FOODS_COOKED_FISH), Ingredient.of((TagKey)CommonTags.CROPS_ONION), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GRATED_POTATO.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BREADING_MISANPLAS.get()})}, "fish_cakes", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.FRIED_MUSHROOMS.get(), 3, 200, 0.35f, null, new Ingredient[]{Ingredient.of((TagKey)Tags.Items.MUSHROOMS), Ingredient.of((TagKey)Tags.Items.MUSHROOMS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BREADING_MISANPLAS.get()})}, "fried_mushrooms", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.MUSHROOM_RISOTTO.get(), 2, 400, 0.35f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of((TagKey)Tags.Items.MUSHROOMS), Ingredient.of(ExtraDelightTags.CHEESE), Ingredient.of(ExtraDelightTags.BUTTER), Ingredient.of(ExtraDelightTags.BROTH), Ingredient.of((TagKey)CommonTags.CROPS_RICE), Ingredient.of(ExtraDelightTags.PROCESSED_ONION)}, "mushroom_risotto", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CURRY_FEAST.get(), 1, 400, 0.35f, ExtraDelightItems.SERVING_POT, new Ingredient[]{Ingredient.of((TagKey)CommonTags.FOODS_RAW_CHICKEN), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CURRY_POWDER.get()}), Ingredient.of(ExtraDelightTags.BROTH), Ingredient.of((TagKey)CommonTags.CROPS_ONION)}, "curry", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.ALFREDO_SAUCE.get(), 1, 200, 0.35f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of((TagKey)CommonTags.FOODS_MILK), Ingredient.of(ExtraDelightTags.CHEESE), Ingredient.of(ExtraDelightTags.BUTTER)}, "alfredo_sauce", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.COOKED_PASTA.get(), 1, 100, 0.15f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of((TagKey)CommonTags.FOODS_PASTA)}, "cooked_pasta", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CACTUS_SOUP.get(), 2, 200, 0.35f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.COOKED_CACTUS.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.COOKED_CACTUS.get()}), Ingredient.of(ExtraDelightTags.PROCESSED_TOMATO), Ingredient.of(ExtraDelightTags.PROCESSED_ONION), Ingredient.of(ExtraDelightTags.BROTH)}, "cactus_soup", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.STUFFED_CACTUS.get(), 1, 200, 0.35f, null, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.COOKED_CACTUS.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.COOKED_CACTUS.get()}), Ingredient.of(ExtraDelightTags.CHEESE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BREADING_MISANPLAS.get()})}, "stuffed_cactus", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CARAMEL_SAUCE.get(), 1, 200, 0.35f, (ItemLike)Items.GLASS_BOTTLE, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.BUTTER), Ingredient.of((TagKey)CommonTags.FOODS_MILK)}, "caramel_sauce", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CARAMEL_CANDY.get(), 2, 400, 0.35f, (ItemLike)Items.PAPER, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CARAMEL_SAUCE.get()})}, "caramel_candy", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CANDY_APPLE.get(), 1, 400, 0.35f, (ItemLike)Items.STICK, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.APPLE}), Ingredient.of(ExtraDelightTags.CANDY), Ingredient.of(ExtraDelightTags.CANDY)}, "candy_apple", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CANDY_APPLE.get(), 1, 400, 0.35f, (ItemLike)Items.STICK, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.APPLE}), Ingredient.of(ExtraDelightTags.SWEETENER)}, "candy_apple_sugar", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CARAMEL_APPLE.get(), 1, 400, 0.35f, (ItemLike)Items.STICK, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.APPLE}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CARAMEL_SAUCE.get()})}, "caramel_apple", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CANDY_GOLDEN_APPLE.get(), 1, 400, 0.35f, (ItemLike)Items.STICK, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE}), Ingredient.of(ExtraDelightTags.CANDY), Ingredient.of(ExtraDelightTags.CANDY)}, "candy_golden_apple", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CANDY_GOLDEN_APPLE.get(), 1, 400, 0.35f, (ItemLike)Items.STICK, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE}), Ingredient.of(ExtraDelightTags.SWEETENER)}, "candy_golden_apple_sugar", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CARAMEL_GOLDEN_APPLE.get(), 1, 400, 0.35f, (ItemLike)Items.STICK, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CARAMEL_SAUCE.get()})}, "caramel_golden_apple", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CORN_CHOWDER.get(), 2, 200, 0.35f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.COOKED_CORN.get()}), Ingredient.of(ExtraDelightTags.PROCESSED_POTATO), CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of((TagKey)CommonTags.FOODS_COOKED_BACON), Ingredient.of((TagKey)CommonTags.FOODS_RAW_BACON)}), Ingredient.of(ExtraDelightTags.PROCESSED_ONION), Ingredient.of((TagKey)CommonTags.FOODS_MILK), Ingredient.of(ExtraDelightTags.BROTH)}, "corn_chowder", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CREAM_CORN.get(), 1, 200, 0.35f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.COOKED_CORN.get()}), Ingredient.of((TagKey)CommonTags.FOODS_MILK), Ingredient.of(ExtraDelightTags.BUTTER)}, "cream_corn", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CORN_FRITTERS.get(), 1, 200, 0.35f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.COOKED_CORN.get()}), Ingredient.of(ExtraDelightTags.FLOUR), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.EGG_MIX.get()}), Ingredient.of(ExtraDelightTags.FRYING_OIL), Ingredient.of(ExtraDelightTags.PROCESSED_ONION)}, "corn_fritters", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.COOKED_CORN.get(), 1, 100, 0.35f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CORN_SEEDS.get()})}, "corn", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.STEWED_APPLES.get(), 1, 200, 0.35f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of(ExtraDelightTags.SLICED_APPLE), Ingredient.of(ExtraDelightTags.SLICED_APPLE), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.BUTTER)}, "stewed_apples", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.APPLE_FRITTERS.get(), 1, 200, 0.35f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of(ExtraDelightTags.PROCESSED_APPLE), Ingredient.of(ExtraDelightTags.FLOUR), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.EGG_MIX.get()}), Ingredient.of(ExtraDelightTags.FRYING_OIL), Ingredient.of(ExtraDelightTags.SWEETENER)}, "apple_fritters", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CARAMEL_CUSTARD.get(), 1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CARAMEL_SAUCE.get()}), Ingredient.of((TagKey)CommonTags.FOODS_MILK), Ingredient.of((TagKey)Tags.Items.EGGS), Ingredient.of(ExtraDelightTags.SWEETENER)}, "caramel_custard", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.STUFFING_FEAST.get(), 1, 200, 1.0f, ExtraDelightItems.SERVING_POT, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CROUTONS.get()}), Ingredient.of(ExtraDelightTags.BUTTER), Ingredient.of(ExtraDelightTags.BROTH), Ingredient.of(ExtraDelightTags.PROCESSED_ONION), Ingredient.of((TagKey)Tags.Items.EGGS)}, "stuffing", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.EGGNOG.get(), 1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.MILK_BOTTLE.get()}), Ingredient.of(ExtraDelightTags.GROUND_CINNAMON), Ingredient.of((TagKey)Tags.Items.EGGS), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.EGGS)}, "eggnog", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CANDY_BLACK.get(), 4, 100, 0.35f, (ItemLike)Items.PAPER, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_BLACK)}, "candy_black", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CANDY_BLUE.get(), 4, 100, 0.35f, (ItemLike)Items.PAPER, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_BLUE)}, "candy_blue", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CANDY_BROWN.get(), 4, 100, 0.35f, (ItemLike)Items.PAPER, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_BROWN)}, "candy_brown", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CANDY_CYAN.get(), 4, 100, 0.35f, (ItemLike)Items.PAPER, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_CYAN)}, "candy_cyan", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CANDY_GRAY.get(), 4, 100, 0.35f, (ItemLike)Items.PAPER, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_GRAY)}, "candy_gray", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CANDY_GREEN.get(), 4, 100, 0.35f, (ItemLike)Items.PAPER, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_GREEN)}, "candy_green", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CANDY_LIGHT_BLUE.get(), 4, 100, 0.35f, (ItemLike)Items.PAPER, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_LIGHT_BLUE)}, "candy_light_blue", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CANDY_LIGHT_GRAY.get(), 4, 100, 0.35f, (ItemLike)Items.PAPER, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_LIGHT_GRAY)}, "candy_light_gray", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CANDY_LIME.get(), 4, 100, 0.35f, (ItemLike)Items.PAPER, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_LIME)}, "candy_lime", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CANDY_MAGENTA.get(), 4, 100, 0.35f, (ItemLike)Items.PAPER, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_MAGENTA)}, "candy_magenta", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CANDY_ORANGE.get(), 4, 100, 0.35f, (ItemLike)Items.PAPER, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_ORANGE)}, "candy_orange", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CANDY_PINK.get(), 4, 100, 0.35f, (ItemLike)Items.PAPER, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_PINK)}, "candy_pink", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CANDY_PURPLE.get(), 4, 100, 0.35f, (ItemLike)Items.PAPER, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_PURPLE)}, "candy_purple", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CANDY_RED.get(), 4, 100, 0.35f, (ItemLike)Items.PAPER, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_RED)}, "candy_red", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CANDY_WHITE.get(), 4, 100, 0.35f, (ItemLike)Items.PAPER, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_WHITE)}, "candy_white", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CANDY_YELLOW.get(), 4, 100, 0.35f, (ItemLike)Items.PAPER, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_YELLOW)}, "candy_yellow", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.GINGER_BEER.get(), 1, 400, 0.35f, (ItemLike)Items.GLASS_BOTTLE, new Ingredient[]{Ingredient.of(ExtraDelightTags.PROCESSED_GINGER), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.YEAST.get()})}, "ginger_beer", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.HORCHATA.get(), 1, 400, 0.35f, (ItemLike)Items.GLASS_BOTTLE, new Ingredient[]{Ingredient.of((TagKey)CommonTags.CROPS_RICE), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.GROUND_CINNAMON), Ingredient.of((TagKey)CommonTags.FOODS_MILK)}, "horchata", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.MINT_CANDY_BLUE.get(), 4, 100, 0.35f, null, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_BLUE), Ingredient.of(ExtraDelightTags.MINT)}, "mint_candy_blue", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.MINT_CANDY_GREEN.get(), 4, 100, 0.35f, null, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_GREEN), Ingredient.of(ExtraDelightTags.MINT)}, "mint_candy_green", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.MINT_CANDY_RED.get(), 4, 100, 0.35f, null, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of((TagKey)Tags.Items.DYES_RED), Ingredient.of(ExtraDelightTags.MINT)}, "mint_candy_red", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CONGEE.get(), 1, 400, 0.35f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of((TagKey)CommonTags.CROPS_RICE), Ingredient.of(ExtraDelightTags.PROCESSED_GINGER)}, "congee", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.LUGAW.get(), 1, 400, 0.35f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of((TagKey)CommonTags.CROPS_RICE), Ingredient.of(ExtraDelightTags.PROCESSED_GINGER), Ingredient.of(ExtraDelightTags.PROCESSED_ONION), Ingredient.of(ExtraDelightTags.BROTH), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BOILED_EGG.get()}), Ingredient.of((TagKey)CommonTags.FOODS_COOKED_CHICKEN)}, "lugaw", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.RICE_PUDDING.get(), 1, 200, 0.35f, (ItemLike)Items.GLASS_BOTTLE, new Ingredient[]{Ingredient.of((TagKey)CommonTags.CROPS_RICE), Ingredient.of((TagKey)CommonTags.CROPS_RICE), Ingredient.of((TagKey)CommonTags.FOODS_MILK), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.GROUND_CINNAMON)}, "rice_pudding", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CANDIED_GINGER.get(), 4, 200, 0.35f, (ItemLike)Items.PAPER, new Ingredient[]{Ingredient.of(ExtraDelightTags.PROCESSED_GINGER), Ingredient.of(ExtraDelightTags.SWEETENER)}, "candied_ginger", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.XOCOLATL.get(), 1, 200, 0.35f, (ItemLike)Items.GLASS_BOTTLE, new Ingredient[]{Ingredient.of((TagKey)CommonTags.FOODS_MILK), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.CHOCOLATE_SYRUP), Ingredient.of(ExtraDelightTags.CHILI_POWDER)}, "xocolatl", consumer);
        Recipes.pot((ItemLike)ModItems.HOT_COCOA.get(), 1, 200, 0.35f, (ItemLike)Items.GLASS_BOTTLE, new Ingredient[]{Ingredient.of((TagKey)CommonTags.FOODS_MILK), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.CHOCOLATE_SYRUP)}, consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.XOCOLATL.get(), 1, 200, 0.35f, (ItemLike)Items.GLASS_BOTTLE, new Ingredient[]{Ingredient.of((TagKey)CommonTags.FOODS_MILK), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.COCOA_POWDER), Ingredient.of(ExtraDelightTags.CHILI_POWDER)}, "xocolatl_beans", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.PEANUT_BRITTLE.get(), 4, 200, 0.35f, null, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.BUTTER), Ingredient.of(ExtraDelightTags.ROASTED_NUTS)}, "peanut_brittle", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.BUTTERSCOTCH.get(), 2, 200, 0.35f, null, new Ingredient[]{Ingredient.of(ExtraDelightTags.SWEETENER), Ingredient.of(ExtraDelightTags.BUTTER)}, "butterscotch", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.COFFEE.get(), 1, 100, 0.35f, (ItemLike)Items.GLASS_BOTTLE, new Ingredient[]{Ingredient.of(ExtraDelightTags.GROUND_COFFEE_BEANS)}, "coffee", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.TEA.get(), 1, 100, 0.35f, (ItemLike)Items.GLASS_BOTTLE, new Ingredient[]{Ingredient.of(ExtraDelightTags.TEA_INGREDIENTS), Ingredient.of(ExtraDelightTags.TEA_INGREDIENTS), Ingredient.of(ExtraDelightTags.SWEETENER)}, "tea", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CRISP_RICE_TREATS_BLOCK.get(), 1, 200, 0.35f, (ItemLike)ExtraDelightItems.TRAY.get(), new Ingredient[]{Ingredient.of(ExtraDelightTags.PUFFED_RICE), Ingredient.of(ExtraDelightTags.MARSHMALLOW), Ingredient.of(ExtraDelightTags.BUTTER)}, "crisp_rice_treats", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.SCOTCHAROO_BLOCK.get(), 1, 200, 0.35f, (ItemLike)ExtraDelightItems.TRAY.get(), new Ingredient[]{Ingredient.of(ExtraDelightTags.PUFFED_RICE), Ingredient.of(ExtraDelightTags.MARSHMALLOW), Ingredient.of(ExtraDelightTags.BUTTER), Ingredient.of(ExtraDelightTags.BUTTERSCOTCH), Ingredient.of(ExtraDelightTags.CHOCOLATE_SYRUP), Ingredient.of(ExtraDelightTags.NUT_BUTTER)}, "scotcharoos", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.SOS.get(), 1, 200, 0.35f, (ItemLike)ExtraDelightItems.BREAD_SLICE.get(), new Ingredient[]{Ingredient.of(ExtraDelightTags.SCRAP_BEEF), Ingredient.of(ExtraDelightTags.FLOUR), Ingredient.of((TagKey)CommonTags.FOODS_MILK)}, "sos", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.OXTAIL_SOUP.get(), 2, 200, 0.35f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of(ExtraDelightTags.OXTAIL), Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT}), Ingredient.of(ExtraDelightTags.BROTH), Ingredient.of(ExtraDelightTags.PROCESSED_TOMATO)}, "oxtail_soup", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.LIVER_ONIONS.get(), 1, 200, 0.35f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of(ExtraDelightTags.LIVER), Ingredient.of(ExtraDelightTags.PROCESSED_ONION)}, "liver_onions", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.FRIED_BRAINS.get(), 1, 200, 0.35f, null, new Ingredient[]{Ingredient.of(ExtraDelightTags.BRAIN), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BREADING_MISANPLAS.get()})}, "fried_brains", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.MULLIGATAWNY_SOUP.get(), 2, 200, 0.35f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CURRY_POWDER.get()}), Ingredient.of(ExtraDelightTags.SLICED_APPLE), Ingredient.of(ExtraDelightTags.PROCESSED_ONION), Ingredient.of(ExtraDelightTags.BROTH), Ingredient.of((TagKey)CommonTags.FOODS_RAW_CHICKEN), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.RICE.get()})}, "mulligatawny_soup", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.AEBLEFLAESK.get(), 1, 200, 0.35f, ExtraDelightItems.TOAST, new Ingredient[]{Ingredient.of(ExtraDelightTags.SLICED_APPLE), Ingredient.of(ExtraDelightTags.PROCESSED_ONION), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BACON.get()}), Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})}, "aebleflaesk", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.CHILI_CON_CARNE_FEAST.get(), 1, 200, 0.35f, ExtraDelightItems.SERVING_POT, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TOMATO_SAUCE.get()}), Ingredient.of(ExtraDelightTags.BROTH), Ingredient.of(ExtraDelightTags.MEAT), Ingredient.of(ExtraDelightTags.CHILI_POWDER), Ingredient.of(ExtraDelightTags.PROCESSED_VEG), Ingredient.of(ExtraDelightTags.PROCESSED_VEG)}, "chili_con_carne", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.WHITE_CHILI_FEAST.get(), 1, 200, 0.35f, ExtraDelightItems.SERVING_POT, new Ingredient[]{Ingredient.of((TagKey)CommonTags.FOODS_MILK), Ingredient.of(ExtraDelightTags.BROTH), Ingredient.of((TagKey)CommonTags.FOODS_COOKED_CHICKEN), Ingredient.of(ExtraDelightTags.PROCESSED_CHILI), Ingredient.of(ExtraDelightTags.PROCESSED_VEG), Ingredient.of(ExtraDelightTags.PROCESSED_VEG)}, "white_chili", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.NUT_BUTTER_CUSTARD.get(), 1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, new Ingredient[]{Ingredient.of(ExtraDelightTags.NUT_BUTTER), Ingredient.of((TagKey)CommonTags.FOODS_MILK), Ingredient.of((TagKey)Tags.Items.EGGS), Ingredient.of(ExtraDelightTags.SWEETENER)}, "nut_butter_custard", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.HAZELNUT_SOUP.get(), 2, 200, 1.0f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of(ExtraDelightTags.ROASTED_HAZELNUTS), Ingredient.of((TagKey)CommonTags.FOODS_MILK), Ingredient.of(ExtraDelightTags.PROCESSED_ONION), Ingredient.of(ExtraDelightTags.PROCESSED_POTATO), Ingredient.of(ExtraDelightTags.BUTTER), Ingredient.of((TagKey)CommonTags.FOODS_COOKED_BACON)}, "hazelnut_soup", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.ONION_SOUP.get(), 3, 200, 1.0f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of(ExtraDelightTags.PROCESSED_ONION), Ingredient.of(ExtraDelightTags.PROCESSED_ONION), Ingredient.of(ExtraDelightTags.BUTTER), Ingredient.of(ExtraDelightTags.BROTH), Ingredient.of(ExtraDelightTags.BREAD_SLICE), Ingredient.of(ExtraDelightTags.CHEESE)}, "onion_soup", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.ONION_BHAJI.get(), 2, 200, 1.0f, null, new Ingredient[]{Ingredient.of(ExtraDelightTags.PROCESSED_ONION), Ingredient.of(ExtraDelightTags.PROCESSED_ONION), Ingredient.of(ExtraDelightTags.FLOUR), Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.CURRY_POWDER}), Ingredient.of(ExtraDelightTags.COOKING_OIL)}, "onion_bhaji", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.PAMONHA.get(), 2, 200, 1.0f, null, new Ingredient[]{Ingredient.of(ExtraDelightTags.CORN_KERNELS), Ingredient.of(ExtraDelightTags.CORN_KERNELS), Ingredient.of((TagKey)CommonTags.FOODS_MILK), Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.CORN_HUSK})}, "pamonha", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.BORSCHT.get(), 4, 200, 1.0f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of(ExtraDelightTags.BROTH), Ingredient.of(ExtraDelightTags.PROCESSED_BEETROOT), Ingredient.of(ExtraDelightTags.PROCESSED_CARROT), Ingredient.of(ExtraDelightTags.PROCESSED_CABBAGE), Ingredient.of(ExtraDelightTags.PROCESSED_POTATO), Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.SLICED_TOMATO, (ItemLike)ModItems.TOMATO_SAUCE.get(), (ItemLike)ModItems.TOMATO.get()})}, "borscht", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.DEVILLED_SAUSAGES.get(), 2, 200, 1.0f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of(ExtraDelightTags.BROTH), Ingredient.of(ExtraDelightTags.PROCESSED_ONION), Ingredient.of(ExtraDelightTags.SAUSAGE_RAW), Ingredient.of(ExtraDelightTags.PROCESSED_APPLE), Ingredient.of(ExtraDelightTags.PROCESSED_GARLIC)}, "devilled_sausages", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.AGLIO_E_OLIO.get(), 1, 200, 1.0f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of(ExtraDelightTags.RAW_PASTA), Ingredient.of(ExtraDelightTags.PROCESSED_GARLIC), Ingredient.of(ExtraDelightTags.COOKING_OIL), Ingredient.of(ExtraDelightTags.PROCESSED_CHILI), Ingredient.of(ExtraDelightTags.CHEESE)}, "aglio_e_olio", consumer);
        Recipes.pot((ItemLike)ExtraDelightItems.PENNE_ALL_ARRABIATA.get(), 1, 200, 1.0f, (ItemLike)Items.BOWL, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.PENNE.get()}), Ingredient.of(ExtraDelightTags.PROCESSED_GARLIC), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TOMATO_SAUCE.get()}), Ingredient.of(ExtraDelightTags.PROCESSED_CHILI), Ingredient.of(ExtraDelightTags.COOKING_OIL)}, "penne_all_arrabbiata", consumer);
    }

    private void dynamicJamRecipes(RecipeOutput consumer) {
        DynamicJamRecipeBuilder.cookingPotRecipe(1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, "chorus_fruit").addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.CHORUS_FRUIT})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.CHORUS_FRUIT})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.CHORUS_FRUIT})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer, "dynamic_chorus");
        DynamicJamRecipeBuilder.cookingPotRecipe(1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, "apple").addIngredient(Ingredient.of(ExtraDelightTags.PROCESSED_APPLE)).addIngredient(Ingredient.of(ExtraDelightTags.PROCESSED_APPLE)).addIngredient(Ingredient.of(ExtraDelightTags.PROCESSED_APPLE)).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer, "dynamic_apple");
        DynamicJamRecipeBuilder.cookingPotRecipe(1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, "melon").addIngredient(Ingredient.of(ExtraDelightTags.PROCESSED_MELON)).addIngredient(Ingredient.of(ExtraDelightTags.PROCESSED_MELON)).addIngredient(Ingredient.of(ExtraDelightTags.PROCESSED_MELON)).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer, "dynamic_melon");
        DynamicJamRecipeBuilder.cookingPotRecipe(1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, "sweet_berries").addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer, "dynamic_berries");
        DynamicJamRecipeBuilder.cookingPotRecipe(1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, "carrot").addIngredient(Ingredient.of(ExtraDelightTags.PROCESSED_CARROT)).addIngredient(Ingredient.of(ExtraDelightTags.PROCESSED_CARROT)).addIngredient(Ingredient.of(ExtraDelightTags.PROCESSED_CARROT)).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer, "dynamic_carrot");
        DynamicJamRecipeBuilder.cookingPotRecipe(1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, "golden_apple").addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer, "dynamic_golden_apple");
        DynamicJamRecipeBuilder.cookingPotRecipe(1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, "glow_berries").addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOW_BERRIES})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOW_BERRIES})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOW_BERRIES})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer, "dynamic_glow_berries");
        DynamicJamRecipeBuilder.cookingPotRecipe(1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, "orange").addIngredient(Ingredient.of(ExtraDelightTags.PROCESSED_ORANGE)).addIngredient(Ingredient.of(ExtraDelightTags.PROCESSED_ORANGE)).addIngredient(Ingredient.of(ExtraDelightTags.PROCESSED_ORANGE)).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer, "dynamic_orange");
        DynamicJamRecipeBuilder.cookingPotRecipe(1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, "lemon").addIngredient(Ingredient.of(ExtraDelightTags.PROCESSED_LEMON)).addIngredient(Ingredient.of(ExtraDelightTags.PROCESSED_LEMON)).addIngredient(Ingredient.of(ExtraDelightTags.PROCESSED_LEMON)).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer, "dynamic_lemon");
        DynamicJamRecipeBuilder.cookingPotRecipe(1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, "lime").addIngredient(Ingredient.of(ExtraDelightTags.PROCESSED_LIME)).addIngredient(Ingredient.of(ExtraDelightTags.PROCESSED_LIME)).addIngredient(Ingredient.of(ExtraDelightTags.PROCESSED_LIME)).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer, "dynamic_lime");
        DynamicJamRecipeBuilder.cookingPotRecipe(1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, "grapefruit").addIngredient(Ingredient.of(ExtraDelightTags.PROCESSED_GRAPEFRUIT)).addIngredient(Ingredient.of(ExtraDelightTags.PROCESSED_GRAPEFRUIT)).addIngredient(Ingredient.of(ExtraDelightTags.PROCESSED_GRAPEFRUIT)).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer, "dynamic_grapefruit");
        DynamicJamRecipeBuilder.cookingPotRecipe(1, 200, 1.0f, (ItemLike)Items.GLASS_BOTTLE, "mint").addIngredient(Ingredient.of(ExtraDelightTags.MINT)).addIngredient(Ingredient.of(ExtraDelightTags.MINT)).addIngredient(Ingredient.of(ExtraDelightTags.MINT)).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).addIngredient(Ingredient.of(ExtraDelightTags.GELATIN)).addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(consumer, "dynamic_mint");
    }

    private void dynamicToast(RecipeOutput consumer) {
        DynamicToastRecipeBuilder.shapeless(RecipeCategory.FOOD, ExtraDelightItems.DYNAMIC_TOAST.toStack(), "dynamic").requires(Ingredient.of(ExtraDelightTags.TOAST)).requires(ALL_JAM_AS_INGREDIENT).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.TOAST.get()})).save(consumer, Recipes.EDLoc("dynamic_toast_dynamic_jam"));
        DynamicToastRecipeBuilder.shapeless(RecipeCategory.FOOD, ExtraDelightItems.DYNAMIC_TOAST.toStack(), "lemon_curd").requires(Ingredient.of(ExtraDelightTags.TOAST)).requires(Ingredient.of((ItemLike[])new ItemLike[]{SummerCitrus.LEMON_CURD})).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.TOAST.get()})).save(consumer, Recipes.EDLoc("dynamic_toast_lemon_curd"));
        DynamicToastRecipeBuilder.shapeless(RecipeCategory.FOOD, ExtraDelightItems.DYNAMIC_TOAST.toStack(), "nut_butter").requires(Ingredient.of(ExtraDelightTags.TOAST)).requires(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.PEANUT_BUTTER_BOTTLE})).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.TOAST.get()})).save(consumer, Recipes.EDLoc("dynamic_toast_nut_butter"));
        DynamicToastRecipeBuilder.shapeless(RecipeCategory.FOOD, ExtraDelightItems.DYNAMIC_TOAST.toStack(), "hazelnut_spread").requires(Ingredient.of(ExtraDelightTags.TOAST)).requires(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.HAZELNUT_SPREAD_BOTTLE})).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.TOAST.get()})).save(consumer, Recipes.EDLoc("dynamic_toast_hazelnut_spread"));
        DynamicToastRecipeBuilder.shapeless(RecipeCategory.FOOD, ExtraDelightItems.DYNAMIC_TOAST.toStack(), "marshmallow_fluff").requires(Ingredient.of(ExtraDelightTags.TOAST)).requires(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.MARSHMALLOW_FLUFF_BOTTLE})).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.TOAST.get()})).save(consumer, Recipes.EDLoc("dynamic_toast_marshmallow_fluff"));
        DynamicToastRecipeBuilder.shapeless(RecipeCategory.FOOD, ExtraDelightItems.DYNAMIC_TOAST.toStack(), "yeast_spread").requires(Ingredient.of(ExtraDelightTags.TOAST)).requires(Ingredient.of((ItemLike[])new ItemLike[]{Fermentation.YEAST_SPREAD})).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.TOAST.get()})).save(consumer, Recipes.EDLoc("dynamic_toast_yeast_spread"));
        DynamicToastRecipeBuilder.shapeless(RecipeCategory.FOOD, ExtraDelightItems.DYNAMIC_TOAST.toStack(), "butter").requires(Ingredient.of(ExtraDelightTags.TOAST)).requires(Ingredient.of(ExtraDelightTags.BUTTER)).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.TOAST.get()})).save(consumer, Recipes.EDLoc("dynamic_toast_butter"));
    }

    private void knifeRecipes(RecipeOutput consumer) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.WHEAT}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)Items.WHEAT_SEEDS, (int)2).addResult((ItemLike)ModItems.STRAW.get()).build(consumer, Recipes.EDLoc("cutting/wheat_seeds"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.SUNFLOWER}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.SUNFLOWER_SEEDS.get()), (int)2).addResult((ItemLike)Items.YELLOW_DYE, 2).build(consumer, Recipes.EDLoc("cutting/sunflower_seeds"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.APPLE}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.SLICED_APPLE.get()), (int)2).build(consumer, Recipes.EDLoc("cutting/cut_apples"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((TagKey)Tags.Items.CROPS_POTATO), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GRATER.get()}), (ItemLike)((ItemLike)ExtraDelightItems.GRATED_POTATO.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/grate_potato"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((TagKey)Tags.Items.CROPS_CARROT), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GRATER.get()}), (ItemLike)((ItemLike)ExtraDelightItems.GRATED_CARROT.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/grate_carrot"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((TagKey)Tags.Items.FOODS_BREAD), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GRATER.get()}), (ItemLike)((ItemLike)ExtraDelightItems.BREAD_CRUMBS.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/grate_bread"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GARLIC_CLOVE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GRATER.get()}), (ItemLike)((ItemLike)ExtraDelightItems.GRATED_GARLIC.get()), (int)1).build(consumer, Recipes.EDLoc("cutting/grate_garlic"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((TagKey)Tags.Items.CROPS_POTATO), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.SLICED_POTATO.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/sliced_potato"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.SLICED_POTATO.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.POTATO_STICKS.get()), (int)1).build(consumer, Recipes.EDLoc("cutting/stick_potato"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GLOW_BERRY_PIE_ITEM.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.GLOW_BERRY_PIE_SLICE.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/glow_berry_pie_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.MEAT_PIE_BLOCK_ITEM.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.MEAT_PIE_SLICE.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/meat_pie_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.SWEET_BERRY_PIE_ITEM.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.SWEET_BERRY_PIE_SLICE.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/sweet_berry_pie_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CHOCOLATE_CHEESECAKE_ITEM.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.CHOCOLATE_CHEESECAKE_SLICE.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/chocolate_cheesecake_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GLOW_BERRY_CHEESECAKE_ITEM.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.GLOW_BERRY_CHEESECAKE_SLICE.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/glow_berry_cheesecake_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.HONEY_CHEESECAKE_ITEM.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.HONEY_CHEESECAKE_SLICE.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/honey_cheesecake_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.PUMPKIN_CHEESECAKE_ITEM.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.PUMPKIN_CHEESECAKE_SLICE.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/pumpkin_cheesecake_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.APPLE_CHEESECAKE_ITEM.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.APPLE_CHEESECAKE_SLICE.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/apple_cheesecake_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CHEESECAKE_ITEM.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.CHEESECAKE_SLICE.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/cheesecake_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.QUICHE.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.QUICHE_SLICE.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/quiche_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.BREAD}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.BREAD_SLICE.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/bread_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of(ExtraDelightTags.BREAD_SLICE), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.CROUTONS.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/croutons_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((TagKey)CommonTags.CROPS_ONION), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.SLICED_ONION.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/sliced_onion"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((TagKey)CommonTags.CROPS_TOMATO), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.SLICED_TOMATO.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/sliced_tomato"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.CACTUS}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.CACTUS.get()), (int)2).build(consumer, Recipes.EDLoc("cutting/sliced_cactus"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CARAMEL_CHEESECAKE_ITEM.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.CARAMEL_CHEESECAKE_SLICE.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/caramel_cheesecake_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.PUMPKIN_PIE_ITEM.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.PUMPKIN_PIE_SLICE.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/pumpkin_pie_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.PUMPKIN_ROLL_FEAST.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.PUMPKIN_ROLL.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/pumpkin_roll_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CORN_ON_COB.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.CORN_SEEDS.get()), (int)1).addResult((ItemLike)ExtraDelightItems.CORN_COB.get(), 1).addResultWithChance((ItemLike)ExtraDelightItems.CORN_SEEDS.get(), 0.75f, 1).build(consumer, Recipes.EDLoc("cutting/corn_seeds_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CINNAMON_BARK.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.RAW_CINNAMON.get()), (int)2).addResultWithChance((ItemLike)ExtraDelightItems.RAW_CINNAMON.get(), 0.75f, 1).addResultWithChance((ItemLike)ModItems.TREE_BARK.get(), 0.75f, 1).build(consumer, Recipes.EDLoc("cutting/cinnamon_bark_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GINGER.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.GINGER_CUTTING.get()), (int)1).addResultWithChance((ItemLike)ExtraDelightItems.GINGER_CUTTING.get(), 0.75f, 1).build(consumer, Recipes.EDLoc("cutting/ginger_cutting_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of(ExtraDelightTags.GINGER), (Ingredient)Ingredient.of(ExtraDelightTags.SPOONS), (ItemLike)((ItemLike)ExtraDelightItems.PEELED_GINGER.get()), (int)1).addResultWithChance((ItemLike)ExtraDelightItems.GINGER_CUTTING.get(), 0.25f, 1).build(consumer, Recipes.EDLoc("cutting/spoon_ginger"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.PEELED_GINGER.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.SLICED_GINGER.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/sliced_ginger_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.PEELED_GINGER.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GRATER.get()}), (ItemLike)((ItemLike)ExtraDelightItems.GRATED_GINGER.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/grated_ginger"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.COFFEE_CAKE_FEAST.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.COFFEE_CAKE_SLICE.get()), (int)7).build(consumer, Recipes.EDLoc("cutting/coffee_cake_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.MILK_TART_FEAST.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.MILK_TART_SLICE.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/milk_tart_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CINNAMON_LOG.get()}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.AXE_STRIP).toVanilla(), (ItemLike)((ItemLike)ExtraDelightItems.STRIPPED_CINNAMON_LOG.get())).addResult((ItemLike)ExtraDelightItems.CINNAMON_BARK.get()).addSound(SoundEvents.AXE_STRIP).build(consumer, Recipes.EDLoc("cutting/strip_cinnamon_log"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CINNAMON_WOOD.get()}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.AXE_STRIP).toVanilla(), (ItemLike)((ItemLike)ExtraDelightItems.STRIPPED_CINNAMON_WOOD.get())).addResult((ItemLike)ExtraDelightItems.CINNAMON_BARK.get()).addSound(SoundEvents.AXE_STRIP).build(consumer, Recipes.EDLoc("cutting/strip_cinnamon_wood"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CINNAMON_DOOR.get()}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.AXE_DIG).toVanilla(), (ItemLike)((ItemLike)ExtraDelightItems.CINNAMON_PLANKS.get())).build(consumer, Recipes.EDLoc("cutting/cinnamon_door_to_plank"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CINNAMON_TRAPDOOR.get()}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.AXE_DIG).toVanilla(), (ItemLike)((ItemLike)ExtraDelightItems.CINNAMON_PLANKS.get())).build(consumer, Recipes.EDLoc("cutting/cinnamon_trapdoor_to_plank"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.FRUIT_LOG.get()}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.AXE_STRIP).toVanilla(), (ItemLike)((ItemLike)ExtraDelightItems.STRIPPED_FRUIT_LOG.get())).addResult((ItemLike)ModItems.TREE_BARK.get()).addSound(SoundEvents.AXE_STRIP).build(consumer, Recipes.EDLoc("cutting/strip_fruit_log"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.FRUIT_WOOD.get()}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.AXE_STRIP).toVanilla(), (ItemLike)((ItemLike)ExtraDelightItems.STRIPPED_FRUIT_WOOD.get())).addResult((ItemLike)ModItems.TREE_BARK.get()).addSound(SoundEvents.AXE_STRIP).build(consumer, Recipes.EDLoc("cutting/strip_fruit_wood"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.FRUIT_DOOR.get()}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.AXE_DIG).toVanilla(), (ItemLike)((ItemLike)ExtraDelightItems.FRUIT_PLANKS.get())).build(consumer, Recipes.EDLoc("cutting/fruit_door_to_plank"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.FRUIT_TRAPDOOR.get()}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.AXE_DIG).toVanilla(), (ItemLike)((ItemLike)ExtraDelightItems.FRUIT_PLANKS.get())).build(consumer, Recipes.EDLoc("cutting/fruit_trapdoor_to_plank"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_DOOR.get()}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.PICKAXE_DIG).toVanilla(), (ItemLike)((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_BLOCK.get())).build(consumer, Recipes.EDLoc("cutting/blood_chocolate_door_to_block"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_TRAPDOOR.get()}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.PICKAXE_DIG).toVanilla(), (ItemLike)((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_BLOCK.get())).build(consumer, Recipes.EDLoc("cutting/blood_chocolate_trapdoor_to_block"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.DARK_CHOCOLATE_DOOR.get()}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.PICKAXE_DIG).toVanilla(), (ItemLike)((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_BLOCK.get())).build(consumer, Recipes.EDLoc("cutting/dark_chocolate_door_to_block"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.DARK_CHOCOLATE_TRAPDOOR.get()}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.PICKAXE_DIG).toVanilla(), (ItemLike)((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_BLOCK.get())).build(consumer, Recipes.EDLoc("cutting/dark_chocolate_trapdoor_to_block"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.MILK_CHOCOLATE_DOOR.get()}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.PICKAXE_DIG).toVanilla(), (ItemLike)((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_BLOCK.get())).build(consumer, Recipes.EDLoc("cutting/milk_chocolate_door_to_block"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.MILK_CHOCOLATE_TRAPDOOR.get()}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.PICKAXE_DIG).toVanilla(), (ItemLike)((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_BLOCK.get())).build(consumer, Recipes.EDLoc("cutting/milk_chocolate_trapdoor_to_block"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_DOOR.get()}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.PICKAXE_DIG).toVanilla(), (ItemLike)((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_BLOCK.get())).build(consumer, Recipes.EDLoc("cutting/white_chocolate_door_to_block"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_TRAPDOOR.get()}), (Ingredient)new ItemAbilityIngredient(ItemAbilities.PICKAXE_DIG).toVanilla(), (ItemLike)((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_BLOCK.get())).build(consumer, Recipes.EDLoc("cutting/white_chocolate_trapdoor_to_block"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of(ExtraDelightTags.BLOOD_CHOCOLATE_BAR), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.BLOOD_CHOCOLATE_CHIPS.get()), (int)5).build(consumer, Recipes.EDLoc("cutting/blood_chocolate_chips"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of(ExtraDelightTags.DARK_CHOCOLATE_BAR), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.DARK_CHOCOLATE_CHIPS.get()), (int)5).build(consumer, Recipes.EDLoc("cutting/dark_chocolate_chips"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of(ExtraDelightTags.MILK_CHOCOLATE_BAR), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.MILK_CHOCOLATE_CHIPS.get()), (int)5).build(consumer, Recipes.EDLoc("cutting/milk_chocolate_chips"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of(ExtraDelightTags.WHITE_CHOCOLATE_BAR), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.WHITE_CHOCOLATE_CHIPS.get()), (int)5).build(consumer, Recipes.EDLoc("cutting/white_chocolate_chips"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.PEANUTS_IN_SHELL.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.PEANUTS.get()), (int)2).build(consumer, Recipes.EDLoc("cutting/peanuts"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.HAZELNUTS_IN_SHELL.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.HAZELNUTS.get()), (int)2).build(consumer, Recipes.EDLoc("cutting/hazelnuts"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CHOCOLATE_CAKE_BLOCK.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.CHOCOLATE_CAKE.get()), (int)7).build(consumer, Recipes.EDLoc("cutting/chocolate_cake_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.TARTE_TATIN.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.TARTE_TATIN_SLICE.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/tarte_tatin_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CHILI.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.SLICED_CHILI.get()), (int)3).build(consumer, Recipes.EDLoc("cutting/chili_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.MISSISSIPPI_MUD_PIE.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.MISSISSIPPI_MUD_PIE_SLICE.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/mississippi_pie_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GRASSHOPPER_PIE.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.GRASSHOPPER_PIE_SLICE.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/grasshopper_pie_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.PANFORTE.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.PANFORTE_SLICE.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/panforte_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.BACON_EGG_PIE.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.BACON_EGG_PIE_SLICE.get()), (int)4).build(consumer, Recipes.EDLoc("cutting/bacon_egg_pie_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GARLIC.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.GARLIC_CLOVE.get()), (int)3).addResultWithChance((ItemLike)ExtraDelightItems.GARLIC_CLOVE.get(), 0.75f, 1).build(consumer, Recipes.EDLoc("cutting/garlic_dividing_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.WILD_GINGER.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.GINGER.get()), (int)1).addResultWithChance((ItemLike)Items.RED_DYE, 0.5f, 2).build(consumer, Recipes.EDLoc("cutting/wild_ginger_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.WILD_PEANUT_BLOCK.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.PEANUTS_IN_SHELL.get()), (int)1).addResultWithChance((ItemLike)Items.YELLOW_DYE, 0.5f, 2).build(consumer, Recipes.EDLoc("cutting/wild_peanut_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.WILD_CHILI_BLOCK.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.CHILI_SEEDS.get()), (int)1).addResultWithChance((ItemLike)ExtraDelightItems.CHILI.get(), 0.2f, 1).addResultWithChance((ItemLike)Items.GREEN_DYE, 0.1f, 1).build(consumer, Recipes.EDLoc("cutting/wild_chili_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.WILD_MALLOW_ROOT_BLOCK.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.MALLOW_ROOT.get()), (int)1).addResultWithChance((ItemLike)Items.PINK_DYE, 0.5f, 2).build(consumer, Recipes.EDLoc("cutting/wild_mallow_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.WILD_GARLIC_BLOCK.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.GARLIC.get()), (int)1).addResult((ItemLike)Items.MAGENTA_DYE, 2).addResultWithChance((ItemLike)Items.LIME_DYE, 0.1f, 1).build(consumer, Recipes.EDLoc("cutting/wild_garlic_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.HANGING_CHILI.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.CHILI.get()), (int)8).addResultWithChance((ItemLike)ModItems.ROPE.get(), 0.5f, 1).build(consumer, Recipes.EDLoc("cutting/hanging_chili_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.HANGING_CORN.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.CORN_ON_COB.get()), (int)8).addResultWithChance((ItemLike)ModItems.ROPE.get(), 0.5f, 1).build(consumer, Recipes.EDLoc("cutting/hanging_corn_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.HANGING_DRIED_CHILI.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.DRIED_CHILI.get()), (int)8).addResultWithChance((ItemLike)ModItems.ROPE.get(), 0.5f, 1).build(consumer, Recipes.EDLoc("cutting/hanging_dried_chili_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.HANGING_GARLIC.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.GARLIC.get()), (int)8).addResultWithChance((ItemLike)ModItems.ROPE.get(), 0.5f, 1).build(consumer, Recipes.EDLoc("cutting/hanging_garlic_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.HANGING_HAM.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ModItems.HAM.get()), (int)1).addResultWithChance((ItemLike)ModItems.ROPE.get(), 0.5f, 1).build(consumer, Recipes.EDLoc("cutting/hanging_ham_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.HANGING_MINT.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ExtraDelightItems.MINT.get()), (int)4).addResultWithChance((ItemLike)ModItems.ROPE.get(), 0.5f, 1).build(consumer, Recipes.EDLoc("cutting/hanging_mint_knife"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.HANGING_ONION.get()}), (Ingredient)Ingredient.of((TagKey)CommonTags.TOOLS_KNIFE), (ItemLike)((ItemLike)ModItems.ONION.get()), (int)8).addResultWithChance((ItemLike)ModItems.ROPE.get(), 0.5f, 1).build(consumer, Recipes.EDLoc("cutting/hanging_onion_knife"));
    }

    private void mortarRecipes(RecipeOutput consumer) {
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{Items.LAPIS_LAZULI, Items.CORNFLOWER}), new ItemStack((ItemLike)Items.BLUE_DYE, 2), FluidStack.EMPTY, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.LAPIS_LAZULI})).save(consumer, Recipes.EDLoc("dye_blue"));
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE_MEAL, Items.LILY_OF_THE_VALLEY}), new ItemStack((ItemLike)Items.WHITE_DYE, 2), FluidStack.EMPTY, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BONE_MEAL})).save(consumer, Recipes.EDLoc("dye_white"));
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{Items.ORANGE_TULIP, Items.TORCHFLOWER, SummerCitrus.ORANGE_PETAL_LITTER_ITEM}), new ItemStack((ItemLike)Items.ORANGE_DYE, 2), FluidStack.EMPTY, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.ORANGE_TULIP})).save(consumer, Recipes.EDLoc("dye_orange"));
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{Items.ALLIUM}), new ItemStack((ItemLike)Items.MAGENTA_DYE, 2), FluidStack.EMPTY, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.ALLIUM})).save(consumer, Recipes.EDLoc("dye_magenta"));
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{Items.LILAC}), new ItemStack((ItemLike)Items.MAGENTA_DYE, 3), FluidStack.EMPTY, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.LILAC})).save(consumer, Recipes.EDLoc("dye_magenta_three"));
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{Items.BLUE_ORCHID}), new ItemStack((ItemLike)Items.LIGHT_BLUE_DYE, 2), FluidStack.EMPTY, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BLUE_ORCHID})).save(consumer, Recipes.EDLoc("dye_light_blue"));
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{Items.DANDELION, SummerCitrus.LEMON_PETAL_LITTER_ITEM}), new ItemStack((ItemLike)Items.YELLOW_DYE, 2), FluidStack.EMPTY, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.DANDELION})).save(consumer, Recipes.EDLoc("dye_yellow"));
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUNFLOWER}), new ItemStack((ItemLike)Items.YELLOW_DYE, 3), FluidStack.EMPTY, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.SUNFLOWER})).save(consumer, Recipes.EDLoc("dye_yellow_three"));
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{Items.SEA_PICKLE, SummerCitrus.LIME_PETAL_LITTER_ITEM}), new ItemStack((ItemLike)Items.LIME_DYE, 2), FluidStack.EMPTY, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.SEA_PICKLE})).save(consumer, Recipes.EDLoc("dye_lime"));
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{Items.PINK_TULIP, Items.PINK_PETALS, SummerCitrus.GRAPEFRUIT_PETAL_LITTER_ITEM}), new ItemStack((ItemLike)Items.PINK_DYE, 2), FluidStack.EMPTY, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.PINK_TULIP})).save(consumer, Recipes.EDLoc("dye_pink"));
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{Items.PEONY}), new ItemStack((ItemLike)Items.PINK_DYE, 3), FluidStack.EMPTY, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.PEONY})).save(consumer, Recipes.EDLoc("dye_pink_three"));
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{Items.OXEYE_DAISY, Items.AZURE_BLUET, Items.WHITE_TULIP}), new ItemStack((ItemLike)Items.LIGHT_GRAY_DYE, 2), FluidStack.EMPTY, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.OXEYE_DAISY})).save(consumer, Recipes.EDLoc("dye_light_gray"));
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{Items.COCOA_BEANS}), new ItemStack((ItemLike)Items.BROWN_DYE, 2), FluidStack.EMPTY, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.COCOA_BEANS})).save(consumer, Recipes.EDLoc("dye_brown"));
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{Items.CACTUS}), new ItemStack((ItemLike)Items.GREEN_DYE, 2), FluidStack.EMPTY, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.CACTUS})).save(consumer, Recipes.EDLoc("dye_green"));
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{Items.RED_TULIP, Items.BEETROOT, Items.POPPY}), new ItemStack((ItemLike)Items.RED_DYE, 2), FluidStack.EMPTY, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.RED_TULIP})).save(consumer, Recipes.EDLoc("dye_red"));
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{Items.ROSE_BUSH}), new ItemStack((ItemLike)Items.RED_DYE, 3), FluidStack.EMPTY, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.ROSE_BUSH})).save(consumer, Recipes.EDLoc("dye_red_three"));
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{Items.INK_SAC, Items.WITHER_ROSE}), new ItemStack((ItemLike)Items.BLACK_DYE, 2), FluidStack.EMPTY, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.INK_SAC})).save(consumer, Recipes.EDLoc("dye_black"));
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{Items.PITCHER_PLANT}), new ItemStack((ItemLike)Items.CYAN_DYE, 3), FluidStack.EMPTY, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.PITCHER_PLANT})).save(consumer, Recipes.EDLoc("dye_cyan"));
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE}), new ItemStack((ItemLike)Items.BONE_MEAL, 4), FluidStack.EMPTY, 8).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BONE_MEAL})).save(consumer, Recipes.EDLoc("bone_meal_bone"));
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{Items.BLAZE_ROD}), new ItemStack((ItemLike)Items.BLAZE_POWDER, 3), FluidStack.EMPTY, 8).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BONE_MEAL})).save(consumer, Recipes.EDLoc("blaze_powder_blaze_rod"));
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{Items.WHEAT_SEEDS}), new ItemStack((ItemLike)ExtraDelightItems.FLOUR.get(), 1), new FluidStack(ExtraDelightFluids.OIL.FLUID, 50), 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BONE_MEAL})).save(consumer, Recipes.EDLoc("flour_oil_wheat_seeds"));
        MortarRecipeBuilder.grind(DifferenceIngredient.of((Ingredient)Ingredient.of((TagKey)Tags.Items.SEEDS), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.WHEAT_SEEDS, (ItemLike)ExtraDelightItems.CORN_SEEDS.get(), (ItemLike)Fermentation.SOYBEANS.get(), (ItemLike)ExtraDelightItems.SUNFLOWER_SEEDS.get()})), new ItemStack((ItemLike)Items.BONE_MEAL, 1), new FluidStack(ExtraDelightFluids.OIL.FLUID, 100), 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BEETROOT_SEEDS})).save(consumer, Recipes.EDLoc("oil_seeds"));
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.AGAR_SHEETS.get()}), new ItemStack((ItemLike)ExtraDelightItems.AGAR_AGAR.get(), 1), FluidStack.EMPTY, 8).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.AGAR_SHEETS.get()})).save(consumer, Recipes.EDLoc("agar_powder_agar_sheets"));
        MortarRecipeBuilder.grind(Ingredient.of(ExtraDelightTags.CORN_KERNELS), new ItemStack((ItemLike)ExtraDelightItems.CORN_MEAL.get(), 1), new FluidStack(ExtraDelightFluids.OIL.FLUID, 100), 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CORN_SEEDS.get()})).save(consumer, Recipes.EDLoc("cornmeal_oil_corn_seeds"));
        MortarRecipeBuilder.grind(Ingredient.of(ExtraDelightTags.CINNAMON_STICK), new ItemStack((ItemLike)ExtraDelightItems.GROUND_CINNAMON.get(), 2), FluidStack.EMPTY, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CINNAMON_STICK.get()})).save(consumer, Recipes.EDLoc("ground_cinnamon_cinnamon_stick"));
        MortarRecipeBuilder.grind(Ingredient.of(ExtraDelightTags.ROASTED_COCOA_BEANS), new ItemStack((ItemLike)ExtraDelightItems.COCOA_SOLIDS.get(), 1), new FluidStack(ExtraDelightFluids.COCOA_BUTTER.FLUID, 50), 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.ROASTED_COCOA_BEANS.get()})).save(consumer, Recipes.EDLoc("cocoa_solids_roasted_beans"));
        MortarRecipeBuilder.grind(Ingredient.of(ExtraDelightTags.ROASTED_NUTS), ItemStack.EMPTY, new FluidStack(ExtraDelightFluids.NUT_BUTTER.FLUID, 250), 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.ROASTED_PEANUTS.get()})).save(consumer, Recipes.EDLoc("nut_butter_nuts"));
        MortarRecipeBuilder.grind(Ingredient.of(ExtraDelightTags.MALLOWROOT), ExtraDelightItems.MALLOW_POWDER.toStack(), FluidStack.EMPTY, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.MALLOW_ROOT.get()})).save(consumer, Recipes.EDLoc("mallow_powder_mallow_root"));
        MortarRecipeBuilder.grind(Ingredient.of(ExtraDelightTags.DRIED_CHILI), ExtraDelightItems.CHILI_POWDER.toStack(), FluidStack.EMPTY, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.DRIED_CHILI.get()})).save(consumer, Recipes.EDLoc("chili_powder_dried_chili"));
        MortarRecipeBuilder.grind(Ingredient.of(ExtraDelightTags.ROASTED_COFFEE_BEANS), ExtraDelightItems.GROUND_COFFEE.toStack(), FluidStack.EMPTY, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.COFFEE_BEANS.get()})).save(consumer, Recipes.EDLoc("ground_coffee_beans"));
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{ExtraDelightItems.SUNFLOWER_SEEDS}), ItemStack.EMPTY, new FluidStack(ExtraDelightFluids.OIL.FLUID, 250), 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.SUNFLOWER_SEEDS.get()})).save(consumer, Recipes.EDLoc("sunflower_seeds_oil"));
        MortarRecipeBuilder.grind(Ingredient.of((ItemLike[])new ItemLike[]{Fermentation.SOYBEANS}), ItemStack.EMPTY, new FluidStack(ExtraDelightFluids.OIL.FLUID, 250), 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)Fermentation.SOYBEANS.get()})).save(consumer, Recipes.EDLoc("soybeans_oil"));
        MortarRecipeBuilder.grind(Ingredient.of(ExtraDelightTags.GREEN_COFFEE), ItemStack.EMPTY, new FluidStack(ExtraDelightFluids.OIL.FLUID, 150), 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GREEN_COFFEE.get()})).save(consumer, Recipes.EDLoc("green_coffee_oil"));
        MortarRecipeBuilder.grind(Ingredient.of(ExtraDelightTags.COCOA_SOLIDS), ExtraDelightItems.COCOA_POWDER.toStack(2), FluidStack.EMPTY, 4).unlockedBy(this.getName(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.COCOA_SOLIDS.get()})).save(consumer, Recipes.EDLoc("cocoa_powder"));
    }

    private void ovenRecipes(RecipeOutput consumer) {
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.STUFFED_HEART.get(), 1), 200, 0.35f, new ItemStack((ItemLike)ExtraDelightItems.TRAY.get()), false).addIngredient(ExtraDelightTags.HEART).addIngredient((TagKey<Item>)Tags.Items.MUSHROOMS).addIngredient(ExtraDelightTags.BREAD_CRUMBS).addIngredient(ExtraDelightTags.PROCESSED_ONION).addIngredient((TagKey<Item>)Tags.Items.EGGS).build(consumer, "stuffed_heart");
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.POT_ROAST_FEAST_ITEM.get(), 1), 400, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SQUARE_PAN.get()), false).addIngredient(ExtraDelightTags.BROTH).addIngredient(ExtraDelightTags.ROAST_RAW).addIngredient(ExtraDelightTags.COOKING_OIL).addIngredient(ExtraDelightTags.PROCESSED_ONION).addIngredient(ExtraDelightTags.PROCESSED_POTATO).addIngredient(ExtraDelightTags.PROCESSED_CARROT).addIngredient(ExtraDelightTags.PROCESSED_ONION).addIngredient(ExtraDelightTags.PROCESSED_POTATO).addIngredient(ExtraDelightTags.PROCESSED_CARROT).build(consumer, "pot_roast_feast");
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.BBQ_RIBS_FEAST_ITEM.get(), 1), 400, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.TRAY.get()), false).addIngredient(ExtraDelightTags.RIBS_RAW).addIngredient(ExtraDelightTags.RIBS_RAW).addIngredient(ExtraDelightTags.RIBS_RAW).addIngredient(ExtraDelightTags.RIBS_RAW).addIngredient(ExtraDelightTags.BBQ_SAUCE).build(consumer, "bbq_ribs_feast");
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.RACK_LAMB_FEAST_ITEM.get(), 1), 1600, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.TRAY.get()), false).addIngredient(ExtraDelightTags.MUTTON_RIBS).addIngredient(ExtraDelightTags.COOKING_OIL).addIngredient(ExtraDelightTags.MUTTON_RIBS).addIngredient(ExtraDelightTags.MUTTON_RIBS).addIngredient(ExtraDelightTags.PROCESSED_ONION).addIngredient(ExtraDelightTags.MUTTON_RIBS).addIngredient((TagKey<Item>)Tags.Items.FOODS_BERRY).addIngredient(ExtraDelightTags.BREAD_CRUMBS).addIngredient((TagKey<Item>)Tags.Items.FOODS_BERRY).unlockedByAnyIngredient(new ItemLike[]{Items.WHEAT, Items.EGG, Items.SUGAR, Items.MILK_BUCKET}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.BEEF_WELLINGTON_FEAST_ITEM.get(), 1), 1600, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.TRAY.get()), false).addIngredient((TagKey<Item>)Tags.Items.MUSHROOMS).addIngredient(ExtraDelightTags.BEEF_ROAST).addIngredient((TagKey<Item>)Tags.Items.MUSHROOMS).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.DOUGH).addIngredient(ExtraDelightTags.LIVER).addIngredient((TagKey<Item>)CommonTags.FOODS_COOKED_BACON).addIngredient((TagKey<Item>)Tags.Items.EGGS).addIngredient(ExtraDelightTags.PROCESSED_ONION).unlockedByAnyIngredient(new ItemLike[]{Items.WHEAT, Items.EGG, Items.SUGAR, Items.MILK_BUCKET}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.HAGGIS_FEAST_ITEM.get(), 1), 1600, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.TRAY.get()), false).addIngredient(ExtraDelightTags.OFFAL).addIngredient(ExtraDelightTags.OFFAL).addIngredient(ExtraDelightTags.OFFAL).addIngredient(ExtraDelightTags.LUNG).addIngredient(ExtraDelightTags.STOMACH).addIngredient(ExtraDelightTags.SCRAP_MEAT).addIngredient((TagKey<Item>)Tags.Items.SEEDS).addIngredient((TagKey<Item>)Tags.Items.SEEDS).addIngredient((TagKey<Item>)Tags.Items.SEEDS).unlockedByAnyIngredient(new ItemLike[]{Items.WHEAT, Items.EGG, Items.SUGAR, Items.MILK_BUCKET}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)Items.CAKE, 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SQUARE_PAN.get()), false).addIngredient(ExtraDelightTags.FLOUR, 3).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).addIngredient((TagKey<Item>)Tags.Items.EGGS).addIngredient(ExtraDelightTags.SWEETENER, 2).unlockedByAnyIngredient(new ItemLike[]{Items.WHEAT, Items.EGG, Items.SUGAR, Items.MILK_BUCKET}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.GLOW_BERRY_COOKIE.get(), 8), 400, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient(ExtraDelightTags.GLOW_BERRY_COOKIE_DOUGH).unlockedByAnyIngredient(new ItemLike[]{Items.GLOW_BERRIES}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)Items.COOKIE, 8), 400, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient(ExtraDelightTags.CHOCOLATE_CHIP_COOKIE_DOUGH).unlockedByAnyIngredient(new ItemLike[]{Items.COCOA_BEANS}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.SUGAR_COOKIE.get(), 8), 400, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient(ExtraDelightTags.SUGAR_COOKIE_DOUGH).unlockedByAnyIngredient(new ItemLike[]{Items.SUGAR}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.PUMPKIN_COOKIE.get(), 8), 400, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient(ExtraDelightTags.PUMPKIN_COOKIE_DOUGH).unlockedByAnyIngredient((ItemLike)ModItems.PUMPKIN_SLICE.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ModItems.SWEET_BERRY_COOKIE.get(), 8), 400, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient(ExtraDelightTags.SWEET_BERRY_COOKIE_DOUGH).unlockedByAnyIngredient(new ItemLike[]{Items.SWEET_BERRIES}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ModItems.HONEY_COOKIE.get(), 8), 400, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient(ExtraDelightTags.HONEY_COOKIE_DOUGH).unlockedByAnyIngredient(new ItemLike[]{Items.HONEY_BOTTLE}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.APPLE_COOKIE.get(), 8), 400, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient((ItemLike)ExtraDelightItems.APPLE_COOKIE_DOUGH.get()).unlockedByAnyIngredient(new ItemLike[]{Items.APPLE}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.CHEESECAKE_ITEM.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.PIE_DISH.get()), false).addIngredient(Ingredient.of((TagKey)CommonTags.FOODS_MILK)).addIngredient((ItemLike)ModItems.PIE_CRUST.get(), 1).addIngredient(Ingredient.of((TagKey)CommonTags.FOODS_MILK)).unlockedByAnyIngredient(new ItemLike[]{Items.MILK_BUCKET, (ItemLike)ModItems.MILK_BOTTLE.get()}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ModItems.SHEPHERDS_PIE_BLOCK.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SQUARE_PAN.get()), false).addIngredient((ItemLike)Items.BAKED_POTATO).addIngredient(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of((TagKey)CommonTags.FOODS_MILK), Ingredient.of(ExtraDelightTags.BROTH)})).addIngredient((ItemLike)Items.BAKED_POTATO).addIngredient(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of((TagKey)CommonTags.FOODS_COOKED_MUTTON), Ingredient.of(ExtraDelightTags.MUTTON_COOKED)})).addIngredient((ItemLike)ModItems.TOMATO_SAUCE.get()).addIngredient(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of((TagKey)CommonTags.FOODS_COOKED_MUTTON), Ingredient.of(ExtraDelightTags.MUTTON_COOKED)})).addIngredient(ExtraDelightTags.PROCESSED_CARROT).addIngredient(ExtraDelightTags.PROCESSED_ONION).addIngredient(ExtraDelightTags.PROCESSED_CABBAGE).unlockedBy("shepherds_pie", Recipes.has((TagKey)CommonTags.FOODS_COOKED_MUTTON)).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.CHOCOLATE_CHEESECAKE_ITEM.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.PIE_DISH.get()), false).addIngredient(ExtraDelightTags.COCOA_POWDER).addIngredient(Ingredient.of((TagKey)CommonTags.FOODS_MILK)).addIngredient((ItemLike)ModItems.PIE_CRUST.get(), 1).addIngredient(Ingredient.of((TagKey)CommonTags.FOODS_MILK)).unlockedByAnyIngredient(new ItemLike[]{ExtraDelightItems.COCOA_POWDER}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.GLOW_BERRY_CHEESECAKE_ITEM.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.PIE_DISH.get()), false).addIngredient((ItemLike)Items.GLOW_BERRIES, 3).addIngredient(Ingredient.of((TagKey)CommonTags.FOODS_MILK)).addIngredient((ItemLike)ModItems.PIE_CRUST.get(), 1).addIngredient(Ingredient.of((TagKey)CommonTags.FOODS_MILK)).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.CHEESE.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.HONEY_CHEESECAKE_ITEM.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.PIE_DISH.get()), false).addIngredient((ItemLike)Items.HONEY_BOTTLE, 3).addIngredient(Ingredient.of((TagKey)CommonTags.FOODS_MILK)).addIngredient((ItemLike)ModItems.PIE_CRUST.get(), 1).addIngredient(Ingredient.of((TagKey)CommonTags.FOODS_MILK)).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.CHEESE.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.PUMPKIN_CHEESECAKE_ITEM.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.PIE_DISH.get()), false).addIngredient((ItemLike)ModItems.PUMPKIN_SLICE.get(), 3).addIngredient(Ingredient.of((TagKey)CommonTags.FOODS_MILK)).addIngredient((ItemLike)ModItems.PIE_CRUST.get(), 1).addIngredient(Ingredient.of((TagKey)CommonTags.FOODS_MILK)).unlockedByAnyIngredient((ItemLike)ModItems.PUMPKIN_SLICE.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.APPLE_CHEESECAKE_ITEM.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.PIE_DISH.get()), false).addIngredient(ExtraDelightTags.PROCESSED_APPLE).addIngredient(ExtraDelightTags.PROCESSED_APPLE).addIngredient(ExtraDelightTags.PROCESSED_APPLE).addIngredient(Ingredient.of((TagKey)CommonTags.FOODS_MILK)).addIngredient((ItemLike)ModItems.PIE_CRUST.get(), 1).addIngredient(Ingredient.of((TagKey)CommonTags.FOODS_MILK)).unlockedByAnyIngredient((ItemLike)ModItems.PUMPKIN_SLICE.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.SWEET_BERRY_PIE_ITEM.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.PIE_DISH.get()), false).addIngredient(ExtraDelightTags.FLOUR, 3).addIngredient((ItemLike)Items.SWEET_BERRIES, 3).addIngredient(Ingredient.of(ExtraDelightTags.SWEETENER)).addIngredient((ItemLike)ModItems.PIE_CRUST.get(), 1).addIngredient(Ingredient.of(ExtraDelightTags.SWEETENER)).unlockedByAnyIngredient(new ItemLike[]{Items.SWEET_BERRIES}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.GLOW_BERRY_PIE_ITEM.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.PIE_DISH.get()), false).addIngredient(ExtraDelightTags.FLOUR, 3).addIngredient((ItemLike)Items.GLOW_BERRIES, 3).addIngredient(Ingredient.of(ExtraDelightTags.SWEETENER)).addIngredient((ItemLike)ModItems.PIE_CRUST.get(), 1).addIngredient(Ingredient.of(ExtraDelightTags.SWEETENER)).unlockedByAnyIngredient(new ItemLike[]{Items.GLOW_BERRIES}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.QUICHE.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.PIE_DISH.get()), false).addIngredient((ItemLike)ExtraDelightItems.OMELETTE_MIX.get(), 1).addIngredient((ItemLike)ModItems.PIE_CRUST.get(), 1).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.OMELETTE_MIX.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.EGG_BASKET.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient((TagKey<Item>)Tags.Items.EGGS).addIngredient(ExtraDelightTags.BREAD_SLICE).unlockedBy("egg_basket", Recipes.has((TagKey)Tags.Items.EGGS)).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.SAUSAGE_ROLL.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient(ExtraDelightTags.SAUSAGE).addIngredient(ExtraDelightTags.DOUGH).unlockedBy("sausage_roll", Recipes.has(ExtraDelightTags.SAUSAGE)).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.LASAGNA_FEAST.get(), 1), 1600, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SQUARE_PAN.get()), true).addIngredient(ExtraDelightTags.CHEESE).addIngredient((ItemLike)ModItems.TOMATO_SAUCE.get()).addIngredient(ExtraDelightTags.CHEESE).addIngredient((ItemLike)ExtraDelightItems.LASAGNA_NOODLES.get()).addIngredient((ItemLike)ExtraDelightItems.LASAGNA_NOODLES.get()).addIngredient((ItemLike)ExtraDelightItems.LASAGNA_NOODLES.get()).addIngredient(ExtraDelightTags.GROUND_BEEF_COOKED).addIngredient((ItemLike)ModItems.TOMATO_SAUCE.get()).addIngredient(ExtraDelightTags.GROUND_BEEF_COOKED).unlockedBy("lasagna", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.LASAGNA_NOODLES.get()))).build(consumer, "lasagna_bc");
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.MEAT_LOAF_FEAST.get(), 1), 1600, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.LOAF_PAN.get()), false).addIngredient(ExtraDelightTags.KETCHUP).addIngredient(ExtraDelightTags.BREAD_CRUMBS).addIngredient((ItemLike)ExtraDelightItems.EGG_MIX.get()).addIngredient(ExtraDelightTags.GROUND_MEAT_RAW).addIngredient(ExtraDelightTags.GROUND_MEAT_RAW).addIngredient(ExtraDelightTags.GROUND_MEAT_RAW).addIngredient(ExtraDelightTags.PROCESSED_ONION).unlockedBy("meatloaf", Recipes.has(ExtraDelightTags.GROUND_MEAT_RAW)).build(consumer, "meatloaf_bc");
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.HOTDISH_FEAST.get(), 1), 1600, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SQUARE_PAN.get()), true).addIngredient(ExtraDelightTags.STARCH).addIngredient(ExtraDelightTags.STARCH).addIngredient(ExtraDelightTags.STARCH).addIngredient(ExtraDelightTags.MEAT_COOKED).addIngredient(ExtraDelightTags.SOUP).addIngredient(ExtraDelightTags.MEAT_COOKED).addIngredient((TagKey<Item>)Tags.Items.FOODS_VEGETABLE).addIngredient(ExtraDelightTags.SOUP).addIngredient((TagKey<Item>)Tags.Items.FOODS_VEGETABLE).unlockedBy("hotdish", Recipes.has(ExtraDelightTags.SOUP)).save(consumer, Recipes.EDLoc("hotdish"));
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.STUFFED_MUSHROOMS.get(), 3), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient((TagKey<Item>)Tags.Items.MUSHROOMS).addIngredient((TagKey<Item>)Tags.Items.MUSHROOMS).addIngredient((TagKey<Item>)Tags.Items.MUSHROOMS).addIngredient(ExtraDelightTags.CHEESE).addIngredient(ExtraDelightTags.BREAD_CRUMBS).addIngredient(ExtraDelightTags.BUTTER).unlockedBy("stuffed_mushroom", Recipes.has((TagKey)Tags.Items.MUSHROOMS)).save(consumer, Recipes.EDLoc("stuffed_mushroom"));
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.MEAT_PIE_BLOCK_ITEM.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.PIE_DISH.get()), false).addIngredient(ExtraDelightTags.GROUND_MEAT_RAW).addIngredient(ExtraDelightTags.GROUND_MEAT_RAW).addIngredient(ExtraDelightTags.GROUND_MEAT_RAW).addIngredient((TagKey<Item>)Tags.Items.MUSHROOMS).addIngredient(ExtraDelightTags.PROCESSED_POTATO).addIngredient(ExtraDelightTags.PROCESSED_ONION).addIngredient((ItemLike)ModItems.PIE_CRUST.get()).unlockedBy("meat_pie", Recipes.has((ItemLike)((ItemLike)ModItems.PIE_CRUST.get()))).save(consumer, Recipes.EDLoc("meat_pie"));
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.CHICKEN_PARM.get(), 2), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.TRAY.get()), false).addIngredient((ItemLike)ExtraDelightItems.FRIED_CHICKEN.get()).addIngredient((ItemLike)ModItems.TOMATO_SAUCE.get()).addIngredient(ExtraDelightTags.CHEESE).unlockedBy("chicken_parm", Recipes.has((ItemLike)((ItemLike)ExtraDelightItems.FRIED_CHICKEN.get()))).save(consumer, Recipes.EDLoc("chicken_parm"));
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ModItems.ROAST_CHICKEN_BLOCK.get(), 1), 1600, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.TRAY.get()), false).addIngredient(ExtraDelightTags.PROCESSED_ONION).addIngredient(ExtraDelightTags.GRAVY).addIngredient(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of((TagKey)Tags.Items.FOODS_BREAD), Ingredient.of(ExtraDelightTags.BREAD_CRUMBS)})).addIngredient(ExtraDelightTags.PROCESSED_CARROT).addIngredient((ItemLike)Items.CHICKEN).addIngredient(ExtraDelightTags.PROCESSED_POTATO).addIngredient(ExtraDelightTags.PROCESSED_CARROT).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.PROCESSED_POTATO).unlockedBy("roast_chicken", Recipes.has((ItemLike)Items.CHICKEN)).save(consumer, Recipes.EDLoc("roast_chicken"));
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ModItems.HONEY_GLAZED_HAM_BLOCK.get(), 1), 1600, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.TRAY.get()), false).addIngredient(ExtraDelightTags.FRUIT_SWEET_BERRY).addIngredient((ItemLike)Items.HONEY_BOTTLE).addIngredient(ExtraDelightTags.FRUIT_SWEET_BERRY).addIngredient(ExtraDelightTags.FRUIT_SWEET_BERRY).addIngredient((ItemLike)ModItems.HAM.get()).addIngredient(ExtraDelightTags.FRUIT_SWEET_BERRY).addIngredient((ItemLike)ModItems.COOKED_RICE.get()).addIngredient((ItemLike)ExtraDelightItems.BUTTER.get()).addIngredient((ItemLike)ModItems.COOKED_RICE.get()).unlockedBy("honey_ham", Recipes.has((ItemLike)((ItemLike)ModItems.HAM.get()))).save(consumer, Recipes.EDLoc("honey_ham"));
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ModItems.CHOCOLATE_PIE.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.PIE_DISH.get()), false).addIngredient(ExtraDelightTags.COCOA_POWDER).addIngredient(ExtraDelightTags.WHIPPED_CREAM).addIngredient(ExtraDelightTags.COCOA_POWDER).addIngredient((ItemLike)ExtraDelightItems.EGG_MIX.get()).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)ModItems.PIE_CRUST.get()).addIngredient(ExtraDelightTags.SWEETENER).unlockedBy("chocolate_pie", Recipes.has((ItemLike)Items.COCOA_BEANS)).save(consumer, Recipes.EDLoc("chocolate_pie"));
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ModItems.PIE_CRUST.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.PIE_DISH.get()), false).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.BUTTER).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).unlockedBy("pie_crust", Recipes.has(ExtraDelightTags.FLOUR)).save(consumer, Recipes.EDLoc("pie_crust"));
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ModItems.PIE_CRUST.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.PIE_DISH.get()), false).addIngredient(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of(ExtraDelightTags.COOKIE), Ingredient.of(ExtraDelightTags.GRAHAM_CRACKER)})).addIngredient(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of(ExtraDelightTags.COOKIE), Ingredient.of(ExtraDelightTags.GRAHAM_CRACKER)})).addIngredient(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of(ExtraDelightTags.COOKIE), Ingredient.of(ExtraDelightTags.GRAHAM_CRACKER)})).addIngredient(ExtraDelightTags.BUTTER).unlockedBy("pie_crust", Recipes.has(ExtraDelightTags.COOKIE)).save(consumer, Recipes.EDLoc("pie_crust_crumb"));
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ModItems.SWEET_BERRY_CHEESECAKE.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.PIE_DISH.get()), false).addIngredient(ExtraDelightTags.FRUIT_SWEET_BERRY).addIngredient(ExtraDelightTags.FRUIT_SWEET_BERRY).addIngredient(ExtraDelightTags.FRUIT_SWEET_BERRY).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).addIngredient((ItemLike)ModItems.PIE_CRUST.get()).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).unlockedBy("sweet_berry", Recipes.has((ItemLike)Items.SWEET_BERRIES)).save(consumer, Recipes.EDLoc("sweet_berry_cheesecake"));
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ModItems.APPLE_PIE.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.PIE_DISH.get()), false).addIngredient((ItemLike)ModItems.PIE_CRUST.get()).addIngredient(ExtraDelightTags.PROCESSED_APPLE).addIngredient(ExtraDelightTags.PROCESSED_APPLE).addIngredient(ExtraDelightTags.PROCESSED_APPLE).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)ModItems.PIE_CRUST.get()).unlockedBy("apple_pie", Recipes.has((ItemLike)Items.APPLE)).save(consumer, Recipes.EDLoc("apple_pie"));
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ModItems.APPLE_PIE.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.PIE_DISH.get()), false).addIngredient((ItemLike)ModItems.PIE_CRUST.get()).addIngredient((ItemLike)ExtraDelightItems.STEWED_APPLES).addIngredient((ItemLike)ModItems.PIE_CRUST.get()).unlockedBy("apple_pie", Recipes.has((ItemLike)Items.APPLE)).save(consumer, Recipes.EDLoc("apple_pie_stewed"));
        Recipes.bulkBake((ItemLike)ModItems.FRIED_EGG.get(), Ingredient.of((TagKey)Tags.Items.EGGS), consumer, (ItemLike)ExtraDelightItems.TRAY.get(), "fried_egg");
        Recipes.bulkBake((ItemLike)ModItems.BEEF_PATTY.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.MINCED_BEEF.get()}), consumer, (ItemLike)ExtraDelightItems.TRAY.get(), "beef_patty");
        Recipes.bulkBake((ItemLike)ModItems.COOKED_CHICKEN_CUTS.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CHICKEN_CUTS.get()}), consumer, (ItemLike)ExtraDelightItems.TRAY.get(), "chicken_cuts");
        Recipes.bulkBake((ItemLike)ModItems.COOKED_COD_SLICE.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COD_SLICE.get()}), consumer, (ItemLike)ExtraDelightItems.TRAY.get(), "cod_slice");
        Recipes.bulkBake((ItemLike)ModItems.COOKED_SALMON_SLICE.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SALMON_SLICE.get()}), consumer, (ItemLike)ExtraDelightItems.TRAY.get(), "salmon_slice");
        Recipes.bulkBake((ItemLike)ModItems.COOKED_BACON.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BACON.get()}), consumer, (ItemLike)ExtraDelightItems.TRAY.get(), "bacon");
        Recipes.bulkBake((ItemLike)ModItems.COOKED_MUTTON_CHOPS.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.MUTTON_CHOPS.get()}), consumer, (ItemLike)ExtraDelightItems.TRAY.get(), "mutton_chops");
        Recipes.bulkBake((ItemLike)ModItems.SMOKED_HAM.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.HAM.get()}), consumer, (ItemLike)ExtraDelightItems.TRAY.get(), "ham");
        Recipes.bulkBake((ItemLike)Items.BREAD, Ingredient.of(ExtraDelightTags.DOUGH), consumer, (ItemLike)ExtraDelightItems.LOAF_PAN.get(), "bread");
        Recipes.bulkBake((ItemLike)Items.BAKED_POTATO, Ingredient.of((ItemLike[])new ItemLike[]{Items.POTATO}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "potato");
        Recipes.bulkBake((ItemLike)ExtraDelightItems.ROASTED_CARROT.get(), Ingredient.of((ItemLike[])new ItemLike[]{Items.CARROT}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "carrot");
        Recipes.bulkBake((ItemLike)ExtraDelightItems.ROASTED_APPLE.get(), Ingredient.of((ItemLike[])new ItemLike[]{Items.APPLE}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "apple");
        Recipes.bulkBake((ItemLike)Items.COOKED_BEEF, Ingredient.of((ItemLike[])new ItemLike[]{Items.BEEF}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "beef");
        Recipes.bulkBake((ItemLike)Items.COOKED_CHICKEN, Ingredient.of((ItemLike[])new ItemLike[]{Items.CHICKEN}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "chicken");
        Recipes.bulkBake((ItemLike)Items.COOKED_COD, Ingredient.of((ItemLike[])new ItemLike[]{Items.COD}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "cod");
        Recipes.bulkBake((ItemLike)Items.COOKED_MUTTON, Ingredient.of((ItemLike[])new ItemLike[]{Items.MUTTON}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "mutton");
        Recipes.bulkBake((ItemLike)Items.COOKED_PORKCHOP, Ingredient.of((ItemLike[])new ItemLike[]{Items.PORKCHOP}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "porkchop");
        Recipes.bulkBake((ItemLike)Items.COOKED_RABBIT, Ingredient.of((ItemLike[])new ItemLike[]{Items.RABBIT}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "rabbit");
        Recipes.bulkBake((ItemLike)Items.COOKED_SALMON, Ingredient.of((ItemLike[])new ItemLike[]{Items.SALMON}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "salmon");
        Recipes.bulkBake((ItemLike)ExtraDelightItems.TOAST.get(), Ingredient.of(ExtraDelightTags.BREAD_SLICE), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "toast");
        Recipes.bulkBake((ItemLike)ExtraDelightItems.GRILLED_CHEESE.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CHEESE_SANDWICH.get()}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "grilled_cheese");
        Recipes.bulkBake((ItemLike)ExtraDelightItems.COOKED_CACTUS.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.CACTUS.get()}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "cooked_cactus");
        Recipes.bulkBake((ItemLike)ExtraDelightItems.CRISP_RICE.get(), Ingredient.of((TagKey)CommonTags.CROPS_RICE), consumer, (ItemLike)ExtraDelightItems.TRAY.get(), "crisp_rice");
        Recipes.bulkBake((ItemLike)ExtraDelightItems.ROASTED_COCOA_BEANS.get(), Ingredient.of((ItemLike[])new ItemLike[]{Items.COCOA_BEANS}), consumer, (ItemLike)ExtraDelightItems.TRAY.get(), "roasted_cocoa_beans");
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.CARAMEL_CHEESECAKE_ITEM.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.PIE_DISH.get()), false).addIngredient((ItemLike)ExtraDelightItems.CARAMEL_SAUCE.get(), 3).addIngredient(Ingredient.of((TagKey)CommonTags.FOODS_MILK)).addIngredient((ItemLike)ModItems.PIE_CRUST.get(), 1).addIngredient(Ingredient.of((TagKey)CommonTags.FOODS_MILK)).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.CARAMEL_SAUCE.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.CORNBREAD_FEAST.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ModItems.SKILLET.get()), true).addIngredient(ExtraDelightTags.CORN_MEAL).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)ExtraDelightItems.BUTTER.get()).addIngredient((ItemLike)ExtraDelightItems.EGG_MIX.get()).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.CORN_MEAL.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.CORN_PUDDING_FEAST.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SQUARE_PAN.get()), true).addIngredient(ExtraDelightTags.CORN_MEAL).addIngredient((ItemLike)ExtraDelightItems.COOKED_CORN.get()).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)ExtraDelightItems.BUTTER.get()).addIngredient((ItemLike)ExtraDelightItems.EGG_MIX.get()).addIngredient(Ingredient.of((TagKey)CommonTags.FOODS_MILK)).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.CORN_MEAL.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.PUMPKIN_PIE_ITEM.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.PIE_DISH.get()), false).addIngredient((ItemLike)ModItems.PUMPKIN_SLICE.get(), 3).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)ModItems.PIE_CRUST.get()).addIngredient((ItemLike)ExtraDelightItems.EGG_MIX.get()).unlockedByAnyIngredient((ItemLike)ModItems.PUMPKIN_SLICE.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.APPLE_CRISP_FEAST.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SQUARE_PAN.get()), true).addIngredient((ItemLike)Items.WHEAT_SEEDS).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.SWEETENER).addIngredient(ExtraDelightTags.PROCESSED_APPLE).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.PROCESSED_APPLE).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ExtraDelightItems.SLICED_APPLE.get(), Items.APPLE}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.POTATO_AU_GRATIN_FEAST.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SQUARE_PAN.get()), true).addIngredient(ExtraDelightTags.FLOUR).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).addIngredient(ExtraDelightTags.CHEESE).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.SLICED_POTATO).addIngredient(ExtraDelightTags.SLICED_POTATO).addIngredient(ExtraDelightTags.SLICED_POTATO).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.SLICED_POTATO.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.PUMPKIN_ROLL_FEAST.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.TRAY.get()), false).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.FLOUR).addIngredient((ItemLike)ExtraDelightItems.EGG_MIX.get()).addIngredient(ExtraDelightTags.FLOUR).addIngredient((ItemLike)ModItems.PUMPKIN_SLICE.get()).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)ModItems.PUMPKIN_SLICE.get()).unlockedByAnyIngredient((ItemLike)ModItems.PUMPKIN_SLICE.get()).build(consumer);
        Recipes.bulkBake((ItemLike)ExtraDelightItems.GRILLED_CORN_ON_COB.get(), Ingredient.of(ExtraDelightTags.CORN_ON_COB), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "cooked_corn_cob");
        Recipes.bulkBake((ItemLike)ExtraDelightItems.ROASTED_PUMPKIN_SEEDS.get(), Ingredient.of((ItemLike[])new ItemLike[]{Items.PUMPKIN_SEEDS}), consumer, (ItemLike)ExtraDelightItems.TRAY.get(), "cooked_pumpkin_seeds");
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.GINGERBREAD_COOKIE.get(), 8), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient(ExtraDelightTags.GINGERBREAD_COOKIE_DOUGH).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.GINGERBREAD_COOKIE_DOUGH.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.GINGERBREAD_COOKIE_BLOCK.get(), 4), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient(ExtraDelightTags.GINGERBREAD_COOKIE_DOUGH, 4).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.GINGERBREAD_COOKIE_DOUGH.get()).build(consumer);
        Recipes.bulkBake((ItemLike)ExtraDelightItems.GINGERBREAD_ALEX.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_GINGERBREAD_ALEX.get()}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "gingerbread_alex_oven", 1);
        Recipes.bulkBake((ItemLike)ExtraDelightItems.GINGERBREAD_CREEPER.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_GINGERBREAD_CREEPER.get()}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "gingerbread_creeper_oven", 1);
        Recipes.bulkBake((ItemLike)ExtraDelightItems.GINGERBREAD_PICKAXE.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_GINGERBREAD_PICKAXE.get()}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "gingerbread_pickaxe_oven", 1);
        Recipes.bulkBake((ItemLike)ExtraDelightItems.GINGERBREAD_STEVE.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_GINGERBREAD_STEVE.get()}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "gingerbread_steve_oven", 1);
        Recipes.bulkBake((ItemLike)ExtraDelightItems.GINGERBREAD_SWORD.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_GINGERBREAD_SWORD.get()}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "gingerbread_sword_oven", 1);
        Recipes.bulkBake((ItemLike)ExtraDelightItems.GINGERBREAD_VILLAGER.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_GINGERBREAD_VILLAGER.get()}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "gingerbread_villager_oven", 1);
        Recipes.bulkBake((ItemLike)ExtraDelightItems.GINGERBREAD_DIAMOND.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_GINGERBREAD_DIAMOND.get()}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "gingerbread_diamond_oven", 1);
        Recipes.bulkBake((ItemLike)ExtraDelightItems.GINGERBREAD_EMERALD.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_GINGERBREAD_EMERALD.get()}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "gingerbread_emerald_oven", 1);
        Recipes.bulkBake((ItemLike)ExtraDelightItems.SUGAR_COOKIE_ALEX.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_ALEX.get()}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "sugar_cookie_alex_oven", 1);
        Recipes.bulkBake((ItemLike)ExtraDelightItems.SUGAR_COOKIE_CREEPER.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_CREEPER.get()}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "sugar_cookie_creeper_oven", 1);
        Recipes.bulkBake((ItemLike)ExtraDelightItems.SUGAR_COOKIE_PICKAXE.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_PICKAXE.get()}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "sugar_cookie_pickaxe_oven", 1);
        Recipes.bulkBake((ItemLike)ExtraDelightItems.SUGAR_COOKIE_STEVE.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_STEVE.get()}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "sugar_cookie_steve_oven", 1);
        Recipes.bulkBake((ItemLike)ExtraDelightItems.SUGAR_COOKIE_SWORD.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_SWORD.get()}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "sugar_cookie_sword_oven", 1);
        Recipes.bulkBake((ItemLike)ExtraDelightItems.SUGAR_COOKIE_VILLAGER.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_VILLAGER.get()}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "sugar_cookie_villager_oven", 1);
        Recipes.bulkBake((ItemLike)ExtraDelightItems.SUGAR_COOKIE_DIAMOND.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_DIAMOND.get()}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "sugar_cookie_diamond_oven", 1);
        Recipes.bulkBake((ItemLike)ExtraDelightItems.SUGAR_COOKIE_EMERALD.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.RAW_SUGAR_COOKIE_EMERALD.get()}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "sugar_cookie_emerald_oven", 1);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.APPLE_COOKIE_BLOCK.get(), 4), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient((ItemLike)ExtraDelightItems.APPLE_COOKIE_DOUGH.get(), 4).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.APPLE_COOKIE_DOUGH.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.CHOCOLATE_CHIP_COOKIE_BLOCK.get(), 4), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient(ExtraDelightTags.CHOCOLATE_CHIP_COOKIE_DOUGH, 4).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.CHOCOLATE_CHIP_COOKIE_DOUGH.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.GLOW_BERRY_COOKIE_BLOCK.get(), 4), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient(ExtraDelightTags.GLOW_BERRY_COOKIE_DOUGH, 4).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.GLOW_BERRY_COOKIE_DOUGH.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.HONEY_COOKIE_BLOCK.get(), 4), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient(ExtraDelightTags.HONEY_COOKIE_DOUGH, 4).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.HONEY_COOKIE_DOUGH.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.PUMPKIN_COOKIE_BLOCK.get(), 4), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient(ExtraDelightTags.PUMPKIN_COOKIE_DOUGH, 4).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.PUMPKIN_COOKIE_DOUGH.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.SUGAR_COOKIE_BLOCK.get(), 4), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient(ExtraDelightTags.SUGAR_COOKIE_DOUGH, 4).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.SUGAR_COOKIE_DOUGH.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.SWEET_BERRY_COOKIE_BLOCK.get(), 4), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient(ExtraDelightTags.SWEET_BERRY_COOKIE_DOUGH, 4).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.SWEET_BERRY_COOKIE_DOUGH.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.FRENCH_TOAST.get(), 4), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.TRAY.get()), false).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.SWEETENER).addIngredient(ExtraDelightTags.GROUND_CINNAMON).addIngredient((TagKey<Item>)Tags.Items.EGGS).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).addIngredient(ExtraDelightTags.BREAD_SLICE, 4).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.BREAD_SLICE.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.MUFFIN_APPLE.get(), 6), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.MUFFIN_TIN.get()), false).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.SWEETENER).addIngredient(ExtraDelightTags.PROCESSED_APPLE).addIngredient((TagKey<Item>)Tags.Items.EGGS).addIngredient(ExtraDelightTags.FLOUR).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.GINGER.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.MUFFIN_CINNAMON.get(), 6), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.MUFFIN_TIN.get()), false).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.SWEETENER).addIngredient(ExtraDelightTags.GROUND_CINNAMON).addIngredient((TagKey<Item>)Tags.Items.EGGS).addIngredient(ExtraDelightTags.FLOUR).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.GROUND_CINNAMON.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.MUFFIN_GINGER.get(), 6), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.MUFFIN_TIN.get()), false).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.SWEETENER).addIngredient(ExtraDelightTags.PROCESSED_GINGER).addIngredient((TagKey<Item>)Tags.Items.EGGS).addIngredient(ExtraDelightTags.FLOUR).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.GINGER.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.MUFFIN_SWEET_BERRY.get(), 6), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.MUFFIN_TIN.get()), false).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)Items.SWEET_BERRIES).addIngredient((TagKey<Item>)Tags.Items.EGGS).addIngredient(ExtraDelightTags.FLOUR).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).unlockedByAnyIngredient(new ItemLike[]{Items.SWEET_BERRIES}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.FRUIT_BREAD.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.LOAF_PAN.get()), false).addIngredient(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of(ExtraDelightTags.PROCESSED_FRUIT), Ingredient.of(ExtraDelightTags.DRIED_FRUIT)})).addIngredient(ExtraDelightTags.DOUGH).unlockedByAnyIngredient((ItemLike)ModItems.WHEAT_DOUGH.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.CRACKERS.get(), 4), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.BUTTER).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.FLOUR.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.ROLL.get(), 6), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.MUFFIN_TIN.get()), false).addIngredient(ExtraDelightTags.DOUGH).unlockedByAnyIngredient((ItemLike)ModItems.WHEAT_DOUGH.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.CINNAMON_ROLLS_FEAST.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SQUARE_PAN.get()), true).addIngredient(ExtraDelightTags.DOUGH).addIngredient(ExtraDelightTags.SWEETENER).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.GROUND_CINNAMON).addIngredient((ItemLike)ExtraDelightItems.FROSTING_WHITE.get()).unlockedByAnyIngredient((ItemLike)ModItems.WHEAT_DOUGH.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.MONKEY_BREAD_FEAST.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SQUARE_PAN.get()), false).addIngredient(ExtraDelightTags.DOUGH).addIngredient(ExtraDelightTags.SWEETENER).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.GROUND_CINNAMON).unlockedByAnyIngredient((ItemLike)ModItems.WHEAT_DOUGH.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.COFFEE_CAKE_FEAST.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SQUARE_PAN.get()), false).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.GROUND_CINNAMON).addIngredient(ExtraDelightTags.FLOUR).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).addIngredient(ExtraDelightTags.BUTTER).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).addIngredient((TagKey<Item>)Tags.Items.EGGS).addIngredient(ExtraDelightTags.SWEETENER, 2).unlockedByAnyIngredient(new ItemLike[]{Items.WHEAT, Items.EGG, Items.SUGAR, Items.MILK_BUCKET}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.MINT_LAMB_FEAST.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.TRAY.get()), false).addIngredient((ItemLike)Items.MUTTON, 4).addIngredient(ExtraDelightTags.MINT).addIngredient(ExtraDelightTags.BREAD_CRUMBS).addIngredient(ExtraDelightTags.COOKING_OIL).unlockedByAnyIngredient(new ItemLike[]{Items.MUTTON}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.CHRISTMAS_PUDDING_FEAST.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SQUARE_PAN.get()), false).addIngredient(ExtraDelightTags.DRIED_FRUIT, 3).addIngredient(ExtraDelightTags.BREAD_CRUMBS).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.GROUND_CINNAMON).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((TagKey<Item>)Tags.Items.EGGS).addIngredient(ExtraDelightTags.SWEETENER).unlockedByAnyIngredient(new ItemLike[]{Items.MUTTON}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.MILK_TART_FEAST.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.PIE_DISH.get()), false).addIngredient(ExtraDelightTags.GROUND_CINNAMON).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((TagKey<Item>)Tags.Items.EGGS).addIngredient((ItemLike)ModItems.PIE_CRUST.get()).unlockedByAnyIngredient((ItemLike)ModItems.PIE_CRUST.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.LAVA_CAKE.get(), 6), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.MUFFIN_TIN.get()), false).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.CHOCOLATE_SYRUP).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).addIngredient(ExtraDelightTags.CHOCOLATE_SYRUP).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((TagKey<Item>)Tags.Items.EGGS).addIngredient(ExtraDelightTags.SWEETENER).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.MUFFIN_TIN.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.GRAHAM_CRACKER.get(), 4), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.TRAY.get()), false).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.SWEETENER).addIngredient(ExtraDelightTags.GROUND_CINNAMON).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).addIngredient(ExtraDelightTags.COOKING_OIL).addIngredient((TagKey<Item>)Tags.Items.EGGS).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.TRAY.get()).build(consumer);
        Recipes.bulkBake((ItemLike)ExtraDelightItems.COFFEE_BEANS.get(), Ingredient.of(ExtraDelightTags.GREEN_COFFEE), consumer, (ItemLike)ExtraDelightItems.TRAY.get(), "coffee_oven", 1);
        Recipes.bulkBake((ItemLike)ExtraDelightItems.ROASTED_PEANUTS.get(), Ingredient.of(ExtraDelightTags.PEANUTS), consumer, (ItemLike)ExtraDelightItems.TRAY.get(), "peanuts_oven", 1);
        Recipes.bulkBake((ItemLike)ExtraDelightItems.ROASTED_HAZELNUTS.get(), Ingredient.of(ExtraDelightTags.HAZELNUTS), consumer, (ItemLike)ExtraDelightItems.TRAY.get(), "hazelnuts_oven", 1);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.BROWNIES_BLOCK.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SQUARE_PAN.get()), true).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.SWEETENER).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.CHOCOLATE_SYRUP).addIngredient(ExtraDelightTags.CHOCOLATE_CHIPS).addIngredient((TagKey<Item>)Tags.Items.EGGS).addIngredient(ExtraDelightTags.BUTTER).addIngredient((TagKey<Item>)Tags.Items.EGGS).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.SQUARE_PAN.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.BLONDIES_BLOCK.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SQUARE_PAN.get()), true).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.SWEETENER).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.BUTTERSCOTCH).addIngredient((TagKey<Item>)Tags.Items.EGGS).addIngredient(ExtraDelightTags.BUTTER).addIngredient((TagKey<Item>)Tags.Items.EGGS).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.SQUARE_PAN.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.CHOCOLATE_CAKE_BLOCK.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SQUARE_PAN.get()), false).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.CHOCOLATE_SYRUP).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).addIngredient(ExtraDelightTags.CHOCOLATE_SYRUP).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((TagKey<Item>)Tags.Items.EGGS).addIngredient(ExtraDelightTags.SWEETENER).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.SQUARE_PAN.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.STICKY_TOFFEE_PUDDING_BLOCK.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SQUARE_PAN.get()), false).addIngredient(ExtraDelightTags.FLOUR).addIngredient((ItemLike)ExtraDelightItems.CARAMEL_SAUCE).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.BUTTER).addIngredient((TagKey<Item>)CommonTags.FOODS_MILK).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((TagKey<Item>)Tags.Items.EGGS).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((TagKey<Item>)Tags.Items.EGGS).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.SQUARE_PAN.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.ROMBOSSE.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.TRAY.get()), false).addIngredient(ExtraDelightTags.FRUIT_APPLE).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.SWEETENER).addIngredient(ExtraDelightTags.DOUGH).addIngredient(ExtraDelightTags.CINNAMON_STICK).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.TRAY.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.PORK_AND_APPLES_FEAST.get(), 1), 1600, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SQUARE_PAN.get()), false).addIngredient(ExtraDelightTags.PROCESSED_APPLE).addIngredient(ExtraDelightTags.PORK_ROAST).addIngredient(ExtraDelightTags.PROCESSED_APPLE).addIngredient(ExtraDelightTags.PROCESSED_ONION).addIngredient(ExtraDelightTags.BROTH).addIngredient(ExtraDelightTags.BUTTER).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.SQUARE_PAN.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.APPLE_CHIPS.get(), 8), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient(ExtraDelightTags.SLICED_APPLE).addIngredient(ExtraDelightTags.SLICED_APPLE).addIngredient(ExtraDelightTags.SLICED_APPLE).addIngredient(ExtraDelightTags.SLICED_APPLE).addIngredient(ExtraDelightTags.GROUND_CINNAMON).addIngredient(ExtraDelightTags.SLICED_APPLE).addIngredient(ExtraDelightTags.SLICED_APPLE).addIngredient(ExtraDelightTags.SLICED_APPLE).addIngredient(ExtraDelightTags.SLICED_APPLE).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.SHEET.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.STUFFED_APPLES_FEAST.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SQUARE_PAN.get()), false).addIngredient(ExtraDelightTags.FRUIT_APPLE).addIngredient(ExtraDelightTags.DRIED_FRUIT).addIngredient(ExtraDelightTags.FRUIT_APPLE).addIngredient(ExtraDelightTags.FRUIT_APPLE).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.FRUIT_APPLE).addIngredient(ExtraDelightTags.NUTS).addIngredient(ExtraDelightTags.SWEETENER).addIngredient(ExtraDelightTags.GROUND_CINNAMON).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.SQUARE_PAN.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.TARTE_TATIN_IN_PAN.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ModItems.SKILLET.get()), true).addIngredient((ItemLike)ExtraDelightItems.CARAMEL_SAUCE.get()).addIngredient((ItemLike)ModItems.PIE_CRUST.get()).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.FRUIT_APPLE).addIngredient(ExtraDelightTags.FRUIT_APPLE).addIngredient(ExtraDelightTags.FRUIT_APPLE).unlockedByAnyIngredient(new ItemLike[]{Items.APPLE, (ItemLike)ModItems.SKILLET.get()}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.JALAPENO_POPPER.get(), 2), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.TRAY.get()), false).addIngredient(ExtraDelightTags.CHILI).addIngredient(ExtraDelightTags.CHILI).addIngredient(ExtraDelightTags.CHEESE).addIngredient((TagKey<Item>)CommonTags.FOODS_RAW_BACON).unlockedByAnyIngredient(new ItemLike[]{ExtraDelightItems.CHILI}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.CHILI_CHEESE_CORNBREAD_MUFFIN.get(), 6), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.MUFFIN_TIN.get()), false).addIngredient(ExtraDelightTags.CORN_MEAL).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.SWEETENER).addIngredient((ItemLike)ExtraDelightItems.BUTTER.get()).addIngredient((ItemLike)ExtraDelightItems.EGG_MIX.get()).addIngredient(ExtraDelightTags.CHEESE).addIngredient(ExtraDelightTags.PROCESSED_CHILI).unlockedByAnyIngredient((ItemLike)ExtraDelightItems.CORN_MEAL.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.NUT_BUTTER_COOKIE.get(), 8), 400, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient((ItemLike)ExtraDelightItems.NUT_BUTTER_COOKIE_DOUGH.get()).unlockedByAnyIngredient(new ItemLike[]{ExtraDelightItems.NUT_BUTTER_COOKIE_DOUGH}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.NUT_BUTTER_COOKIE_BLOCK.get(), 4), 400, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient((ItemLike)ExtraDelightItems.NUT_BUTTER_COOKIE_DOUGH.get()).addIngredient((ItemLike)ExtraDelightItems.NUT_BUTTER_COOKIE_DOUGH.get()).addIngredient((ItemLike)ExtraDelightItems.NUT_BUTTER_COOKIE_DOUGH.get()).addIngredient((ItemLike)ExtraDelightItems.NUT_BUTTER_COOKIE_DOUGH.get()).unlockedByAnyIngredient(new ItemLike[]{ExtraDelightItems.NUT_BUTTER_COOKIE_DOUGH}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.CHOCOLATE_COOKIE.get(), 8), 400, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient((ItemLike)ExtraDelightItems.CHOCOLATE_COOKIE_DOUGH.get()).unlockedByAnyIngredient(new ItemLike[]{ExtraDelightItems.CHOCOLATE_COOKIE_DOUGH}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.CHOCOLATE_COOKIE_BLOCK.get(), 4), 400, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient((ItemLike)ExtraDelightItems.CHOCOLATE_COOKIE_DOUGH.get()).addIngredient((ItemLike)ExtraDelightItems.CHOCOLATE_COOKIE_DOUGH.get()).addIngredient((ItemLike)ExtraDelightItems.CHOCOLATE_COOKIE_DOUGH.get()).addIngredient((ItemLike)ExtraDelightItems.CHOCOLATE_COOKIE_DOUGH.get()).unlockedByAnyIngredient(new ItemLike[]{ExtraDelightItems.CHOCOLATE_COOKIE_DOUGH}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.BACON_EGG_PIE.get(), 1), 400, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.PIE_DISH.get()), false).addIngredient((TagKey<Item>)Tags.Items.EGGS).addIngredient((TagKey<Item>)Tags.Items.EGGS).addIngredient((TagKey<Item>)Tags.Items.EGGS).addIngredient((ItemLike)ModItems.BACON.get()).addIngredient((ItemLike)ModItems.PIE_CRUST.get()).addIngredient((ItemLike)ModItems.BACON.get()).unlockedByAnyIngredient((ItemLike)ModItems.PIE_CRUST.get()).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.FAT_POTATOES.get(), 4), 400, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SQUARE_PAN.get()), false).addIngredient((ItemLike)Items.POTATO).addIngredient((ItemLike)Items.POTATO).addIngredient((ItemLike)Items.POTATO).addIngredient((ItemLike)Items.POTATO).addIngredient(ExtraDelightTags.FAT).unlockedByAnyIngredient(new ItemLike[]{Items.POTATO}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.PANFORTE.get(), 1), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.PIE_DISH.get()), false).addIngredient(ExtraDelightTags.DRIED_FRUIT).addIngredient(ExtraDelightTags.DRIED_FRUIT).addIngredient(ExtraDelightTags.ROASTED_NUTS).addIngredient(ExtraDelightTags.FLOUR).addIngredient(ExtraDelightTags.GROUND_CINNAMON).addIngredient((ItemLike)Items.HONEY_BOTTLE).addIngredient((ItemLike)Items.SUGAR).addIngredient(ExtraDelightTags.CHOCOLATE_CHIPS).unlockedByAnyIngredient(new ItemLike[]{ExtraDelightItems.DRIED_FRUIT}).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.BRUSCHETTA_FEAST.get(), 1), 200, 0.35f, new ItemStack((ItemLike)Items.BOWL), true).addIngredient((ItemLike)Items.BREAD).addIngredient(ExtraDelightTags.PROCESSED_ONION).addIngredient(ExtraDelightTags.PROCESSED_TOMATO).addIngredient(ExtraDelightTags.COOKING_OIL).addIngredient(ExtraDelightTags.VINEGAR).addIngredient(ExtraDelightTags.PROCESSED_GARLIC).addIngredient(ExtraDelightTags.CHEESE).build(consumer, "bruschetta_feast");
        Recipes.bulkBake((ItemLike)ExtraDelightItems.ROASTED_GARLIC.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ExtraDelightItems.GARLIC_CLOVE.get()}), consumer, (ItemLike)ExtraDelightItems.SHEET.get(), "roasted_garlic");
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.GARLIC_BREAD.get(), 2), 400, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient((ItemLike)Items.BREAD).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.PROCESSED_GARLIC).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.CHEESY_GARLIC_BREAD.get(), 2), 400, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.SHEET.get()), false).addIngredient((ItemLike)Items.BREAD).addIngredient(ExtraDelightTags.BUTTER).addIngredient(ExtraDelightTags.PROCESSED_GARLIC).addIngredient(ExtraDelightTags.CHEESE).build(consumer);
        OvenRecipeBuilder.OvenRecipe(new ItemStack((ItemLike)ExtraDelightItems.CHICKEN_KIEV.get(), 2), 800, 1.0f, new ItemStack((ItemLike)ExtraDelightItems.TRAY.get()), false).addIngredient(ExtraDelightTags.CHICKEN_BREAST_RAW).addIngredient(ExtraDelightTags.PROCESSED_GARLIC).addIngredient(ExtraDelightTags.BUTTER).addIngredient((TagKey<Item>)Tags.Items.EGGS).addIngredient(ExtraDelightTags.BREAD_CRUMBS).build(consumer);
    }

    public static void bulkBake(ItemLike mainResult, Ingredient in, RecipeOutput consumer, ItemLike pan, String name) {
        Recipes.bulkBake(mainResult, in, consumer, pan, name, 1);
    }

    public static void bulkBake(ItemLike mainResult, Ingredient in, RecipeOutput consumer, ItemLike pan, String name, int count) {
        for (int i = 1; i < 10; ++i) {
            OvenRecipeBuilder.OvenRecipe(new ItemStack(mainResult, i * count), 800, 1.0f, new ItemStack(pan), false).addIngredient(in, i).unlockedByItems(name, pan).build(consumer, "extradelight:oven/bulk/" + name + i);
        }
    }

    public static void pot(ItemLike output, int count, int speed, float xp, ItemLike container, Ingredient[] itemsIn, String rc, RecipeOutput consumer) {
        CookingPotRecipeBuilder b = CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)output, (int)count, (int)speed, (float)xp, (ItemLike)container).setRecipeBookTab(CookingPotRecipeBookTab.MEALS);
        for (Ingredient i : itemsIn) {
            b.addIngredient(i);
        }
        b.build(consumer, "farmersdelight:" + rc);
    }

    public static void pot(ItemLike output, int count, int speed, float xp, ItemLike container, Ingredient[] itemsIn, RecipeOutput consumer) {
        CookingPotRecipeBuilder b = CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)output, (int)count, (int)speed, (float)xp, (ItemLike)container).setRecipeBookTab(CookingPotRecipeBookTab.MEALS);
        for (Ingredient i : itemsIn) {
            b.addIngredient(i);
        }
        b.build(consumer);
    }
}

