/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.data.recipebuilders;

import com.lance5057.extradelight.workstations.evaporator.recipes.EvaporatorRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class EvaporatorRecipeBuilder
implements RecipeBuilder {
    @Nullable
    private String group;
    SizedFluidIngredient fluid;
    ResourceLocation lootTable;
    Block display;
    ItemStack out;
    protected final int cookTime;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public EvaporatorRecipeBuilder(SizedFluidIngredient fluid, ItemStack out, ResourceLocation lootTable, int cookTime, Block displayBlock) {
        this.fluid = fluid;
        this.lootTable = lootTable;
        this.cookTime = cookTime;
        this.display = displayBlock;
        this.out = out;
    }

    public static EvaporatorRecipeBuilder evaporate(SizedFluidIngredient fluid, ItemStack out, ResourceLocation lootTable, int cookTime, Block displayBlock) {
        return new EvaporatorRecipeBuilder(fluid, out, lootTable, cookTime, displayBlock);
    }

    public RecipeBuilder unlockedBy(String criterionName, Criterion<?> criterionTrigger) {
        this.criteria.put(criterionName, criterionTrigger);
        return this;
    }

    public EvaporatorRecipeBuilder group(String groupName) {
        this.group = groupName;
        return this;
    }

    public Item getResult() {
        return Items.STICK;
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation id) {
        ResourceLocation recipeId = id.withPrefix("evaporator/");
        Advancement.Builder advancementBuilder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)recipeId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
        EvaporatorRecipe recipe = new EvaporatorRecipe("", this.fluid, this.cookTime, this.lootTable, BuiltInRegistries.BLOCK.getKey((Object)this.display), this.out);
        recipeOutput.accept(recipeId, (Recipe)recipe, advancementBuilder.build(id.withPrefix("recipes/evaporator/")));
    }
}

