/*
 * Decompiled with CFR 0.152.
 */
package com.lance5057.extradelight.displays.food;

import com.lance5057.extradelight.displays.food.FoodDisplayBlock;
import com.lance5057.extradelight.displays.food.FoodDisplayEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import org.joml.Quaternionf;

public class FoodDisplayRenderer
implements BlockEntityRenderer<FoodDisplayEntity> {
    public FoodDisplayRenderer(BlockEntityRendererProvider.Context cxt) {
    }

    public void render(FoodDisplayEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        if (!pBlockEntity.hasLevel()) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        IItemHandler itemInteractionHandler = pBlockEntity.getItemHandler();
        Direction dir = (Direction)pBlockEntity.getBlockState().getValue((Property)FoodDisplayBlock.FACING);
        pPoseStack.pushPose();
        float xoff = 0.0f;
        float yoff = 0.0f;
        float zoff = 0.0f;
        for (int i = 0; i < pBlockEntity.getNumSlots(); ++i) {
            ItemStack item;
            xoff = (float)(i % 3) * 0.28f;
            if (i % 3 == 0) {
                zoff += 0.22f;
                yoff -= 0.1f;
            }
            if ((item = itemInteractionHandler.getStackInSlot(i)).isEmpty()) continue;
            BakedModel bakedmodel = itemRenderer.getModel(item, pBlockEntity.getLevel(), null, 0);
            pPoseStack.pushPose();
            pPoseStack.translate(0.5f, 0.0f, 0.5f);
            pPoseStack.mulPose(new Quaternionf().rotateXYZ(0.0f, (float)Math.toRadians(-dir.toYRot()), 0.0f));
            pPoseStack.translate((double)(xoff - 0.28f), (double)yoff + 0.45, (double)zoff - 0.4);
            if (i % 2 == 0) {
                pPoseStack.translate(0.0, 0.05, 0.05);
            }
            pPoseStack.mulPose(new Quaternionf().rotateXYZ((float)Math.toRadians(-45.0), (float)Math.toRadians(180.0), 0.0f));
            float uniscale = 0.65f;
            pPoseStack.scale(uniscale, uniscale, uniscale);
            itemRenderer.render(item, ItemDisplayContext.GROUND, false, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, bakedmodel);
            pPoseStack.popPose();
        }
        pPoseStack.popPose();
    }

    public boolean shouldRenderOffScreen(FoodDisplayEntity pBlockEntity) {
        return true;
    }

    public int getViewDistance() {
        return 64;
    }

    public boolean shouldRender(FoodDisplayEntity pBlockEntity, Vec3 pCameraPos) {
        return true;
    }
}

